<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package zuari
 */

if ( ! function_exists( 'zuari_posted_on' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time.
	 */
	function zuari_posted_on() {
		$time_string = '<time class="entry-date published updated dt-published" datetime="%1$s">%2$s</time>';

		$time_string = sprintf(
			$time_string,
			esc_attr( get_the_date( DATE_W3C ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( DATE_W3C ) ),
			esc_html( get_the_modified_date() )
		);

		$posted_on = sprintf(
			'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark" class="u-url">' . $time_string . '</a>'
		);

		echo '<span class="posted-on">' . $posted_on . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	}
endif;

if ( ! function_exists( 'zuari_posted_by' ) ) :
	/**
	 * Prints HTML with meta information for the current author.
	 */
	function zuari_posted_by() {
		$byline = sprintf(
			'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
		);

		echo '<span class="byline"> ' . $byline . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	}
endif;

if ( ! function_exists( 'zuari_entry_footer' ) ) :
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function zuari_entry_footer() {
		// Hide tag text for pages.
		if ( 'post' === get_post_type() ) {
			echo '<span class="content__meta__tags">';
			if ( get_the_tags() ) {
				foreach ( get_the_tags() as $tag ) {
					echo '<a rel="tag" class="p-category" href="';
					echo esc_url( get_tag_link( $tag->term_id ) );
					echo '">' . $tag->name . '</a>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				}
			}
			echo '</span>';
		}

		/*
		Commonting out old code.
		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link">';
			comments_popup_link( '' );
			echo '</span>';
		}
		*/

		if ( function_exists( 'get_syndication_links' ) ) {
			echo get_syndication_links( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				null,
				array(
					'show_text_before' => null,
				)
			);
		}

		edit_post_link(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Edit <span class="screen-reader-text">%s</span>', 'zuari' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			),
			'<span class="edit-link">',
			'</span>'
		);
	}
endif;

if ( ! function_exists( 'zuari_post_thumbnail' ) ) :
	/**
	 * Displays an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 */
	function zuari_post_thumbnail() {
		if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
			return;
		}

		if ( is_singular() ) :
			?>

			<div class="content__thumbnail">
				<?php
				the_post_thumbnail(
					'large',
					array(
						'class' => 'u-photo',
					)
				);
				?>
			</div><!-- .post-thumbnail -->

		<?php else : ?>

		<a class="content__thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
			<?php
			the_post_thumbnail(
				'large',
				array(
					'class' => 'u-photo',
					'alt'   => the_title_attribute(
						array(
							'echo' => false,
						)
					),
				)
			);
			?>
		</a>

			<?php
		endif; // End is_singular().
	}
endif;
