<?php

// No direct access, please

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function zoom_theme_header_slider()
{

    $ids_array = get_theme_mod( 'header_slider' );

    ob_start();

    $t_url = get_template_directory_uri().'/assets/images/header/defaut-slider/';

    if ( is_array( $ids_array ) && ! empty( $ids_array ) ) {

        $def_img = wp_get_attachment_image_src( $ids_array[0], 'zoom-img-slider' );

        $def_img_h = ( isset( $def_img[2] ) ? $def_img[2] : 350 );

        echo '<div class="zoom-slider-wrapper slider-wrapper theme-default" style="height:'.esc_attr( $def_img_h ).'px;"><div class="ribbon"></div><div id="slider" class="nivoSlider zoom-image-slider">';

        foreach ( $ids_array as $id ) {

            $img          = wp_get_attachment_image_src( $id, 'zoom-img-slider' );
            $slider_img   = ( isset( $img[0] ) ? $img[0] : $t_url.'slider1.jpg' );
            $slider_img_w = ( isset( $img[1] ) ? $img[1] : 1200 );
            $slider_img_h = ( isset( $img[2] ) ? $img[2] : 350 );

            ?>
            <img class="zoom_nivoSlider_img" src="<?php echo esc_url( $slider_img ); ?>" width="<?php echo esc_attr( $slider_img_w ); ?>" height="<?php echo esc_attr( $slider_img_h ); ?>" />
			<?php
}

        echo '</div></div>';

    } else {

        echo '<div class="zoom-slider-wrapper slider-wrapper theme-default"><div class="ribbon"></div><div id="slider" class="nivoSlider zoom-image-slider">';
        echo '<img src="'.esc_url( $t_url.'slider1.jpg' ).'" width="1200" height="350" /><img src="'.esc_url( $t_url.'slider2.jpg' ).'" width="1200" height="350" /><img src="'.esc_url( $t_url.'slider3.jpg' ).'" width="1200" height="350" />';
        echo '</div></div>';
    }

    $header_slider = ob_get_clean();

    return $header_slider;

}