<?php

// No direct access, please

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Add Custom Render for JetPack Infinite Scroll
 * @return Posts
 */
function zoom_infinite_scroll_render()
{

    get_template_part( 'contents/content', 'infinitescroll' );

}

/**
 * Custom Order
 */
function zoom_jetpack_infinite_scroll_query_args( $args )
{

    $args['order']   = ''.esc_html( strtoupper( get_theme_mod( 'misc_jpis_order', 'DESC' ) ) ).'';
    $args['orderby'] = 'date';

    return $args;

}

add_filter( 'infinite_scroll_query_args', 'zoom_jetpack_infinite_scroll_query_args', 100 );

/**
 * Custom JS Settings
 */
function zoom_filter_jetpack_infinite_scroll_js_settings( $settings )
{

    $settings['text'] = esc_html( get_theme_mod( 'misc_jpis_load_more_txt', 'Load More...' ) );

    return $settings;

}

add_filter( 'infinite_scroll_js_settings', 'zoom_filter_jetpack_infinite_scroll_js_settings', 100 );

/**
 * Remove default JetPack infinity.js and replace with custom infinity.js
 */
function zoom_dequeue_defaul_jpack_infinity_script()
{

    if ( zoom_jetpack_active_module( 'infinite-scroll' ) ) {

        wp_dequeue_script( 'the-neverending-homepage' );

    }

}

add_action( 'wp_print_scripts', 'zoom_dequeue_defaul_jpack_infinity_script', 100 );

if ( class_exists( 'The_Neverending_Home_Page' ) ) {

    class Zoom_Fixed_Query_Time_Filter_Function_Ext extends The_Neverending_Home_Page
    {

        public function query_time_filter( $where, $query )
        {

            if ( The_Neverending_Home_Page::got_infinity() ) {
                global $wpdb;

                $sort_field = The_Neverending_Home_Page::get_query_sort_field( $query );

                if ( 'post_date' !== $sort_field || 'DESC' !== $_REQUEST['query_args']['order'] ) {
                    return $where;
                }

                if ( isset( $_REQUEST['query_before'] ) ) {
                    $query_before = sanitize_text_field( wp_unslash( $_REQUEST['query_before'] ) );
                }

                if ( empty( $query_before ) ) {
                    return $where;
                }

                // Construct the date query using our timestamp
                $clause = $wpdb->prepare( " AND {$wpdb->posts}.post_date <= %s", $query_before );

                /**
                 * Filter Infinite Scroll's SQL date query making sure post queries
                 * will always return results prior to (descending sort)
                 * or before (ascending sort) the last post date.
                 *
                 * @module infinite-scroll
                 *
                 * @param string $clause SQL Date query.
                 * @param object $query Query.
                 * @param string $operator @deprecated Query operator.
                 * @param string $last_post_date @deprecated Last Post Date timestamp.
                 */
                $operator       = 'ASC' === $_REQUEST['query_args']['order'] ? '>' : '<';
                $last_post_date = sanitize_text_field( wp_unslash( $_REQUEST['last_post_date'] ) );
                $where .= apply_filters( 'infinite_scroll_posts_where', $clause, $query, $operator, $last_post_date );
            }

            return $where;

        }

    }

}