<?php

// No direct access, please

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function zoom_theme_customize_post_options( $wp_customize )
{

    $default_opt = zoom_default_theme_options();
    
    // Next/Prev Post Link
    $wp_customize->add_setting(
        'post_next_prev',
        array(
            'default'           => $default_opt['post_next_prev'],
            'sanitize_callback' => 'zoom_sanitize_checkbox',
        )
    );

    $wp_customize->add_control( new Zoom_Switch_Option_Control( $wp_customize, 'post_next_prev_control', array(
        'type'        => 'switch_option',
        'label'       => esc_html__( 'Link to The Next Post', 'zoom-lite' ),
        'description' => esc_html__( 'Used on single post, enable this option will displays a link to the next post which exists in chronological order from the current post', 'zoom-lite' ),
        'section'     => 'site_post_meta_section',
        'settings'    => 'post_next_prev',
        'priority'    => 3,
    ) ) );

    // Post Author Box
    $wp_customize->add_setting(
        'author_box',
        array(
            'default'           => $default_opt['author_box'],
            'sanitize_callback' => 'zoom_sanitize_checkbox',
        )
    );

    $wp_customize->add_control( new Zoom_Switch_Option_Control( $wp_customize, 'author_box_control', array(
        'type'        => 'switch_option',
        'label'       => esc_html__( 'Author Box', 'zoom-lite' ),
        'description' => esc_html__( 'Use this option to show / hide the Author Box on every bottom of post', 'zoom-lite' ),
        'section'     => 'site_post_meta_section',
        'settings'    => 'author_box',
        'priority'    => 4,
    ) ) );

    // Show Hide Post Title
    $wp_customize->add_setting(
        'hide_post_title',
        array(
            'default'           => $default_opt['hide_post_title'],
            'sanitize_callback' => 'zoom_sanitize_checkbox',
        )
    );

    $wp_customize->add_control( new Zoom_Switch_Option_Control( $wp_customize, 'hide_post_title_control', array(
        'type'        => 'switch_option',
        'label'       => esc_html__( 'Hide Post Title', 'zoom-lite' ),
        'description' => esc_html__( 'Use this option to show / hide the title of post', 'zoom-lite' ),
        'section'     => 'site_post_meta_section',
        'settings'    => 'hide_post_title',
        'priority'    => 5,
    ) ) );

}

add_action( 'customize_register', 'zoom_theme_customize_post_options' );