<?php

// No direct access, please

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function zoom_theme_customize_post_meta_options( $wp_customize )
{

    $default_opt = zoom_default_theme_options();
    
    // Post Meta
    $wp_customize->add_setting(
        'post_meta',
        array(
            'default'           => $default_opt['post_meta'],
            'sanitize_callback' => 'zoom_sanitize_multiple_checkbox',
        )
    );

    $wp_customize->add_control( new Zoom_Multiple_Checkbox_Control( $wp_customize, 'post_meta_control', array(
        'type'     => 'checkbox_multiple',
        'settings' => 'post_meta',
        'section'  => 'site_post_meta_section',
        'label'    => esc_html__( 'Post Meta Options', 'zoom-lite' ),
        'priority' => 1,
        'choices'  => array(
            'meta_date'     => array(
                'label' => esc_html__( 'Show Post Date', 'zoom-lite' ),
            ),
            'meta_cat'      => array(
                'label' => esc_html__( 'Show Categories', 'zoom-lite' ),
            ),
            'meta_tags'     => array(
                'label' => esc_html__( 'Show Tags', 'zoom-lite' ),
            ),
            'meta_author'   => array(
                'label' => esc_html__( 'Show Author', 'zoom-lite' ),
            ),
            'meta_comments' => array(
                'label' => esc_html__( 'Show Comments', 'zoom-lite' ),
            ),
            'breadcrumb'    => array(
                'label' => esc_html__( 'Show Breadcrumbs ( Small Navigation )', 'zoom-lite' ),
            ),
        ),
    )
    )
    );
    
}

add_action( 'customize_register', 'zoom_theme_customize_post_meta_options' );