<?php

// No direct access, please

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function zoom_theme_customize_sections( $wp_customize )
{

    // Bottom Bar
    $wp_customize->add_section( 'zoom_theme_b_bar_section', array(
        'title'       => esc_html__( 'Bottom Bar', 'zoom-lite' ),
        'priority'    => 20,
        'description' => esc_html__( 'You can set your Bottom Bar with the following fields', 'zoom-lite' ),
        'panel'       => 'zoom_site_branding',
    ) );

    // Top Bar
    $wp_customize->add_section( 'zoom_theme_t_bar_section', array(
        'title'       => esc_html__( 'Top Bar', 'zoom-lite' ),
        'priority'    => 19,
        'description' => esc_html__( 'You can set your Top Bar with the following fields', 'zoom-lite' ),
        'panel'       => 'zoom_site_branding',
    ) );

    // Branding Logo
    $wp_customize->add_section( 'zoom_theme_logo_section', array(
        'title'       => esc_html__( 'Logo', 'zoom-lite' ),
        'priority'    => 18,
        'description' => esc_html__( 'Upload a logo for available spot below.', 'zoom-lite' ),
        'panel'       => 'zoom_site_branding',
    ) );

    // Header Settings
    $wp_customize->add_section( 'zoom_theme_header_section', array(
        'title'    => esc_html__( 'Header', 'zoom-lite' ),
        'panel'    => 'zoom_site_styles',
        'priority' => 1,
    ) );

    // Layout Footer
    $wp_customize->add_section( 'zoom_site_footer_layout', array(
        'title'       => esc_html__( 'Footer', 'zoom-lite' ),
        'priority'    => 31,
        'description' => esc_html__( 'You can use the following options to manage widget in footer area', 'zoom-lite' ),
        'panel'       => 'zoom_theme_layout_panel',
    ) );

    // Layout Blog & Page
    $wp_customize->add_section( 'zoom_blog_layout', array(
        'title'    => esc_html__( 'Blog &amp; Page', 'zoom-lite' ),
        'priority' => 29,
        'panel'    => 'zoom_theme_layout_panel',
    ) );

    // Layout Sidebar
    $wp_customize->add_section( 'zoom_sidebar_layout', array(
        'title'    => esc_html__( 'Sidebar', 'zoom-lite' ),
        'priority' => 30,
        'panel'    => 'zoom_theme_layout_panel',
    ) );

    // Layout Site
    $wp_customize->add_section( 'zoom_site_layout', array(
        'title'    => esc_html__( 'Main Layout', 'zoom-lite' ),
        'priority' => 28,
        'panel'    => 'zoom_theme_layout_panel',
    ) );

    // Misc Admin
    $wp_customize->add_section(
        'zoom_theme_admin_settings',
        array(
            'title'      => esc_html__( 'Admin Settings', 'zoom-lite' ),
            'capability' => 'edit_theme_options',
            'priority'   => 4,
            'panel'      => 'zoom_misc_panel',
        )
    );

    // Misc Custom JS
    $wp_customize->add_section(
        'zoom_theme_custom_js',
        array(
            'title'       => esc_html__( 'Additional JS', 'zoom-lite' ),
            'description' => esc_html__( 'Make sure your code inside <script> and </script>. For example: <script>alert("aaa");</script>', 'zoom-lite' ),
            'capability'  => 'edit_css',
            'priority'    => 3,
            'panel'       => 'zoom_misc_panel',
        )
    );

    // Misc Site Effects
    $wp_customize->add_section(
        'zoom_theme_site_effects',
        array(
            'title'      => esc_html__( 'Effects', 'zoom-lite' ),
            'capability' => 'edit_theme_options',
            'priority'   => 1,
            'panel'      => 'zoom_misc_panel',
        )
    );

    // Misc Site Performances & SEO
    $wp_customize->add_section(
        'zoom_theme_site_performances',
        array(
            'title'      => esc_html__( 'Performances &amp; SEO', 'zoom-lite' ),
            'capability' => 'edit_theme_options',
            'priority'   => 2,
            'panel'      => 'zoom_misc_panel',
        )
    );

    // Misc Custom Text
    $wp_customize->add_section(
        'zoom_theme_custom_text',
        array(
            'title'       => esc_html__( 'Custom Text / Label', 'zoom-lite' ),
            'description' => esc_html__( 'Use the following options to change the default navigation text on your site', 'zoom-lite' ),
            'capability'  => 'edit_theme_options',
            'priority'    => 3,
            'panel'       => 'zoom_misc_panel',
        )
    );

    // Post Comments
    $wp_customize->add_section( 'zoom_theme_comment_blog_section', array(
        'title'       => esc_html__( 'Post Comments', 'zoom-lite' ),
        'priority'    => 21,
        'description' => esc_html__( 'Change how this theme displays the comments', 'zoom-lite' ),
        'panel'       => 'zoom_post_options',
    ) );

    // Post Excerpts
    $wp_customize->add_section( 'zoom_theme_blog_section', array(
        'title'       => esc_html__( 'Post Excerpts', 'zoom-lite' ),
        'priority'    => 20,
        'description' => esc_html__( 'Change how Zoom displays posts', 'zoom-lite' ),
        'panel'       => 'zoom_post_options',
    ) );

    // Post Image
    $wp_customize->add_section( 'site_styles_image_section', array(
        'title'       => esc_html__( 'Post Images', 'zoom-lite' ),
        'priority'    => 22,
        'description' => esc_html__( 'Define and set your post images style', 'zoom-lite' ),
        'panel'       => 'zoom_post_options',
    ) );

    // Post Meta & Informations
    $wp_customize->add_section( 'site_post_meta_section', array(
        'title'       => esc_html__( 'Post Information', 'zoom-lite' ),
        'priority'    => 19,
        'description' => esc_html__( 'Define and set your post meta with the following options', 'zoom-lite' ),
        'panel'       => 'zoom_post_options',
    ) );

    // Post Sticky
    $wp_customize->add_section( 'site_post_sticky_section', array(
        'title'       => esc_html__( 'Post Sticky ( Featured Post )', 'zoom-lite' ),
        'priority'    => 23,
        'description' => esc_html__( 'Define and set your featured post with the following options', 'zoom-lite' ),
        'panel'       => 'zoom_post_options',
    ) );

    // Styles Button
    $wp_customize->add_section(
        'zoom_theme_site_button',
        array(
            'title'      => esc_html__( 'Button', 'zoom-lite' ),
            'capability' => 'edit_theme_options',
            'priority'   => 4,
            'panel'      => 'zoom_site_styles',
        )
    );

    // Color Scheme
    $wp_customize->add_section( 'site_color_scheme_section', array(
        'title'       => esc_html__( 'Color Scheme', 'zoom-lite' ),
        'priority'    => 3,
        'description' => esc_html__( 'Define and set your site your site color scheme', 'zoom-lite' ),
        'panel'       => 'zoom_site_styles',
    ) );

    // Colors
    $wp_customize->add_section( 'site_styles_section', array(
        'title'       => esc_html__( 'Colors', 'zoom-lite' ),
        'priority'    => 2,
        'description' => esc_html__( 'Define and set your site color elements', 'zoom-lite' ),
        'panel'       => 'zoom_site_styles',
    ) );

}

add_action( 'customize_register', 'zoom_theme_customize_sections' );