<?php
/*
Template Name: contact
*/
?>
<?php get_header(); ?>

<div id="side-left">
	<div id="content">

		<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
						<div class="kutu">
	<div class="ust"><span></span></div>

		<div class="post" id="post-<?php the_ID(); ?>">
		<h2 class="pagetitle"><?php the_title(); ?></h2>
			<div class="entry">
						<?php
		//validate email adress
		function is_valid_email($email)
		{
  			return (eregi ("^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}$", $email));
		}

		//clean up text
		function clean($text)
		{
			return stripslashes($text);
		}

		//encode special chars (in name and subject)
		function encodeMailHeader ($string, $charset = 'UTF-8')
		{
    		return sprintf ('=?%s?B?%s?=', strtoupper ($charset),base64_encode ($string));
		}

		$bx_name    = (!empty($_POST['bx_name']))    ? $_POST['bx_name']    : "";
		$bx_email   = (!empty($_POST['bx_email']))   ? $_POST['bx_email']   : "";
		$bx_url     = (!empty($_POST['bx_url']))     ? $_POST['bx_url']     : "";
		$bx_subject = (!empty($_POST['bx_subject'])) ? $_POST['bx_subject'] : "";
		$bx_message = (!empty($_POST['bx_message'])) ? $_POST['bx_message'] : "";

		$bx_subject = clean($bx_subject);
		$bx_message = clean($bx_message);
		$error_msg = "";
		$send = 0;

		if (!empty($_POST['submit'])) {
			$send = 1;
			if (empty($bx_name) || empty($bx_email) || empty($bx_subject) || empty($bx_message)) {
				$error_msg.= "<p><strong>Please fill in all required fields.</strong></p>\n";
				$send = 0;
			}
			if (!is_valid_email($bx_email)) {
				$error_msg.= "<p><strong>Your email adress failed to validate.</strong></p>\n";
				$send = 0;
			}
		}

		if (!$send) { ?>

			<h2><?php the_title(); ?></h2>
			<p class="tips">Asagidaki form araciligiyla;</p>
		<ul>
		<li>Fadonet.Net'e reklam vermek iin  irtibata geebilirsiniz.</li>
		<li>Istek ve nerilerinizi bildirebilirsiniz.</li>
		<li>Sahsiniza hakaret oldugunu dsndgnz bir yazi veya yorum varsa bunu ihbar edebilirsiniz.</li>
		<li>Veya bu konular disinda herhangi bir konuda yazabilirsiniz. </li>
		</ul>

			<?php
				the_content();
				echo $error_msg;
			?>

			<form method="post" action="<?php echo "http://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>" id="contactform">
				<fieldset>
					<p><label for="bx_name">Isim</label> <input type="text" name="bx_name" id="bx_name" value="<?php echo $bx_name; ?>" tabindex="1" /><em>Gerekli</em></p>
					<p><label for="bx_email">Email</label> <input type="text" name="bx_email" id="bx_email" value="<?php echo $bx_email; ?>" tabindex="2" /><em>Gerekli</em></p>
					<p><label for="bx_url">Web Site</label> <input type="text" name="bx_url" id="bx_url" value="<?php echo $bx_url; ?>" tabindex="3" /> <em>Varsa Eger</em></p>
					<p><label for="bx_subject">Baslik</label> <input type="text" name="bx_subject" id="bx_subject" value='<?php echo $bx_subject; ?>' tabindex="4" /></p>
					<p><label for="bx_message">Konu</label> <textarea name="bx_message" id="bx_message" cols="30" rows="10" tabindex="5"><?php echo $bx_message; ?></textarea></p>
					<p><label for="bx_message">&nbsp;</label><input name="submit" type="submit" tabindex="6" value="Tamam" /></p>
				</fieldset>
			</form>

		<?php
		} else {

			$displayName_array	= explode(" ",$bx_name);
			$displayName = htmlentities(utf8_decode($displayName_array[0]));

			$header  = "MIME-Version: 1.0\n";
			$header .= "Content-Type: text/plain; charset=\"utf-8\"\n";
			$header .= "Kimden:" . encodeMailHeader($bx_name) . "<" . $bx_email . ">\n";
			$email_subject	= "[" . get_settings('blogname') . "] " . encodeMailHeader($bx_subject);
			$email_text		= "From......: " . $bx_name . "\n" .
							  "Email.....: " . $bx_email . "\n" .
							  "Web Site.......: " . $bx_url . "\n\n" .
							  "..........................................................\n" .
							  "Konu...: " . $bx_subject . "\n" .
							  "..........................................................\n\n" .
							  $bx_message;

			if (@mail(get_settings('admin_email'), $email_subject, $email_text, $header)) {
				echo "<h2>Tesekkrler " . $displayName . ",</h2><p>Mesajiniz basariyla iletilmistir.</p>";
			}
		}
		?>

			</div>
		</div>
		<?php endwhile; endif; ?>
	<?php edit_post_link('Edit this entry.', '<p style="margin:10px;">', '</p>'); ?>
<br class="clear" />
		<div class="alt"><span></span></div></div>
	</div>

</div>
<?php get_sidebar(); ?>

<?php get_footer(); ?>