<?php
/**
 * ZenFire: Customizer
 */

if ( ! function_exists( 'zenfire_customize_register' ) ) :
	/**
	 * Add postMessage support for site title and description for the Theme Customizer.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 */
	function zenfire_customize_register( $wp_customize ) {

		/**
		 * Add Footer Section
		 */
		$wp_customize->add_section(
			'zenfire_footer_section',
			array(
				'title'       => __( 'Footer', 'zenfire' ),
				'capability'  => 'edit_theme_options',
			)
		);
		
		// Add Footer Copyright Text
		$wp_customize->add_setting(
			'zenfire_footer_copyright',
			array(
			    'default'           => '',
			    'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'zenfire_footer_copyright',
	        array(
	            'label'          => __( 'Copyright Text', 'zenfire' ),
	            'section'        => 'zenfire_footer_section',
	            'settings'       => 'zenfire_footer_copyright',
	            'type'           => 'text',
	            )
	        )
		);

		/**
		 * Add Slider Section
		 */
		$wp_customize->add_section(
			'zenfire_slider_section',
			array(
				'title'       => __( 'Slider', 'zenfire' ),
				'capability'  => 'edit_theme_options',
			)
		);

		// Add display slider option
		$wp_customize->add_setting(
				'zenfire_slider_display',
				array(
						'default'           => 0,
						'sanitize_callback' => 'zenfire_sanitize_checkbox',
				)
		);

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'zenfire_slider_display',
								array(
									'label'          => __( 'Display Slider on a Static Front Page', 'zenfire' ),
									'section'        => 'zenfire_slider_section',
									'settings'       => 'zenfire_slider_display',
									'type'           => 'checkbox',
								)
							)
		);
		
		for ($i = 1; $i <= 5; ++$i) {
		
			$slideImageId = 'zenfire_slide'.$i.'_image';
			$defaultSliderImagePath = get_template_directory_uri().'/images/slider/'.$i.'.jpg';
			
			// Add Slide Background Image
			$wp_customize->add_setting( $slideImageId,
				array(
					'default' => $defaultSliderImagePath,
					'sanitize_callback' => 'zenfire_sanitize_url'
				)
			);

			$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $slideImageId,
					array(
						'label'   	 => sprintf( esc_html__( 'Slide #%s Image', 'zenfire' ), $i ),
						'section' 	 => 'zenfire_slider_section',
						'settings'   => $slideImageId,
					) 
				)
			);
		}

		/**
	     * Add Animations Section
	     */
	    $wp_customize->add_section(
	        'zenfire_animations_display',
	        array(
	            'title'       => __( 'Animations', 'zenfire' ),
	            'capability'  => 'edit_theme_options',
	        )
	    );

	    // Add display Animations option
	    $wp_customize->add_setting(
	            'zenfire_animations_display',
	            array(
	                    'default'           => 1,
	                    'sanitize_callback' => 'zenfire_sanitize_checkbox',
	            )
	    );

	    $wp_customize->add_control( new WP_Customize_Control( $wp_customize,
	                        'zenfire_animations_display',
	                            array(
	                                'label'          => __( 'Enable Animations', 'zenfire' ),
	                                'section'        => 'zenfire_animations_display',
	                                'settings'       => 'zenfire_animations_display',
	                                'type'           => 'checkbox',
	                            )
	                        )
	    );
	}
endif; // zenfire_customize_register
add_action( 'customize_register', 'zenfire_customize_register' );

if ( ! function_exists( 'zenfire_sanitize_checkbox' ) ) :
	/**
	 * Sanitization callback for 'checkbox' type controls. This callback sanitizes `$checked`
	 * as a boolean value, either TRUE or FALSE.
	 *
	 * @param bool $checked Whether the checkbox is checked.
	 * @return bool Whether the checkbox is checked.
	 */
	function zenfire_sanitize_checkbox( $checked ) {
		// Boolean check.
		return ( ( isset( $checked ) && true == $checked ) ? true : false );
	}
endif; // zenfire_sanitize_checkbox

if ( ! function_exists( 'zenfire_sanitize_url' ) ) :

	function zenfire_sanitize_url( $url ) {
		return esc_url_raw( $url );
	}

endif; // zenfire_sanitize_url
