<?php
/**
 *
 * Adds custom Block Patterns to the post/page editor.
 *
 * see: https://developer.wordpress.org/block-editor/developers/block-api/block-patterns/
 *
 * @package Zeko Lite
 */


register_block_pattern_category(
	'zeko-lite-theme',
	array( 'label' => esc_html__( 'Zeko Lite', 'zeko-lite' ) )
);


register_block_pattern_category(
	'zeko-lite-theme-wc',
	array( 'label' => esc_html__( 'Zeko Lite - Products', 'zeko-lite' ) )
);

register_block_pattern(
	'zeko-lite/zeko-lite-hero',
	array(
		'title'			=> esc_html__( 'Hero Section', 'zeko-lite' ),
		'description'	=> esc_html_x( 'A pattern to quickly create the top hero section.', 'Block pattern description', 'zeko-lite' ),

		'content'		=> '<!-- wp:cover {"url":"' . esc_url( get_theme_file_uri( 'images/hero.jpg' ) ) . '","hasParallax":true,"minHeight":700,"align":"full","className":"is-style-editorskit-diagonal"} -->
        <div class="wp-block-cover alignfull has-background-dim has-parallax hero-image" style="background-image:url(' . esc_url( get_theme_file_uri( 'images/hero.jpg' ) ) . ');min-height:700px"><div class="wp-block-cover__inner-container"><!-- wp:paragraph -->
        <p></p>
        <!-- /wp:paragraph -->

        <!-- wp:group -->
        <div class="wp-block-group has-background"><div class="wp-block-group__inner-container"><!-- wp:heading {"level":1,"style":{"typography":{"fontSize":93}}} -->
        <h1 style="font-size:93px">' . esc_html_x( 'Welcome to Zeko Lite', 'Theme starter content', 'zeko-lite' ) . '</h1>
        <!-- /wp:heading -->
        
        <!-- wp:paragraph -->
        <p>' . esc_html_x( 'Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes. Commodo metus adipiscing odio. Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes.', 'Theme starter content', 'zeko-lite' ) . '</p>
        <!-- /wp:paragraph -->
        
        <!-- wp:buttons -->
        <div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"strong-red","textColor":"strong-gray"} -->
        <div class="wp-block-button"><a class="wp-block-button__link has-strong-gray-color has-strong-red-background-color has-text-color has-background">' . esc_html_x( 'Donate Now', 'Theme starter content', 'zeko-lite' ) . '</a></div>
        <!-- /wp:button --></div>
        <!-- /wp:buttons --></div></div>
        <!-- /wp:group --></div></div>
        <!-- /wp:cover -->',

		'viewportWidth'	=> 1400,
		'categories'	=> array( 'zeko-lite-theme' ),
	)
);

register_block_pattern(
	'zeko-lite/zeko-lite-text-image',
	array(
		'title'			=> esc_html__( '2 Columns - Text and Image', 'zeko-lite' ),
		'description'	=> esc_html_x( 'A pattern to quickly create 2 columns with text and image.', 'Block pattern description', 'zeko-lite' ),

		'content'		=> '<!-- wp:columns {"className":"has-2-columns"} -->
        <div class="wp-block-columns has-2-columns"><!-- wp:column -->
        <div class="wp-block-column"><!-- wp:heading {"fontSize":"large"} -->
        <h2 class="has-large-font-size">' . esc_html_x( 'Love for Ellies', 'Theme starter content', 'zeko-lite' ) . '</h2>
        <!-- /wp:heading -->
        
        <!-- wp:paragraph -->
        <p>' . esc_html_x( 'Do you know that every 15 minutes one elephant is senselessly killed just for their tusk? That leads to more than 30 000 elephants a year killed for nothing more than a human greed.', 'Theme starter content', 'zeko-lite' ) . '</p>
        <!-- /wp:paragraph -->
        
        <!-- wp:list {"className":"styled"} -->
        <ul class="styled"><li><strong>' . esc_html_x( 'Water', 'Theme starter content', 'zeko-lite' ) . '</strong>&nbsp;–&nbsp;<em>' . esc_html_x( 'drinking water is essential to animals as much as humans.', 'Theme starter content', 'zeko-lite' ) . '</em></li><li><strong>' . esc_html_x( 'Food', 'Theme starter content', 'zeko-lite' ) . '</strong>&nbsp;–&nbsp;<em>' . esc_html_x( 'food is essential to animals as much as humans.', 'Theme starter content', 'zeko-lite' ) . '</em></li></ul>
        <!-- /wp:list -->
        
        <!-- wp:button {"align":"left"} -->
        <div class="wp-block-button alignleft"><a class="wp-block-button__link" href="https://anarieldesign.com/themedemos/zeko-lite/causes/">' . esc_html_x( 'Donate Now', 'Theme starter content', 'zeko-lite' ) . '</a></div>
        <!-- /wp:button --></div>
        <!-- /wp:column -->
        
        <!-- wp:column -->
        <div class="wp-block-column"><!-- wp:image -->
        <figure class="wp-block-image"><img src="' . esc_url( get_theme_file_uri( 'images/ellie-1.jpg' ) ) . '" alt="image" class=""/></figure>
        <!-- /wp:image --></div>
        <!-- /wp:column --></div>
        <!-- /wp:columns -->',

		'viewportWidth'	=> 1400,
		'categories'	=> array( 'zeko-lite-theme' ),
	)
);

register_block_pattern(
	'zeko-lite/zeko-lite-team',
	array(
		'title'			=> esc_html__( 'Team', 'zeko-lite' ),
		'description'	=> esc_html_x( 'A pattern to quickly create team block.', 'Block pattern description', 'zeko-lite' ),

		'content'		=> '<!-- wp:columns {"className":"has-3-columns"} -->
        <div class="wp-block-columns has-3-columns"><!-- wp:column -->
        <div class="wp-block-column"><!-- wp:image -->
        <figure class="wp-block-image"><img src="' . esc_url( get_theme_file_uri( 'images/team-1.jpg' ) ) . '" alt="image" class=""/></figure>
        <!-- /wp:image -->
        
        <!-- wp:heading {"align":"left","level":3} -->
        <h3 class="has-text-align-left">' . esc_html_x( 'Angela Ema', 'Theme starter content', 'zeko-lite' ) . '</h3>
        <!-- /wp:heading -->
        
        <!-- wp:paragraph -->
        <p><em>' . esc_html_x( 'CEO/Founder', 'Theme starter content', 'zeko-lite' ) . '</em></p>
        <!-- /wp:paragraph -->
        
        <!-- wp:paragraph -->
        <p>' . esc_html_x( 'Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes. Malesuada nibh montes fusce cum eleifend. Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes.', 'Theme starter content', 'zeko-lite' ) . '</p>
        <!-- /wp:paragraph --></div>
        <!-- /wp:column -->
        
        <!-- wp:column -->
        <div class="wp-block-column"><!-- wp:image -->
        <figure class="wp-block-image"><img src="' . esc_url( get_theme_file_uri( 'images/team-2.jpg' ) ) . '" alt="image" class=""/></figure>
        <!-- /wp:image -->
        
        <!-- wp:heading {"align":"left","level":3} -->
        <h3 class="has-text-align-left">' . esc_html_x( 'Alex Zela', 'Theme starter content', 'zeko-lite' ) . '</h3>
        <!-- /wp:heading -->
        
        <!-- wp:paragraph -->
        <p><em>' . esc_html_x( 'Volunteer', 'Theme starter content', 'zeko-lite' ) . '</em></p>
        <!-- /wp:paragraph -->
        
        <!-- wp:paragraph -->
        <p>' . esc_html_x( 'Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes. Malesuada nibh montes fusce cum eleifend. Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes.', 'Theme starter content', 'zeko-lite' ) . '</p>
        <!-- /wp:paragraph --></div>
        <!-- /wp:column -->
        
        <!-- wp:column -->
        <div class="wp-block-column"><!-- wp:image -->
        <figure class="wp-block-image"><img src="' . esc_url( get_theme_file_uri( 'images/team-3.jpg' ) ) . '" alt="image" class=""/></figure>
        <!-- /wp:image -->
        
        <!-- wp:heading {"align":"left","level":3} -->
        <h3 class="has-text-align-left">' . esc_html_x( 'Talinka Bubi', 'Theme starter content', 'zeko-lite' ) . '</h3>
        <!-- /wp:heading -->
        
        <!-- wp:paragraph -->
        <p><em>' . esc_html_x( 'Manager', 'Theme starter content', 'zeko-lite' ) . '</em></p>
        <!-- /wp:paragraph -->
        
        <!-- wp:paragraph -->
        <p>' . esc_html_x( 'Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes. Malesuada nibh montes fusce cum eleifend. Malesuada nibh montes fusce cum eleifend fringilla commodo mattis tempor platea montes.', 'Theme starter content', 'zeko-lite' ) . '</p>
        <!-- /wp:paragraph --></div>
        <!-- /wp:column --></div>
        <!-- /wp:columns -->',

		'viewportWidth'	=> 1400,
		'categories'	=> array( 'zeko-lite-theme' ),
	)
);