import { useSelect } from '@wordpress/data';
import { __ } from '@wordpress/i18n';
import React from 'react';
import usePluginInstallActivate from '../../hook/usePluginInstallActivate';
import { ZAKRA_DASHBOARD_STORE } from '../../store';
import { localized } from '../../utils/global';

export const StarterTemplates: React.FC = () => {
	const pluginsStatus = useSelect((select) => {
		return (
			select(ZAKRA_DASHBOARD_STORE) as any
		).getPluginsStatus() as typeof localized.plugins;
	}, []);
	const { performPluginAction } = usePluginInstallActivate({
		pluginsStatus: localized.plugins,
	});
	return (
		<div>
			<div className="wrap demo-importer">
				<div className="themegrill-demo-importer-BlankState flex justify-center">
					<div className="themegrill-demo-importer-BlankState-info w-2/5 m-auto p-[80px]">
						<svg
							xmlns="http://www.w3.org/2000/svg"
							width="120"
							height="106"
							viewBox="0 0 120 106"
							fill="none"
						>
							<path
								d="M92.2813 12.7843L59.7221 0.790039L27.4741 12.6263C23.3563 14.6181 19.746 15.8152 19.746 19.7462V39.3488C19.6789 53.0679 23.3521 66.5458 30.3709 78.3337C36.3848 88.3457 45.6929 98.6545 60.0573 105.209C73.239 100.819 83.0786 89.1118 89.0925 79.0951C96.1117 67.3091 99.785 53.8326 99.7173 40.1149V22.485C99.6934 16.8734 96.7966 14.1345 92.2813 12.7843Z"
								fill="#4A7EEE"
							/>
							<g opacity="0.8">
								<path
									d="M92.2813 12.7843L59.7221 0.790039L27.4741 12.6263C23.3563 14.6181 19.746 15.8152 19.746 19.7462V39.3488C19.6789 53.0679 23.3521 66.5458 30.3709 78.3337C36.3848 88.3457 45.6929 98.6545 60.0573 105.209C73.239 100.819 83.0786 89.1118 89.0925 79.095C96.1117 67.3091 99.785 53.8326 99.7173 40.1149V22.485C99.6934 16.8734 96.7966 14.1345 92.2813 12.7843Z"
									fill="white"
								/>
							</g>
							<path
								d="M79.6026 36.77H73.6174V29.8108C73.6174 26.1236 72.1527 22.5875 69.5455 19.9803C66.9383 17.3731 63.4022 15.9084 59.7151 15.9084C56.0279 15.9084 52.4918 17.3731 49.8846 19.9803C47.2775 22.5875 45.8127 26.1236 45.8127 29.8108V62.37H39.8276V29.8108C39.7867 27.1731 40.2708 24.5537 41.2519 22.105C42.233 19.6563 43.6913 17.4272 45.5421 15.5474C47.3929 13.6677 49.5991 12.1749 52.0323 11.156C54.4655 10.137 57.0771 9.6123 59.7151 9.6123C62.353 9.6123 64.9646 10.137 67.3978 11.156C69.831 12.1749 72.0372 13.6677 73.888 15.5474C75.7388 17.4272 77.1972 19.6563 78.1782 22.105C79.1593 24.5537 79.6435 27.1731 79.6026 29.8108V36.77Z"
								fill="#4A7EEE"
							/>
							<g opacity="0.4">
								<path
									d="M79.6026 36.77H73.6174V29.8108C73.6174 26.1236 72.1527 22.5875 69.5455 19.9803C66.9383 17.3731 63.4022 15.9084 59.7151 15.9084C56.0279 15.9084 52.4918 17.3731 49.8846 19.9803C47.2775 22.5875 45.8127 26.1236 45.8127 29.8108V62.37H39.8276V29.8108C39.7867 27.1731 40.2708 24.5537 41.2519 22.105C42.233 19.6563 43.6913 17.4272 45.5421 15.5474C47.3929 13.6677 49.5991 12.1749 52.0323 11.156C54.4655 10.137 57.0771 9.6123 59.7151 9.6123C62.353 9.6123 64.9646 10.137 67.3978 11.156C69.831 12.1749 72.0372 13.6677 73.888 15.5474C75.7388 17.4272 77.1972 19.6563 78.1782 22.105C79.1593 24.5537 79.6435 27.1731 79.6026 29.8108V36.77Z"
									fill="black"
								/>
							</g>
							<path
								d="M83.735 47.8809H35.6957C34.1593 47.8809 32.9138 49.1264 32.9138 50.6628V79.4873C32.9138 81.0237 34.1593 82.2692 35.6957 82.2692H83.735C85.2714 82.2692 86.5169 81.0237 86.5169 79.4873V50.6628C86.5169 49.1264 85.2714 47.8809 83.735 47.8809Z"
								fill="#4A7EEE"
							/>
							<g opacity="0.5">
								<path
									d="M64.1943 60.5988C64.1949 59.7649 63.9627 58.9473 63.524 58.2382C63.0853 57.529 62.4574 56.9563 61.7109 56.5844C60.9645 56.2126 60.1291 56.0564 59.2988 56.1334C58.4684 56.2104 57.676 56.5176 57.0107 57.0204C56.3454 57.5231 55.8335 58.2015 55.5327 58.9793C55.2319 59.7571 55.154 60.6034 55.3079 61.423C55.4618 62.2426 55.8413 63.003 56.4038 63.6187C56.9662 64.2344 57.6893 64.6809 58.4917 64.9081V71.6115H60.9384V64.9081C61.8771 64.6437 62.7034 64.0793 63.2913 63.3012C63.8792 62.5231 64.1964 61.574 64.1943 60.5988Z"
									fill="black"
								/>
							</g>
							<path
								d="M35.7723 79.009C35.6478 79.009 35.552 73.2633 35.552 66.2008C35.552 59.1383 35.6478 53.3926 35.7723 53.3926C35.8967 53.3926 35.9973 59.1383 35.9973 66.2008C35.9973 73.2633 35.8967 79.009 35.7723 79.009Z"
								fill="#FAFAFA"
							/>
							<path
								d="M56.2081 66.3397C56.2081 66.3397 55.9974 66.2726 55.6814 66.0428C55.2385 65.7119 54.8492 65.3146 54.5274 64.8649C53.9686 64.1274 53.5797 63.2754 53.3887 62.37C53.1976 61.4645 53.2091 60.528 53.4223 59.6276C53.6355 58.7271 54.0452 57.8849 54.622 57.1613C55.1988 56.4377 55.9285 55.8505 56.7587 55.4419C57.2554 55.1856 57.7882 55.0064 58.3388 54.9104C58.5352 54.8566 58.7409 54.8452 58.9421 54.8769C58.9421 54.9631 58.0946 55.0445 56.9311 55.7196C56.1716 56.1395 55.5084 56.7136 54.9839 57.405C54.4595 58.0963 54.0854 58.8897 53.8856 59.7342C53.6859 60.5787 53.6649 61.4557 53.8241 62.3087C53.9833 63.1618 54.3191 63.9721 54.8099 64.6878C55.2302 65.2756 55.6978 65.8281 56.2081 66.3397Z"
								fill="#FAFAFA"
							/>
							<path
								d="M2.06393 87.0668C3.20367 87.0668 4.12761 86.1429 4.12761 85.0031C4.12761 83.8634 3.20367 82.9395 2.06393 82.9395C0.924185 82.9395 0.000244141 83.8634 0.000244141 85.0031C0.000244141 86.1429 0.924185 87.0668 2.06393 87.0668Z"
								fill="#4A7EEE"
							/>
							<path
								d="M120 19.5743C119.999 19.9823 119.877 20.3808 119.65 20.7195C119.422 21.0583 119.1 21.322 118.723 21.4775C118.345 21.633 117.931 21.6731 117.531 21.593C117.131 21.5128 116.763 21.3159 116.475 21.0271C116.187 20.7383 115.991 20.3706 115.912 19.9704C115.833 19.5702 115.874 19.1555 116.03 18.7787C116.186 18.4019 116.451 18.0799 116.79 17.8533C117.129 17.6268 117.528 17.5059 117.936 17.5059C118.208 17.5059 118.476 17.5594 118.727 17.6634C118.978 17.7674 119.205 17.9198 119.397 18.112C119.589 18.3041 119.741 18.5322 119.844 18.7831C119.948 19.034 120.001 19.3029 120 19.5743Z"
								fill="#4A7EEE"
							/>
							<path
								d="M16.5575 90.3324C16.5575 90.4368 16.5265 90.5388 16.4684 90.6255C16.4103 90.7122 16.3278 90.7797 16.2313 90.8194C16.1348 90.8591 16.0286 90.8693 15.9263 90.8486C15.824 90.8279 15.7302 90.7772 15.6567 90.7031C15.5833 90.6289 15.5335 90.5347 15.5137 90.4322C15.4939 90.3297 15.505 90.2236 15.5456 90.1275C15.5862 90.0313 15.6545 89.9494 15.7417 89.8921C15.829 89.8348 15.9313 89.8047 16.0356 89.8057C16.1745 89.8069 16.3072 89.863 16.405 89.9616C16.5027 90.0603 16.5575 90.1935 16.5575 90.3324Z"
								fill="#4A7EEE"
							/>
							<path
								d="M27.757 32.4828C27.757 32.5869 27.7261 32.6888 27.6682 32.7754C27.6104 32.862 27.5281 32.9295 27.4319 32.9694C27.3356 33.0092 27.2297 33.0196 27.1276 32.9993C27.0254 32.979 26.9315 32.9288 26.8579 32.8552C26.7842 32.7815 26.7341 32.6877 26.7137 32.5855C26.6934 32.4833 26.7038 32.3774 26.7437 32.2812C26.7836 32.185 26.8511 32.1027 26.9377 32.0448C27.0243 31.9869 27.1261 31.9561 27.2303 31.9561C27.37 31.9561 27.504 32.0115 27.6027 32.1103C27.7015 32.2091 27.757 32.3431 27.757 32.4828Z"
								fill="#4A7EEE"
							/>
							<path
								d="M116.922 40.1411C116.922 40.2456 116.892 40.3481 116.835 40.4355C116.777 40.5228 116.695 40.5911 116.599 40.6315C116.502 40.672 116.396 40.6828 116.293 40.6626C116.191 40.6425 116.096 40.5922 116.022 40.5183C115.948 40.4443 115.898 40.35 115.878 40.2474C115.858 40.1448 115.869 40.0385 115.909 39.9421C115.95 39.8456 116.018 39.7634 116.105 39.7059C116.193 39.6484 116.295 39.6182 116.4 39.6192C116.538 39.6192 116.671 39.6741 116.769 39.772C116.867 39.8699 116.922 40.0026 116.922 40.1411Z"
								fill="#4A7EEE"
							/>
						</svg>
						<h2 className="themegrill-demo-importer-BlankState-message my-[30px] w-[68%] mx-auto">
							{__(
								'In order to be able to import any starter sites for Zakra you need to install ThemeGrill demo importer plugin active.',
								'zakra',
							)}
						</h2>
						{'active' !==
							pluginsStatus[
								'themegrill-demo-importer/themegrill-demo-importer.php'
							] && (
							<button
								onClick={async () => {
									await performPluginAction(
										'themegrill-demo-importer/themegrill-demo-importer.php',
									);
									window.location.href =
										localized.adminUrl +
										'themes.php?page=zakra-starter-templates&browse=all';
								}}
								className="border-none rounded-[4px] text-[16px] w-9/12 p-[16px] text-[#FFFFFF] bg-[#2563EB] cursor-pointer"
								data-name="themegrill-demo-importer"
								data-slug="themegrill-demo-importer"
								aria-label="Install ThemeGrill Demo Importer Plugin"
							>
								{'inactive' ===
								pluginsStatus[
									'themegrill-demo-importer/themegrill-demo-importer.php'
								]
									? __('Activate ThemeGrill Demo Importer Plugin', 'zakra')
									: 'not-installed' ===
										  pluginsStatus[
												'themegrill-demo-importer/themegrill-demo-importer.php'
										  ]
										? __('Install ThemeGrill Demo Importer Plugin ')
										: 'View Starter Template'}
							</button>
						)}
					</div>

					<div className="starter-template-overlay"></div>
				</div>
			</div>
		</div>
	);
};
