<?php
    /**
     * Template for the post excerpt slider on the homepage.
     *
     * @package yumtastic
     * @since yumtastic 1.0
     */
    ?>

    <!--  scroller -->
    <?php if( is_home() && get_theme_mod( 'yumtastic_customizer_slider_disable' ) != 'disable' ) {
    ?>
    <div class="slider-wrapper23">
            <div class="yumtastic_slides container">
                    <?php
                    $yumtastic_image_size = "yumtastic-medium-image";
                    $yumtastic_number23 = 4;
                    $yumtastic_category=get_theme_mod('yumtastic_slider_category');

                        $yumtastic_featured_list_args  = array(
                            'posts_per_page' => $yumtastic_number23,
                            'cat' => $yumtastic_category
                        );
                        $yumtastic_featured_list_posts = new WP_Query( $yumtastic_featured_list_args );
                    ?>

                    <?php while( $yumtastic_featured_list_posts->have_posts() ) : $yumtastic_featured_list_posts->the_post() ?>
                <div class="item-slide">


                <div class="slide-wrap">


                    <?php if ( has_post_thumbnail() ) {
                        $image_alt = get_post_meta(get_post_thumbnail_id($post->ID), '_wp_attachment_image_alt', true); // Retrieve existing alt text
                        $image_alt = !empty($image_alt) ? $image_alt : get_the_title(get_post_thumbnail_id($post->ID)); // Use title if alt text is empty
                        $yumtastic_image = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), $yumtastic_image_size ); ?>
                        <div class="image-slide">
                            <a href="<?php echo esc_url(get_permalink()); ?>">
                                <img src="<?php echo $yumtastic_image[0]; ?>" alt="<?php echo esc_attr($image_alt); ?>" />
                            </a>
                        </div>
                    <?php }
                    else { ?>
                        <div class="image-slide">
                            <a href="<?php echo esc_url(get_permalink()); ?>">
                                <img src="<?php echo esc_url(get_template_directory_uri() . '/images/slider-default.png');  ?>" alt="<?php esc_attr_e('No Image', 'yumtastic'); ?>" />
                            </a>
                        </div>
                    <?php } ?>
                    <div class="feat-item-wrapper">
                        <div class="feat-overlay">
                            <div class="feat-inner">
                                <div class="scroll-post">
                                    <?php echo yumtastic_getCategory(); ?>
                                </div>
                                <h2 class="feat-title">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h2>

                            </div>
                        </div>



                    </div>


                </div>

                </div>

            <?php endwhile; ?>
                    <?php wp_reset_postdata(); ?>
            </div><!-- slides -->
    </div>



    <?php } ?>