<?php
    /**
     * Template for the Footer Grids.
     *
     * @package yumtastic
     * @since yumtastic 1.0
     */
    ?>

    <!--  scroller -->
    <?php if( get_theme_mod( 'yumtastic_customizer_footerslider_disable' ) != 'disable' ) {
    ?>
    <div class="yumtastic_footerslider_whole">
    <?php
    $yumtastic_image_size = "yumtastic-medium-image";
    $yumtastic_number23 = 4;
    $yumtastic_category1=get_theme_mod('yumtastic_footerslider_category1');
    $yumtastic_category2=get_theme_mod('yumtastic_footerslider_category2');
    $yumtastic_category3=get_theme_mod('yumtastic_footerslider_category3');

    $yumtastic_featured_list_args1  = array(
        'posts_per_page' => $yumtastic_number23,
        'cat' => $yumtastic_category1
    );
    $yumtastic_featured_list_args2  = array(
        'posts_per_page' => $yumtastic_number23,
        'cat' => $yumtastic_category2
    );
    $yumtastic_featured_list_args3  = array(
        'posts_per_page' => $yumtastic_number23,
        'cat' => $yumtastic_category3
    );
    $yumtastic_featured_list_posts1 = new WP_Query( $yumtastic_featured_list_args1 );
    $yumtastic_featured_list_posts2 = new WP_Query( $yumtastic_featured_list_args2 );
    $yumtastic_featured_list_posts3 = new WP_Query( $yumtastic_featured_list_args3 );
    ?>

            <div class="yumtastic-footergrid-heading container">
                <div class="yumtastic-toggle active" data-index="1">
                    <?php
                    if (!get_theme_mod('yumtastic_footerslider_text1')){
                        _e( 'Breakfast', 'yumtastic' );
                    }
                    else{
                        echo wp_kses_post(get_theme_mod('yumtastic_footerslider_text1'));
                    } ?>
                </div>
                <div class="yumtastic-toggle notactive" data-index="2">
                    <?php
                    if (!get_theme_mod('yumtastic_footerslider_text2')){
                        _e( 'Lunch', 'yumtastic' );
                    }
                    else{
                        echo wp_kses_post(get_theme_mod('yumtastic_footerslider_text2'));
                    } ?>
                </div>
                <div class="yumtastic-toggle notactive" data-index="3">
                    <?php
                    if (!get_theme_mod('yumtastic_footerslider_text3')){
                        _e( 'Dinner', 'yumtastic' );
                    }
                    else{
                        echo wp_kses_post(get_theme_mod('yumtastic_footerslider_text3'));
                    } ?>
                </div>
            </div>
        <div class="slideswrap">
            <div class="yumtastic_slides container active">


                    <?php while( $yumtastic_featured_list_posts1->have_posts() ) : $yumtastic_featured_list_posts1->the_post() ?>

                    <div class="item-slide">


                <div class="slide-wrap">


                    <?php if ( has_post_thumbnail() ) {
                        $image_alt = get_post_meta(get_post_thumbnail_id($post->ID), '_wp_attachment_image_alt', true); // Retrieve existing alt text
                        $image_alt = !empty($image_alt) ? $image_alt : get_the_title(get_post_thumbnail_id($post->ID)); // Use title if alt text is empty
                        $yumtastic_image = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), $yumtastic_image_size ); ?>
                        <div class="image-slide">
                            <a href="<?php echo esc_url(get_permalink()); ?>">
                                <img src="<?php echo $yumtastic_image[0]; ?>" alt="<?php echo esc_attr($image_alt); ?>" loading="lazy" />
                            </a>
                        </div>
                    <?php }
                    else { ?>
                        <div class="image-slide">
                            <a href="<?php echo esc_url(get_permalink()); ?>">
                                <img src="<?php echo esc_url(get_template_directory_uri() . '/images/slider-default.png');  ?>" alt="<?php esc_attr_e('No Image', 'yumtastic'); ?>"  loading="lazy" />
                            </a>
                        </div>
                    <?php } ?>
                    <div class="feat-item-wrapper">
                        <div class="feat-overlay">
                            <div class="feat-inner">
                                <div class="scroll-post">
                                    <?php echo yumtastic_getCategory(); ?>
                                </div>
                                <h2 class="feat-title">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h2>

                            </div>
                        </div>



                    </div>


                </div>

                </div>

                    <?php endwhile; ?>
                    <?php wp_reset_postdata(); ?>

            </div><!-- slides -->

        <div class="yumtastic_slides container">


            <?php while( $yumtastic_featured_list_posts2->have_posts() ) : $yumtastic_featured_list_posts2->the_post() ?>

                <div class="item-slide">


                    <div class="slide-wrap">


                        <?php if ( has_post_thumbnail() ) {
                            $image_alt = get_post_meta(get_post_thumbnail_id($post->ID), '_wp_attachment_image_alt', true); // Retrieve existing alt text
                            $image_alt = !empty($image_alt) ? $image_alt : get_the_title(get_post_thumbnail_id($post->ID)); // Use title if alt text is empty
                            $yumtastic_image = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), $yumtastic_image_size ); ?>
                            <div class="image-slide">
                                <a href="<?php echo esc_url(get_permalink()); ?>">
                                    <img src="<?php echo $yumtastic_image[0]; ?>" alt="<?php echo esc_attr($image_alt);  ?>" loading="lazy" />
                                </a>
                            </div>
                        <?php }
                        else { ?>
                            <div class="image-slide">
                                <a href="<?php echo esc_url(get_permalink()); ?>">
                                    <img src="<?php echo esc_url(get_template_directory_uri() . '/images/slider-default.png');  ?>" alt="<?php esc_attr_e('No Image', 'yumtastic');  ?>" loading="lazy" />
                                </a>
                            </div>
                        <?php } ?>
                        <div class="feat-item-wrapper">
                            <div class="feat-overlay">
                                <div class="feat-inner">
                                    <div class="scroll-post">
                                        <?php echo yumtastic_getCategory(); ?>
                                    </div>
                                    <h2 class="feat-title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h2>

                                </div>
                            </div>



                        </div>


                    </div>

                </div>

            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>

        </div><!-- slides -->

            <div class="yumtastic_slides container">


                <?php while( $yumtastic_featured_list_posts3->have_posts() ) : $yumtastic_featured_list_posts3->the_post() ?>

                    <div class="item-slide">


                        <div class="slide-wrap">


                            <?php if ( has_post_thumbnail() ) {
                                $image_alt = get_post_meta(get_post_thumbnail_id($post->ID), '_wp_attachment_image_alt', true); // Retrieve existing alt text
                                $image_alt = !empty($image_alt) ? $image_alt : get_the_title(get_post_thumbnail_id($post->ID)); // Use title if alt text is empty
                                $yumtastic_image = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), $yumtastic_image_size ); ?>
                                <div class="image-slide">
                                    <a href="<?php echo esc_url(get_permalink()); ?>">
                                        <img src="<?php echo $yumtastic_image[0]; ?>" alt="<?php echo esc_attr($image_alt); ?>"  loading="lazy" />
                                    </a>
                                </div>
                            <?php }
                            else { ?>
                                <div class="image-slide">
                                    <a href="<?php echo esc_url(get_permalink()); ?>">
                                        <img src="<?php echo esc_url(get_template_directory_uri() . '/images/slider-default.png');  ?>" alt="<?php esc_attr_e('No Image', 'yumtastic'); ?>"  loading="lazy" />
                                    </a>
                                </div>
                            <?php } ?>
                            <div class="feat-item-wrapper">
                                <div class="feat-overlay">
                                    <div class="feat-inner">
                                        <div class="scroll-post">
                                            <?php echo yumtastic_getCategory(); ?>
                                        </div>
                                        <h2 class="feat-title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h2>

                                    </div>
                                </div>



                            </div>


                        </div>

                    </div>

                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>

            </div><!-- slides -->

        </div>

    </div>
    <?php } ?>