<?php // About Yumtastic

// Add About Yumtastic Page
function yumtastic_about_page() {
    add_theme_page( esc_html__( 'About Yumtastic', 'yumtastic' ), esc_html__( 'About Yumtastic', 'yumtastic' ), 'edit_theme_options', 'about-yumtastic', 'yumtastic_about_page_output' );
}
add_action( 'admin_menu', 'yumtastic_about_page' );

// Render About yumtastic HTML
function yumtastic_about_page_output() {
    ?>
    <div class="wrap">
        <h1><?php esc_html_e( 'Welcome to Yumtastic!', 'yumtastic' ); ?></h1>
        <p class="welcome-text">
            <?php esc_html_e( 'Yumtastic is free food blog WordPress Blog theme. It\'s perfect for any kind of blog: personal, multi-author, food, lifestyle, etc... Is fully Responsive and Retina Display ready, clean, modern and minimal. Coded with latest WordPress\' standards.', 'yumtastic' ); ?>
        </p>

        <!-- Tabs -->
        <?php $active_tab = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : 'yumtastic_tab_1'; ?>

        <div class="nav-tab-wrapper">
            <a href="<?php echo esc_url('?page=about-yumtastic&tab=yumtastic_tab_1')?>" class="nav-tab <?php echo $active_tab == 'yumtastic_tab_1' ? 'nav-tab-active' : ''; ?>">
                <?php esc_html_e( 'Getting Started', 'yumtastic' ); ?>
            </a>
            <a href="<?php echo esc_url('?page=about-yumtastic&tab=yumtastic_tab_2')?>" class="nav-tab <?php echo $active_tab == 'yumtastic_tab_2' ? 'nav-tab-active' : ''; ?>">
                <?php esc_html_e( 'Recommended Plugins', 'yumtastic' ); ?>
            </a>
            <a href="<?php echo esc_url('?page=about-yumtastic&tab=yumtastic_tab_3')?>" class="nav-tab <?php echo $active_tab == 'yumtastic_tab_3' ? 'nav-tab-active' : ''; ?>">
                <?php esc_html_e( 'Support', 'yumtastic' ); ?>
            </a>
            <a href="<?php echo esc_url('?page=about-yumtastic&tab=yumtastic_tab_4')?>" class="nav-tab <?php echo $active_tab == 'yumtastic_tab_4' ? 'nav-tab-active' : ''; ?>">
                <?php esc_html_e( 'Free vs Premium', 'yumtastic' ); ?>
            </a>
        </div>

        <!-- Tab Content -->
        <?php if ( $active_tab == 'yumtastic_tab_1' ) : ?>

            <div class="three-columns-wrap">

                <br>

                <div class="column-wdith-3">
                    <h3><?php esc_html_e( 'Theme Documentation', 'yumtastic' ); ?></h3>
                    <p>
                        <?php esc_html_e( 'Highly recommended to begin with this, read the full theme documentation to understand the basics and even more details about how to use Yumtastic. It is worth to spend 10 minutes and know almost everything about the theme.', 'yumtastic' ); ?>
                    </p>
                    <a target="_blank" href="<?php echo esc_url('https://www.vinethemes.com/documentation/yumtastic-theme-documentation/'); ?>" class="button button-primary"><?php esc_html_e( 'Read Documentation', 'yumtastic' ); ?></a>
                </div>


                <div class="column-wdith-3">
                    <h3><?php esc_html_e( 'Theme Customizer', 'yumtastic' ); ?></h3>
                    <p>
                        <?php esc_html_e( 'All theme options are located here. After reading the Theme Documentation we recommend you to open the Theme Customizer and play with some options. You will enjoy it.', 'yumtastic' ); ?>
                    </p>
                    <a target="_blank" href="<?php echo esc_url( wp_customize_url() );?>" class="button button-primary"><?php esc_html_e( 'Customize Your Site', 'yumtastic' ); ?></a>
                </div>

            </div>

            <div class="four-columns-wrap">

                <h2><?php esc_html_e( 'Yumtastic Premium - Predefined Styles', 'yumtastic' ); ?></h2>
                <p>
                    <?php esc_html_e( 'Yumtastic Premium\'s powerful setup allows you to easily create unique looking sites. Here are a few included examples that can be installed with one click in the ', 'yumtastic' ); ?>
                    <a target="_blank" href="<?php echo esc_url('https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/'); ?>"><?php esc_html_e( 'Yumtastic Premium Theme.', 'yumtastic' ); ?></a>
                    <?php esc_html_e( 'More details in the theme Documentation.', 'yumtastic' ); ?>
                </p>

                <div class="column-wdith-4">
                    <div class="active-style"><?php esc_html_e( 'Active', 'yumtastic' ); ?></div>

                    <div>
                        <h2><?php esc_html_e( 'Version 1', 'yumtastic' ); ?></h2>
                        <a href="<?php echo esc_url('https://demo.vinethemes.com/yumtastic/'); ?>" target="_blank" class="button button-primary"><?php esc_html_e( 'Live Preview', 'yumtastic' ); ?></a>
                    </div>
                </div>
                <div class="column-wdith-4">

                    <div>
                        <h2><?php esc_html_e( 'Version 2', 'yumtastic' ); ?></h2>
                        <a href="<?php echo esc_url('https://demo.vinethemes.com/yumtastic/?home=2'); ?>" target="_blank" class="button button-primary"><?php esc_html_e( 'Live Preview', 'yumtastic' ); ?></a>
                    </div>
                </div>
                <div class="column-wdith-4">

                    <div>
                        <h2><?php esc_html_e( 'Version 3', 'yumtastic' ); ?></h2>
                        <a href="<?php echo esc_url('https://demo.vinethemes.com/yumtastic/?home=3'); ?>" target="_blank" class="button button-primary"><?php esc_html_e( 'Live Preview', 'yumtastic' ); ?></a>
                    </div>
                </div>


            </div>

        <?php elseif ( $active_tab == 'yumtastic_tab_2' ) : ?>

            <div class="three-columns-wrap">

                <br>
                <p><?php esc_html_e( 'Recommended Plugins are fully supported by Yumtastic theme. They well build the theme by giving more and more features. These are highly recommended to install.', 'yumtastic' ); ?></p>
                <br>

                <?php


                // Kirki
                yumtastic_recommended_plugin( 'kirki', 'index', esc_html__( 'Kirki', 'yumtastic' ), esc_html__( 'Theme advanced customizer options.', 'yumtastic' ) );

                // MailChimp
                yumtastic_recommended_plugin( 'mailchimp-for-wp', 'mailchimp-for-wp', esc_html__( 'Mailchimp', 'yumtastic' ), esc_html__( 'Mail newsletters. Simple but flexible.', 'yumtastic' ) );

                // Instagram Widget
                yumtastic_recommended_plugin( 'wp-instagram-widget', 'wp-instagram-widget', esc_html__( 'WP Instagram Widget', 'yumtastic' ), esc_html__( 'A WordPress widget for showing your latest Instagram photos.', 'yumtastic' ) );



                ?>


            </div>

        <?php elseif ( $active_tab == 'yumtastic_tab_3' ) : ?>

            <div class="three-columns-wrap">

                <br>

                <div class="column-wdith-3">
                    <h3>
                        <span class="dashicons dashicons-sos"></span>
                        <?php esc_html_e( 'Forums', 'yumtastic' ); ?>
                    </h3>
                    <p>
                        <?php esc_html_e( 'Before asking a questions it\'s highly recommended to search on forums, but if you can\'t find the solution feel free to create a new topic.', 'yumtastic' ); ?>
                    <hr>
                    <a target="_blank" href="<?php echo esc_url('https://www.vinethemes.com/forums/'); ?>"><?php esc_html_e( 'Go to Support Forums', 'yumtastic' ); ?></a>
                    </p>
                </div>

                <div class="column-wdith-3">
                    <h3>
                        <span class="dashicons dashicons-book"></span>
                        <?php esc_html_e( 'Documentation', 'yumtastic' ); ?>
                    </h3>
                    <p>
                        <?php esc_html_e( 'Need more details? Please check out yumtastic Theme Documentation for detailed information.', 'yumtastic' ); ?>
                    <hr>
                    <a target="_blank" href="<?php echo esc_url('https://www.vinethemes.com/documentation/yumtastic-theme-documentation/'); ?>"><?php esc_html_e( 'Read Full Documentation', 'yumtastic' ); ?></a>
                    </p>
                </div>


                <div class="column-wdith-3">
                    <h3>
                        <span class="dashicons dashicons-smiley"></span>
                        <?php esc_html_e( 'Donation', 'yumtastic' ); ?>
                    </h3>
                    <p>
                        <?php esc_html_e( 'Even a small sum can help us a lot with theme development. If the yumtastic theme is useful and our support is helpful, please don\'t hesitate to donate a little bit, at least buy us a Coffee or a Beer :)', 'yumtastic' ); ?>
                    <hr>
                    <a target="_blank" href="<?php echo esc_url('https://www.paypal.me/oddthemes'); ?>"><?php esc_html_e( 'Donate with PayPal', 'yumtastic' ); ?></a>
                    </p>
                </div>

            </div>

        <?php elseif ( $active_tab == 'yumtastic_tab_4' ) : ?>

            <br><br>

            <table class="free-vs-pro form-table">
                <thead>
                <tr>
                    <th>
                        <a href="<?php echo esc_url('https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/'); ?>" target="_blank" class="button button-primary button-hero">
                            <?php esc_html_e( 'Get Yumtastic Premium', 'yumtastic' ); ?>
                        </a>

                    </th>
                    <th><?php esc_html_e( 'Yumtastic', 'yumtastic' ); ?></th>
                    <th><?php esc_html_e( 'Yumtastic Premium', 'yumtastic' ); ?></th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>
                        <h3><?php esc_html_e( '100% Responsive and Retina Ready', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Theme adapts to any kind of device screen, from mobile phones to high resolution Retina displays.', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Translation Ready', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Each hard-coded string is ready for translation, means you can translate everything. Language "yumtastic.pot" file included.', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'MailChimp Support', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'The most popular email client plugin. Very simple but super flexible.', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Image &amp; Text Logos', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Upload your logo image(set the size) or simply type your text logo.', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Featured Posts Slider', 'yumtastic' ); ?></h3>
                        <p>
                            <?php esc_html_e( 'Showcase unlimited number of Blog Posts in header area. There are three Slider designs.', 'yumtastic' ); ?>
                        </p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Background Image/Color', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Set the custom body Background image or Color.', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Header Background Image/Color', 'yumtastic' ); ?></h3>
                        <p>
                            <?php esc_html_e( 'Set the custom header Background image or Color.', 'yumtastic' ); ?>
                        </p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Instagram Widget Area', 'yumtastic' ); ?></h3>
                        <p>
                            <?php esc_html_e( 'Set your Instagram Images in the footer.', 'yumtastic' ); ?>
                        </p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>

                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Post Layouts', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Standard, List and Grid Blog Feed layout.', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Multi-level Sub Menu Support', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Unlimited level of sub menus. Add as much as you need.', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Right Sidebar', 'yumtastic' ); ?></h3>
                        <p>
                            <?php esc_html_e( 'Right Widgetised area.', 'yumtastic' ); ?>
                        </p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <!-- Only Pro -->
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Unlimited Colors', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Tons of color options. You can customize your Header, Content and Footer separately as much as possible.', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-no"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( '800+ Google Fonts', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Rich Typography options. Choose from more than 800 Google Fonts, adjust Size, Line Height, Font Weight, etc...', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-no"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Grid Layout', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Choose from 1 up to 4 columns grid layout for your Blog Feed.', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-no"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'List Layout', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Choose from 1 up to 4 columns grid layout for your Blog Feed.', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-no"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>
                        <h3><?php esc_html_e( 'Advanced Footer Options', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Theme and Author credit links in the footer are automatically removed.', 'yumtastic' ); ?></p>
                    </td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-no"></span></td>
                    <td class="compare-icon"><span class="dashicons-before dashicons-yes"></span></td>
                </tr>


                <tr>
                    <td></td>
                    <td colspan="2">
                        <a href="<?php echo esc_url('https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/'); ?>" target="_blank" class="button button-primary button-hero">
                            <?php esc_html_e( 'Get Yumtastic Premium', 'yumtastic' ); ?>
                        </a>
                        <br>

                    </td>
                </tr>
                </tbody>
            </table>

        <?php endif; ?>

    </div><!-- /.wrap -->
    <?php
} // end yumtastic_about_page_output

// Check if plugin is installed
function yumtastic_check_installed_plugin( $slug, $filename ) {
    return file_exists( ABSPATH . 'wp-content/plugins/' . $slug . '/' . $filename . '.php' ) ? true : false;
}

// Generate Recommended Plugin HTML
function yumtastic_recommended_plugin( $slug, $filename, $name, $description) {

    if ( $slug === 'facebook-pagelike-widget' ) {
        $size = '128x128';
    } else {
        $size = '256x256';
    }

    ?>

    <div class="plugin-card">
        <div class="name column-name">
            <h3>
                <?php echo esc_html( $name ); ?>
                <img src="<?php echo esc_url('https://ps.w.org/'. $slug .'/assets/icon-'. $size .'.png') ?>" class="plugin-icon" alt="">
            </h3>
        </div>
        <div class="action-links">
            <?php if ( yumtastic_check_installed_plugin( $slug, $filename ) ) : ?>
                <button type="button" class="button button-disabled" disabled="disabled"><?php esc_html_e( 'Installed', 'yumtastic' ); ?></button>
            <?php else : ?>
                <a class="install-now button-primary" href="<?php echo esc_url( wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin='. $slug ), 'install-plugin_'. $slug ) ); ?>" >
                    <?php esc_html_e( 'Install Now', 'yumtastic' ); ?>
                </a>
            <?php endif; ?>
        </div>
        <div class="desc column-description">
            <p><?php echo esc_html( $description ); ?></p>
        </div>
    </div>

    <?php
}

// enqueue ui CSS/JS
function yumtastic_enqueue_about_page_scripts($hook) {

    if ( 'appearance_page_about-yumtastic' != $hook ) {
        return;
    }

    // enqueue CSS
    wp_enqueue_style( 'yumtastic-about-page-css', get_theme_file_uri( '/inc/about/css/about-yumtastic-page.css' ) );

}
add_action( 'admin_enqueue_scripts', 'yumtastic_enqueue_about_page_scripts' );