<?php
    /**
     *
     * Displays all of the <head> section and everything before <div id="content-wrap">
     *
     * @package yumtastic
     * @since yumtastic 1.0
     */
    ?>
    <!DOCTYPE html>
    <html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />

        <link rel="profile" href="http://gmpg.org/xfn/11" />

        <?php if ( is_singular() && pings_open() ) { ?>
            <link rel="pingback" href="<?php echo esc_url(get_bloginfo( 'pingback_url' )); ?>" />
        <?php } ?>

        <?php wp_head(); ?>
    </head>

    <body <?php body_class(); ?>>
    <?php
    //wp_body_open hook from WordPress 5.2
    if (function_exists('wp_body_open')) {
        wp_body_open();
    }
    else { do_action( 'wp_body_open' ); }
    ?>
    <a class="skip-link" href="#content"><?php _e( 'Skip to main content', 'yumtastic' ); ?></a>
        <div id="wrapper" class="clearfix">


            <?php if(get_theme_mod('yumtastic_information_bar_disable')!= 'disable'){ ?>

                <div class="information-bar">
                    <div class="container">
                    <?php if(get_theme_mod('yumtastic_information_link')){ ?>
                        <a href="<?php echo esc_url( get_theme_mod( 'yumtastic_information_link' ) ); ?>"><?php
                            if (!get_theme_mod('yumtastic_information_text')){
                                _e( 'Subscribe to get new recipes', 'yumtastic' );
                            }
                            else{
                                echo wp_kses_post(get_theme_mod('yumtastic_information_text'));
                            } ?></a>
                    <?php }
                    else {
                        if (!get_theme_mod('yumtastic_information_text')){
                            _e( 'Subscribe to get new recipes', 'yumtastic' );
                        }
                        else{
                            echo wp_kses_post(get_theme_mod('yumtastic_information_text'));
                        }

                    } ?>
                        <div class="close"><i class="fa fa-times"></i></div>
                    </div>
                </div>
            <?php } ?>


            <?php

            if(get_theme_mod('yumtastic_header_design_layout')!='header1') {
                if(get_theme_mod('yumtastic_header_design_layout')=='header2'){
                    ?>
                    <div class="yumtastic-top-bar header2">
                        <div class="header-inside clearfix">



                            <div class="hearder-holder">



                                <?php if( is_front_page() && is_home() ) { ?>

                                    <div class="logo-default">
                                        <div class="logo-text">

                                            <?php
                                            if (has_custom_logo()) {
                                                the_custom_logo();
                                                if (display_header_text()==true){ ?>

                                                    <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>

                                                    <span class="site-description"><?php bloginfo( 'description' ); ?></span>
                                                    <?php
                                                }
                                            }

                                            else {

                                            if (display_header_text() == true){
                                            ?>
                                            <span class="only-text">
                                <h1>
                                    <a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo( 'name' ); ?></a>
                                </h1>
                                <span><?php bloginfo('description') ?></span>
                                </span>
                                            <?php
                                            }
                                            }
                                            ?><!-- otherwise show the site title and description -->

                                        </div>

                                    </div>

                                <?php } else { ?>

                                    <div class="logo-default">
                                        <div class="logo-text">

                                            <?php
                                            if (has_custom_logo()) {
                                                the_custom_logo();
                                                if (display_header_text()==true){ ?>

                                                    <span class="only-text">
                                        <h2 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h2>

                                        <span class="site-description"><?php bloginfo( 'description' ); ?></span>
                                </span>
                                                    <?php

                                                }
                                            }

                                            else {

                                            if (display_header_text() == true){
                                            ?>
                                            <h2>
                                                <a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo( 'name' ); ?></a>
                                            </h2>
                                            <span><?php bloginfo('description') ?></span>
                                            <?php
                                            }
                                            }
                                            ?><!-- otherwise show the site title and description -->

                                        </div>

                                    </div>

                                <?php } ?>



                                <?php if ( has_header_image() ) { ?>
                                    <img src="<?php header_image(); ?>" class="header-image" alt="<?php esc_attr_e( 'Header image','yumtastic' ); ?>" />
                                <?php } ?>

                            </div>

                        </div><!-- header inside -->
                        <div class="menu-wrap">

                            <?php if ( has_nav_menu( 'main' ) ) { ?>
                                <div class="top-bar">
                                    <div class="menu-wrap-inner">
                                        <a class="menu-toggle" href="#"><i class="fa fa-bars"></i></a>
                                        <?php wp_nav_menu( array( 'theme_location' => 'main', 'menu_class' => 'main-nav clearfix' ) ); ?>

                                    </div>
                                </div><!-- top bar -->
                            <?php } ?>



                            <div class="social-links">

                                <div class="socials">
                                    <?php if(!get_theme_mod('yumtastic_general_search_icon')) : ?>
                                        <button class="button ct_icon search" id="open-trigger">
                                            <i class="fa fa-search"></i>
                                        </button>


                                        <div class="modal micromodal-slide" id="modal-1" aria-hidden="true">
                                            <div class="modal__overlay" tabindex="-1" data-micromodal-close>
                                                <div class="modal__container" role="dialog" aria-modal="true" aria-labelledby="modal-1-title">

                                                    <main class="modal__content" id="modal-1-content">
                                                        <div id="modal-1-content">
                                                            <?php get_search_form(); ?>

                                                        </div>
                                                    </main>

                                                </div>
                                                <button class="button" id="close-trigger">
                                                    <i class="fa fa-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>


                    </div><!-- top bar -->
                    <?php
                }
                else{
                    ?>
                    <div class="yumtastic-top-bar header1">
                        <div class="header-inside clearfix">



                            <div class="hearder-holder">



                                <?php if( is_front_page() && is_home() ) { ?>

                                    <div class="logo-default">
                                        <div class="logo-text">

                                            <?php
                                            if (has_custom_logo()) {
                                                the_custom_logo();
                                                if (display_header_text()==true){ ?>

                                                    <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>

                                                    <span class="site-description"><?php bloginfo( 'description' ); ?></span>
                                                    <?php
                                                }
                                            }

                                            else {

                                            if (display_header_text() == true){
                                            ?>
                                            <span class="only-text">
                                <h1>
                                    <a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo( 'name' ); ?></a>
                                </h1>
                                <span><?php bloginfo('description') ?></span>
                                </span>
                                            <?php
                                            }
                                            }
                                            ?><!-- otherwise show the site title and description -->

                                        </div>

                                    </div>

                                <?php } else { ?>

                                    <div class="logo-default">
                                        <div class="logo-text">

                                            <?php
                                            if (has_custom_logo()) {
                                                the_custom_logo();
                                                if (display_header_text()==true){ ?>

                                                    <span class="only-text">
                                        <h2 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h2>

                                        <span class="site-description"><?php bloginfo( 'description' ); ?></span>
                                </span>
                                                    <?php

                                                }
                                            }

                                            else {

                                            if (display_header_text() == true){
                                            ?>
                                            <h2>
                                                <a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo( 'name' ); ?></a>
                                            </h2>
                                            <span><?php bloginfo('description') ?></span>
                                            <?php
                                            }
                                            }
                                            ?><!-- otherwise show the site title and description -->

                                        </div>

                                    </div>

                                <?php } ?>



                                <?php if ( has_header_image() ) { ?>
                                    <img src="<?php header_image(); ?>" class="header-image" alt="<?php esc_attr_e( 'Header image','yumtastic' ); ?>" />
                                <?php } ?>

                            </div>

                        </div><!-- header inside -->
                        <div class="menu-wrap">

                            <?php if ( has_nav_menu( 'main' ) ) { ?>
                                <div class="top-bar">
                                    <div class="menu-wrap-inner">
                                        <a class="menu-toggle" href="#"><i class="fa fa-bars"></i></a>
                                        <?php wp_nav_menu( array( 'theme_location' => 'main', 'menu_class' => 'main-nav clearfix' ) ); ?>

                                    </div>
                                </div><!-- top bar -->
                            <?php } ?>


                            <div class="social-links">

                                <div class="socials">
                                    <?php if(!get_theme_mod('yumtastic_general_search_icon')) : ?>
                                        <button class="button ct_icon search" id="open-trigger">
                                            <i class="fa fa-search"></i>
                                        </button>


                                        <div class="modal micromodal-slide" id="modal-1" aria-hidden="true">
                                            <div class="modal__overlay" tabindex="-1" data-micromodal-close>
                                                <div class="modal__container" role="dialog" aria-modal="true" aria-labelledby="modal-1-title">

                                                    <main class="modal__content" id="modal-1-content">
                                                        <div id="modal-1-content">
                                                            <?php get_search_form(); ?>

                                                        </div>
                                                    </main>

                                                </div>
                                                <button class="button" id="close-trigger">
                                                    <i class="fa fa-close"></i>
                                                </button>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                        </div>


                    </div><!-- top bar -->
                    <?php
                }
            }
            else{
                ?>
                <div class="yumtastic-top-bar header1">
                    <div class="header-inside clearfix">



                        <div class="hearder-holder">



                            <?php if( is_front_page() && is_home() ) { ?>

                                <div class="logo-default">
                                    <div class="logo-text">

                                        <?php
                                        if (has_custom_logo()) {
                                            the_custom_logo();
                                            if (display_header_text()==true){ ?>

                                                <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>

                                                <span class="site-description"><?php bloginfo( 'description' ); ?></span>
                                                <?php
                                            }
                                        }

                                        else {

                                        if (display_header_text() == true){
                                        ?>
                                        <span class="only-text">
                                <h1>
                                    <a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo( 'name' ); ?></a>
                                </h1>
                                <span><?php bloginfo('description') ?></span>
                                </span>
                                        <?php
                                        }
                                        }
                                        ?><!-- otherwise show the site title and description -->

                                    </div>

                                </div>

                            <?php } else { ?>

                                <div class="logo-default">
                                    <div class="logo-text">

                                        <?php
                                        if (has_custom_logo()) {
                                            the_custom_logo();
                                            if (display_header_text()==true){ ?>

                                                <span class="only-text">
                                        <h2 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h2>

                                        <span class="site-description"><?php bloginfo( 'description' ); ?></span>
                                </span>
                                                <?php

                                            }
                                        }

                                        else {

                                        if (display_header_text() == true){
                                        ?>
                                        <h2>
                                            <a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo( 'name' ); ?></a>
                                        </h2>
                                        <span><?php bloginfo('description') ?></span>
                                        <?php
                                        }
                                        }
                                        ?><!-- otherwise show the site title and description -->

                                    </div>

                                </div>

                            <?php } ?>



                            <?php if ( has_header_image() ) { ?>
                                <img src="<?php header_image(); ?>" class="header-image" alt="<?php esc_attr_e( 'Header image','yumtastic' ); ?>" />
                            <?php } ?>

                        </div>

                    </div><!-- header inside -->
                    <div class="menu-wrap">

                        <?php if ( has_nav_menu( 'main' ) ) { ?>
                            <div class="top-bar">
                                <div class="menu-wrap-inner">
                                    <a class="menu-toggle" href="#"><i class="fa fa-bars"></i></a>
                                    <?php wp_nav_menu( array( 'theme_location' => 'main', 'menu_class' => 'main-nav clearfix' ) ); ?>

                                </div>
                            </div><!-- top bar -->
                        <?php } ?>

                        <div class="social-links">

                            <div class="socials">
                                <?php if(!get_theme_mod('yumtastic_general_search_icon')) : ?>
                                    <button class="button ct_icon search" id="open-trigger">
                                        <i class="fa fa-search"></i>
                                    </button>


                                    <div class="modal micromodal-slide" id="modal-1" aria-hidden="true">
                                        <div class="modal__overlay" tabindex="-1" data-micromodal-close>
                                            <div class="modal__container" role="dialog" aria-modal="true" aria-labelledby="modal-1-title">

                                                <main class="modal__content" id="modal-1-content">
                                                    <div id="modal-1-content">
                                                        <?php get_search_form(); ?>

                                                    </div>
                                                </main>

                                            </div>
                                            <button class="button" id="close-trigger">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>


                    </div>


                </div><!-- top bar -->
                <?php
            }

            ?>







            <?php if( !is_home() ) : ?>
                <?php if(get_theme_mod( 'yumtastic_featured_box' ) == true) : ?>

                    <?php get_template_part('inc/featured-box/featured_box'); ?>

                <?php endif; ?>
            <?php endif; ?>


            <div id="main" class="clearfix">
