<?php
    /**
     * Theme options via the Customizer.
     *
     * @package yumtastic
     * @since yumtastic 1.0
     */

    // ------------- Theme Customizer  ------------- //

    add_action( 'customize_register', 'yumtastic_customizer_register' );

    function yumtastic_customizer_register( $wp_customize ) {



// Pro Version
        class Yumtastic_Customize_Pro_Version extends WP_Customize_Control {
            public $type = 'pro_options';

            public function render_content() {
                echo '<span>Upgrade to <strong></strong></span>';
                echo '<a href="'. esc_url($this->description) .'" target="_blank">';
                echo '<strong> '. esc_html__( 'Yumtastic Premium', 'yumtastic' ) .'<strong></a>';
                echo '</a>';
            }
        }

        // Pro Version Links
        class Yumtastic_Customize_Pro_Version_Links extends WP_Customize_Control {
            public $type = 'pro_links';

            public function render_content() {
                ?>
                <ul>
                    <li class="customize-control">
                        <h3><?php esc_html_e( 'Upgrade', 'yumtastic' ); ?> <span>*</span></h3>
                        <p><?php esc_html_e( 'There are lots of reasons to upgrade to Pro version. Unlimited custom Colors, rich Typography options, multiple variation of Blog Feed layout and way much more. Also Premium Support included.', 'yumtastic' ); ?></p>
                        <a href="<?php echo esc_url('https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/'); ?>" target="_blank" class="button button-primary widefat"><?php esc_html_e( 'Get Yumtastic Premium', 'yumtastic' ); ?></a>
                    </li>
                    <li class="customize-control">
                        <h3><?php esc_html_e( 'Documentation', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'Read how to customize the theme, set up widgets, and learn all the possible options available to you.', 'yumtastic' ); ?></p>
                        <a href="<?php echo esc_url('https://www.vinethemes.com/documentation/yumtastic-theme-documentation/'); ?>" target="_blank" class="button button-primary widefat"><?php esc_html_e( 'Documentation', 'yumtastic' ); ?></a>
                    </li>
                    <li class="customize-control">
                        <h3><?php esc_html_e( 'Support', 'yumtastic' ); ?></h3>
                        <p><?php esc_html_e( 'For Yumtastic theme related questions feel free to post on our support forums.', 'yumtastic' ); ?></p>
                        <a href="<?php echo esc_url('https://www.vinethemes.com/forums'); ?>" target="_blank" class="button button-primary widefat"><?php esc_html_e( 'Support', 'yumtastic' ); ?></a>
                    </li>

                </ul>
                <?php
            }
        }


        /*
        ** Pro Version =====
        */

        // add Colors section
        $wp_customize->add_section( 'yumtastic_pro' , array(
            'title'		 => esc_html__( 'About Yumtastic', 'yumtastic' ),
            'priority'	 => 1,
            'capability' => 'edit_theme_options'
        ) );

        // Pro Version
        $wp_customize->add_setting( 'pro_version_', array(
            'sanitize_callback' => 'yumtastic_sanitize_custom_control'
        ) );
        $wp_customize->add_control( new Yumtastic_Customize_Pro_Version_Links ( $wp_customize,
                'pro_version_', array(
                    'section'	=> 'yumtastic_pro',
                    'type'		=> 'pro_links',
                    'label' 	=> '',
                    'priority'	=> 1
                )
            )
        );



        //Top Information Bar
        $wp_customize->add_section( 'yumtastic_information_bar', array(
            'title'       => esc_html__( 'Top Information Bar', 'yumtastic' ),
            'description' => esc_html__( 'Configure your Top Information bar here.', 'yumtastic' ),
            'priority'    => 2
        ) );


        $wp_customize->add_setting( 'yumtastic_information_bar_disable', array(
            'default'    => 'enable',
            'section'  => 'yumtastic_information_bar',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_radio',
        ) );

        $wp_customize->add_control( 'yumtastic_information_bar_select_box', array(
            'settings' => 'yumtastic_information_bar_disable',
            'label'    => esc_html__( 'Top Information Bar', 'yumtastic' ),
            'section'  => 'yumtastic_information_bar',
            'type'     => 'select',
            'choices'  => array(
                'enable'  => esc_html__( 'Enable', 'yumtastic' ),
                'disable' => esc_html__( 'Disable', 'yumtastic' ),
            ),
            'priority' => 1
        ) );

        $wp_customize->add_setting(
            'yumtastic_information_text',
            array(
                'default'     => '',
                'sanitize_callback' => 'sanitize_text_field'
            )
        );

        $wp_customize->add_control('yumtastic_information_text', array(
                'label'      => esc_html__('Information Bar Text','yumtastic'),
                'section'    => 'yumtastic_information_bar',
                'settings'   => 'yumtastic_information_text',
                'type'		 => 'text',
                'priority'	 => 2
            )
        );


        $wp_customize->add_setting(
            'yumtastic_information_link',
            array(
                'sanitize_callback' => 'esc_url_raw'
            )
        );

        $wp_customize->add_control('yumtastic_information_link', array(
                'label'      => esc_html__('Information Bar Link URL','yumtastic'),
                'section'    => 'yumtastic_information_bar',
                'settings'   => 'yumtastic_information_link',
                'type'		 => 'url',
                'priority'	 => 3
            )
        );

        // Pro Version
        $wp_customize->add_setting( 'pro_version_colors8', array(
            'sanitize_callback' => 'yumtastic_sanitize_custom_control'
        ) );
        $wp_customize->add_control( new Yumtastic_Customize_Pro_Version ( $wp_customize,
                'pro_version_colors8', array(
                    'section'	  => 'yumtastic_information_bar',
                    'type'		  => 'pro_options',
                    'label' 	  => esc_html__( 'Upgrade', 'yumtastic' ),
                    'description' => esc_url_raw( 'https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/' ),
                    'priority'	  => 100
                )
            )
        );



        //Top Information Bar


        // Header Design
        $wp_customize->add_section( 'yumtastic_header_designs', array(
            'title'       => esc_html__( 'Header Designs', 'yumtastic' ),
            'description' => esc_html__( 'Select Header Designs from here.', 'yumtastic' ),
            'priority'    => 3
        ) );

        $wp_customize->add_setting( 'yumtastic_header_design_layout', array(
            'default' => 'header1',
            'section'  => 'yumtastic_header_designs',
            'sanitize_callback'	=> 'yumtastic_sanitize_radio',
        ) );
        $wp_customize->add_control( 'yumtastic_header_design_layout', array(
            'type' => 'radio',
            'label'    => esc_html__( 'Header Design Layout', 'yumtastic' ),
            'section'  => 'yumtastic_header_designs',
            'choices'  => array(
                'header1'  => esc_html__( 'Header 1', 'yumtastic' ),
                'header2' => esc_html__( 'Header 2', 'yumtastic' ),
            ),
            'priority' => 10
        ) );

        // Pro Version
        $wp_customize->add_setting( 'pro_version_colors7', array(
            'sanitize_callback' => 'yumtastic_sanitize_custom_control'
        ) );
        $wp_customize->add_control( new Yumtastic_Customize_Pro_Version ( $wp_customize,
                'pro_version_colors7', array(
                    'section'	  => 'yumtastic_header_designs',
                    'type'		  => 'pro_options',
                    'label' 	  => esc_html__( 'Upgrade', 'yumtastic' ),
                    'description' => esc_url_raw( 'https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/' ),
                    'priority'	  => 100
                )
            )
        );

        //Header Design

        //Slick Slider
        $wp_customize->add_section( 'yumtastic_customizer_slider', array(
            'title'       => esc_html__( 'Top Grid Options', 'yumtastic' ),
            'description' => esc_html__( 'Configure your Top Grid here.', 'yumtastic' ),
            'priority'    => 4
        ) );
        $wp_customize->add_setting( 'yumtastic_customizer_slider_disable', array(
            'default'    => 'enable',
            'section'  => 'yumtastic_customizer_slider',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_radio',
        ) );

        $wp_customize->add_control( 'yumtastic_slider_select_box', array(
            'settings' => 'yumtastic_customizer_slider_disable',
            'label'    => esc_html__( 'Homepage Top Grid', 'yumtastic' ),
            'section'  => 'yumtastic_customizer_slider',
            'type'     => 'select',
            'choices'  => array(
                'enable'  => esc_html__( 'Enable', 'yumtastic' ),
                'disable' => esc_html__( 'Disable', 'yumtastic' ),
                ),
            'priority' => 5
        ) );
        $wp_customize->add_setting( 'yumtastic_slider_category', array(
            'default' => '0',
            'sanitize_callback'	=> 'absint',
            'section'  => 'yumtastic_customizer_slider',

        ) );
         $wp_customize->add_control(new yumtastic_Customize_Category_Control( $wp_customize, 'yumtastic_slider_category', array(
                    'label'    => esc_html__( 'Category for Top Grid', 'yumtastic' ),
                    'section'  => 'yumtastic_customizer_slider',
                    'settings' => 'yumtastic_slider_category',
                    'priority'	 => 6
                )
            )
        );

        // Pro Version
        $wp_customize->add_setting( 'pro_version_colors6', array(
            'sanitize_callback' => 'yumtastic_sanitize_custom_control'
        ) );
        $wp_customize->add_control( new Yumtastic_Customize_Pro_Version ( $wp_customize,
                'pro_version_colors6', array(
                    'section'	  => 'yumtastic_customizer_slider',
                    'type'		  => 'pro_options',
                    'label' 	  => esc_html__( 'Upgrade', 'yumtastic' ),
                    'description' => esc_url_raw( 'https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/' ),
                    'priority'	  => 100
                )
            )
        );



        // Featured Boxes Starts

        $wp_customize->add_section( 'yumtastic_featured_boxes' , array(
            'title'      => esc_html__( 'Featured Boxes','yumtastic'),
            'description'=> esc_html__( 'Configure Featured Boxes', 'yumtastic' ),
            'priority'   => 5
        ) );

        // Featured Boxes
        $wp_customize->add_setting('yumtastic_featured_box', array(
            'default'     => false,
            'section'  => 'yumtastic_featured_boxes',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_checkbox',
        ) );
        $wp_customize->add_setting('yumtastic_promo1_title', array(
            'default'     => '',
            'section'  => 'yumtastic_featured_boxes',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'sanitize_text_field',
        ) );

        $wp_customize->add_setting('yumtastic_promo1_image', array(
            'default' => get_theme_file_uri('images/slider-default.png'), // Add Default Image URL
            'sanitize_callback' => 'esc_url_raw'
        ));

        $wp_customize->add_setting(
            'yumtastic_promo1_url',
            array(
                'default'     => '',
                'sanitize_callback'	=> 'esc_url_raw',
            )
        );

        $wp_customize->add_setting('yumtastic_promo2_title', array(
            'default'     => '',
            'section'  => 'yumtastic_featured_boxes',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'sanitize_text_field',
        ) );

        $wp_customize->add_setting('yumtastic_promo2_image', array(
            'default' => get_theme_file_uri('images/slider-default.png'), // Add Default Image URL
            'sanitize_callback' => 'esc_url_raw'
        ));

        $wp_customize->add_setting(
            'yumtastic_promo2_url',
            array(
                'default'     => '',
                'sanitize_callback'	=> 'esc_url_raw',
            )
        );

        $wp_customize->add_setting('yumtastic_promo3_title', array(
            'default'     => '',
            'section'  => 'yumtastic_featured_boxes',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'sanitize_text_field',
        ) );

        $wp_customize->add_setting('yumtastic_promo3_image', array(
            'default' => get_theme_file_uri('images/slider-default.png'), // Add Default Image URL
            'sanitize_callback' => 'esc_url_raw'
        ));

        $wp_customize->add_setting(
            'yumtastic_promo3_url',
            array(
                'default'     => '',
                'sanitize_callback'	=> 'esc_url_raw',
            )
        );

        $wp_customize->add_setting('yumtastic_promo4_title', array(
            'default'     => '',
            'section'  => 'yumtastic_featured_boxes',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'sanitize_text_field',
        ) );

        $wp_customize->add_setting('yumtastic_promo4_image', array(
            'default' => get_theme_file_uri('images/slider-default.png'), // Add Default Image URL
            'sanitize_callback' => 'esc_url_raw'
        ));

        $wp_customize->add_setting(
            'yumtastic_promo4_url',
            array(
                'default'     => '',
                'sanitize_callback'	=> 'esc_url_raw',
            )
        );

        $wp_customize->add_setting('yumtastic_promo5_title', array(
            'default'     => '',
            'section'  => 'yumtastic_featured_boxes',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'sanitize_text_field',
        ) );

        $wp_customize->add_setting('yumtastic_promo5_image', array(
            'default' => get_theme_file_uri('images/slider-default.png'), // Add Default Image URL
            'sanitize_callback' => 'esc_url_raw'
        ));

        $wp_customize->add_setting(
            'yumtastic_promo5_url',
            array(
                'default'     => '',
                'sanitize_callback'	=> 'esc_url_raw',
            )
        );

        $wp_customize->add_setting('yumtastic_promo6_title', array(
            'default'     => '',
            'section'  => 'yumtastic_featured_boxes',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'sanitize_text_field',
        ) );

        $wp_customize->add_setting('yumtastic_promo6_image', array(
            'default' => get_theme_file_uri('images/slider-default.png'), // Add Default Image URL
            'sanitize_callback' => 'esc_url_raw'
        ));

        $wp_customize->add_setting(
            'yumtastic_promo6_url',
            array(
                'default'     => '',
                'sanitize_callback'	=> 'esc_url_raw',
            )
        );

        $wp_customize->add_setting('yumtastic_promo7_title', array(
            'default'     => '',
            'section'  => 'yumtastic_featured_boxes',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'sanitize_text_field',
        ) );

        $wp_customize->add_setting('yumtastic_promo7_image', array(
            'default' => get_theme_file_uri('images/slider-default.png'), // Add Default Image URL
            'sanitize_callback' => 'esc_url_raw'
        ));

        $wp_customize->add_setting(
            'yumtastic_promo7_url',
            array(
                'default'     => '',
                'sanitize_callback'	=> 'esc_url_raw',
            )
        );

        $wp_customize->add_setting('yumtastic_promo8_title', array(
            'default'     => '',
            'section'  => 'yumtastic_featured_boxes',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'sanitize_text_field',
        ) );

        $wp_customize->add_setting('yumtastic_promo8_image', array(
            'default' => get_theme_file_uri('images/slider-default.png'), // Add Default Image URL
            'sanitize_callback' => 'esc_url_raw'
        ));

        $wp_customize->add_setting(
            'yumtastic_promo8_url',
            array(
                'default'     => '',
                'sanitize_callback'	=> 'esc_url_raw',
            )
        );

        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'featured_boxes',
                array(
                    'label'      => esc_html__('Enable Featured Boxes','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_featured_box',
                    'type'		 => 'checkbox',
                    'priority'	 => 1
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo1_title',
                array(
                    'label'      => esc_html__('Featured Box1 Title','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo1_title',
                    'type'		 => 'text',
                    'priority'	 => 3
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Image_Control(
                $wp_customize,
                'promo1_image',
                array(
                    'label'      => esc_html__('Featured Box1 Image','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo1_image',
                    'priority'	 => 4
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo1_url',
                array(
                    'label'      => esc_html__('Featured Box1 URL','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo1_url',
                    'type'		 => 'url',
                    'priority'	 => 5
                )
            )
        );

        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo2_title',
                array(
                    'label'      => esc_html__('Featured Box2 Title','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo2_title',
                    'type'		 => 'text',
                    'priority'	 => 6
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Image_Control(
                $wp_customize,
                'promo2_image',
                array(
                    'label'      => esc_html__('Featured Box2 Image','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo2_image',
                    'priority'	 => 7
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo2_url',
                array(
                    'label'      => esc_html__('Featured Box2 URL','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo2_url',
                    'type'		 => 'url',
                    'priority'	 => 8
                )
            )
        );

        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo3_title',
                array(
                    'label'      => esc_html__('Featured Box3 Title','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo3_title',
                    'type'		 => 'text',
                    'priority'	 => 9
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Image_Control(
                $wp_customize,
                'promo3_image',
                array(
                    'label'      => esc_html__('Featured Box3 Image','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo3_image',
                    'priority'	 => 10
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo3_url',
                array(
                    'label'      => esc_html__('Featured Box3 URL','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo3_url',
                    'type'		 => 'url',
                    'priority'	 => 11
                )
            )
        );


        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo4_title',
                array(
                    'label'      => esc_html__('Featured Box4 Title','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo4_title',
                    'type'		 => 'text',
                    'priority'	 => 12
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Image_Control(
                $wp_customize,
                'promo4_image',
                array(
                    'label'      => esc_html__('Featured Box4 Image','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo4_image',
                    'priority'	 => 13
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo4_url',
                array(
                    'label'      => esc_html__('Featured Box4 URL','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo4_url',
                    'type'		 => 'url',
                    'priority'	 => 14
                )
            )
        );

        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo5_title',
                array(
                    'label'      => esc_html__('Featured Box5 Title','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo5_title',
                    'type'		 => 'text',
                    'priority'	 => 15
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Image_Control(
                $wp_customize,
                'promo5_image',
                array(
                    'label'      => esc_html__('Featured Box5 Image','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo5_image',
                    'priority'	 => 16
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo5_url',
                array(
                    'label'      => esc_html__('Featured Box5 URL','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo5_url',
                    'type'		 => 'url',
                    'priority'	 => 17
                )
            )
        );

        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo6_title',
                array(
                    'label'      => esc_html__('Featured Box6 Title','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo6_title',
                    'type'		 => 'text',
                    'priority'	 => 18
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Image_Control(
                $wp_customize,
                'promo6_image',
                array(
                    'label'      => esc_html__('Featured Box6 Image','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo6_image',
                    'priority'	 => 19
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo6_url',
                array(
                    'label'      => esc_html__('Featured Box6 URL','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo6_url',
                    'type'		 => 'url',
                    'priority'	 => 20
                )
            )
        );

        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo7_title',
                array(
                    'label'      => esc_html__('Featured Box7 Title','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo7_title',
                    'type'		 => 'text',
                    'priority'	 => 21
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Image_Control(
                $wp_customize,
                'promo7_image',
                array(
                    'label'      => esc_html__('Featured Box7 Image','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo7_image',
                    'priority'	 => 22
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo7_url',
                array(
                    'label'      => esc_html__('Featured Box7 URL','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo7_url',
                    'type'		 => 'url',
                    'priority'	 => 23
                )
            )
        );

        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo8_title',
                array(
                    'label'      => esc_html__('Featured Box8 Title','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo8_title',
                    'type'		 => 'text',
                    'priority'	 => 24
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Image_Control(
                $wp_customize,
                'promo8_image',
                array(
                    'label'      => esc_html__('Featured Box8 Image','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo8_image',
                    'priority'	 => 25
                )
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'promo8_url',
                array(
                    'label'      => esc_html__('Featured Box8 URL','yumtastic'),
                    'section'    => 'yumtastic_featured_boxes',
                    'settings'   => 'yumtastic_promo8_url',
                    'type'		 => 'url',
                    'priority'	 => 26
                )
            )
        );

        // Pro Version
        $wp_customize->add_setting( 'pro_version_colors5', array(
            'sanitize_callback' => 'yumtastic_sanitize_custom_control'
        ) );
        $wp_customize->add_control( new Yumtastic_Customize_Pro_Version ( $wp_customize,
                'pro_version_colors5', array(
                    'section'	  => 'yumtastic_featured_boxes',
                    'type'		  => 'pro_options',
                    'label' 	  => esc_html__( 'Upgrade', 'yumtastic' ),
                    'description' => esc_url_raw( 'https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/' ),
                    'priority'	  => 100
                )
            )
        );
        // Featured Boxes End


        // Footer Grid Options
        $wp_customize->add_section( 'yumtastic_customizer_footerslider', array(
            'title'       => esc_html__( 'Footer Grid Options', 'yumtastic' ),
            'description' => esc_html__( 'Configure your Footer Grid here. (Breakfast, Lunch, Dinner section)', 'yumtastic' ),
            'priority'    => 6
        ) );


        $wp_customize->add_setting( 'yumtastic_customizer_footerslider_disable', array(
            'default'    => 'enable',
            'section'  => 'yumtastic_customizer_footerslider',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_radio',
        ) );

        $wp_customize->add_control( 'yumtastic_footerslider_select_box', array(
            'settings' => 'yumtastic_customizer_footerslider_disable',
            'label'    => esc_html__( 'Footer Grids', 'yumtastic' ),
            'section'  => 'yumtastic_customizer_footerslider',
            'type'     => 'select',
            'choices'  => array(
                'enable'  => esc_html__( 'Enable', 'yumtastic' ),
                'disable' => esc_html__( 'Disable', 'yumtastic' ),
            ),
            'priority' => 6
        ) );



        $wp_customize->add_setting(
            'yumtastic_footerslider_text1',
            array(
                'default'     => '',
                'sanitize_callback' => 'sanitize_text_field'
            )
        );

        $wp_customize->add_control('yumtastic_footerslider_text1', array(
                'label'      => esc_html__('Heading for Footer Grid 1','yumtastic'),
                'section'    => 'yumtastic_customizer_footerslider',
                'settings'   => 'yumtastic_footerslider_text1',
                'type'		 => 'text',
                'priority'	 => 7
            )
        );


        $wp_customize->add_setting( 'yumtastic_footerslider_category1', array(
            'default' => '0',
            'sanitize_callback'	=> 'absint',
            'section'  => 'yumtastic_customizer_footerslider',

        ) );
        $wp_customize->add_control(new yumtastic_Customize_Category_Control( $wp_customize, 'yumtastic_footerslider_category1', array(
                    'label'    => esc_html__( 'Category for Footer Grid 1', 'yumtastic' ),
                    'section'  => 'yumtastic_customizer_footerslider',
                    'settings' => 'yumtastic_footerslider_category1',
                    'priority'	 => 8
                )
            )
        );

        $wp_customize->add_setting(
            'yumtastic_footerslider_text2',
            array(
                'default'     => '',
                'sanitize_callback' => 'sanitize_text_field'
            )
        );

        $wp_customize->add_control('yumtastic_footerslider_text2', array(
                'label'      => esc_html__('Heading for Footer Grid 2','yumtastic'),
                'section'    => 'yumtastic_customizer_footerslider',
                'settings'   => 'yumtastic_footerslider_text2',
                'type'		 => 'text',
                'priority'	 => 9
            )
        );

        $wp_customize->add_setting( 'yumtastic_footerslider_category2', array(
            'default' => '0',
            'sanitize_callback'	=> 'absint',
            'section'  => 'yumtastic_customizer_footerslider',

        ) );
        $wp_customize->add_control(new yumtastic_Customize_Category_Control( $wp_customize, 'yumtastic_footerslider_category2', array(
                    'label'    => esc_html__( 'Category for Footer Grid 2', 'yumtastic' ),
                    'section'  => 'yumtastic_customizer_footerslider',
                    'settings' => 'yumtastic_footerslider_category2',
                    'priority'	 => 10
                )
            )
        );
        $wp_customize->add_setting(
            'yumtastic_footerslider_text3',
            array(
                'default'     => '',
                'sanitize_callback' => 'sanitize_text_field'
            )
        );

        $wp_customize->add_control('yumtastic_footerslider_text3', array(
                'label'      => esc_html__('Heading for Footer Grid 3','yumtastic'),
                'section'    => 'yumtastic_customizer_footerslider',
                'settings'   => 'yumtastic_footerslider_text3',
                'type'		 => 'text',
                'priority'	 => 11
            )
        );
        $wp_customize->add_setting( 'yumtastic_footerslider_category3', array(
            'default' => '0',
            'sanitize_callback'	=> 'absint',
            'section'  => 'yumtastic_customizer_footerslider',

        ) );
        $wp_customize->add_control(new yumtastic_Customize_Category_Control( $wp_customize, 'yumtastic_footerslider_category3', array(
                    'label'    => esc_html__( 'Category for Footer Grid 3', 'yumtastic' ),
                    'section'  => 'yumtastic_customizer_footerslider',
                    'settings' => 'yumtastic_footerslider_category3',
                    'priority'	 => 12
                )
            )
        );

        // Pro Version
        $wp_customize->add_setting( 'pro_version_colors4', array(
            'sanitize_callback' => 'yumtastic_sanitize_custom_control'
        ) );
        $wp_customize->add_control( new Yumtastic_Customize_Pro_Version ( $wp_customize,
                'pro_version_colors4', array(
                    'section'	  => 'yumtastic_customizer_footerslider',
                    'type'		  => 'pro_options',
                    'label' 	  => esc_html__( 'Upgrade', 'yumtastic' ),
                    'description' => esc_url_raw( 'https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/' ),
                    'priority'	  => 100
                )
            )
        );

        // Footer Grid Options End



        //General Options

        $wp_customize->add_section( 'yumtastic_general_options', array(
            'title'       => esc_html__( 'General Options', 'yumtastic' ),
            'description' => esc_html__( 'Configure Your Theme Settings Here.', 'yumtastic' ),
            'priority'    => 7
        ) );

        $wp_customize->add_setting( 'yumtastic_general_search_icon', array(
            'section'  => 'yumtastic_general_options',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_checkbox',
        ) );

        $wp_customize->add_control( 'yumtastic_general_search_icon', array(
            'settings' => 'yumtastic_general_search_icon',
            'label'    => esc_html__( 'Hide Top Search Icon', 'yumtastic' ),
            'section'  => 'yumtastic_general_options',
            'type'     => 'checkbox',
            'priority' => 6
        ) );
        $wp_customize->add_setting( 'yumtastic_general_responsive', array(
            'section'  => 'yumtastic_general_options',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_checkbox',
        ) );

        $wp_customize->add_control( 'yumtastic_general_responsive', array(
            'settings' => 'yumtastic_general_responsive',
            'label'    => esc_html__( 'Disable Responsive', 'yumtastic' ),
            'section'  => 'yumtastic_general_options',
            'type'     => 'checkbox',
            'priority' => 6
        ) );
        $wp_customize->add_setting( 'yumtastic_general_sidebar_home', array(
            'section'  => 'yumtastic_general_options',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_checkbox',
        ) );

        $wp_customize->add_control( 'yumtastic_general_sidebar_home', array(
            'settings' => 'yumtastic_general_sidebar_home',
            'label'    => esc_html__( 'Disable Sidebar on Homepage and Archive Pages', 'yumtastic' ),
            'section'  => 'yumtastic_general_options',
            'type'     => 'checkbox',
            'priority' => 6
        ) );
        $wp_customize->add_setting( 'yumtastic_general_sidebar_post', array(
            'section'  => 'yumtastic_general_options',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_checkbox',
        ) );

        $wp_customize->add_control( 'yumtastic_general_sidebar_post', array(
            'settings' => 'yumtastic_general_sidebar_post',
            'label'    => esc_html__( 'Disable Sidebar on Posts', 'yumtastic' ),
            'section'  => 'yumtastic_general_options',
            'type'     => 'checkbox',
            'priority' => 6
        ) );
        $wp_customize->add_setting( 'yumtastic_general_sidebar_page', array(
            'section'  => 'yumtastic_general_options',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_checkbox',
        ) );

        $wp_customize->add_control( 'yumtastic_general_sidebar_page', array(
            'settings' => 'yumtastic_general_sidebar_page',
            'label'    => esc_html__( 'Disable Sidebar on Pages', 'yumtastic' ),
            'section'  => 'yumtastic_general_options',
            'type'     => 'checkbox',
            'priority' => 6
        ) );

        $wp_customize->add_setting( 'yumtastic_general_author_post', array(
            'section'  => 'yumtastic_general_options',
            'capability' => 'edit_theme_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_checkbox',
        ) );

        $wp_customize->add_control( 'yumtastic_general_author_post', array(
            'settings' => 'yumtastic_general_author_post',
            'label'    => esc_html__( 'Disable Author Box on Posts', 'yumtastic' ),
            'section'  => 'yumtastic_general_options',
            'type'     => 'checkbox',
            'priority' => 6
        ) );

        $wp_customize->add_setting( 'yumtastic_general_post_summary', array(
            'default' => 'excerpt',
            'section'  => 'yumtastic_general_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_radio',
        ) );

        $wp_customize->add_control( 'yumtastic_general_post_summary', array(
            'type' => 'radio',
            'label'    => esc_html__( 'Homepage and Archive Post Summary Type', 'yumtastic' ),
            'section'  => 'yumtastic_general_options',
            'choices'  => array(
                'excerpt'  => esc_html__( 'Use Excerpt', 'yumtastic' ),
                'full' => esc_html__( 'Use Full Post', 'yumtastic' ),
            ),
            'priority' => 9
        ) );
        $wp_customize->add_setting( 'yumtastic_general_post_layout', array(
            'default' => 'standard',
            'section'  => 'yumtastic_general_options',
            'sanitize_callback'	=> 'yumtastic_sanitize_radio',
        ) );
        $wp_customize->add_control( 'yumtastic_general_post_layout', array(
            'type' => 'radio',
            'label'    => esc_html__( 'Homepage and Archive Post Layout Type', 'yumtastic' ),
            'section'  => 'yumtastic_general_options',
            'choices'  => array(
                'grid'  => esc_html__( 'Grid Layout', 'yumtastic' ),
                'standard' => esc_html__( 'Standard Post', 'yumtastic' ),
                'list' => esc_html__( 'List Post [Only in Premium Version]', 'yumtastic' ),
            ),
            'priority' => 10
        ) );

        // Pro Version
        $wp_customize->add_setting( 'pro_version_colors2', array(
            'sanitize_callback' => 'yumtastic_sanitize_custom_control'
        ) );
        $wp_customize->add_control( new Yumtastic_Customize_Pro_Version ( $wp_customize,
                'pro_version_colors2', array(
                    'section'	  => 'yumtastic_general_options',
                    'type'		  => 'pro_options',
                    'label' 	  => esc_html__( 'Upgrade', 'yumtastic' ),
                    'description' => esc_url_raw( 'https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/' ),
                    'priority'	  => 100
                )
            )
        );


        // Footer Settings
        $wp_customize->add_section( 'yumtastic_footer_settings', array(
            'title'       => esc_html__( 'Footer Settings', 'yumtastic' ),
            'description' => esc_html__( 'Configure Your Footer Here. You can\'t change our footer links in the free version of this theme.', 'yumtastic' ),
             'priority'    => 8
        ) );

        $wp_customize->add_setting(
            'footer_copyright',
            array(
                'default'     => 'Copyright 2024.',
                'sanitize_callback' => 'sanitize_text_field'
            )
        );

        $wp_customize->add_control('footer_copyright', array(
                    'label'      => esc_html__('Footer Copyright Text','yumtastic'),
                    'section'    => 'yumtastic_footer_settings',
                    'settings'   => 'footer_copyright',
                    'type'		 => 'text',
                    'priority'	 => 1
                )
        );


        // Pro Version
        $wp_customize->add_setting( 'pro_version_colors3', array(
            'sanitize_callback' => 'yumtastic_sanitize_custom_control'
        ) );
        $wp_customize->add_control( new Yumtastic_Customize_Pro_Version ( $wp_customize,
                'pro_version_colors3', array(
                    'section'	  => 'yumtastic_footer_settings',
                    'type'		  => 'pro_options',
                    'label' 	  => esc_html__( 'Upgrade', 'yumtastic' ),
                    'description' => esc_url_raw( 'https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/' ),
                    'priority'	  => 100
                )
            )
        );


    }


// Adding controls to default customizer panel
    add_action('customize_register','yumtastic_customizer_options');
    /*
     * Add in our custom Main Color setting and control to be used in the Customizer in the Colors section
     *
     */
    function yumtastic_customizer_options( $wp_customize ) {
        $wp_customize->add_setting(
            'yumtastic_main_color', //give it an ID
            array(
                'default' => '#75405e', // Give it a default
                'sanitize_callback' => 'sanitize_hex_color',
                'transport'      => 'refresh'
            )
        );
        $wp_customize->add_control(
            new WP_Customize_Color_Control(
                $wp_customize,
                'yumtastic_custom_main_color', //give it an ID
                array(
                    'label'      => esc_html__( 'Main Color', 'yumtastic' ), //set the label to appear in the Customizer
                    'section'    => 'colors', //select the section for it to appear under
                    'settings'   => 'yumtastic_main_color' //pick the setting it applies to
                )
            )
        );
        $wp_customize->add_setting(
            'yumtastic_main_text', //give it an ID
            array(
                'default' => '#75405e', // Give it a default
                'sanitize_callback' => 'sanitize_hex_color',
                'transport'      => 'refresh'
            )
        );
        $wp_customize->add_control(
            new Yumtastic_Customize_Pro_Version(
                $wp_customize,
                'yumtastic_custom_text', //give it an ID
                array(
                    'label'      => esc_html__( 'Upgrade', 'yumtastic' ), //set the label to appear in the Customizer
                    'section'    => 'colors', //select the section for it to appear under
                    'settings'   => 'yumtastic_main_text', //pick the setting it applies to
                    'description' => esc_url_raw( 'https://www.vinethemes.com/downloads/yumtastic-food-wordpress-theme/' ),
                )
            )
        );



    }



    /*
    * Adding a section to manage social links
    */
    function yumtastic_sociallink_customizer( $wp_customize ) {
        $wp_customize->add_section( 'yumtastic_social_section' , array(
            'title' => esc_html__( 'Social Links', 'yumtastic' ),
            'priority' => 30,
            'description' => 'Add a link to each of your Social Media Profiles. Leave the field empty for the icons you don\'t want to be displayed. Eg: https://www.facebook.com/vinethemes',

        ) );

        $wp_customize->add_setting( 'yumtastic_facebook', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_twitter', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );

        $wp_customize->add_setting( 'yumtastic_pinterest', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );

        $wp_customize->add_setting( 'yumtastic_linkedin', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_instagram', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_bloglovin', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_snapchat', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_tiktok', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_tumblr', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_youtube', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_dribbble', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_soundcloud', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_whatsapp', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_vimeo', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );
        $wp_customize->add_setting( 'yumtastic_rss', array(
            'sanitize_callback'	=> 'esc_url_raw',

        ) );


        $wp_customize->add_control( 'facebook', array(
            'type' => 'url',
            'label' => esc_html__( 'Facebook', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_facebook',
        ) );
        $wp_customize->add_control( 'twitter', array(
            'type' => 'url',
            'label' => esc_html__( 'Twitter', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_twitter',
        ) );
        $wp_customize->add_control( 'linkedin', array(
            'type' => 'url',
            'label' => esc_html__( 'Linkedin', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_linkedin',
        ) );
        $wp_customize->add_control( 'pinterest', array(
            'type' => 'url',
            'label' => esc_html__( 'Pinterest', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_pinterest',
        ) );

        $wp_customize->add_control( 'instagram', array(
            'type' => 'url',
            'label' => esc_html__( 'Instagram', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_instagram',
        ) );
        $wp_customize->add_control( 'bloglovin', array(
            'type' => 'url',
            'label' => esc_html__( 'Bloglovin', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_bloglovin',
        ) );
        $wp_customize->add_control( 'snapchat', array(
            'type' => 'url',
            'label' => esc_html__( 'Snapchat', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_snapchat',
        ) );
        $wp_customize->add_control( 'tiktok', array(
            'type' => 'url',
            'label' => esc_html__( 'Tiktok', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_tiktok',
        ) );
        $wp_customize->add_control( 'tumblr', array(
            'type' => 'url',
            'label' => esc_html__( 'Tumblr', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_tumblr',
        ) );
        $wp_customize->add_control( 'youtube', array(
            'type' => 'url',
            'label' => esc_html__( 'Youtube', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_youtube',
        ) );
        $wp_customize->add_control( 'dribbble', array(
            'type' => 'url',
            'label' => esc_html__( 'Dribbble', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_dribbble',
        ) );
        $wp_customize->add_control( 'soundcloud', array(
            'type' => 'url',
            'label' => esc_html__( 'Soundcloud', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_soundcloud',
        ) );
        $wp_customize->add_control( 'whatsapp', array(
            'type' => 'url',
            'label' => esc_html__( 'Whatsapp', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_whatsapp',
        ) );
        $wp_customize->add_control( 'vimeo', array(
            'type' => 'url',
            'label' => esc_html__( 'Vimeo', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_vimeo',
        ) );
        $wp_customize->add_control( 'rss', array(
            'type' => 'url',
            'label' => esc_html__( 'Rss', 'yumtastic' ),
            'section' => 'yumtastic_social_section',
            'settings' => 'yumtastic_rss',
        ) );


    }
    add_action('customize_register', 'yumtastic_sociallink_customizer');

    function yumtastic_sanitize_text( $input ) {
        return wp_kses_post( force_balance_tags( $input ) );
    }


    //checkbox sanitization function
    function yumtastic_sanitize_checkbox( $input ){

        //returns true if checkbox is checked
        return (( isset( $input ) && true === $input ) ? true : false );
    }

    //radio box sanitization function
    function yumtastic_sanitize_radio( $input, $setting ){
    $valid = array(
        'excerpt' => 'excerpt',
        'full' => 'full',
        'standard' => 'standard',
        'grid' => 'grid',
        'enable' => 'enable',
        'disable' => 'disable',
        'header1' => 'header1',
        'header2' => 'header2',
    );
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return $setting->default;
    }
    }

    function yumtastic_panels_js() {
        wp_enqueue_style( 'yumtastic-customizer-ui-css', get_theme_file_uri( '/customizer-ui.css' ) );
    }
    add_action( 'customize_controls_enqueue_scripts', 'yumtastic_panels_js' );
