<?php

/**
 * Title: About Page
 * Slug: about-page
 * Categories: yummy-bites-patterns
 * Keywords: recipe
 * Block Types: core/group, core/columns, core/image, core/cover
 * @package Yummy Bites
 * @since 1.0.0
 */

?>
<!-- wp:group {"align":"full","className":"bg-primary-color-op-5","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull bg-primary-color-op-5">
    <!-- wp:group {"align":"wide","style":{"color":{"background":"#f4f6f5"}},"layout":{"type":"constrained"}} -->
    <div class="wp-block-group alignwide has-background" style="background-color:#f4f6f5">
        <!-- wp:spacer {"height":"75px"} -->
        <div style="height:75px" aria-hidden="true" class="wp-block-spacer"></div>
        <!-- /wp:spacer -->

        <!-- wp:columns {"verticalAlignment":"center"} -->
        <div class="wp-block-columns are-vertically-aligned-center">
            <!-- wp:column {"verticalAlignment":"center","className":"tasty-mg-bt-0"} -->
            <div class="wp-block-column is-vertically-aligned-center tasty-mg-bt-0">
                <!-- wp:heading {"style":{"typography":{"fontSize":"1.94em"}},"className":"shply-mg-bottom-0"} -->
                <h2 class="shply-mg-bottom-0" style="font-size:1.94em"><?php esc_html_e( 'Hi ! I am Lauren Clark!', 'yummy-bites'); ?></h2>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"400","fontSize":"1.1em"}},"textColor":"heading-color","className":"shply-mg-bottom-0"} -->
                <p class="shply-mg-bottom-0 has-heading-color-color has-text-color" style="font-size:1.1em;font-style:normal;font-weight:400"><?php esc_html_e( 'A certified Holistic Nutritionist, yoga-lover, travel enthusiast, and founder of Cook Recipe.', 'yummy-bites'); ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:paragraph {"style":{"typography":{"fontSize":"1em"}},"className":"shply-mg-bottom-0"} -->
                <p class="shply-mg-bottom-0" style="font-size:1em"><?php esc_html_e( 'Most days you can find me in the kitchen creating new recipes or in the gym getting my move on! The thing I am most passionate about in life is helping others to live healthier and happier lives. I am lucky to connect with and inspire people all around the world.', 'yummy-bites' ); ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:spacer {"height":"16px"} -->
                <div style="height:16px" aria-hidden="true" class="wp-block-spacer"></div>
                <!-- /wp:spacer -->

                <!-- wp:image {"id":2572,"sizeSlug":"full","linkDestination":"none","className":"shply-mg-bottom-0"} -->
                <figure class="wp-block-image size-full shply-mg-bottom-0"><img src="http://demo.wpdelicious.com/yummy-bites/wp-content/uploads/sites/6/2023/01/signature.png" alt="" class="wp-image-2572" /></figure>
                <!-- /wp:image -->

                <!-- wp:spacer {"height":"27px"} -->
                <div style="height:27px" aria-hidden="true" class="wp-block-spacer"></div>
                <!-- /wp:spacer -->

                <!-- wp:columns {"className":"tasty-mg-bt-0"} -->
                <div class="wp-block-columns tasty-mg-bt-0">
                    <!-- wp:column {"verticalAlignment":"top","className":"tasty-mg-bt-0"} -->
                    <div class="wp-block-column is-vertically-aligned-top tasty-mg-bt-0">
                        <!-- wp:social-links {"className":"is-style-logos-only"} -->
                        <ul class="wp-block-social-links is-style-logos-only">
                            <!-- wp:social-link {"url":"#","service":"facebook"} /-->

                            <!-- wp:social-link {"url":"#","service":"twitter"} /-->

                            <!-- wp:social-link {"url":"#","service":"instagram"} /-->

                            <!-- wp:social-link {"url":"#","service":"google"} /-->

                            <!-- wp:social-link {"url":"#","service":"pinterest"} /-->
                        </ul>
                        <!-- /wp:social-links -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
            </div>
            <!-- /wp:column -->

            <!-- wp:column {"verticalAlignment":"center"} -->
            <div class="wp-block-column is-vertically-aligned-center">
                <!-- wp:image {"id":2422,"sizeSlug":"full","linkDestination":"none"} -->
                <figure class="wp-block-image size-full"><img src="http://demo.wpdelicious.com/yummy-bites/wp-content/uploads/sites/6/2023/01/image-author.jpg" alt="" class="wp-image-2422" /></figure>
                <!-- /wp:image -->

                <!-- wp:paragraph -->
                <p></p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:column -->
        </div>
        <!-- /wp:columns -->

        <!-- wp:spacer {"height":"95px","className":"tasty-mobile-height"} -->
        <div style="height:95px" aria-hidden="true" class="wp-block-spacer tasty-mobile-height"></div>
        <!-- /wp:spacer -->
    </div>
    <!-- /wp:group -->
</div>
<!-- /wp:group -->

<!-- wp:spacer {"height":"80px","className":"tasty-mobile-height"} -->
<div style="height:80px" aria-hidden="true" class="wp-block-spacer tasty-mobile-height"></div>
<!-- /wp:spacer -->

<!-- wp:group {"className":"tasty-mg-bt-0","layout":{"type":"constrained"}} -->
<div class="wp-block-group tasty-mg-bt-0">
    <!-- wp:columns {"className":"tasty-mg-bt-0"} -->
    <div class="wp-block-columns tasty-mg-bt-0">
        <!-- wp:column {"width":"100%","className":"tasty-mg-bt-0"} -->
        <div class="wp-block-column tasty-mg-bt-0" style="flex-basis:100%">
            <!-- wp:group {"className":"tasty-mg-bt-0","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
            <div class="wp-block-group tasty-mg-bt-0">
                <!-- wp:columns {"verticalAlignment":"top","className":"tasty-mg-bt-0"} -->
                <div class="wp-block-columns are-vertically-aligned-top tasty-mg-bt-0">
                    <!-- wp:column {"verticalAlignment":"top","width":"100%","className":"tasty-mg-bt-0"} -->
                    <div class="wp-block-column is-vertically-aligned-top tasty-mg-bt-0" style="flex-basis:100%">
                        <!-- wp:group {"className":"tasty-mg-bt-0 tasty-max-width-790","layout":{"type":"constrained"}} -->
                        <div class="wp-block-group tasty-mg-bt-0 tasty-max-width-790">
                            <!-- wp:image {"align":"center","id":2614,"sizeSlug":"full","linkDestination":"none"} -->
                            <figure class="wp-block-image aligncenter size-full"><img src="http://demo.wpdelicious.com/yummy-bites/wp-content/uploads/sites/6/2023/01/quotes.png" alt="" class="wp-image-2614" /></figure>
                            <!-- /wp:image -->

                            <!-- wp:heading {"textAlign":"center","style":{"typography":{"fontSize":"1.55em"}},"className":"tasty-mg-bt-0"} -->
                            <h2 class="has-text-align-center tasty-mg-bt-0" style="font-size:1.55em"> <?php esc_html_e ( 'My goal is to offer straightforward, simple-to-follow recipes that are wholesome and actually taste good.', 'yummy-bites' ); ?></h2>
                            <!-- /wp:heading -->
                        </div>
                        <!-- /wp:group -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
<!-- /wp:group -->

<!-- wp:spacer {"height":"80px","className":"tasty-mobile-height"} -->
<div style="height:80px" aria-hidden="true" class="wp-block-spacer tasty-mobile-height"></div>
<!-- /wp:spacer -->

<!-- wp:separator {"backgroundColor":"section-bg-color","className":"is-style-wide"} -->
<hr class="wp-block-separator has-text-color has-section-bg-color-color has-alpha-channel-opacity has-section-bg-color-background-color has-background is-style-wide" />
<!-- /wp:separator -->

<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group">
    <!-- wp:columns {"className":"tasty-max-width-790"} -->
    <div class="wp-block-columns tasty-max-width-790">
        <!-- wp:column -->
        <div class="wp-block-column">
            <!-- wp:group {"layout":{"type":"constrained"}} -->
            <div class="wp-block-group">
                <!-- wp:spacer {"height":"80px","className":"tasty-mobile-height"} -->
                <div style="height:80px" aria-hidden="true" class="wp-block-spacer tasty-mobile-height"></div>
                <!-- /wp:spacer -->

                <!-- wp:heading {"textAlign":"left","style":{"typography":{"fontSize":"1.94em"}},"className":"tasty-mg-bt-0"} -->
                <h2 class="has-text-align-left tasty-mg-bt-0" style="font-size:1.94em"><?php esc_html_e( 'A little bit more about me', 'yummy-bites'); ?></h2>
                <!-- /wp:heading -->

                <!-- wp:spacer {"height":"16px"} -->
                <div style="height:16px" aria-hidden="true" class="wp-block-spacer"></div>
                <!-- /wp:spacer -->

                <!-- wp:paragraph {"style":{"typography":{"fontSize":"1.11em"}}} -->
                <p style="font-size:1.11em"><?php esc_html_e( 'Yes, I know my stuff! And throughout our coaching time, you will develop the tools and confidence to take action.', 'yummy-bites' ); ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:paragraph {"style":{"typography":{"fontSize":"1.11em"}}} -->
                <p style="font-size:1.11em"><?php esc_html_e ( 'My way of coaching is to empower you in becoming the Leader you want to be. You are unique and so your coaching should be too. I don’t follow a template, or ‘one size fits all’. We start where you are &amp; we work towards your goals. If you want a business that generates your income while also positively contributing to others, then you have arrived at the right place!', 'yummy-bites' ); ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:spacer {"height":"56px"} -->
                <div style="height:56px" aria-hidden="true" class="wp-block-spacer"></div>
                <!-- /wp:spacer -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
<!-- /wp:group -->

<!-- wp:columns {"className":"tasty-mg-bt-0"} -->
<div class="wp-block-columns tasty-mg-bt-0">
    <!-- wp:column {"className":"tasty-mg-bt-0"} -->
    <div class="wp-block-column tasty-mg-bt-0">
        <!-- wp:image {"id":2608,"sizeSlug":"full","linkDestination":"none","className":"tasty-mg-bt-0"} -->
        <figure class="wp-block-image size-full tasty-mg-bt-0"><img src="http://demo.wpdelicious.com/yummy-bites/wp-content/uploads/sites/6/2023/01/Rectangle-1395.jpg" alt="" class="wp-image-2608" /></figure>
        <!-- /wp:image -->
    </div>
    <!-- /wp:column -->

    <!-- wp:column {"className":"tasty-mg-bt-0"} -->
    <div class="wp-block-column tasty-mg-bt-0">
        <!-- wp:image {"id":2610,"sizeSlug":"full","linkDestination":"none","className":"tasty-mg-bt-0"} -->
        <figure class="wp-block-image size-full tasty-mg-bt-0"><img src="http://demo.wpdelicious.com/yummy-bites/wp-content/uploads/sites/6/2023/01/Rectangle-1396.jpg" alt="" class="wp-image-2610" /></figure>
        <!-- /wp:image -->
    </div>
    <!-- /wp:column -->

    <!-- wp:column {"className":"tasty-mg-bt-0"} -->
    <div class="wp-block-column tasty-mg-bt-0">
        <!-- wp:image {"id":2609,"sizeSlug":"full","linkDestination":"none","className":"tasty-mg-bt-0"} -->
        <figure class="wp-block-image size-full tasty-mg-bt-0"><img src="http://demo.wpdelicious.com/yummy-bites/wp-content/uploads/sites/6/2023/01/Rectangle-1397.jpg" alt="" class="wp-image-2609" /></figure>
        <!-- /wp:image -->
    </div>
    <!-- /wp:column -->
</div>
<!-- /wp:columns -->

<!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group">
    <!-- wp:columns -->
    <div class="wp-block-columns">
        <!-- wp:column {"className":"tasty-max-width-790"} -->
        <div class="wp-block-column tasty-max-width-790">
            <!-- wp:spacer {"height":"80px","className":"tasty-mobile-height"} -->
            <div style="height:80px" aria-hidden="true" class="wp-block-spacer tasty-mobile-height"></div>
            <!-- /wp:spacer -->

            <!-- wp:heading {"style":{"typography":{"fontSize":"1.94em"}}} -->
            <h2 style="font-size:1.94em"><?php esc_html_e( 'Food photography', 'yummy-bites'); ?></h2>
            <!-- /wp:heading -->

            <!-- wp:paragraph {"style":{"typography":{"fontSize":"1.11em"}}} -->
            <p style="font-size:1.11em"><?php esc_html_e( 'I also developed a love for food photography along the process and learned how to make regular meals appear as nice as they taste.', 'yummy-bites' ); ?></p>
            <!-- /wp:paragraph -->

            <!-- wp:paragraph {"style":{"typography":{"fontSize":"1.11em"}}} -->
            <p style="font-size:1.11em"><em><?php esc_html_e( 'All of the food images you see on the website are mine.', 'yummy-bites'); ?> </em></p>
            <!-- /wp:paragraph -->

            <!-- wp:paragraph {"style":{"typography":{"fontSize":"1.11em"}}} -->
            <p style="font-size:1.11em"><?php esc_html_e( 'If you are interested in working with me, you can send me an email at lauren@tastyrecipe.com or send me a direct message on Instagram.', 'yummy-bites' ); ?></p>
            <!-- /wp:paragraph -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
<!-- /wp:group -->