<?php
/**
 * Customizer Settings Defaults 
 * 
 * @package Yummy Bites
 */

if( ! function_exists( 'yummy_bites_get_site_defaults' ) ) :
/**
 * Site Defaults
 * 
 * @return array
 */
function yummy_bites_get_site_defaults(){

    $defaults = array(
        'hide_title'        => false,
        'hide_tagline'      => true,
        'logo_width'        => '200',
        'tablet_logo_width' => '200',
        'mobile_logo_width' => '200',
    );

    return apply_filters( 'yummy_bites_site_options_defaults', $defaults );
}
endif;

if( ! function_exists( 'yummy_bites_get_typography_defaults' ) ) :
/**
 * Typography Defaults
 * 
 * @return array
 */
function yummy_bites_get_typography_defaults(){
    $defaults = array(   
        'primary_font' => array(
            'family'         => 'System Stack',
            'variants'       => '',
            'category'       => '',
            'weight'         => '400',
            'transform'      => 'none',
            'desktop' => array(
                'font_size'      => 18,
                'line_height'    => 1.75,
                'letter_spacing' => 0,
            ),
            'tablet' => array(
                'font_size'      => 18,
                'line_height'    => 1.75,
                'letter_spacing' => 0,
            ),
            'mobile' => array(
                'font_size'      => 18,
                'line_height'    => 1.75,
                'letter_spacing' => 0,
            )
        ),
        'site_title' => array(
            'family'    => 'Default Family',
            'variants'  => '',
            'category'  => '',
            'weight'    => 'bold',
            'transform' => 'none',
            'desktop' => array(
                'font_size'      => 28,
                'line_height'    => 1.4,
                'letter_spacing' => 0
            ),
            'tablet' => array(
                'font_size'      => 28,
                'line_height'    => 1.4,
                'letter_spacing' => 0,
            ),
            'mobile' => array(
                'font_size'      => 28,
                'line_height'    => 1.4,
                'letter_spacing' => 0,
            )
        ),
        'button' => array(
            'family'         => 'Default Family',
            'variants'       => '',
            'category'       => '',
            'weight'         => '500',
            'transform'      => 'none',
            'desktop' => array(
                'font_size'      => 18,
                'line_height'    => 1.6,
                'letter_spacing' => 0,
            ),
            'tablet' => array(
                'font_size'      => 18,
                'line_height'    => 1.6,
                'letter_spacing' => 0,
            ),
            'mobile' => array(
                'font_size'      => 18,
                'line_height'    => 1.6,
                'letter_spacing' => 0,
            )
        ),
        'heading_one' => array(
            'family'      => 'System Stack',
            'variants'    => '',
            'category'    => '',
            'weight'      => '400',
            'transform'   => 'none',
            'desktop' => array(
                'font_size'      => 48,
                'line_height'    => 1.3,
                'letter_spacing' => 0,
            ),
            'tablet' => array(
                'font_size'      => 40,
                'line_height'    => 1.3,
                'letter_spacing' => 0,
            ),
            'mobile' => array(
                'font_size'      => 36,
                'line_height'    => 1.3,
                'letter_spacing' => 0,
            )
        ),
        'heading_two' => array(
            'family'      => 'System Stack',
            'variants'    => '',
            'category'    => '',
            'weight'      => '400',
            'transform'   => 'none',
            'desktop' => array(
                'font_size'      => 40,
                'line_height'    => 1.3,
                'letter_spacing' => 0,
            ),
            'tablet' => array(
                'font_size'      => 32,
                'line_height'    => 1.3,
                'letter_spacing' => 0,
            ),
            'mobile' => array(
                'font_size'      => 28,
                'line_height'    => 1.3,
                'letter_spacing' => 0,
            )
        ),
        'heading_three' => array(
            'family'      => 'System Stack',
            'variants'    => '',
            'category'    => '',
            'weight'      => '400',
            'transform'   => 'none',
            'desktop' => array(
                'font_size'      => 32,
                'line_height'    => 1.3,
                'letter_spacing' => 0,
            ),
            'tablet' => array(
                'font_size'      => 26,
                'line_height'    => 1.4,
                'letter_spacing' => 0,
            ),
            'mobile' => array(
                'font_size'      => 24,
                'line_height'    => 1.4,
                'letter_spacing' => 0,
            )
        ),
        'heading_four' => array(
            'family'      => 'System Stack',
            'variants'    => '',
            'category'    => '',
            'weight'      => '400',
            'transform'   => 'none',
            'desktop' => array(
                'font_size'      => 24,
                'line_height'    => 1.5,
                'letter_spacing' => 0,
            ),
            'tablet' => array(
                'font_size'      => 22,
                'line_height'    => 1.5,
                'letter_spacing' => 0,
            ),
            'mobile' => array(
                'font_size'      => 22,
                'line_height'    => 1.5,
                'letter_spacing' => 0,
            )
        ),
        'heading_five' => array(
            'family'      => 'System Stack',
            'variants'    => '',
            'category'    => '',
            'weight'      => '400',
            'transform'   => 'none',
            'desktop' => array(
                'font_size'      => 20,
                'line_height'    => 1.5,
                'letter_spacing' => 0,
            ),
            'tablet' => array(
                'font_size'      => 20,
                'line_height'    => 1.5,
                'letter_spacing' => 0,
            ),
            'mobile' => array(
                'font_size'      => 20,
                'line_height'    => 1.5,
                'letter_spacing' => 0,
            )
        ),
        'heading_six' => array(
            'family'      => 'System Stack',
            'variants'    => '',
            'category'    => '',
            'weight'      => '400',
            'transform'   => 'none',
            'desktop' => array(
                'font_size'      => 18,
                'line_height'    => 1.5,
                'letter_spacing' => 0,
            ),
            'tablet' => array(
                'font_size'      => 18,
                'line_height'    => 1.5,
                'letter_spacing' => 0,
            ),
            'mobile' => array(
                'font_size'      => 18,
                'line_height'    => 1.5,
                'letter_spacing' => 0,
            )
        )
    );

    return apply_filters( 'yummy_bites_typography_options_defaults', $defaults ); 
}
endif;

if( ! function_exists( 'yummy_bites_get_color_defaults' ) ) :
/**
 * Color Defaults
 * 
 * @return array
 */
function yummy_bites_get_color_defaults(){
    $defaults = array(
		'primary_color'             => '#EDA602',
		'secondary_color'           => '#227755',
		'body_font_color'           => '#39433F',
		'heading_color'             => '#07120D',
		'site_bg_color'             => '#FFFFFF',
		'accent_color_one'          => '#FBEDFF',
		'accent_color_two'          => '#F6F4F0',
		'site_title_color'          => '#000000',
		'site_tagline_color'        => '#333333',
		'btn_text_color_initial'    => '#ffffff',
		'btn_text_color_hover'      => '#ffffff',
		'btn_bg_color_initial'      => '#EDA602',
		'btn_bg_color_hover'        => '#227755',
		'btn_border_color_initial'  => '#EDA602',
		'btn_border_color_hover'    => '#227755',
		'foot_text_color'           => 'rgba(255,255,255,0.9)',
		'foot_bg_color'             => '#0D0C0C',
		'foot_widget_heading_color' => '#FFFFFF',
		'abt_bg_color'              => '#F4F6F5',
		'abt_title_color'           => '#07120D',
		'abt_desc_color'            => '#39433F',
    );

    return apply_filters( 'yummy_bites_color_options_defaults', $defaults );
}
endif;

if( ! function_exists( 'yummy_bites_get_button_defaults' ) ) :
/**
 * Button Defaults
 * 
 * @return array
 */
function yummy_bites_get_button_defaults(){

    $defaults = array(
        'button_roundness' => array(
            'top'    => 4,
            'right'  => 4,
            'bottom' => 4,
            'left'   => 4,
        ),
        'button_padding'   => array(
            'top'    => 12,
            'right'  => 32,
            'bottom' => 12,
            'left'   => 32,
        )
    );

    return apply_filters( 'yummy_bites_button_options_defaults', $defaults );
}
endif;

if( ! function_exists( 'yummy_bites_get_general_defaults' ) ) :
/**
 * General Defaults
 * 
 * @return array
 */
function yummy_bites_get_general_defaults(){

    $defaults = array(
        'blog_main_title'               => __( 'Recent Recipes', 'yummy-bites' ),
        'blog_main_content'             => '',
        'blog_post_options'             => 'both',
        'blog_readmore'                 => __( 'Read More', 'yummy-bites' ),
        'blog_post_per_page'            => 4,
        'container_width'               => 1230,
        'tablet_container_width'        => 992,
        'mobile_container_width'        => 420,
        'fullwidth_centered'            => 750,
        'tablet_fullwidth_centered'     => 750,
        'mobile_fullwidth_centered'     => 750,
        'sidebar_width'                 => 30,
        'widgets_spacing'               => 32,
        'tablet_widgets_spacing'        => 32,
        'mobile_widgets_spacing'        => 20,
        'ed_last_widget_sticky'         => false,
        'ed_scroll_top'                 => true,
        'scroll_top_size'               => 20,
        'tablet_scroll_top_size'        => 20,
        'mobile_scroll_top_size'        => 20,
        'ed_localgoogle_fonts'          => false,
        'ed_preload_local_fonts'        => false,
        'page_sidebar_layout'           => 'right-sidebar',
        'post_sidebar_layout'           => 'right-sidebar',
        'layout_style'                  => 'right-sidebar',
        'abt_bg_image'                  => '',
        'abt_author_image'              => '',
        'abt_title'                     => '',
        'abt_description'               => '',
        'ed_about_social_links'         => false,
        'ed_about_social_links_new_tab' => true,
        'abt_button_label'              => '',
        'abt_button_link'               => '',
        'about_social_media_order'      => array( 'yummy_facebook', 'yummy_twitter', 'yummy_instagram'),
        'feature_recipe_title'          => '',
        'ed_header_search'              => false,
        'ed_woo_cart'                   => false,
        'ed_social_links'               => false,
        'ed_social_links_new_tab'       => true,
        'social_media_order'            => array( 'yummy_facebook', 'yummy_twitter', 'yummy_instagram'),
        'yummy_facebook'                => '#',
        'yummy_twitter'                 => '#',
        'yummy_instagram'               => '#',
        'yummy_pinterest'               => '',
        'yummy_youtube'                 => '',
        'yummy_tiktok'                  => '',
        'yummy_linkedin'                => '',
        'yummy_whatsapp'                => '',
        'yummy_viber'                   => '',
        'yummy_telegram'                => '',
        'footer_copyright'              => '',
        'ed_breadcrumb'                 => true,
        'home_text'                     => __( 'Home', 'yummy-bites' ),
        'separator_icon'                => 'one',
        'ed_post_update_date'           => true,
        'ed_instagram'                  => false,
        'ed_blog_title'                 => true,
        'ed_blog_desc'                  => false,
        'blog_alignment'                => 'left',
        'blog_crop_image'               => true,
        'blog_content'                  => 'excerpt',
        'excerpt_length'                => 20,
        'read_more_text'                => __( 'Read More', 'yummy-bites' ),
        'blog_meta_order'               => array( 'date', 'comment' ),
        'ed_post_featured_image'        => true,
        'post_crop_image'               => true,
        'post_meta_order'               => array( 'date', 'reading-time' ),
        'read_words_per_minute'         => 200,
        'ed_post_tags'                  => true,
        'ed_post_category'              => true,
        'ed_post_pagination'            => true,
        'ed_author'                     => true,
        'author_title'                  => __( 'About Author', 'yummy-bites' ),
        'ed_related'                    => true,
        'related_post_title'            => __( 'You may also like...', 'yummy-bites' ),
        'no_of_posts_rp'                => 4,
        'ed_post_comments'              => true,
        'single_comment_form'           => 'below',
        'toggle_comments'               => 'end-post',
        'ed_page_title'                 => true,
        'pagetitle_alignment'           => 'center',
        'ed_page_featured_image'        => true,
        'ed_page_comments'              => false,
        'ed_archive_title'              => true,
        'ed_archive_desc'               => true,
        'archivetitle_alignment'        => 'left',
        'ed_archive_post_count'         => true,
        'ed_prefix_archive'             => true,
        'builder_types'                 => 'customizer',
    );
    return apply_filters( 'yummy_bites_general_defaults', $defaults );
}
endif;

if( ! function_exists ( 'yummy_bites_get_banner_defaults') ) :
/**
 * Banner Defaults
 * 
 * @return array
 */
function yummy_bites_get_banner_defaults(){

    $defaults = array(
        'ed_banner_section'        => 'slider_banner',
        'slider_type'              => 'latest_posts',
        'slider_cat'               => '',
        'no_of_slides'             => 6,
        'slider_auto'              => true,
        'slider_loop'              => true,
        'slider_caption'           => true,
        'slider_full_image'        => false,
        'slider_animation'         => '',
        'slider_speed'             => 5000,
        'slider_readmore'           => __('Read More', 'yummy-bites'),

    );

    return apply_filters( 'yummy_bites_get_banner_defaults', $defaults );

}
endif;

if( ! function_exists( 'yummy_bites_color_preset_array')):
/**
 * Check the style preset and return the color array
 *
 * @param string $preset
 * @return array
 */
function yummy_bites_color_preset_array($preset = 'one'){
    // Initialize the color preset array
    $color_preset = array(
        'one' => [
            'primary_color'    => '#EDA602',
            'secondary_color'  => '#227755',
            'body_font_color'  => '#39433F',
            'heading_color'    => '#07120D',
            'site_bg_color'    => '#FFF',
            'accent_color_one' => '#FBEDFF',
            'accent_color_two' => '#F6F4F0',
        ],
        'two' => [
            'primary_color'    => '#51724E',
            'secondary_color'  => '#3C1C37',
            'body_font_color'  => '#39433F',
            'heading_color'    => '#07120D',
            'site_bg_color'    => '#FFFFFF',
            'accent_color_one' => '#FECCCD',
            'accent_color_two' => '#ECE7ED',
        ],
        'three' => [
            'primary_color'    => '#EC8A2F',
            'secondary_color'  => '#802F51',
            'body_font_color'  => '#443E45',
            'heading_color'    => '#161217',
            'site_bg_color'    => '#FFFFFF',
            'accent_color_one' => '#FBEDFF',
            'accent_color_two' => '#F6F4F0',
        ],
        'four' => [
            'primary_color'    => '#CF8049',
            'secondary_color'  => '#73AD66',
            'body_font_color'  => '#3D403F',
            'heading_color'    => '#101816',
            'site_bg_color'    => '#FFFFFF',
            'accent_color_one' => '#EACEBD',
            'accent_color_two' => '#F3F0EB',
        ],
        'five' => [
            'primary_color'    => '#62A053',
            'secondary_color'  => '#F65558',
            'body_font_color'  => '#444040',
            'heading_color'    => '#151414',
            'site_bg_color'    => '#FFFFFF',
            'accent_color_one' => '#F1F7EF',
            'accent_color_two' => '#F4F1EC',
        ],
        'six' => [
            'primary_color'    => '#AB3727',
            'secondary_color'  => '#165C61',
            'body_font_color'  => '#3D3D3D',
            'heading_color'    => '#191518',
            'site_bg_color'    => '#FFFFFF',
            'accent_color_one' => '#DCE8EA',
            'accent_color_two' => '#F4F3F0',
        ],
        'seven' => [
            'primary_color'    => '#336882',
            'secondary_color'  => '#DB7791',
            'body_font_color'  => '#5A5A5A',
            'heading_color'    => '#242424',
            'site_bg_color'    => '#FFFFFF',
            'accent_color_one' => '#E8EEF1',
            'accent_color_two' => '#FCF4F6',
        ],
        'eight' => [
            'primary_color'    => '#F07F6E',
            'secondary_color'  => '#61B3B8',
            'body_font_color'  => '#5A5D68',
            'heading_color'    => '#242424',
            'site_bg_color'    => '#FFFFFF',
            'accent_color_one' => 'F4F0ED',
            'accent_color_two' => '#E4EFF0',
        ],
        'nine' => [
            'primary_color'    => '#29A963',
            'secondary_color'  => '#f65030',
            'body_font_color'  => '#5A5A5A',
            'heading_color'    => '#131212',
            'site_bg_color'    => '#ffffff',
            'accent_color_one' => '#f6f9f7',
            'accent_color_two' => '#f2f9f3',
        ],
        'default' => [
            'primary_color'    => get_theme_mod( 'primary_color', yummy_bites_get_color_defaults()['primary_color'] ),
            'secondary_color'  => get_theme_mod( 'secondary_color', yummy_bites_get_color_defaults()['secondary_color'] ),
            'body_font_color'  => get_theme_mod( 'body_font_color', yummy_bites_get_color_defaults()['body_font_color'] ),
            'heading_color'    => get_theme_mod( 'heading_color', yummy_bites_get_color_defaults()['heading_color'] ),
            'site_bg_color'    => get_theme_mod( 'site_bg_color', yummy_bites_get_color_defaults()['site_bg_color'] ),
            'accent_color_one' => get_theme_mod( 'accent_color_one', yummy_bites_get_color_defaults()['accent_color_one'] ),
            'accent_color_two' => get_theme_mod( 'accent_color_two', yummy_bites_get_color_defaults()['accent_color_two'] ),
        ],
    );

    return $color_preset[$preset];
}
endif;

if( ! function_exists( 'yummy_bites_typography_preset_array')):
/**
 * Check the style preset and return the typography array
 *
 * @param string $preset
 * @return array
 */
function yummy_bites_typography_preset_array($preset ='one'){
    // Initialize the typography preset array
    $typography_preset = array(
        'one' => array(
            'primary_font'  => 'System Stack',
            'heading_one'   => 'System Stack',
            'heading_two'   => 'System Stack',
            'heading_three' => 'System Stack',
            'heading_four'  => 'System Stack',
            'heading_five'  => 'System Stack',
            'heading_six'   => 'System Stack',
        ),
        'two' => array(
            'primary_font'  => 'Bitter',
            'heading_one'   => 'Domine',
            'heading_two'   => 'Domine',
            'heading_three' => 'Domine',
            'heading_four'  => 'Domine',
            'heading_five'  => 'Domine',
            'heading_six'   => 'Domine',
        ),
        'three' => array(
            'primary_font'  => 'Open Sans',
            'heading_one'   => 'Playfair Display',
            'heading_two'   => 'Playfair Display',
            'heading_three' => 'Playfair Display',
            'heading_four'  => 'Playfair Display',
            'heading_five'  => 'Playfair Display',
            'heading_six'   => 'Playfair Display',   
        ),
        'four' => array(
            'primary_font'  => 'PT Sans',
            'heading_one'   => 'Signika',
            'heading_two'   => 'Signika',
            'heading_three' => 'Signika',
            'heading_four'  => 'Signika',
            'heading_five'  => 'Signika',
            'heading_six'   => 'Signika',   
        ),
        'five' => array(
            'primary_font'  => 'Red Hat Text',
            'heading_one'   => 'Wittgenstein',
            'heading_two'   => 'Wittgenstein',
            'heading_three' => 'Wittgenstein',
            'heading_four'  => 'Wittgenstein',
            'heading_five'  => 'Wittgenstein',
            'heading_six'   => 'Wittgenstein',   
        ),
        'six' => array(
            'primary_font'  => 'Noto Sans',
            'heading_one'   => 'Platypi',
            'heading_two'   => 'Platypi',
            'heading_three' => 'Platypi',
            'heading_four'  => 'Platypi',
            'heading_five'  => 'Platypi',
            'heading_six'   => 'Platypi',   
        ),
        'seven' => array(
            'primary_font'  => 'Reddit Sans',
            'heading_one'   => 'Hedvig Letters Serif',
            'heading_two'   => 'Hedvig Letters Serif',
            'heading_three' => 'Hedvig Letters Serif',
            'heading_four'  => 'Hedvig Letters Serif',
            'heading_five'  => 'Hedvig Letters Serif',
            'heading_six'   => 'Hedvig Letters Serif',   
        ),
        'default' => array(
            'primary_font'  => get_theme_mod( 'primary_font', yummy_bites_get_typography_defaults()['primary_font'] )['family'],
            'heading_one'   => get_theme_mod( 'heading_one', yummy_bites_get_typography_defaults()['heading_one'] )['family'],
            'heading_two'   => get_theme_mod( 'heading_two', yummy_bites_get_typography_defaults()['heading_two'] )['family'],
            'heading_three' => get_theme_mod( 'heading_three', yummy_bites_get_typography_defaults()['heading_three'] )['family'],
            'heading_four'  => get_theme_mod( 'heading_four', yummy_bites_get_typography_defaults()['heading_four'] )['family'],
            'heading_five'  => get_theme_mod( 'heading_five', yummy_bites_get_typography_defaults()['heading_five'] )['family'],
            'heading_six'   => get_theme_mod( 'heading_six', yummy_bites_get_typography_defaults()['heading_six'] )['family'],
        )
    );

    return $typography_preset[$preset];
}
endif;

if ( ! function_exists('yummy_bites_color_preset_style_list') ) :
    /**
     * Color Preset Icon List
     */
    function yummy_bites_color_preset_style_list($icon = 'one'){
    
        $array_list = [
            'one'   => '<svg width="304" height="48" viewBox="0 0 304 48" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="32" cy="24" r="16" fill="#E9A626"/><circle cx="72" cy="24" r="16" fill="#2A7756"/><circle cx="112" cy="24" r="16" fill="#39433F"/><circle cx="152" cy="24" r="16" fill="#08120D"/><circle cx="192" cy="24" r="15.5" fill="white" stroke="#DDDDDD"/><circle cx="232" cy="24" r="15.5" fill="#F2F6F5" stroke="#DDDDDD"/><circle cx="272" cy="24" r="15.5" fill="#FDF9EF" stroke="#DDDDDD"/></svg>',
            'two'   => '<svg width="304" height="42" viewBox="0 0 304 42" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="32" cy="21" r="16" fill="#51724E"/><circle cx="72" cy="21" r="16" fill="#3C1C37"/><circle cx="112" cy="21" r="16" fill="#39433F"/><circle cx="152" cy="21" r="16" fill="#07120D"/><circle cx="192" cy="21" r="15.5" fill="white" stroke="#DDDDDD"/><circle cx="232" cy="21" r="15.5" fill="#FECCCD" stroke="#DDDDDD"/><circle cx="272" cy="21" r="15.5" fill="#ECE7ED" stroke="#DDDDDD"/></svg>',
            'three' => '<svg width="304" height="48" viewBox="0 0 304 48" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="32" cy="24" r="16" fill="#EC8A2F"/><circle cx="72" cy="24" r="16" fill="#802F51"/><circle cx="112" cy="24" r="16" fill="#443E45"/><circle cx="152" cy="24" r="16" fill="#161217"/><circle cx="192" cy="24" r="15.5" fill="white" stroke="#DDDDDD"/><circle cx="232" cy="24" r="15.5" fill="#FBEDFF" stroke="#DDDDDD"/><circle cx="272" cy="24" r="15.5" fill="#F6F4F0" stroke="#DDDDDD"/></svg>',
            'four'  => '<svg width="304" height="48" viewBox="0 0 304 48" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="32" cy="24" r="16" fill="#CF8049"/><circle cx="72" cy="24" r="16" fill="#73AD66"/><circle cx="112" cy="24" r="16" fill="#3D403F"/><circle cx="152" cy="24" r="16" fill="#101816"/><circle cx="192" cy="24" r="15.5" fill="white" stroke="#DDDDDD"/><circle cx="232" cy="24" r="15.5" fill="#EACEBD" stroke="#DDDDDD"/><circle cx="272" cy="24" r="15.5" fill="#F3F0EB" stroke="#DDDDDD"/></svg>',
            'five'  => '<svg width="304" height="48" viewBox="0 0 304 48" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="32" cy="24" r="16" fill="#62A053"/><circle cx="72" cy="24" r="16" fill="#F65558"/><circle cx="112" cy="24" r="16" fill="#444040"/><circle cx="152" cy="24" r="16" fill="#151414"/><circle cx="192" cy="24" r="15.5" fill="white" stroke="#DDDDDD"/><circle cx="232" cy="24" r="15.5" fill="#F1F7EF" stroke="#DDDDDD"/><circle cx="272" cy="24" r="15.5" fill="#F4F1EC" stroke="#DDDDDD"/></svg>',
            'six'   => '<svg width="304" height="48" viewBox="0 0 304 48" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="32" cy="24" r="16" fill="#AB3727"/><circle cx="72" cy="24" r="16" fill="#165C61"/><circle cx="112" cy="24" r="16" fill="#3D3D3D"/><circle cx="152" cy="24" r="16" fill="#191518"/><circle cx="192" cy="24" r="15.5" fill="white" stroke="#DDDDDD"/><circle cx="232" cy="24" r="15.5" fill="#DCE8EA" stroke="#DDDDDD"/><circle cx="272" cy="24" r="15.5" fill="#F4F3F0" stroke="#DDDDDD"/></svg>',
            'seven'   => '<svg width="304" height="48" viewBox="0 0 304 48" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="32" cy="24" r="16" fill="#336882"/><circle cx="72" cy="24" r="16" fill="#DB7791"/><circle cx="112" cy="24" r="16" fill="#5A5A5A"/><circle cx="152" cy="24" r="16" fill="#242424"/><circle cx="192" cy="24" r="15.5" fill="white" stroke="#DDDDDD"/><circle cx="232" cy="24" r="15.5" fill="#E8EEF1" stroke="#DDDDDD"/><circle cx="272" cy="24" r="15.5" fill="#FCF4F6" stroke="#DDDDDD"/></svg>',
            'eight'   => '<svg width="304" height="48" viewBox="0 0 304 48" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M48 24C48 32.8366 40.8366 40 32 40C23.1634 40 16 32.8366 16 24C16 15.1634 23.1634 8 32 8C40.8366 8 48 15.1634 48 24Z"fill="#F07F6E"/><circle cx="72" cy="24" r="16" fill="#61B3B8"/><circle cx="112" cy="24" r="16" fill="#5A5D68"/><circle cx="152" cy="24" r="16" fill="#242424"/><circle cx="192" cy="24" r="15.5" fill="white" stroke="#DDDDDD"/><circle cx="232" cy="24" r="15.5" fill="#F4F0ED" stroke="#DDDDDD"/><circle cx="272" cy="24" r="15.5" fill="#E4EFF0" stroke="#DDDDDD"/></svg>',
            'nine'   => '<svg width="304" height="48" viewBox="0 0 304 48" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="32" cy="24" r="16" fill="#29A963"/><circle cx="72" cy="24" r="16" fill="#F65030"/><circle cx="112" cy="24" r="16" fill="#5A5A5A"/><circle cx="152" cy="24" r="16" fill="#131212"/><circle cx="192" cy="24" r="15.5" fill="white" stroke="#DDDDDD"/><circle cx="232" cy="24" r="15.5" fill="#F6F9F7" stroke="#DDDDDD"/><circle cx="272" cy="24" r="15.5" fill="#F2F9F3" stroke="#DDDDDD"/></svg>',
        ];
        return $array_list[$icon];
    }
endif;

if ( ! function_exists('yummy_bites_typography_preset_style_list') ) :
    /**
     * Typography Preset Icon List
     */
    function yummy_bites_typography_preset_style_list($icon = 'one'){
    
        $array_list = [
            'one'   => '<svg width="155" height="82" viewBox="0 0 155 82" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="155" height="82" fill="white"/><rect x="0.5" y="0.5" width="154" height="81" stroke="black" stroke-opacity="0.1"/><path d="M51.962 25.0909C51.8768 24.3712 51.5311 23.8125 50.9251 23.4148C50.319 23.017 49.5756 22.8182 48.695 22.8182C48.051 22.8182 47.4876 22.9223 47.0046 23.1307C46.5264 23.339 46.1523 23.6255 45.8825 23.9901C45.6173 24.3546 45.4847 24.7689 45.4847 25.233C45.4847 25.6212 45.5771 25.955 45.7617 26.2344C45.9511 26.509 46.1926 26.7386 46.4862 26.9233C46.7797 27.1032 47.0875 27.2524 47.4094 27.3707C47.7314 27.4844 48.0273 27.5767 48.2972 27.6477L49.7745 28.0455C50.1533 28.1449 50.5747 28.2822 51.0387 28.4574C51.5075 28.6326 51.9549 28.8717 52.381 29.1747C52.8119 29.473 53.167 29.8565 53.4464 30.3253C53.7257 30.794 53.8654 31.3693 53.8654 32.0511C53.8654 32.8371 53.6594 33.5473 53.2475 34.1818C52.8403 34.8163 52.2437 35.3205 51.4577 35.6946C50.6765 36.0687 49.7272 36.2557 48.6097 36.2557C47.5681 36.2557 46.6661 36.0876 45.9038 35.7514C45.1462 35.4152 44.5496 34.9465 44.114 34.3452C43.6831 33.7438 43.4393 33.0455 43.3825 32.25H45.2006C45.248 32.7992 45.4326 33.2538 45.7546 33.6136C46.0813 33.9687 46.4933 34.2339 46.9904 34.4091C47.4923 34.5795 48.0321 34.6648 48.6097 34.6648C49.2821 34.6648 49.8858 34.5559 50.4208 34.3381C50.9558 34.1155 51.3796 33.8078 51.6921 33.4148C52.0046 33.017 52.1609 32.553 52.1609 32.0227C52.1609 31.5398 52.0259 31.1468 51.756 30.8438C51.4862 30.5407 51.131 30.2945 50.6907 30.1051C50.2504 29.9157 49.7745 29.75 49.2631 29.608L47.4734 29.0966C46.337 28.7699 45.4374 28.3035 44.7745 27.6974C44.1116 27.0914 43.7802 26.2983 43.7802 25.3182C43.7802 24.5038 44.0004 23.7936 44.4407 23.1875C44.8858 22.5767 45.4824 22.1032 46.2305 21.767C46.9833 21.4261 47.8237 21.2557 48.7518 21.2557C49.6893 21.2557 50.5226 21.4238 51.2518 21.7599C51.9809 22.0914 52.5586 22.5459 52.9847 23.1236C53.4156 23.7012 53.6429 24.357 53.6665 25.0909H51.962ZM57.6136 40.0909C57.3295 40.0909 57.0762 40.0672 56.8537 40.0199C56.6312 39.9773 56.4773 39.9347 56.392 39.892L56.8182 38.4148C57.2254 38.5189 57.5852 38.5568 57.8977 38.5284C58.2102 38.5 58.4872 38.3603 58.7287 38.1094C58.9749 37.8632 59.1998 37.4631 59.4034 36.9091L59.7159 36.0568L55.6818 25.0909H57.5L60.5114 33.7841H60.625L63.6364 25.0909H65.4545L60.8239 37.5909C60.6155 38.1544 60.3575 38.6207 60.0497 38.9901C59.742 39.3641 59.3845 39.6411 58.9773 39.821C58.5748 40.0009 58.1203 40.0909 57.6136 40.0909ZM75.3942 27.5341L73.8885 27.9602C73.7938 27.7093 73.6541 27.4654 73.4695 27.2287C73.2895 26.9872 73.0433 26.7884 72.7308 26.6321C72.4183 26.4759 72.0182 26.3977 71.5305 26.3977C70.8629 26.3977 70.3066 26.5516 69.8615 26.8594C69.4212 27.1624 69.201 27.5483 69.201 28.017C69.201 28.4337 69.3525 28.7628 69.6555 29.0043C69.9586 29.2457 70.4321 29.447 71.076 29.608L72.6953 30.0057C73.6707 30.2424 74.3975 30.6046 74.8757 31.0923C75.3539 31.5753 75.593 32.1979 75.593 32.9602C75.593 33.5852 75.4131 34.1439 75.0533 34.6364C74.6982 35.1288 74.201 35.517 73.5618 35.8011C72.9226 36.0852 72.1792 36.2273 71.3317 36.2273C70.219 36.2273 69.2981 35.9858 68.5689 35.5028C67.8397 35.0199 67.3781 34.3144 67.1839 33.3864L68.7749 32.9886C68.9264 33.5758 69.2128 34.0161 69.6342 34.3097C70.0604 34.6032 70.6167 34.75 71.3033 34.75C72.0845 34.75 72.7048 34.5843 73.1641 34.2528C73.6281 33.9167 73.8601 33.5142 73.8601 33.0455C73.8601 32.6667 73.7275 32.3494 73.4624 32.0938C73.1972 31.8333 72.79 31.6392 72.2408 31.5114L70.4226 31.0852C69.4235 30.8485 68.6896 30.4815 68.2209 29.9844C67.7569 29.4825 67.5249 28.8551 67.5249 28.1023C67.5249 27.4867 67.6977 26.9422 68.0433 26.4688C68.3937 25.9953 68.8696 25.6236 69.4709 25.3537C70.0769 25.0838 70.7635 24.9489 71.5305 24.9489C72.6101 24.9489 73.4576 25.1856 74.0732 25.6591C74.6934 26.1326 75.1338 26.7576 75.3942 27.5341ZM82.8604 25.0909V26.5114H77.207V25.0909H82.8604ZM78.8548 22.4773H80.5309V32.875C80.5309 33.3485 80.5996 33.7036 80.7369 33.9403C80.8789 34.1723 81.0588 34.3286 81.2766 34.4091C81.4992 34.4848 81.7335 34.5227 81.9798 34.5227C82.1644 34.5227 82.3159 34.5133 82.4343 34.4943C82.5527 34.4706 82.6474 34.4517 82.7184 34.4375L83.0593 35.9432C82.9457 35.9858 82.7871 36.0284 82.5835 36.071C82.3799 36.1184 82.1218 36.142 81.8093 36.142C81.3358 36.142 80.8718 36.0402 80.4173 35.8366C79.9674 35.633 79.5934 35.3229 79.2951 34.9062C79.0015 34.4896 78.8548 33.964 78.8548 33.3295V22.4773ZM89.8384 36.2273C88.7873 36.2273 87.8806 35.9953 87.1183 35.5312C86.3607 35.0625 85.7759 34.4091 85.364 33.571C84.9568 32.7282 84.7532 31.7481 84.7532 30.6307C84.7532 29.5133 84.9568 28.5284 85.364 27.6761C85.7759 26.8191 86.3488 26.1515 87.0827 25.6733C87.8214 25.1903 88.6831 24.9489 89.668 24.9489C90.2362 24.9489 90.7972 25.0436 91.3512 25.233C91.9052 25.4223 92.4094 25.7301 92.864 26.1562C93.3185 26.5777 93.6808 27.1364 93.9506 27.8324C94.2205 28.5284 94.3555 29.3854 94.3555 30.4034V31.1136H85.9464V29.6648H92.6509C92.6509 29.0492 92.5278 28.5 92.2816 28.017C92.0401 27.5341 91.6945 27.1529 91.2447 26.8736C90.7996 26.5942 90.274 26.4545 89.668 26.4545C89.0004 26.4545 88.4227 26.6203 87.935 26.9517C87.4521 27.2784 87.0804 27.7045 86.82 28.2301C86.5595 28.7557 86.4293 29.3191 86.4293 29.9205V30.8864C86.4293 31.7102 86.5714 32.4086 86.8555 32.9815C87.1443 33.5497 87.5444 33.983 88.0558 34.2812C88.5671 34.5748 89.1613 34.7216 89.8384 34.7216C90.2788 34.7216 90.6765 34.66 91.0316 34.5369C91.3915 34.4091 91.7016 34.2197 91.962 33.9688C92.2224 33.7131 92.4237 33.3958 92.5657 33.017L94.185 33.4716C94.0146 34.0208 93.7281 34.5038 93.3256 34.9205C92.9232 35.3324 92.426 35.6544 91.8342 35.8864C91.2423 36.1136 90.5771 36.2273 89.8384 36.2273ZM96.9052 36V25.0909H98.5245V26.7955H98.6665C98.8938 26.2131 99.2608 25.7609 99.7674 25.4389C100.274 25.1122 100.882 24.9489 101.593 24.9489C102.312 24.9489 102.911 25.1122 103.39 25.4389C103.873 25.7609 104.249 26.2131 104.519 26.7955H104.632C104.912 26.232 105.331 25.7846 105.89 25.4531C106.448 25.117 107.118 24.9489 107.9 24.9489C108.875 24.9489 109.673 25.2543 110.293 25.8651C110.913 26.4711 111.223 27.4157 111.223 28.6989V36H109.547V28.6989C109.547 27.8939 109.327 27.3187 108.887 26.973C108.446 26.6274 107.928 26.4545 107.331 26.4545C106.564 26.4545 105.97 26.6866 105.549 27.1506C105.127 27.6098 104.917 28.1922 104.917 28.8977V36H103.212V28.5284C103.212 27.9081 103.011 27.4086 102.608 27.0298C102.206 26.6463 101.687 26.4545 101.053 26.4545C100.617 26.4545 100.21 26.5705 99.8313 26.8026C99.4573 27.0346 99.1542 27.3565 98.9222 27.7685C98.695 28.1757 98.5813 28.6468 98.5813 29.1818V36H96.9052ZM49.8438 60H45.3551V45.4545H50.0426C51.4536 45.4545 52.661 45.7457 53.6648 46.3281C54.6686 46.9058 55.438 47.7367 55.973 48.821C56.508 49.9006 56.7756 51.1932 56.7756 52.6989C56.7756 54.214 56.5057 55.5185 55.9659 56.6122C55.4261 57.7012 54.6402 58.5393 53.608 59.1264C52.5758 59.7088 51.321 60 49.8438 60ZM47.1165 58.4375H49.7301C50.9328 58.4375 51.9295 58.2055 52.7202 57.7415C53.5109 57.2775 54.1004 56.617 54.4886 55.7599C54.8769 54.9029 55.071 53.8826 55.071 52.6989C55.071 51.5246 54.8793 50.5137 54.4957 49.6662C54.1122 48.8139 53.5393 48.1605 52.777 47.706C52.0147 47.2467 51.0653 47.017 49.929 47.017H47.1165V58.4375ZM64.0767 60.2273C63.0256 60.2273 62.1188 59.9953 61.3565 59.5312C60.599 59.0625 60.0142 58.4091 59.6023 57.571C59.1951 56.7282 58.9915 55.7481 58.9915 54.6307C58.9915 53.5133 59.1951 52.5284 59.6023 51.6761C60.0142 50.8191 60.5871 50.1515 61.321 49.6733C62.0597 49.1903 62.9214 48.9489 63.9062 48.9489C64.4744 48.9489 65.0355 49.0436 65.5895 49.233C66.1435 49.4223 66.6477 49.7301 67.1023 50.1562C67.5568 50.5777 67.919 51.1364 68.1889 51.8324C68.4588 52.5284 68.5938 53.3854 68.5938 54.4034V55.1136H60.1847V53.6648H66.8892C66.8892 53.0492 66.7661 52.5 66.5199 52.017C66.2784 51.5341 65.9328 51.1529 65.483 50.8736C65.0379 50.5942 64.5123 50.4545 63.9062 50.4545C63.2386 50.4545 62.661 50.6203 62.1733 50.9517C61.6903 51.2784 61.3187 51.7045 61.0582 52.2301C60.7978 52.7557 60.6676 53.3191 60.6676 53.9205V54.8864C60.6676 55.7102 60.8097 56.4086 61.0938 56.9815C61.3826 57.5497 61.7827 57.983 62.294 58.2812C62.8054 58.5748 63.3996 58.7216 64.0767 58.7216C64.517 58.7216 64.9148 58.66 65.2699 58.5369C65.6297 58.4091 65.9399 58.2197 66.2003 57.9688C66.4607 57.7131 66.6619 57.3958 66.804 57.017L68.4233 57.4716C68.2528 58.0208 67.9664 58.5038 67.5639 58.9205C67.1615 59.3324 66.6643 59.6544 66.0724 59.8864C65.4806 60.1136 64.8153 60.2273 64.0767 60.2273ZM76.0014 49.0909V50.5114H70.1207V49.0909H76.0014ZM71.8821 60V47.5852C71.8821 46.9602 72.0289 46.4394 72.3224 46.0227C72.616 45.6061 72.9972 45.2936 73.4659 45.0852C73.9347 44.8769 74.4295 44.7727 74.9503 44.7727C75.3622 44.7727 75.6984 44.8059 75.9588 44.8722C76.2192 44.9384 76.4134 45 76.5412 45.0568L76.0582 46.5057C75.973 46.4773 75.8546 46.4418 75.7031 46.3991C75.5563 46.3565 75.3622 46.3352 75.1207 46.3352C74.5668 46.3352 74.1667 46.4749 73.9205 46.7543C73.679 47.0336 73.5582 47.4432 73.5582 47.983V60H71.8821ZM81.2482 60.2557C80.5569 60.2557 79.9296 60.1255 79.3661 59.8651C78.8027 59.5999 78.3552 59.2188 78.0238 58.7216C77.6924 58.2197 77.5266 57.6136 77.5266 56.9034C77.5266 56.2784 77.6497 55.7718 77.896 55.3835C78.1422 54.9905 78.4712 54.6828 78.8832 54.4602C79.2951 54.2377 79.7496 54.072 80.2468 53.9631C80.7487 53.8494 81.253 53.7595 81.7596 53.6932C82.4225 53.608 82.9599 53.544 83.3718 53.5014C83.7885 53.4541 84.0915 53.3759 84.2809 53.267C84.475 53.1581 84.5721 52.9687 84.5721 52.6989V52.642C84.5721 51.9413 84.3803 51.3968 83.9968 51.0085C83.618 50.6203 83.0427 50.4261 82.271 50.4261C81.4708 50.4261 80.8434 50.6013 80.3888 50.9517C79.9343 51.3021 79.6147 51.6761 79.43 52.0739L77.8391 51.5057C78.1232 50.8428 78.502 50.3267 78.9755 49.9574C79.4537 49.5833 79.9746 49.3229 80.538 49.1761C81.1062 49.0246 81.6649 48.9489 82.2141 48.9489C82.5645 48.9489 82.967 48.9915 83.4215 49.0767C83.8808 49.1572 84.3235 49.3253 84.7496 49.581C85.1805 49.8366 85.538 50.2225 85.8221 50.7386C86.1062 51.2547 86.2482 51.946 86.2482 52.8125V60H84.5721V58.5227H84.4869C84.3732 58.7595 84.1838 59.0128 83.9187 59.2827C83.6535 59.5526 83.3008 59.7822 82.8604 59.9716C82.4201 60.161 81.8827 60.2557 81.2482 60.2557ZM81.5039 58.75C82.1668 58.75 82.7255 58.6198 83.18 58.3594C83.6393 58.099 83.985 57.7628 84.217 57.3509C84.4537 56.9389 84.5721 56.5057 84.5721 56.0511V54.517C84.5011 54.6023 84.3448 54.6804 84.1033 54.7514C83.8666 54.8177 83.592 54.8769 83.2795 54.929C82.9717 54.9763 82.671 55.0189 82.3775 55.0568C82.0887 55.09 81.8543 55.1184 81.6744 55.142C81.2388 55.1989 80.8316 55.2912 80.4528 55.419C80.0787 55.5421 79.7757 55.7292 79.5437 55.9801C79.3164 56.2263 79.2028 56.5625 79.2028 56.9886C79.2028 57.571 79.4182 58.0114 79.8491 58.3097C80.2847 58.6032 80.8363 58.75 81.5039 58.75ZM96.1825 55.5398V49.0909H97.8587V60H96.1825V58.1534H96.0689C95.8132 58.7074 95.4155 59.1785 94.8757 59.5668C94.3359 59.9503 93.6541 60.142 92.8303 60.142C92.1484 60.142 91.5424 59.9929 91.0121 59.6946C90.4818 59.3916 90.0651 58.937 89.7621 58.331C89.459 57.7202 89.3075 56.9508 89.3075 56.0227V49.0909H90.9837V55.9091C90.9837 56.7045 91.2062 57.339 91.6513 57.8125C92.1011 58.286 92.674 58.5227 93.37 58.5227C93.7867 58.5227 94.2105 58.4162 94.6413 58.2031C95.0769 57.9901 95.4415 57.6634 95.7351 57.223C96.0334 56.7827 96.1825 56.2216 96.1825 55.5398ZM102.605 45.4545V60H100.929V45.4545H102.605ZM110.419 49.0909V50.5114H104.766V49.0909H110.419ZM106.413 46.4773H108.089V56.875C108.089 57.3485 108.158 57.7036 108.295 57.9403C108.438 58.1723 108.617 58.3286 108.835 58.4091C109.058 58.4848 109.292 58.5227 109.538 58.5227C109.723 58.5227 109.875 58.5133 109.993 58.4943C110.111 58.4706 110.206 58.4517 110.277 58.4375L110.618 59.9432C110.504 59.9858 110.346 60.0284 110.142 60.071C109.938 60.1184 109.68 60.142 109.368 60.142C108.894 60.142 108.43 60.0402 107.976 59.8366C107.526 59.633 107.152 59.3229 106.854 58.9062C106.56 58.4896 106.413 57.964 106.413 57.3295V46.4773Z" fill="black"/></svg>',
            'two'   => '<svg width="155" height="82" viewBox="0 0 155 82" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="155" height="82" fill="white"/><rect x="0.5" y="0.5" width="154" height="81" stroke="black" stroke-opacity="0.1"/><path d="M37.88 25.18V36.42L39.56 36.84V38H33.6V36.84L35.28 36.42V31.34H29.1V36.42L30.78 36.84V38H24.82V36.84L26.5 36.42V25.18L24.82 24.76V23.6H30.78V24.76L29.1 25.18V29.88H35.28V25.18L33.6 24.76V23.6H39.56V24.76L37.88 25.18ZM50.3366 32.88H43.3566C43.3566 33.7867 43.4899 34.54 43.7566 35.14C43.9699 35.5933 44.2566 35.9467 44.6166 36.2C44.9766 36.44 45.4232 36.56 45.9566 36.56C46.5432 36.56 47.1232 36.4267 47.6966 36.16C48.2832 35.8933 48.7832 35.4933 49.1966 34.96L50.2766 35.8C49.8099 36.4667 49.1766 37.0333 48.3766 37.5C47.5899 37.9667 46.6166 38.2 45.4566 38.2C44.4832 38.2 43.6432 38.0067 42.9366 37.62C42.2299 37.22 41.6899 36.64 41.3166 35.88C41.1166 35.4667 40.9699 35.0067 40.8766 34.5C40.7832 33.9933 40.7366 33.4467 40.7366 32.86C40.7366 30.9933 41.1632 29.5533 42.0166 28.54C42.8832 27.5133 44.1032 27 45.6766 27C47.1299 27 48.2766 27.4267 49.1166 28.28C49.9699 29.12 50.3966 30.2867 50.3966 31.78C50.3966 31.9267 50.3899 32.0733 50.3766 32.22C50.3766 32.3533 50.3632 32.5733 50.3366 32.88ZM45.6366 28.38C44.2632 28.38 43.5099 29.4533 43.3766 31.6H47.7766V31.08C47.7766 30.2133 47.5832 29.5467 47.1966 29.08C46.8232 28.6133 46.3032 28.38 45.6366 28.38ZM51.6898 35.64C51.6898 34.5333 52.1965 33.68 53.2098 33.08C54.2232 32.4667 55.8165 31.9933 57.9898 31.66C57.9365 30.9933 57.8632 30.48 57.7698 30.12C57.6765 29.76 57.5565 29.4533 57.4098 29.2C57.2365 28.8933 57.0232 28.6467 56.7698 28.46C56.5165 28.2733 56.1965 28.18 55.8098 28.18C55.5298 28.18 55.2698 28.2333 55.0298 28.34C54.8032 28.4467 54.6498 28.5933 54.5698 28.78C54.7565 28.8733 54.8832 29.02 54.9498 29.22C55.0298 29.42 55.0698 29.5933 55.0698 29.74C55.0698 30.0733 54.9232 30.3733 54.6298 30.64C54.3365 30.8933 53.9832 31.02 53.5698 31.02C53.1565 31.02 52.8298 30.8867 52.5898 30.62C52.3498 30.34 52.2298 29.9933 52.2298 29.58C52.2298 29.0333 52.4232 28.5667 52.8098 28.18C53.1965 27.7933 53.6898 27.5 54.2898 27.3C54.8898 27.1 55.4965 27 56.1098 27C56.7365 27 57.2965 27.0933 57.7898 27.28C58.2965 27.4533 58.7032 27.6733 59.0098 27.94C60.0632 28.8733 60.5898 30.3533 60.5898 32.38V34.98C60.5898 35.6333 60.6298 36.0867 60.7098 36.34C60.8032 36.5933 60.9965 36.72 61.2898 36.72H62.1898V37.62C60.9632 38.0067 60.0365 38.2 59.4098 38.2C58.9698 38.2 58.6765 38.0533 58.5298 37.76C58.3832 37.4667 58.3098 36.8867 58.3098 36.02H58.2298C57.8165 36.7 57.2698 37.2333 56.5898 37.62C55.9098 38.0067 55.1765 38.2 54.3898 38.2C53.5498 38.2 52.8898 37.9733 52.4098 37.52C51.9298 37.0667 51.6898 36.44 51.6898 35.64ZM55.6098 36.74C55.8898 36.74 56.1965 36.6467 56.5298 36.46C56.8765 36.2733 57.1765 36.0133 57.4298 35.68C57.5765 35.4933 57.7165 35.2267 57.8498 34.88C57.9832 34.5333 58.0498 34.12 58.0498 33.64C58.0498 33.48 58.0432 33.3 58.0298 33.1C58.0165 32.9 57.9965 32.7133 57.9698 32.54C57.0498 32.74 56.3232 32.9533 55.7898 33.18C55.2698 33.4067 54.8965 33.68 54.6698 34C54.4565 34.3067 54.3498 34.6867 54.3498 35.14C54.3498 35.7133 54.4832 36.1267 54.7498 36.38C55.0165 36.62 55.3032 36.74 55.6098 36.74ZM62.8264 32.62C62.8264 31.74 62.9464 30.92 63.1864 30.16C63.4397 29.3867 63.7731 28.7667 64.1864 28.3C64.5731 27.8733 65.0331 27.5533 65.5664 27.34C66.0997 27.1133 66.6997 27 67.3664 27C67.9931 27 68.5464 27.1133 69.0264 27.34C69.5064 27.5667 69.9397 27.9733 70.3264 28.56V23.9L68.7864 23.52V22.4H72.8664V36.5L74.4064 36.88V38L70.7064 38.2L70.5464 36.56C70.1331 37.1733 69.6664 37.6 69.1464 37.84C68.6264 38.08 68.0197 38.2 67.3264 38.2C66.5931 38.2 65.9731 38.0933 65.4664 37.88C64.9731 37.6533 64.5531 37.34 64.2064 36.94C63.7931 36.4733 63.4597 35.8667 63.2064 35.12C62.9531 34.36 62.8264 33.5267 62.8264 32.62ZM70.3264 32.68C70.3264 31.9067 70.2597 31.2333 70.1264 30.66C69.9931 30.0867 69.8331 29.6533 69.6464 29.36C69.4464 29.04 69.1931 28.7933 68.8864 28.62C68.5931 28.4467 68.2331 28.36 67.8064 28.36C67.4864 28.36 67.1597 28.4267 66.8264 28.56C66.4931 28.6933 66.2331 28.9333 66.0464 29.28C65.8731 29.6 65.7397 30.04 65.6464 30.6C65.5664 31.16 65.5264 31.7733 65.5264 32.44C65.5264 33.2133 65.5797 33.8867 65.6864 34.46C65.7931 35.0333 65.9264 35.4733 66.0864 35.78C66.2731 36.1133 66.5264 36.38 66.8464 36.58C67.1797 36.7667 67.5331 36.86 67.9064 36.86C68.2131 36.86 68.5264 36.7933 68.8464 36.66C69.1664 36.5133 69.4331 36.2733 69.6464 35.94C69.8597 35.5933 70.0264 35.14 70.1464 34.58C70.2664 34.0067 70.3264 33.3733 70.3264 32.68ZM76.9413 28.7L75.4013 28.32V27.2H79.4813V36.5L81.0213 36.88V38H75.4013V36.88L76.9413 36.5V28.7ZM76.7213 24.16C76.7213 23.7333 76.8479 23.3867 77.1013 23.12C77.3679 22.8533 77.7346 22.72 78.2013 22.72C78.6679 22.72 79.0346 22.8533 79.3013 23.12C79.5679 23.3867 79.7013 23.7333 79.7013 24.16C79.7013 24.5733 79.5679 24.9133 79.3013 25.18C79.0479 25.4467 78.6813 25.58 78.2013 25.58C77.7213 25.58 77.3546 25.4533 77.1013 25.2C76.8479 24.9333 76.7213 24.5867 76.7213 24.16ZM83.5623 36.5V28.7L82.0223 28.32V27.2H85.5023L85.9423 29.2H86.0223C86.4223 28.52 86.9623 27.9867 87.6423 27.6C88.3223 27.2 89.049 27 89.8223 27C90.929 27 91.749 27.36 92.2823 28.08C92.549 28.4533 92.7357 28.98 92.8423 29.66C92.9623 30.3267 93.0223 31.2333 93.0223 32.38V36.5L94.5623 36.88V38H89.1423V36.88L90.4823 36.5V32.64C90.4823 31.84 90.4557 31.22 90.4023 30.78C90.3623 30.3267 90.2823 29.9667 90.1623 29.7C90.0157 29.3533 89.8157 29.1133 89.5623 28.98C89.309 28.8467 89.009 28.78 88.6623 28.78C88.009 28.78 87.4557 28.9933 87.0023 29.42C86.4557 29.9267 86.1557 30.7067 86.1023 31.76V36.5L87.4423 36.88V38H82.0223V36.88L83.5623 36.5ZM105.439 38.12C105.439 39.3467 104.999 40.2467 104.119 40.82C103.239 41.3933 101.839 41.68 99.9189 41.68C99.0656 41.68 98.2856 41.6 97.5789 41.44C96.8856 41.28 96.3322 41.0133 95.9189 40.64C95.5056 40.28 95.2989 39.7867 95.2989 39.16C95.2989 38.5467 95.4922 38.0533 95.8789 37.68C96.2656 37.3067 96.8389 37.1067 97.5989 37.08V37C96.5856 36.72 96.0789 36.2133 96.0789 35.48C96.0789 35.2133 96.1456 34.9333 96.2789 34.64C96.4122 34.3467 96.6322 34.0867 96.9389 33.86C97.2456 33.6333 97.6456 33.4867 98.1389 33.42C97.4322 33.2467 96.8789 32.8933 96.4789 32.36C96.0789 31.8133 95.8789 31.1733 95.8789 30.44C95.8789 29.3733 96.2389 28.5333 96.9589 27.92C97.6789 27.3067 98.7122 27 100.059 27C100.952 27 101.652 27.08 102.159 27.24C102.666 27.3867 103.112 27.6133 103.499 27.92L104.179 27.68L106.019 26.8H106.359V28.86H106.019L104.619 28.7H104.119C104.386 29.1133 104.519 29.6533 104.519 30.32C104.519 31.4133 104.179 32.28 103.499 32.92C102.819 33.5467 101.839 33.86 100.559 33.86C100.426 33.86 100.292 33.86 100.159 33.86C100.026 33.8467 99.8922 33.8333 99.7589 33.82C99.2389 33.8867 98.8189 34.0067 98.4989 34.18C98.1922 34.34 98.0389 34.5733 98.0389 34.88C98.0389 35.12 98.1656 35.2867 98.4189 35.38C98.6722 35.46 99.1322 35.5 99.7989 35.5H102.119C103.212 35.5 104.039 35.72 104.599 36.16C105.159 36.5867 105.439 37.24 105.439 38.12ZM100.639 37.34H99.9389C99.0456 37.34 98.3989 37.48 97.9989 37.76C97.5989 38.04 97.3989 38.4067 97.3989 38.86C97.3989 39.8733 98.3522 40.38 100.259 40.38C101.286 40.38 102.066 40.2267 102.599 39.92C103.132 39.6267 103.399 39.1933 103.399 38.62C103.399 38.1533 103.192 37.8267 102.779 37.64C102.366 37.44 101.652 37.34 100.639 37.34ZM98.2389 30.36C98.2389 31.1067 98.3989 31.68 98.7189 32.08C99.0522 32.4667 99.5122 32.66 100.099 32.66C100.806 32.66 101.326 32.4667 101.659 32.08C101.992 31.68 102.159 31.1067 102.159 30.36C102.159 29.6533 101.992 29.12 101.659 28.76C101.326 28.4 100.806 28.22 100.099 28.22C99.4989 28.22 99.0389 28.4 98.7189 28.76C98.3989 29.12 98.2389 29.6533 98.2389 30.36Z" fill="black"/><path d="M29.124 53.072L29.208 52.946C29.8427 52.9553 30.3793 53.058 30.818 53.254C31.2567 53.4407 31.5833 53.7113 31.798 54.066C32.022 54.4207 32.134 54.85 32.134 55.354C32.134 55.8767 32.008 56.3387 31.756 56.74C31.5133 57.132 31.126 57.44 30.594 57.664C30.0713 57.888 29.3993 58 28.578 58H24.686V57.398L26.072 57.104L25.89 57.356V48.9L26.114 49.166L24.686 48.9V48.298L26.996 48.228H28.732C29.404 48.228 29.964 48.3213 30.412 48.508C30.86 48.6947 31.196 48.9653 31.42 49.32C31.644 49.6747 31.756 50.1087 31.756 50.622C31.756 51.294 31.5507 51.84 31.14 52.26C30.7293 52.68 30.0573 52.9507 29.124 53.072ZM28.494 49.068H26.828L27.038 48.858V52.792L26.828 52.596H28.144C28.6947 52.596 29.152 52.526 29.516 52.386C29.88 52.246 30.1507 52.0407 30.328 51.77C30.5053 51.4993 30.594 51.168 30.594 50.776C30.594 50.3933 30.5147 50.076 30.356 49.824C30.1973 49.572 29.964 49.3853 29.656 49.264C29.348 49.1333 28.9607 49.068 28.494 49.068ZM28.494 57.16C29.0447 57.16 29.502 57.0853 29.866 56.936C30.23 56.7867 30.5007 56.5767 30.678 56.306C30.8647 56.026 30.958 55.6853 30.958 55.284C30.958 54.892 30.874 54.5607 30.706 54.29C30.5473 54.01 30.3093 53.7953 29.992 53.646C29.684 53.4967 29.3107 53.422 28.872 53.422H26.828L27.038 53.198V57.356L26.828 57.16H28.494ZM36.9754 50.482C38.002 50.482 38.8047 50.804 39.3834 51.448C39.9714 52.092 40.2654 53.002 40.2654 54.178C40.2654 54.9713 40.1207 55.6667 39.8314 56.264C39.5514 56.852 39.15 57.3093 38.6274 57.636C38.1047 57.9627 37.4747 58.126 36.7374 58.126C35.7294 58.126 34.9407 57.8133 34.3714 57.188C33.802 56.5533 33.5174 55.6433 33.5174 54.458C33.5174 53.6367 33.6527 52.932 33.9234 52.344C34.2034 51.7467 34.6 51.2893 35.1134 50.972C35.636 50.6453 36.2567 50.482 36.9754 50.482ZM36.9194 51.308C36.2007 51.308 35.65 51.5787 35.2674 52.12C34.8847 52.6613 34.6934 53.422 34.6934 54.402C34.6934 55.3633 34.8754 56.0867 35.2394 56.572C35.6034 57.0573 36.126 57.3 36.8074 57.3C37.302 57.3 37.7174 57.1787 38.0534 56.936C38.3987 56.684 38.6554 56.3293 38.8234 55.872C39.0007 55.4147 39.0894 54.8687 39.0894 54.234C39.0894 53.282 38.898 52.5587 38.5154 52.064C38.142 51.56 37.61 51.308 36.9194 51.308ZM44.3421 58.126C43.8288 58.126 43.3621 57.986 42.9421 57.706C42.5221 57.4167 42.1908 56.9967 41.9481 56.446C41.7054 55.886 41.5841 55.2093 41.5841 54.416C41.5841 53.1187 41.9154 52.1387 42.5781 51.476C43.2408 50.8133 44.1508 50.482 45.3081 50.482C45.5508 50.482 45.8028 50.5007 46.0641 50.538C46.3348 50.5753 46.6101 50.6313 46.8901 50.706L46.6661 50.832V48.018L46.7921 48.172L45.5041 47.892V47.29L47.7861 47.192V57.314L47.6181 57.118L48.8781 57.37V57.986L46.9181 58.07L46.7501 56.866L46.8901 56.922C46.4701 57.3233 46.0454 57.6267 45.6161 57.832C45.1961 58.028 44.7714 58.126 44.3421 58.126ZM44.7341 57.272C45.0608 57.272 45.3968 57.188 45.7421 57.02C46.0968 56.8427 46.4514 56.5813 46.8061 56.236L46.6661 56.614V51.308L46.8201 51.588C46.2508 51.4013 45.7328 51.308 45.2661 51.308C44.4448 51.308 43.8194 51.574 43.3901 52.106C42.9608 52.638 42.7461 53.3753 42.7461 54.318C42.7461 54.934 42.8301 55.466 42.9981 55.914C43.1754 56.3527 43.4134 56.6887 43.7121 56.922C44.0201 57.1553 44.3608 57.272 44.7341 57.272ZM49.2159 61.276L49.3139 60.45C49.4259 60.4687 49.5285 60.4827 49.6219 60.492C49.7245 60.5013 49.8179 60.506 49.9019 60.506C50.3592 60.506 50.7279 60.3987 51.0079 60.184C51.2972 59.9787 51.5399 59.666 51.7359 59.246C51.9319 58.826 52.1325 58.3033 52.3379 57.678L52.2959 58.098L49.6779 51.28L49.8319 51.406L48.9219 51.252V50.65L51.9879 50.552V51.168L50.7279 51.378L50.8119 51.252L52.8979 57.202L52.6459 57.146L54.6479 51.28L54.7319 51.406L53.4999 51.252V50.65L56.4679 50.552V51.168L55.4879 51.392L55.6839 51.266L53.2199 58.028C53.0519 58.4947 52.8745 58.9287 52.6879 59.33C52.5105 59.7313 52.3052 60.0813 52.0719 60.38C51.8385 60.688 51.5539 60.926 51.2179 61.094C50.8819 61.262 50.4759 61.346 49.9999 61.346C49.7852 61.346 49.5239 61.3227 49.2159 61.276ZM59.7648 58V57.398L60.9968 57.132L60.8568 57.3V51.294L60.9968 51.448H59.7368V50.832L61.0248 50.65L60.8568 50.86V49.684C60.8568 48.8067 61.0808 48.1627 61.5288 47.752C61.9861 47.332 62.5834 47.122 63.3208 47.122C63.5634 47.122 63.8108 47.1453 64.0628 47.192C64.3148 47.2293 64.5808 47.2947 64.8608 47.388L64.6788 48.158C64.4641 48.0927 64.2588 48.0413 64.0628 48.004C63.8668 47.9667 63.6754 47.948 63.4888 47.948C63.0314 47.948 62.6628 48.0787 62.3828 48.34C62.1121 48.6013 61.9768 49.0167 61.9768 49.586V50.86L61.7948 50.664H63.9368L63.9088 51.448H61.8368L61.9768 51.294V57.286L61.8368 57.132L63.3068 57.398V58H59.7648ZM68.0652 50.482C69.0919 50.482 69.8946 50.804 70.4732 51.448C71.0612 52.092 71.3552 53.002 71.3552 54.178C71.3552 54.9713 71.2106 55.6667 70.9212 56.264C70.6412 56.852 70.2399 57.3093 69.7172 57.636C69.1946 57.9627 68.5646 58.126 67.8272 58.126C66.8192 58.126 66.0306 57.8133 65.4612 57.188C64.8919 56.5533 64.6072 55.6433 64.6072 54.458C64.6072 53.6367 64.7426 52.932 65.0132 52.344C65.2932 51.7467 65.6899 51.2893 66.2032 50.972C66.7259 50.6453 67.3466 50.482 68.0652 50.482ZM68.0092 51.308C67.2906 51.308 66.7399 51.5787 66.3572 52.12C65.9746 52.6613 65.7832 53.422 65.7832 54.402C65.7832 55.3633 65.9652 56.0867 66.3292 56.572C66.6932 57.0573 67.2159 57.3 67.8972 57.3C68.3919 57.3 68.8072 57.1787 69.1432 56.936C69.4886 56.684 69.7452 56.3293 69.9132 55.872C70.0906 55.4147 70.1792 54.8687 70.1792 54.234C70.1792 53.282 69.9879 52.5587 69.6052 52.064C69.2319 51.56 68.6999 51.308 68.0092 51.308ZM72.534 58V57.398L73.794 57.118L73.626 57.328V51.308L73.794 51.518L72.534 51.252V50.65L74.494 50.552L74.648 51.924L74.494 51.868C74.9606 51.392 75.446 51.042 75.95 50.818C76.4633 50.594 76.9486 50.482 77.406 50.482C78.022 50.482 78.5306 50.6733 78.932 51.056C79.3426 51.4293 79.5433 52.0127 79.534 52.806V57.328L79.394 57.132L80.626 57.398V58H77.364V57.398L78.582 57.132L78.414 57.342V53.044C78.414 52.4653 78.2833 52.0407 78.022 51.77C77.7606 51.4993 77.4106 51.364 76.972 51.364C76.6266 51.364 76.2486 51.4573 75.838 51.644C75.4366 51.8307 75.04 52.12 74.648 52.512L74.746 52.288V57.342L74.606 57.146L75.796 57.398V58H72.534ZM83.8713 58.126C83.386 58.126 83.0033 57.9767 82.7233 57.678C82.4433 57.37 82.3033 56.908 82.3033 56.292V51.21L82.4853 51.392H81.0433V50.776L82.4993 50.566L82.3033 50.79V48.942L83.4233 48.76V50.79L83.2693 50.608H85.4673L85.4253 51.392H83.2693L83.4233 51.21V56.138C83.4233 56.53 83.498 56.8147 83.6473 56.992C83.806 57.1693 84.0253 57.258 84.3053 57.258C84.4733 57.258 84.6553 57.23 84.8513 57.174C85.0473 57.118 85.2573 57.0387 85.4813 56.936L85.7193 57.58C85.0567 57.944 84.4407 58.126 83.8713 58.126ZM89.2823 58V57.398L90.5143 57.132L90.3743 57.3V51.294L90.5143 51.448H89.2543V50.832L90.5423 50.65L90.3743 50.86V49.684C90.3743 48.8067 90.5983 48.1627 91.0463 47.752C91.5037 47.332 92.101 47.122 92.8383 47.122C93.081 47.122 93.3283 47.1453 93.5803 47.192C93.8323 47.2293 94.0983 47.2947 94.3783 47.388L94.1963 48.158C93.9817 48.0927 93.7763 48.0413 93.5803 48.004C93.3843 47.9667 93.193 47.948 93.0063 47.948C92.549 47.948 92.1803 48.0787 91.9003 48.34C91.6297 48.6013 91.4943 49.0167 91.4943 49.586V50.86L91.3123 50.664H93.4543L93.4263 51.448H91.3543L91.4943 51.294V57.286L91.3543 57.132L92.8243 57.398V58H89.2823ZM99.8485 57.37L99.6665 57.118L100.954 57.37V57.986L98.9945 58.07L98.8265 56.726L98.9245 56.768C98.5138 57.216 98.0705 57.5567 97.5945 57.79C97.1185 58.014 96.6565 58.126 96.2085 58.126C95.6672 58.126 95.2098 57.9533 94.8365 57.608C94.4632 57.2627 94.2765 56.74 94.2765 56.04C94.2765 55.4893 94.3932 55.0693 94.6265 54.78C94.8598 54.4813 95.1818 54.2713 95.5925 54.15C96.0032 54.0287 96.4792 53.968 97.0205 53.968H98.8545L98.7285 54.108V52.764C98.7285 52.2507 98.5932 51.8867 98.3225 51.672C98.0518 51.448 97.6785 51.336 97.2025 51.336C96.9505 51.336 96.6798 51.364 96.3905 51.42C96.1105 51.4667 95.8118 51.546 95.4945 51.658L95.6625 51.476L95.5225 52.75H94.7805L94.6685 51.014C95.2005 50.8367 95.6998 50.706 96.1665 50.622C96.6332 50.5287 97.0625 50.482 97.4545 50.482C98.2012 50.482 98.7845 50.65 99.2045 50.986C99.6338 51.3127 99.8485 51.84 99.8485 52.568V57.37ZM95.4105 55.942C95.4105 56.3993 95.5178 56.7353 95.7325 56.95C95.9565 57.1647 96.2365 57.272 96.5725 57.272C96.8992 57.272 97.2585 57.174 97.6505 56.978C98.0518 56.7727 98.4392 56.4973 98.8125 56.152L98.7285 56.446V54.57L98.8545 54.696H97.1885C96.5258 54.696 96.0638 54.7987 95.8025 55.004C95.5412 55.2 95.4105 55.5127 95.4105 55.942ZM108.485 51.882L108.331 51.91C108.788 51.434 109.273 51.0793 109.787 50.846C110.3 50.6033 110.781 50.482 111.229 50.482C111.798 50.482 112.274 50.6733 112.657 51.056C113.049 51.4293 113.245 52.008 113.245 52.792V57.328L113.105 57.132L114.337 57.398V58H111.089V57.398L112.279 57.132L112.125 57.342V53.044C112.125 52.4653 111.999 52.0407 111.747 51.77C111.504 51.4993 111.187 51.364 110.795 51.364C110.459 51.364 110.085 51.462 109.675 51.658C109.273 51.854 108.877 52.1527 108.485 52.554L108.583 52.288C108.592 52.372 108.597 52.4513 108.597 52.526C108.606 52.6007 108.611 52.6753 108.611 52.75V57.328L108.471 57.132L109.633 57.398V58H106.469V57.398L107.659 57.132L107.491 57.342V53.044C107.491 52.4653 107.365 52.0407 107.113 51.77C106.87 51.4993 106.553 51.364 106.161 51.364C105.825 51.364 105.456 51.4573 105.055 51.644C104.653 51.8307 104.257 52.12 103.865 52.512L103.963 52.302V57.342L103.823 57.146L104.985 57.398V58H101.751V57.398L103.011 57.118L102.843 57.328V51.308L103.011 51.518L101.751 51.252V50.65L103.711 50.552L103.865 51.924L103.711 51.868C104.168 51.392 104.649 51.042 105.153 50.818C105.666 50.594 106.151 50.482 106.609 50.482C107.038 50.482 107.421 50.5987 107.757 50.832C108.093 51.056 108.335 51.406 108.485 51.882ZM117.32 57.286L117.194 57.132L118.412 57.398V58H115.108V57.398L116.326 57.132L116.2 57.286V51.378L116.312 51.504L115.108 51.252V50.65L117.32 50.566V57.286ZM116.676 49.054C116.462 49.054 116.284 48.984 116.144 48.844C116.004 48.704 115.934 48.5127 115.934 48.27C115.934 48.018 116.004 47.8267 116.144 47.696C116.294 47.556 116.476 47.486 116.69 47.486C116.914 47.486 117.096 47.5513 117.236 47.682C117.376 47.8127 117.446 48.0087 117.446 48.27C117.446 48.522 117.372 48.718 117.222 48.858C117.073 48.9887 116.891 49.054 116.676 49.054ZM121.349 57.286L121.223 57.132L122.441 57.398V58H119.123V57.398L120.341 57.132L120.229 57.286V48.018L120.341 48.144L119.123 47.892V47.29L121.349 47.192V57.286ZM122.784 61.276L122.882 60.45C122.994 60.4687 123.097 60.4827 123.19 60.492C123.293 60.5013 123.386 60.506 123.47 60.506C123.928 60.506 124.296 60.3987 124.576 60.184C124.866 59.9787 125.108 59.666 125.304 59.246C125.5 58.826 125.701 58.3033 125.906 57.678L125.864 58.098L123.246 51.28L123.4 51.406L122.49 51.252V50.65L125.556 50.552V51.168L124.296 51.378L124.38 51.252L126.466 57.202L126.214 57.146L128.216 51.28L128.3 51.406L127.068 51.252V50.65L130.036 50.552V51.168L129.056 51.392L129.252 51.266L126.788 58.028C126.62 58.4947 126.443 58.9287 126.256 59.33C126.079 59.7313 125.874 60.0813 125.64 60.38C125.407 60.688 125.122 60.926 124.786 61.094C124.45 61.262 124.044 61.346 123.568 61.346C123.354 61.346 123.092 61.3227 122.784 61.276Z" fill="black"/></svg>',
            'three' => '<svg width="155" height="82" viewBox="0 0 155 82" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="155" height="82" fill="white"/><rect x="0.5" y="0.5" width="154" height="81" stroke="black" stroke-opacity="0.1"/><path d="M33.16 39V38.6C33.6 38.5733 33.9267 38.52 34.14 38.44C34.3667 38.36 34.5133 38.2 34.58 37.96C34.66 37.72 34.7 37.36 34.7 36.88V26.96C34.7 26.4667 34.66 26.1067 34.58 25.88C34.5133 25.64 34.3667 25.48 34.14 25.4C33.9267 25.3067 33.6 25.2533 33.16 25.24V24.84C33.52 24.8533 33.9667 24.8667 34.5 24.88C35.0333 24.8933 35.5667 24.9 36.1 24.9C36.6867 24.9 37.2333 24.8933 37.74 24.88C38.26 24.8667 38.6733 24.8533 38.98 24.84V25.24C38.5533 25.2533 38.2267 25.3067 38 25.4C37.7867 25.48 37.64 25.64 37.56 25.88C37.48 26.1067 37.44 26.4667 37.44 26.96V36.88C37.44 37.36 37.48 37.72 37.56 37.96C37.64 38.2 37.7867 38.36 38 38.44C38.2267 38.52 38.5533 38.5733 38.98 38.6V39C38.6733 38.9733 38.26 38.96 37.74 38.96C37.2333 38.9467 36.6867 38.94 36.1 38.94C35.5667 38.94 35.0333 38.9467 34.5 38.96C33.9667 38.96 33.52 38.9733 33.16 39ZM24.72 39V38.6C25.16 38.5733 25.4867 38.52 25.7 38.44C25.9267 38.36 26.0733 38.2 26.14 37.96C26.22 37.72 26.26 37.36 26.26 36.88V26.96C26.26 26.4667 26.22 26.1067 26.14 25.88C26.0733 25.64 25.9267 25.48 25.7 25.4C25.4867 25.3067 25.16 25.2533 24.72 25.24V24.84C25.0533 24.8533 25.48 24.8667 26 24.88C26.52 24.8933 27.08 24.9 27.68 24.9C28.2133 24.9 28.74 24.8933 29.26 24.88C29.78 24.8667 30.2067 24.8533 30.54 24.84V25.24C30.1133 25.2533 29.7867 25.3067 29.56 25.4C29.3467 25.48 29.2 25.64 29.12 25.88C29.04 26.1067 29 26.4667 29 26.96V36.88C29 37.36 29.04 37.72 29.12 37.96C29.2 38.2 29.3467 38.36 29.56 38.44C29.7867 38.52 30.1133 38.5733 30.54 38.6V39C30.2067 38.9733 29.78 38.96 29.26 38.96C28.74 38.9467 28.2133 38.94 27.68 38.94C27.08 38.94 26.52 38.9467 26 38.96C25.48 38.96 25.0533 38.9733 24.72 39ZM27.9 32.08V31.68H35.8V32.08H27.9ZM44.9116 28.38C46.0849 28.38 47.0049 28.7333 47.6716 29.44C48.3382 30.1467 48.6716 31.2733 48.6716 32.82H41.9316L41.9116 32.44H46.3516C46.3782 31.7867 46.3382 31.1867 46.2316 30.64C46.1249 30.08 45.9516 29.6333 45.7116 29.3C45.4849 28.9667 45.1849 28.8 44.8116 28.8C44.3049 28.8 43.8649 29.1 43.4916 29.7C43.1182 30.2867 42.8849 31.2533 42.7916 32.6L42.8716 32.72C42.8449 32.8933 42.8249 33.08 42.8116 33.28C42.8116 33.48 42.8116 33.68 42.8116 33.88C42.8116 34.8 42.9449 35.56 43.2116 36.16C43.4782 36.76 43.8249 37.2 44.2516 37.48C44.6782 37.76 45.1182 37.9 45.5716 37.9C45.8782 37.9 46.1916 37.8533 46.5116 37.76C46.8316 37.6667 47.1449 37.4933 47.4516 37.24C47.7582 36.9867 48.0382 36.6267 48.2916 36.16L48.6716 36.32C48.5249 36.7867 48.2782 37.2533 47.9316 37.72C47.5982 38.1733 47.1649 38.5467 46.6316 38.84C46.0982 39.1333 45.4716 39.28 44.7516 39.28C43.8449 39.28 43.0449 39.08 42.3516 38.68C41.6582 38.28 41.1182 37.6867 40.7316 36.9C40.3449 36.1 40.1516 35.1267 40.1516 33.98C40.1516 32.7667 40.3516 31.7467 40.7516 30.92C41.1649 30.0933 41.7316 29.4667 42.4516 29.04C43.1716 28.6 43.9916 28.38 44.9116 28.38ZM52.7492 39.14C52.1759 39.14 51.6892 39.0333 51.2892 38.82C50.8892 38.5933 50.5892 38.2933 50.3892 37.92C50.1892 37.5333 50.0892 37.1067 50.0892 36.64C50.0892 36.0667 50.2226 35.6 50.4892 35.24C50.7559 34.8667 51.0959 34.5733 51.5092 34.36C51.9359 34.1333 52.3826 33.9467 52.8492 33.8C53.3159 33.64 53.7559 33.4933 54.1692 33.36C54.5826 33.2133 54.9226 33.0467 55.1892 32.86C55.4559 32.6733 55.5892 32.4267 55.5892 32.12V30.66C55.5892 30.2333 55.5226 29.8867 55.3892 29.62C55.2692 29.34 55.0826 29.1333 54.8292 29C54.5892 28.8533 54.2826 28.78 53.9092 28.78C53.6292 28.78 53.3359 28.82 53.0292 28.9C52.7226 28.98 52.4692 29.1333 52.2692 29.36C52.6159 29.4533 52.8826 29.6267 53.0692 29.88C53.2692 30.1333 53.3692 30.44 53.3692 30.8C53.3692 31.2133 53.2292 31.54 52.9492 31.78C52.6826 32.0067 52.3426 32.12 51.9292 32.12C51.4892 32.12 51.1559 31.98 50.9292 31.7C50.7026 31.42 50.5892 31.0933 50.5892 30.72C50.5892 30.3467 50.6826 30.04 50.8692 29.8C51.0559 29.5467 51.3159 29.32 51.6492 29.12C51.9826 28.8933 52.4092 28.7133 52.9292 28.58C53.4492 28.4467 54.0159 28.38 54.6292 28.38C55.2159 28.38 55.7359 28.4467 56.1892 28.58C56.6426 28.7 57.0292 28.92 57.3492 29.24C57.6692 29.5467 57.8759 29.9267 57.9692 30.38C58.0626 30.8333 58.1092 31.3867 58.1092 32.04V37.52C58.1092 37.8533 58.1492 38.0933 58.2292 38.24C58.3092 38.3733 58.4359 38.44 58.6092 38.44C58.7426 38.44 58.8692 38.4067 58.9892 38.34C59.1092 38.2733 59.2426 38.18 59.3892 38.06L59.6092 38.4C59.3159 38.6267 59.0092 38.8067 58.6892 38.94C58.3692 39.0733 57.9826 39.14 57.5292 39.14C57.0626 39.14 56.6892 39.0733 56.4092 38.94C56.1426 38.8067 55.9426 38.6133 55.8092 38.36C55.6892 38.1067 55.6226 37.8067 55.6092 37.46C55.2892 37.9933 54.8959 38.4067 54.4292 38.7C53.9626 38.9933 53.4026 39.14 52.7492 39.14ZM53.9492 38.02C54.2692 38.02 54.5626 37.9333 54.8292 37.76C55.1092 37.5867 55.3626 37.3267 55.5892 36.98V32.94C55.4559 33.14 55.2626 33.32 55.0092 33.48C54.7692 33.64 54.5092 33.8 54.2292 33.96C53.9492 34.12 53.6826 34.3067 53.4292 34.52C53.1892 34.72 52.9826 34.9733 52.8092 35.28C52.6492 35.5733 52.5692 35.9533 52.5692 36.42C52.5692 36.94 52.6959 37.34 52.9492 37.62C53.2026 37.8867 53.5359 38.02 53.9492 38.02ZM69.7641 23.34V36.82C69.7641 37.42 69.8641 37.8667 70.0641 38.16C70.2641 38.44 70.6174 38.58 71.1241 38.58V39C70.7107 38.96 70.2974 38.94 69.8841 38.94C69.3907 38.94 68.9241 38.96 68.4841 39C68.0441 39.04 67.6307 39.1133 67.2441 39.22V25.74C67.2441 25.14 67.1441 24.7 66.9441 24.42C66.7574 24.1267 66.4041 23.98 65.8841 23.98V23.56C66.3107 23.6 66.7241 23.62 67.1241 23.62C67.6307 23.62 68.1041 23.6 68.5441 23.56C68.9841 23.5067 69.3907 23.4333 69.7641 23.34ZM64.9841 28.38C65.5707 28.38 66.0974 28.4933 66.5641 28.72C67.0307 28.9467 67.3774 29.3267 67.6041 29.86L67.3641 30.06C67.1774 29.6733 66.9241 29.3867 66.6041 29.2C66.2841 29.0133 65.9241 28.92 65.5241 28.92C64.8041 28.92 64.2241 29.3267 63.7841 30.14C63.3574 30.94 63.1441 32.1733 63.1441 33.84C63.1441 34.96 63.2307 35.8667 63.4041 36.56C63.5774 37.24 63.8241 37.7333 64.1441 38.04C64.4774 38.3467 64.8707 38.5 65.3241 38.5C65.8041 38.5 66.2374 38.3067 66.6241 37.92C67.0107 37.52 67.2374 36.9533 67.3041 36.22L67.4441 36.78C67.2707 37.5933 66.9441 38.2133 66.4641 38.64C65.9841 39.0667 65.3507 39.28 64.5641 39.28C63.7641 39.28 63.0507 39.0867 62.4241 38.7C61.8107 38.3 61.3307 37.7 60.9841 36.9C60.6507 36.0867 60.4841 35.06 60.4841 33.82C60.4841 32.6067 60.6841 31.6 61.0841 30.8C61.4841 29.9867 62.0241 29.38 62.7041 28.98C63.3841 28.58 64.1441 28.38 64.9841 28.38ZM74.5 23.56C74.98 23.56 75.3733 23.6933 75.68 23.96C75.9867 24.2267 76.14 24.58 76.14 25.02C76.14 25.46 75.9867 25.8133 75.68 26.08C75.3733 26.3467 74.98 26.48 74.5 26.48C74.02 26.48 73.6267 26.3467 73.32 26.08C73.0133 25.8133 72.86 25.46 72.86 25.02C72.86 24.58 73.0133 24.2267 73.32 23.96C73.6267 23.6933 74.02 23.56 74.5 23.56ZM75.9 28.44V37.14C75.9 37.7 76 38.08 76.2 38.28C76.4133 38.48 76.7667 38.58 77.26 38.58V39C77.02 38.9867 76.6533 38.9733 76.16 38.96C75.6667 38.9333 75.1667 38.92 74.66 38.92C74.1667 38.92 73.6667 38.9333 73.16 38.96C72.6533 38.9733 72.2733 38.9867 72.02 39V38.58C72.5133 38.58 72.86 38.48 73.06 38.28C73.2733 38.08 73.38 37.7 73.38 37.14V30.86C73.38 30.2467 73.28 29.8 73.08 29.52C72.8933 29.2267 72.54 29.08 72.02 29.08V28.66C72.4467 28.7 72.86 28.72 73.26 28.72C73.7533 28.72 74.22 28.7 74.66 28.66C75.1133 28.6067 75.5267 28.5333 75.9 28.44ZM85.3523 28.38C85.9123 28.38 86.359 28.4533 86.6923 28.6C87.039 28.7467 87.319 28.9333 87.5323 29.16C87.7723 29.4133 87.939 29.74 88.0323 30.14C88.139 30.54 88.1923 31.08 88.1923 31.76V37.14C88.1923 37.7 88.2923 38.08 88.4923 38.28C88.7057 38.48 89.059 38.58 89.5523 38.58V39C89.3123 38.9867 88.939 38.9733 88.4323 38.96C87.939 38.9333 87.459 38.92 86.9923 38.92C86.499 38.92 86.019 38.9333 85.5523 38.96C85.0857 38.9733 84.739 38.9867 84.5123 39V38.58C84.939 38.58 85.239 38.48 85.4123 38.28C85.5857 38.08 85.6723 37.7 85.6723 37.14V31.08C85.6723 30.72 85.639 30.4 85.5723 30.12C85.5057 29.8267 85.3723 29.6 85.1723 29.44C84.9723 29.2667 84.6857 29.18 84.3123 29.18C83.8723 29.18 83.479 29.3 83.1323 29.54C82.799 29.78 82.5323 30.1133 82.3323 30.54C82.1457 30.9533 82.0523 31.42 82.0523 31.94V37.14C82.0523 37.7 82.139 38.08 82.3123 38.28C82.4857 38.48 82.7857 38.58 83.2123 38.58V39C82.9857 38.9867 82.6457 38.9733 82.1923 38.96C81.739 38.9333 81.279 38.92 80.8123 38.92C80.319 38.92 79.819 38.9333 79.3123 38.96C78.8057 38.9733 78.4257 38.9867 78.1723 39V38.58C78.6657 38.58 79.0123 38.48 79.2123 38.28C79.4257 38.08 79.5323 37.7 79.5323 37.14V30.84C79.5323 30.24 79.4323 29.8 79.2323 29.52C79.0457 29.2267 78.6923 29.08 78.1723 29.08V28.66C78.599 28.7 79.0123 28.72 79.4123 28.72C79.9057 28.72 80.3723 28.7 80.8123 28.66C81.2657 28.6067 81.679 28.5333 82.0523 28.44V30.44C82.3857 29.68 82.8457 29.1467 83.4323 28.84C84.019 28.5333 84.659 28.38 85.3523 28.38ZM93.9841 42.76C93.1974 42.76 92.4841 42.6867 91.8441 42.54C91.2041 42.3933 90.6974 42.1733 90.3241 41.88C89.9507 41.6 89.7641 41.24 89.7641 40.8C89.7641 40.3733 89.9507 39.9933 90.3241 39.66C90.6974 39.3267 91.2441 39.0733 91.9641 38.9L92.1041 39.22C91.8507 39.3667 91.6574 39.5667 91.5241 39.82C91.3907 40.0733 91.3241 40.34 91.3241 40.62C91.3241 41.1933 91.5841 41.6333 92.1041 41.94C92.6374 42.26 93.3441 42.42 94.2241 42.42C94.8241 42.42 95.3774 42.34 95.8841 42.18C96.3907 42.02 96.7974 41.7733 97.1041 41.44C97.4107 41.1067 97.5641 40.6933 97.5641 40.2C97.5641 39.7867 97.4107 39.44 97.1041 39.16C96.8107 38.88 96.2174 38.74 95.3241 38.74H94.0041C93.5107 38.74 93.0574 38.6867 92.6441 38.58C92.2441 38.4733 91.9241 38.3 91.6841 38.06C91.4441 37.82 91.3241 37.4867 91.3241 37.06C91.3241 36.54 91.5374 36.0733 91.9641 35.66C92.3907 35.2333 93.0574 34.82 93.9641 34.42L94.1841 34.6C93.8507 34.7733 93.5507 34.96 93.2841 35.16C93.0307 35.36 92.9041 35.6133 92.9041 35.92C92.9041 36.3467 93.1974 36.56 93.7841 36.56H96.0441C96.7374 36.56 97.3507 36.6467 97.8841 36.82C98.4307 36.9933 98.8641 37.2667 99.1841 37.64C99.5041 38.0133 99.6641 38.5067 99.6641 39.12C99.6641 39.76 99.4574 40.3533 99.0441 40.9C98.6307 41.46 98.0041 41.9067 97.1641 42.24C96.3374 42.5867 95.2774 42.76 93.9841 42.76ZM94.1641 34.74C93.4441 34.74 92.7907 34.6333 92.2041 34.42C91.6307 34.1933 91.1774 33.8467 90.8441 33.38C90.5107 32.9 90.3441 32.2933 90.3441 31.56C90.3441 30.8267 90.5107 30.2267 90.8441 29.76C91.1774 29.2933 91.6307 28.9467 92.2041 28.72C92.7907 28.4933 93.4441 28.38 94.1641 28.38C94.8974 28.38 95.5507 28.4933 96.1241 28.72C96.6974 28.9467 97.1507 29.2933 97.4841 29.76C97.8174 30.2267 97.9841 30.8267 97.9841 31.56C97.9841 32.2933 97.8174 32.9 97.4841 33.38C97.1507 33.8467 96.6974 34.1933 96.1241 34.42C95.5507 34.6333 94.8974 34.74 94.1641 34.74ZM94.1641 34.38C94.5641 34.38 94.8774 34.18 95.1041 33.78C95.3441 33.3667 95.4641 32.6267 95.4641 31.56C95.4641 30.4933 95.3441 29.76 95.1041 29.36C94.8774 28.9467 94.5641 28.74 94.1641 28.74C93.7641 28.74 93.4441 28.9467 93.2041 29.36C92.9774 29.76 92.8641 30.4933 92.8641 31.56C92.8641 32.6267 92.9774 33.3667 93.2041 33.78C93.4441 34.18 93.7641 34.38 94.1641 34.38ZM97.1841 30.08L96.8041 29.94C97.0041 29.4467 97.3307 29.0333 97.7841 28.7C98.2374 28.3533 98.7174 28.18 99.2241 28.18C99.6107 28.18 99.9107 28.2867 100.124 28.5C100.351 28.7133 100.464 29.0133 100.464 29.4C100.464 29.8 100.357 30.0933 100.144 30.28C99.9307 30.4667 99.6974 30.56 99.4441 30.56C99.2174 30.56 99.0107 30.4867 98.8241 30.34C98.6374 30.18 98.5307 29.94 98.5041 29.62C98.4774 29.2867 98.5841 28.8733 98.8241 28.38L99.0241 28.46C98.5041 28.66 98.1174 28.88 97.8641 29.12C97.6107 29.36 97.3841 29.68 97.1841 30.08Z" fill="black"/><path d="M25.3672 51.0059H28.1973C29.446 51.0059 30.3848 51.1927 31.0137 51.5664C31.6426 51.9401 31.957 52.5758 31.957 53.4736C31.957 53.861 31.8818 54.2096 31.7314 54.5195C31.5856 54.8249 31.3714 55.0778 31.0889 55.2783C30.8063 55.4788 30.4577 55.6178 30.043 55.6953V55.7637C30.4805 55.832 30.8678 55.9574 31.2051 56.1396C31.5423 56.3219 31.8066 56.5771 31.998 56.9053C32.1895 57.2334 32.2852 57.6504 32.2852 58.1562C32.2852 58.7715 32.1416 59.291 31.8545 59.7148C31.5719 60.1387 31.1709 60.46 30.6514 60.6787C30.1318 60.8929 29.5166 61 28.8057 61H25.3672V51.0059ZM26.5293 55.292H28.4434C29.3138 55.292 29.9154 55.1484 30.248 54.8613C30.5853 54.5742 30.7539 54.1549 30.7539 53.6035C30.7539 53.0339 30.5534 52.6237 30.1523 52.373C29.7559 52.1224 29.1224 51.9971 28.252 51.9971H26.5293V55.292ZM26.5293 56.2695V60.0088H28.6074C29.4961 60.0088 30.125 59.8356 30.4941 59.4893C30.8633 59.1383 31.0479 58.6667 31.0479 58.0742C31.0479 57.696 30.9635 57.3724 30.7949 57.1035C30.6309 56.8346 30.362 56.6296 29.9883 56.4883C29.6191 56.3424 29.1247 56.2695 28.5049 56.2695H26.5293ZM40.707 57.2402C40.707 57.8555 40.6273 58.4046 40.4678 58.8877C40.3083 59.3708 40.0781 59.7786 39.7773 60.1113C39.4766 60.444 39.112 60.6992 38.6836 60.877C38.2598 61.0501 37.779 61.1367 37.2412 61.1367C36.7399 61.1367 36.2796 61.0501 35.8604 60.877C35.4456 60.6992 35.0856 60.444 34.7803 60.1113C34.4795 59.7786 34.2448 59.3708 34.0762 58.8877C33.9121 58.4046 33.8301 57.8555 33.8301 57.2402C33.8301 56.4199 33.9691 55.7227 34.2471 55.1484C34.5251 54.5697 34.9215 54.1299 35.4365 53.8291C35.9561 53.5238 36.5736 53.3711 37.2891 53.3711C37.9727 53.3711 38.5697 53.5238 39.0801 53.8291C39.5951 54.1344 39.9938 54.5765 40.2764 55.1553C40.5635 55.7295 40.707 56.4245 40.707 57.2402ZM35.0059 57.2402C35.0059 57.8418 35.0856 58.3636 35.2451 58.8057C35.4046 59.2477 35.6507 59.5895 35.9834 59.8311C36.3161 60.0726 36.7445 60.1934 37.2686 60.1934C37.7881 60.1934 38.2142 60.0726 38.5469 59.8311C38.8841 59.5895 39.1325 59.2477 39.292 58.8057C39.4515 58.3636 39.5312 57.8418 39.5312 57.2402C39.5312 56.6432 39.4515 56.1283 39.292 55.6953C39.1325 55.2578 38.8864 54.9206 38.5537 54.6836C38.221 54.4466 37.7904 54.3281 37.2617 54.3281C36.4824 54.3281 35.9105 54.5856 35.5459 55.1006C35.1859 55.6156 35.0059 56.3288 35.0059 57.2402ZM45.335 61.1367C44.387 61.1367 43.6351 60.8132 43.0791 60.166C42.5277 59.5189 42.252 58.5573 42.252 57.2812C42.252 55.9915 42.5345 55.0186 43.0996 54.3623C43.6647 53.7015 44.4167 53.3711 45.3555 53.3711C45.752 53.3711 46.0983 53.4235 46.3945 53.5283C46.6908 53.6331 46.946 53.7744 47.1602 53.9521C47.3743 54.1253 47.5544 54.3236 47.7002 54.5469H47.7822C47.764 54.4056 47.7458 54.2119 47.7275 53.9658C47.7093 53.7197 47.7002 53.5192 47.7002 53.3643V50.3633H48.835V61H47.9189L47.748 59.9336H47.7002C47.5589 60.1569 47.3789 60.3597 47.1602 60.542C46.946 60.7243 46.6885 60.8701 46.3877 60.9795C46.0915 61.0843 45.7406 61.1367 45.335 61.1367ZM45.5127 60.1934C46.3148 60.1934 46.8822 59.9655 47.2148 59.5098C47.5475 59.054 47.7139 58.3773 47.7139 57.4795V57.2744C47.7139 56.3219 47.5544 55.5905 47.2354 55.0801C46.9209 54.5697 46.3467 54.3145 45.5127 54.3145C44.8154 54.3145 44.2936 54.5833 43.9473 55.1211C43.6009 55.6543 43.4277 56.3835 43.4277 57.3086C43.4277 58.2292 43.5986 58.9401 43.9404 59.4414C44.2868 59.9427 44.8109 60.1934 45.5127 60.1934ZM50.0586 53.5078H51.2754L52.9297 57.8555C53.0254 58.1107 53.1143 58.3568 53.1963 58.5938C53.2783 58.8262 53.3512 59.0495 53.415 59.2637C53.4788 59.4779 53.529 59.6852 53.5654 59.8857H53.6133C53.6771 59.6579 53.7682 59.3594 53.8867 58.9902C54.0052 58.6165 54.1328 58.236 54.2695 57.8486L55.835 53.5078H57.0586L53.7979 62.1006C53.6247 62.5609 53.4219 62.9619 53.1895 63.3037C52.9616 63.6455 52.6836 63.9076 52.3555 64.0898C52.0273 64.2767 51.6309 64.3701 51.166 64.3701C50.9518 64.3701 50.7627 64.3564 50.5986 64.3291C50.4346 64.3063 50.2933 64.279 50.1748 64.2471V63.3379C50.2751 63.3607 50.3958 63.3812 50.5371 63.3994C50.6829 63.4176 50.8333 63.4268 50.9883 63.4268C51.2708 63.4268 51.5146 63.3721 51.7197 63.2627C51.9294 63.1579 52.1094 63.0029 52.2598 62.7979C52.4102 62.5928 52.54 62.349 52.6494 62.0664L53.0596 61.0137L50.0586 53.5078ZM65.2275 54.3965H63.3613V61H62.2266V54.3965H60.9004V53.8496L62.2266 53.4736V52.9746C62.2266 52.3457 62.32 51.8353 62.5068 51.4434C62.6937 51.0469 62.9648 50.7552 63.3203 50.5684C63.6758 50.3815 64.1087 50.2881 64.6191 50.2881C64.9062 50.2881 65.1683 50.3132 65.4053 50.3633C65.6468 50.4134 65.8587 50.4704 66.041 50.5342L65.7471 51.4297C65.5921 51.3796 65.4167 51.334 65.2207 51.293C65.0293 51.2474 64.8333 51.2246 64.6328 51.2246C64.1999 51.2246 63.8786 51.3659 63.6689 51.6484C63.4639 51.9264 63.3613 52.3639 63.3613 52.9609V53.5078H65.2275V54.3965ZM73.0684 57.2402C73.0684 57.8555 72.9886 58.4046 72.8291 58.8877C72.6696 59.3708 72.4395 59.7786 72.1387 60.1113C71.8379 60.444 71.4733 60.6992 71.0449 60.877C70.6211 61.0501 70.1403 61.1367 69.6025 61.1367C69.1012 61.1367 68.641 61.0501 68.2217 60.877C67.807 60.6992 67.4469 60.444 67.1416 60.1113C66.8408 59.7786 66.6061 59.3708 66.4375 58.8877C66.2734 58.4046 66.1914 57.8555 66.1914 57.2402C66.1914 56.4199 66.3304 55.7227 66.6084 55.1484C66.8864 54.5697 67.2829 54.1299 67.7979 53.8291C68.3174 53.5238 68.9349 53.3711 69.6504 53.3711C70.334 53.3711 70.931 53.5238 71.4414 53.8291C71.9564 54.1344 72.3551 54.5765 72.6377 55.1553C72.9248 55.7295 73.0684 56.4245 73.0684 57.2402ZM67.3672 57.2402C67.3672 57.8418 67.4469 58.3636 67.6064 58.8057C67.766 59.2477 68.012 59.5895 68.3447 59.8311C68.6774 60.0726 69.1058 60.1934 69.6299 60.1934C70.1494 60.1934 70.5755 60.0726 70.9082 59.8311C71.2454 59.5895 71.4938 59.2477 71.6533 58.8057C71.8128 58.3636 71.8926 57.8418 71.8926 57.2402C71.8926 56.6432 71.8128 56.1283 71.6533 55.6953C71.4938 55.2578 71.2477 54.9206 70.915 54.6836C70.5824 54.4466 70.1517 54.3281 69.623 54.3281C68.8438 54.3281 68.2718 54.5856 67.9072 55.1006C67.5472 55.6156 67.3672 56.3288 67.3672 57.2402ZM78.5781 53.3711C79.4668 53.3711 80.139 53.5898 80.5947 54.0273C81.0505 54.4603 81.2783 55.1576 81.2783 56.1191V61H80.1572V56.1943C80.1572 55.57 80.0137 55.1029 79.7266 54.793C79.444 54.4831 79.0088 54.3281 78.4209 54.3281C77.5915 54.3281 77.0081 54.5628 76.6709 55.0322C76.3337 55.5016 76.165 56.1829 76.165 57.0762V61H75.0303V53.5078H75.9463L76.1172 54.5879H76.1787C76.3382 54.3236 76.541 54.1025 76.7871 53.9248C77.0332 53.7425 77.3089 53.6058 77.6143 53.5146C77.9196 53.4189 78.2409 53.3711 78.5781 53.3711ZM86.0361 60.207C86.223 60.207 86.4144 60.1911 86.6104 60.1592C86.8063 60.1273 86.9658 60.0885 87.0889 60.043V60.9248C86.9567 60.984 86.7721 61.0342 86.5352 61.0752C86.3027 61.1162 86.0749 61.1367 85.8516 61.1367C85.4551 61.1367 85.0951 61.0684 84.7715 60.9316C84.4479 60.7904 84.1882 60.5534 83.9922 60.2207C83.8008 59.888 83.7051 59.4277 83.7051 58.8398V54.3965H82.6387V53.8428L83.7119 53.3984L84.1631 51.7715H84.8467V53.5078H87.041V54.3965H84.8467V58.8057C84.8467 59.2751 84.9538 59.626 85.168 59.8584C85.3867 60.0908 85.6761 60.207 86.0361 60.207ZM95.5791 54.3965H93.7129V61H92.5781V54.3965H91.252V53.8496L92.5781 53.4736V52.9746C92.5781 52.3457 92.6715 51.8353 92.8584 51.4434C93.0452 51.0469 93.3164 50.7552 93.6719 50.5684C94.0273 50.3815 94.4603 50.2881 94.9707 50.2881C95.2578 50.2881 95.5199 50.3132 95.7568 50.3633C95.9984 50.4134 96.2103 50.4704 96.3926 50.5342L96.0986 51.4297C95.9437 51.3796 95.7682 51.334 95.5723 51.293C95.3809 51.2474 95.1849 51.2246 94.9844 51.2246C94.5514 51.2246 94.2301 51.3659 94.0205 51.6484C93.8154 51.9264 93.7129 52.3639 93.7129 52.9609V53.5078H95.5791V54.3965ZM99.7627 53.3848C100.656 53.3848 101.319 53.5853 101.752 53.9863C102.185 54.3874 102.401 55.0277 102.401 55.9072V61H101.574L101.355 59.8926H101.301C101.091 60.166 100.872 60.3962 100.645 60.583C100.417 60.7653 100.152 60.9043 99.8516 61C99.5553 61.0911 99.1908 61.1367 98.7578 61.1367C98.3021 61.1367 97.8965 61.057 97.541 60.8975C97.1901 60.738 96.9121 60.4964 96.707 60.1729C96.5065 59.8493 96.4062 59.4391 96.4062 58.9424C96.4062 58.195 96.7025 57.6208 97.2949 57.2197C97.8874 56.8187 98.7897 56.5999 100.002 56.5635L101.294 56.5088V56.0508C101.294 55.4036 101.155 54.9502 100.877 54.6904C100.599 54.4307 100.207 54.3008 99.7012 54.3008C99.3092 54.3008 98.9355 54.3577 98.5801 54.4717C98.2246 54.5856 97.8874 54.7201 97.5684 54.875L97.2197 54.0137C97.557 53.8405 97.9443 53.6924 98.3818 53.5693C98.8193 53.4463 99.2796 53.3848 99.7627 53.3848ZM101.28 57.3086L100.139 57.3564C99.2044 57.3929 98.5459 57.5456 98.1631 57.8145C97.7803 58.0833 97.5889 58.4639 97.5889 58.9561C97.5889 59.3844 97.7188 59.7012 97.9785 59.9062C98.2383 60.1113 98.5824 60.2139 99.0107 60.2139C99.6761 60.2139 100.221 60.0293 100.645 59.6602C101.068 59.291 101.28 58.7373 101.28 57.999V57.3086ZM112.874 53.3711C113.699 53.3711 114.321 53.5876 114.74 54.0205C115.16 54.4489 115.369 55.1393 115.369 56.0918V61H114.248V56.1465C114.248 55.5404 114.116 55.0869 113.852 54.7861C113.592 54.4808 113.204 54.3281 112.689 54.3281C111.965 54.3281 111.438 54.5378 111.11 54.957C110.782 55.3763 110.618 55.9938 110.618 56.8096V61H109.49V56.1465C109.49 55.7409 109.431 55.4036 109.312 55.1348C109.199 54.8659 109.025 54.6654 108.793 54.5332C108.565 54.3965 108.276 54.3281 107.925 54.3281C107.428 54.3281 107.029 54.4307 106.729 54.6357C106.428 54.8408 106.209 55.1462 106.072 55.5518C105.94 55.9528 105.874 56.4473 105.874 57.0352V61H104.739V53.5078H105.655L105.826 54.5674H105.888C106.038 54.3076 106.227 54.0889 106.455 53.9111C106.683 53.7334 106.938 53.599 107.221 53.5078C107.503 53.4167 107.804 53.3711 108.123 53.3711C108.693 53.3711 109.169 53.4782 109.552 53.6924C109.939 53.902 110.219 54.2233 110.393 54.6562H110.454C110.7 54.2233 111.037 53.902 111.466 53.6924C111.894 53.4782 112.364 53.3711 112.874 53.3711ZM118.835 53.5078V61H117.7V53.5078H118.835ZM118.281 50.7051C118.468 50.7051 118.628 50.7666 118.76 50.8896C118.896 51.0081 118.965 51.195 118.965 51.4502C118.965 51.7008 118.896 51.8877 118.76 52.0107C118.628 52.1338 118.468 52.1953 118.281 52.1953C118.085 52.1953 117.921 52.1338 117.789 52.0107C117.661 51.8877 117.598 51.7008 117.598 51.4502C117.598 51.195 117.661 51.0081 117.789 50.8896C117.921 50.7666 118.085 50.7051 118.281 50.7051ZM122.383 61H121.241V50.3633H122.383V61ZM123.6 53.5078H124.816L126.471 57.8555C126.566 58.1107 126.655 58.3568 126.737 58.5938C126.819 58.8262 126.892 59.0495 126.956 59.2637C127.02 59.4779 127.07 59.6852 127.106 59.8857H127.154C127.218 59.6579 127.309 59.3594 127.428 58.9902C127.546 58.6165 127.674 58.236 127.811 57.8486L129.376 53.5078H130.6L127.339 62.1006C127.166 62.5609 126.963 62.9619 126.73 63.3037C126.503 63.6455 126.225 63.9076 125.896 64.0898C125.568 64.2767 125.172 64.3701 124.707 64.3701C124.493 64.3701 124.304 64.3564 124.14 64.3291C123.976 64.3063 123.834 64.279 123.716 64.2471V63.3379C123.816 63.3607 123.937 63.3812 124.078 63.3994C124.224 63.4176 124.374 63.4268 124.529 63.4268C124.812 63.4268 125.056 63.3721 125.261 63.2627C125.47 63.1579 125.65 63.0029 125.801 62.7979C125.951 62.5928 126.081 62.349 126.19 62.0664L126.601 61.0137L123.6 53.5078Z" fill="black"/></svg>',
            'four'  => '<svg width="155" height="82" viewBox="0 0 155 82" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="155" height="82" fill="white"/><rect x="0.5" y="0.5" width="154" height="81" stroke="black" stroke-opacity="0.1"/><path d="M34.63 37.59C34.43 37.59 34.2067 37.5833 33.96 37.57C33.7133 37.5633 33.48 37.54 33.26 37.5V33.05C33.26 32.77 33.2633 32.52 33.27 32.3C33.2767 32.08 33.28 31.8367 33.28 31.57V29.34C33.28 29.0667 33.2767 28.8233 33.27 28.61C33.2633 28.39 33.26 28.14 33.26 27.86V23.84C33.48 23.8 33.71 23.7767 33.95 23.77C34.1967 23.7567 34.4133 23.75 34.6 23.75C34.78 23.75 34.9967 23.7567 35.25 23.77C35.51 23.7767 35.7433 23.8 35.95 23.84V37.5C35.73 37.54 35.5033 37.5633 35.27 37.57C35.0367 37.5833 34.8233 37.59 34.63 37.59ZM27 37.59C26.8267 37.59 26.61 37.5833 26.35 37.57C26.0967 37.5633 25.8667 37.54 25.66 37.5V23.84C25.8667 23.8 26.0967 23.7767 26.35 23.77C26.61 23.7567 26.8267 23.75 27 23.75C27.1867 23.75 27.4033 23.7567 27.65 23.77C27.8967 23.7767 28.13 23.8 28.35 23.84V27.86C28.35 28.14 28.3467 28.39 28.34 28.61C28.3333 28.8233 28.33 29.0667 28.33 29.34V31.57C28.33 31.8367 28.3333 32.08 28.34 32.3C28.3467 32.52 28.35 32.77 28.35 33.05V37.5C28.13 37.54 27.8967 37.5633 27.65 37.57C27.4033 37.5833 27.1867 37.59 27 37.59ZM26.72 31.59V29.32C26.9867 29.32 27.2567 29.3233 27.53 29.33C27.8033 29.3367 28.07 29.34 28.33 29.34C28.4167 29.34 28.5267 29.34 28.66 29.34C28.7933 29.3333 28.93 29.33 29.07 29.33C29.21 29.3233 29.32 29.32 29.4 29.32H32.22C32.3 29.32 32.4067 29.3233 32.54 29.33C32.68 29.33 32.82 29.3333 32.96 29.34C33.1 29.34 33.2067 29.34 33.28 29.34C33.5467 29.34 33.8133 29.3367 34.08 29.33C34.3533 29.3233 34.6233 29.32 34.89 29.32V31.59C34.6233 31.59 34.3533 31.5867 34.08 31.58C33.8133 31.5733 33.5467 31.57 33.28 31.57C33.2067 31.57 33.1 31.5733 32.96 31.58C32.82 31.58 32.68 31.5833 32.54 31.59C32.4067 31.59 32.3 31.59 32.22 31.59H29.4C29.32 31.59 29.21 31.59 29.07 31.59C28.93 31.5833 28.7933 31.58 28.66 31.58C28.5267 31.5733 28.4167 31.57 28.33 31.57C28.07 31.57 27.8033 31.5733 27.53 31.58C27.2567 31.5867 26.9867 31.59 26.72 31.59ZM40.0033 33.37V31.54H44.3033V31.29C44.3033 30.91 44.2499 30.56 44.1433 30.24C44.0366 29.92 43.8633 29.6633 43.6233 29.47C43.3833 29.2767 43.0633 29.18 42.6633 29.18C42.0833 29.18 41.6599 29.4233 41.3933 29.91C41.1333 30.39 41.0033 31.0867 41.0033 32V32.79C41.0033 33.33 41.0533 33.8233 41.1533 34.27C41.2599 34.7167 41.4599 35.0733 41.7533 35.34C42.0533 35.6 42.4866 35.73 43.0533 35.73C43.5333 35.73 43.9966 35.6667 44.4433 35.54C44.8966 35.4067 45.3299 35.2433 45.7433 35.05C45.9433 35.25 46.1066 35.5 46.2333 35.8C46.3666 36.1 46.4499 36.3833 46.4833 36.65C45.9966 37.0033 45.4099 37.28 44.7233 37.48C44.0433 37.6733 43.3499 37.77 42.6433 37.77C41.8033 37.77 41.1066 37.63 40.5533 37.35C39.9999 37.0633 39.5599 36.6767 39.2333 36.19C38.9133 35.6967 38.6866 35.14 38.5533 34.52C38.4199 33.8933 38.3533 33.2467 38.3533 32.58C38.3533 31.58 38.5066 30.6833 38.8133 29.89C39.1199 29.09 39.5933 28.4567 40.2333 27.99C40.8733 27.5233 41.6899 27.29 42.6833 27.29C43.5566 27.29 44.2933 27.48 44.8933 27.86C45.4999 28.2333 45.9599 28.74 46.2733 29.38C46.5933 30.02 46.7533 30.74 46.7533 31.54C46.7533 31.9267 46.7366 32.2533 46.7033 32.52C46.6699 32.78 46.6166 33.0633 46.5433 33.37H40.0033ZM48.3042 34.79C48.3042 34.0033 48.4809 33.36 48.8342 32.86C49.1942 32.36 49.6676 31.99 50.2542 31.75C50.8476 31.51 51.4976 31.39 52.2042 31.39C52.5376 31.39 52.9342 31.4033 53.3942 31.43C53.8609 31.45 54.2876 31.5033 54.6742 31.59V33.28C54.3542 33.2067 53.9809 33.1633 53.5542 33.15C53.1342 33.13 52.7609 33.12 52.4342 33.12C51.9076 33.12 51.5142 33.2567 51.2542 33.53C50.9942 33.7967 50.8642 34.1567 50.8642 34.61C50.8642 34.95 50.9609 35.2333 51.1542 35.46C51.3542 35.6867 51.6342 35.8 51.9942 35.8C52.4342 35.8 52.8909 35.6433 53.3642 35.33C53.8442 35.0167 54.2476 34.5733 54.5742 34L54.9542 35.78C54.7009 36.0733 54.4042 36.3767 54.0642 36.69C53.7242 36.9967 53.3242 37.2533 52.8642 37.46C52.4109 37.6667 51.8876 37.77 51.2942 37.77C50.6209 37.77 50.0609 37.6233 49.6142 37.33C49.1742 37.03 48.8442 36.6533 48.6242 36.2C48.4109 35.74 48.3042 35.27 48.3042 34.79ZM57.0242 36.31C56.9709 36.5433 56.8576 36.7933 56.6842 37.06C56.5176 37.3267 56.3442 37.5233 56.1642 37.65C55.6576 37.6033 55.2409 37.46 54.9142 37.22C54.5942 36.98 54.3509 36.69 54.1842 36.35C54.0176 36.0033 53.9109 35.6533 53.8642 35.3V30.91C53.8642 30.39 53.7409 30.01 53.4942 29.77C53.2476 29.5233 52.8842 29.4 52.4042 29.4C51.9376 29.4 51.4442 29.4733 50.9242 29.62C50.4042 29.76 49.8809 29.92 49.3542 30.1C49.1609 29.8867 49.0042 29.6067 48.8842 29.26C48.7709 28.9133 48.7009 28.5733 48.6742 28.24C49.0942 28.0667 49.5576 27.9133 50.0642 27.78C50.5776 27.6467 51.0942 27.5433 51.6142 27.47C52.1342 27.39 52.6142 27.35 53.0542 27.35C53.6742 27.35 54.2409 27.4633 54.7542 27.69C55.2676 27.9167 55.6809 28.28 55.9942 28.78C56.3076 29.2733 56.4642 29.9233 56.4642 30.73V34.81C56.4642 35.1433 56.5042 35.4367 56.5842 35.69C56.6709 35.9367 56.8176 36.1433 57.0242 36.31ZM66.9714 34.65C66.9714 35.0033 67.0147 35.33 67.1014 35.63C67.1947 35.9233 67.3381 36.15 67.5314 36.31C67.4781 36.5433 67.3647 36.7933 67.1914 37.06C67.0247 37.3267 66.8514 37.5233 66.6714 37.65C65.8981 37.5833 65.3281 37.28 64.9614 36.74C64.6014 36.2 64.4214 35.56 64.4214 34.82V22.92L64.5514 22.79H65.5614C66.0881 22.79 66.4547 22.9133 66.6614 23.16C66.8681 23.4 66.9714 23.8133 66.9714 24.4V34.65ZM58.4514 32.65C58.4514 31.4833 58.6347 30.51 59.0014 29.73C59.3681 28.95 59.8481 28.3667 60.4414 27.98C61.0414 27.5867 61.6847 27.39 62.3714 27.39C63.0381 27.39 63.6381 27.5267 64.1714 27.8C64.7047 28.0733 65.2014 28.36 65.6614 28.66L65.2914 30.6C64.9047 30.2933 64.4914 30.0133 64.0514 29.76C63.6181 29.5067 63.1981 29.38 62.7914 29.38C62.4447 29.38 62.1481 29.5067 61.9014 29.76C61.6547 30.0067 61.4614 30.3767 61.3214 30.87C61.1881 31.3567 61.1214 31.9567 61.1214 32.67C61.1214 33.37 61.1881 33.94 61.3214 34.38C61.4547 34.82 61.6347 35.1433 61.8614 35.35C62.0947 35.55 62.3447 35.65 62.6114 35.65C62.8847 35.65 63.1814 35.5733 63.5014 35.42C63.8281 35.2667 64.1381 35.0033 64.4314 34.63C64.7247 34.2567 64.9547 33.7467 65.1214 33.1L65.7014 34.75C65.6081 35.25 65.3847 35.73 65.0314 36.19C64.6847 36.65 64.2481 37.03 63.7214 37.33C63.1947 37.6233 62.6081 37.77 61.9614 37.77C61.1814 37.77 60.5281 37.5533 60.0014 37.12C59.4814 36.6867 59.0914 36.0867 58.8314 35.32C58.5781 34.5467 58.4514 33.6567 58.4514 32.65ZM72.6959 37.5C72.5159 37.5333 72.3093 37.5567 72.0759 37.57C71.8493 37.5833 71.6226 37.59 71.3959 37.59C71.1693 37.59 70.9393 37.5833 70.7059 37.57C70.4793 37.5567 70.2693 37.5333 70.0759 37.5V30.54C70.0759 30.1933 70.0093 29.9233 69.8759 29.73C69.7493 29.5367 69.5159 29.44 69.1759 29.44H68.9059C68.8326 29.1467 68.7959 28.8467 68.7959 28.54C68.7959 28.3867 68.8059 28.23 68.8259 28.07C68.8459 27.91 68.8726 27.75 68.9059 27.59C69.1926 27.5567 69.4726 27.5333 69.7459 27.52C70.0193 27.5067 70.2493 27.5 70.4359 27.5H70.7859C71.3793 27.5 71.8459 27.6867 72.1859 28.06C72.5259 28.4333 72.6959 28.9433 72.6959 29.59V37.5ZM69.4759 24.83C69.4759 24.6633 69.4926 24.49 69.5259 24.31C69.5659 24.1233 69.6193 23.95 69.6859 23.79C69.8326 23.71 70.0259 23.6467 70.2659 23.6C70.5126 23.5467 70.7526 23.52 70.9859 23.52C71.2193 23.52 71.4626 23.5467 71.7159 23.6C71.9693 23.6467 72.1593 23.71 72.2859 23.79C72.3526 23.95 72.4026 24.1233 72.4359 24.31C72.4759 24.4967 72.4959 24.67 72.4959 24.83C72.4959 24.99 72.4759 25.1633 72.4359 25.35C72.4026 25.5367 72.3526 25.7067 72.2859 25.86C72.1593 25.94 71.9693 26.0067 71.7159 26.06C71.4626 26.1133 71.2193 26.14 70.9859 26.14C70.7526 26.14 70.5093 26.1167 70.2559 26.07C70.0093 26.0167 69.8193 25.9467 69.6859 25.86C69.6193 25.7067 69.5659 25.5367 69.5259 25.35C69.4926 25.1633 69.4759 24.99 69.4759 24.83ZM76.5291 27.46C77.0424 27.46 77.4191 27.63 77.6591 27.97C77.8991 28.3033 78.0191 28.76 78.0191 29.34V37.5C77.8391 37.5333 77.6324 37.5567 77.3991 37.57C77.1724 37.5833 76.9457 37.59 76.7191 37.59C76.4991 37.59 76.2724 37.5833 76.0391 37.57C75.8124 37.5567 75.6024 37.5333 75.4091 37.5V27.59L75.5391 27.46H76.5291ZM83.6591 35.19C83.6591 35.5567 83.6891 35.9033 83.7491 36.23C83.8091 36.5567 83.9191 36.8433 84.0791 37.09C83.8857 37.2433 83.6457 37.3767 83.3591 37.49C83.0724 37.5967 82.7657 37.65 82.4391 37.65C81.9191 37.65 81.5557 37.51 81.3491 37.23C81.1491 36.95 81.0491 36.5467 81.0491 36.02V31.35C81.0491 30.7967 80.9757 30.39 80.8291 30.13C80.6891 29.87 80.4157 29.74 80.0091 29.74C79.7357 29.74 79.4357 29.81 79.1091 29.95C78.7824 30.0833 78.4657 30.2867 78.1591 30.56C77.8524 30.8267 77.5924 31.1667 77.3791 31.58V29.2C77.8391 28.72 78.3657 28.3 78.9591 27.94C79.5591 27.5733 80.2157 27.39 80.9291 27.39C81.5491 27.39 82.0591 27.54 82.4591 27.84C82.8591 28.1333 83.1591 28.54 83.3591 29.06C83.5591 29.5733 83.6591 30.16 83.6591 30.82V35.19ZM94.8366 28.76C94.6432 28.9133 94.4999 29.1433 94.4066 29.45C94.3199 29.75 94.2766 30.0767 94.2766 30.43V36.01C94.2766 36.8633 94.2366 37.5733 94.1566 38.14C94.0832 38.7133 93.9732 39.1867 93.8266 39.56C93.6799 39.9333 93.4999 40.2533 93.2866 40.52C92.9266 40.9733 92.4399 41.3167 91.8266 41.55C91.2199 41.79 90.5266 41.91 89.7466 41.91C89.1266 41.91 88.4899 41.8467 87.8366 41.72C87.1899 41.5933 86.6232 41.4367 86.1366 41.25C86.1366 40.9367 86.1966 40.59 86.3166 40.21C86.4432 39.8367 86.6032 39.5433 86.7966 39.33C87.2232 39.5233 87.6766 39.6733 88.1566 39.78C88.6366 39.8867 89.0866 39.94 89.5066 39.94C90.0866 39.94 90.5366 39.8367 90.8566 39.63C91.1832 39.4233 91.4099 39.1367 91.5366 38.77C91.6699 38.41 91.7366 38.0033 91.7366 37.55V30.24C91.7366 29.5 91.9166 28.8633 92.2766 28.33C92.6366 27.79 93.2032 27.4867 93.9766 27.42C94.1566 27.54 94.3332 27.7367 94.5066 28.01C94.6866 28.2767 94.7966 28.5267 94.8366 28.76ZM85.7366 32.55C85.7366 31.39 85.9199 30.42 86.2866 29.64C86.6599 28.86 87.1432 28.2733 87.7366 27.88C88.3366 27.4867 88.9766 27.29 89.6566 27.29C90.2766 27.29 90.8066 27.39 91.2466 27.59C91.6866 27.7833 92.0566 28.0233 92.3566 28.31C92.6632 28.5967 92.9132 28.8833 93.1066 29.17L92.7166 31.34C92.3499 30.7 91.9266 30.2 91.4466 29.84C90.9732 29.4733 90.5232 29.29 90.0966 29.29C89.7432 29.29 89.4399 29.4167 89.1866 29.67C88.9332 29.9167 88.7399 30.2833 88.6066 30.77C88.4732 31.2567 88.4066 31.8567 88.4066 32.57C88.4066 33.6233 88.5466 34.3867 88.8266 34.86C89.1132 35.3267 89.4632 35.56 89.8766 35.56C90.3432 35.56 90.7932 35.4067 91.2266 35.1C91.6599 34.7867 92.0132 34.36 92.2866 33.82L92.6566 35.71C92.4566 36.05 92.1866 36.37 91.8466 36.67C91.5066 36.97 91.1166 37.2167 90.6766 37.41C90.2366 37.5967 89.7699 37.69 89.2766 37.69C88.4832 37.69 87.8232 37.4733 87.2966 37.04C86.7766 36.6067 86.3866 36.0033 86.1266 35.23C85.8666 34.4567 85.7366 33.5633 85.7366 32.55Z" fill="black"/><path d="M31.098 50.94C31.098 51.1733 31.0607 51.4113 30.986 51.654C30.9113 51.8967 30.7993 52.1253 30.65 52.34C30.5007 52.5453 30.3093 52.7273 30.076 52.886C29.8427 53.0447 29.5673 53.166 29.25 53.25V53.306C29.53 53.3527 29.796 53.432 30.048 53.544C30.3093 53.656 30.538 53.81 30.734 54.006C30.93 54.202 31.0887 54.44 31.21 54.72C31.3313 55 31.392 55.3313 31.392 55.714C31.392 56.218 31.2847 56.6567 31.07 57.03C30.8647 57.394 30.5893 57.6927 30.244 57.926C29.908 58.1593 29.5207 58.332 29.082 58.444C28.6433 58.556 28.1953 58.612 27.738 58.612C27.5793 58.612 27.3927 58.612 27.178 58.612C26.9633 58.612 26.7393 58.6027 26.506 58.584C26.2727 58.5747 26.0393 58.556 25.806 58.528C25.5727 58.5093 25.3673 58.4767 25.19 58.43V48.784C25.5353 48.728 25.9367 48.6813 26.394 48.644C26.8513 48.6067 27.3507 48.588 27.892 48.588C28.256 48.588 28.6247 48.6207 28.998 48.686C29.3807 48.742 29.726 48.8587 30.034 49.036C30.342 49.204 30.594 49.442 30.79 49.75C30.9953 50.058 31.098 50.4547 31.098 50.94ZM27.85 57.604C28.1487 57.604 28.438 57.5713 28.718 57.506C28.998 57.4313 29.2453 57.3193 29.46 57.17C29.6747 57.0113 29.8427 56.82 29.964 56.596C30.0947 56.372 30.16 56.106 30.16 55.798C30.16 55.4153 30.0807 55.1073 29.922 54.874C29.7727 54.6407 29.572 54.4587 29.32 54.328C29.0773 54.1973 28.802 54.1087 28.494 54.062C28.186 54.0153 27.878 53.992 27.57 53.992H26.352V57.506C26.4173 57.5247 26.5107 57.5387 26.632 57.548C26.7533 57.5573 26.884 57.5667 27.024 57.576C27.164 57.5853 27.3087 57.5947 27.458 57.604C27.6073 57.604 27.738 57.604 27.85 57.604ZM27.08 53.012C27.2387 53.012 27.43 53.0073 27.654 52.998C27.878 52.9887 28.0647 52.9747 28.214 52.956C28.438 52.8813 28.648 52.7927 28.844 52.69C29.04 52.578 29.2127 52.452 29.362 52.312C29.5207 52.1627 29.642 51.9947 29.726 51.808C29.8193 51.612 29.866 51.402 29.866 51.178C29.866 50.87 29.8053 50.618 29.684 50.422C29.572 50.2167 29.418 50.0533 29.222 49.932C29.026 49.8107 28.802 49.7267 28.55 49.68C28.298 49.624 28.0413 49.596 27.78 49.596C27.472 49.596 27.1873 49.6053 26.926 49.624C26.674 49.6333 26.4827 49.652 26.352 49.68V53.012H27.08ZM32.8618 55C32.8618 53.8147 33.1231 52.9093 33.6458 52.284C34.1778 51.6493 34.9384 51.332 35.9278 51.332C36.4504 51.332 36.9031 51.4207 37.2858 51.598C37.6778 51.766 37.9998 52.0133 38.2518 52.34C38.5038 52.6573 38.6904 53.0447 38.8118 53.502C38.9331 53.95 38.9938 54.4493 38.9938 55C38.9938 56.1853 38.7278 57.0953 38.1958 57.73C37.6731 58.3553 36.9171 58.668 35.9278 58.668C35.4051 58.668 34.9478 58.584 34.5558 58.416C34.1731 58.2387 33.8558 57.9913 33.6038 57.674C33.3518 57.3473 33.1651 56.96 33.0438 56.512C32.9224 56.0547 32.8618 55.5507 32.8618 55ZM34.0238 55C34.0238 55.3547 34.0564 55.6953 34.1218 56.022C34.1964 56.3487 34.3084 56.6333 34.4578 56.876C34.6071 57.1187 34.8031 57.3147 35.0458 57.464C35.2884 57.6133 35.5824 57.688 35.9278 57.688C37.1971 57.6973 37.8318 56.8013 37.8318 55C37.8318 54.636 37.7944 54.2907 37.7198 53.964C37.6544 53.6373 37.5471 53.3527 37.3978 53.11C37.2484 52.8673 37.0524 52.676 36.8098 52.536C36.5671 52.3867 36.2731 52.312 35.9278 52.312C34.6584 52.3027 34.0238 53.1987 34.0238 55ZM46.1356 56.092C46.1356 56.568 46.1403 57.002 46.1496 57.394C46.159 57.7767 46.201 58.1547 46.2756 58.528H45.5196L45.2396 57.534H45.1836C44.997 57.8607 44.7263 58.1313 44.3716 58.346C44.017 58.5607 43.6016 58.668 43.1256 58.668C42.1923 58.668 41.497 58.374 41.0396 57.786C40.5916 57.198 40.3676 56.2787 40.3676 55.028C40.3676 53.8333 40.6476 52.928 41.2076 52.312C41.777 51.6867 42.5563 51.374 43.5456 51.374C43.891 51.374 44.1616 51.3927 44.3576 51.43C44.563 51.4673 44.7823 51.528 45.0156 51.612V48.7H46.1356V56.092ZM43.3076 57.688C43.7836 57.688 44.1616 57.5667 44.4416 57.324C44.7216 57.072 44.913 56.694 45.0156 56.19V52.718C44.8476 52.5873 44.6563 52.494 44.4416 52.438C44.227 52.382 43.9423 52.354 43.5876 52.354C42.9436 52.354 42.4396 52.5687 42.0756 52.998C41.7116 53.418 41.5296 54.0947 41.5296 55.028C41.5296 55.4107 41.5576 55.7653 41.6136 56.092C41.679 56.4187 41.7816 56.6987 41.9216 56.932C42.0616 57.1653 42.2436 57.352 42.4676 57.492C42.701 57.6227 42.981 57.688 43.3076 57.688ZM50.3508 56.036L50.7428 57.38H50.8128L51.1208 56.022L52.4788 51.5H53.6128L51.5408 57.786C51.3822 58.2433 51.2235 58.6867 51.0648 59.116C50.9155 59.5453 50.7475 59.928 50.5608 60.264C50.3742 60.6 50.1642 60.866 49.9308 61.062C49.6975 61.2673 49.4268 61.37 49.1188 61.37C48.7828 61.37 48.5075 61.3233 48.2928 61.23L48.4888 60.264C48.6102 60.3107 48.7268 60.334 48.8388 60.334C49.1002 60.334 49.3522 60.194 49.5948 59.914C49.8375 59.6433 50.0382 59.172 50.1968 58.5L47.3828 51.5H48.6708L50.3508 56.036ZM57.2709 51.5H58.3629V51.108C58.3629 50.6787 58.3956 50.3053 58.4609 49.988C58.5356 49.6707 58.6522 49.414 58.8109 49.218C58.9696 49.0127 59.1749 48.8633 59.4269 48.77C59.6789 48.6673 59.9916 48.616 60.3649 48.616C60.6636 48.616 60.9249 48.6347 61.1489 48.672C61.3822 48.7093 61.6249 48.7793 61.8769 48.882L61.6249 49.82C61.4102 49.7267 61.2049 49.666 61.0089 49.638C60.8222 49.61 60.6449 49.596 60.4769 49.596C60.2342 49.596 60.0429 49.6333 59.9029 49.708C59.7722 49.7827 59.6742 49.8947 59.6089 50.044C59.5529 50.184 59.5156 50.3613 59.4969 50.576C59.4876 50.7813 59.4829 51.024 59.4829 51.304V51.5H61.3449V52.48H59.4829V58.5H58.3629V52.48H57.2709V51.5ZM61.9692 55C61.9692 53.8147 62.2305 52.9093 62.7532 52.284C63.2852 51.6493 64.0459 51.332 65.0352 51.332C65.5579 51.332 66.0105 51.4207 66.3932 51.598C66.7852 51.766 67.1072 52.0133 67.3592 52.34C67.6112 52.6573 67.7979 53.0447 67.9192 53.502C68.0405 53.95 68.1012 54.4493 68.1012 55C68.1012 56.1853 67.8352 57.0953 67.3032 57.73C66.7805 58.3553 66.0245 58.668 65.0352 58.668C64.5125 58.668 64.0552 58.584 63.6632 58.416C63.2805 58.2387 62.9632 57.9913 62.7112 57.674C62.4592 57.3473 62.2725 56.96 62.1512 56.512C62.0299 56.0547 61.9692 55.5507 61.9692 55ZM63.1312 55C63.1312 55.3547 63.1639 55.6953 63.2292 56.022C63.3039 56.3487 63.4159 56.6333 63.5652 56.876C63.7145 57.1187 63.9105 57.3147 64.1532 57.464C64.3959 57.6133 64.6899 57.688 65.0352 57.688C66.3045 57.6973 66.9392 56.8013 66.9392 55C66.9392 54.636 66.9019 54.2907 66.8272 53.964C66.7619 53.6373 66.6545 53.3527 66.5052 53.11C66.3559 52.8673 66.1599 52.676 65.9172 52.536C65.6745 52.3867 65.3805 52.312 65.0352 52.312C63.7659 52.3027 63.1312 53.1987 63.1312 55ZM74.3611 58.5V54.51C74.3611 53.782 74.2537 53.236 74.0391 52.872C73.8337 52.4987 73.4511 52.312 72.8911 52.312C72.3964 52.312 71.9857 52.4473 71.6591 52.718C71.3417 52.9793 71.1177 53.3107 70.9871 53.712V58.5H69.8671V51.5H70.6511L70.8611 52.354H70.9171C71.1411 52.0553 71.4397 51.8127 71.8131 51.626C72.1957 51.43 72.6484 51.332 73.1711 51.332C73.5537 51.332 73.8897 51.3787 74.1791 51.472C74.4684 51.556 74.7064 51.71 74.8931 51.934C75.0891 52.158 75.2337 52.4613 75.3271 52.844C75.4297 53.2173 75.4811 53.6933 75.4811 54.272V58.5H74.3611ZM76.5993 51.5H77.6913V50.114L78.8113 49.792V51.5H80.7153V52.48H78.8113V56.358C78.8113 56.8433 78.872 57.1887 78.9933 57.394C79.1146 57.59 79.32 57.688 79.6093 57.688C79.852 57.688 80.0573 57.6647 80.2253 57.618C80.3933 57.562 80.58 57.492 80.7853 57.408L81.0373 58.262C80.7853 58.3833 80.51 58.4813 80.2113 58.556C79.9126 58.6307 79.5906 58.668 79.2453 58.668C78.676 58.668 78.2746 58.5093 78.0413 58.192C77.808 57.8653 77.6913 57.324 77.6913 56.568V52.48H76.5993V51.5ZM85.2299 51.5H86.3219V51.108C86.3219 50.6787 86.3545 50.3053 86.4199 49.988C86.4945 49.6707 86.6112 49.414 86.7699 49.218C86.9285 49.0127 87.1339 48.8633 87.3859 48.77C87.6379 48.6673 87.9505 48.616 88.3239 48.616C88.6225 48.616 88.8839 48.6347 89.1079 48.672C89.3412 48.7093 89.5839 48.7793 89.8359 48.882L89.5839 49.82C89.3692 49.7267 89.1639 49.666 88.9679 49.638C88.7812 49.61 88.6039 49.596 88.4359 49.596C88.1932 49.596 88.0019 49.6333 87.8619 49.708C87.7312 49.7827 87.6332 49.8947 87.5679 50.044C87.5119 50.184 87.4745 50.3613 87.4559 50.576C87.4465 50.7813 87.4419 51.024 87.4419 51.304V51.5H89.3039V52.48H87.4419V58.5H86.3219V52.48H85.2299V51.5ZM90.3586 52.018C90.7132 51.8033 91.1239 51.6447 91.5906 51.542C92.0666 51.4393 92.5612 51.388 93.0746 51.388C93.5599 51.388 93.9472 51.4533 94.2366 51.584C94.5352 51.7147 94.7592 51.8873 94.9086 52.102C95.0672 52.3073 95.1699 52.536 95.2166 52.788C95.2726 53.04 95.3006 53.292 95.3006 53.544C95.3006 54.104 95.2866 54.65 95.2586 55.182C95.2306 55.714 95.2166 56.218 95.2166 56.694C95.2166 57.0393 95.2306 57.366 95.2586 57.674C95.2866 57.982 95.3379 58.2667 95.4126 58.528H94.5866L94.2926 57.548H94.2226C94.1386 57.6787 94.0312 57.8093 93.9006 57.94C93.7792 58.0613 93.6299 58.1733 93.4526 58.276C93.2752 58.3693 93.0699 58.4487 92.8366 58.514C92.6032 58.5793 92.3372 58.612 92.0386 58.612C91.7399 58.612 91.4599 58.5653 91.1986 58.472C90.9466 58.3787 90.7272 58.248 90.5406 58.08C90.3539 57.9027 90.2046 57.6927 90.0926 57.45C89.9899 57.2073 89.9386 56.932 89.9386 56.624C89.9386 56.2133 90.0226 55.8727 90.1906 55.602C90.3586 55.322 90.5919 55.1027 90.8906 54.944C91.1986 54.776 91.5626 54.6593 91.9826 54.594C92.4119 54.5193 92.8832 54.482 93.3966 54.482C93.5272 54.482 93.6532 54.482 93.7746 54.482C93.9052 54.482 94.0359 54.4913 94.1666 54.51C94.1946 54.23 94.2086 53.978 94.2086 53.754C94.2086 53.2407 94.1059 52.8813 93.9006 52.676C93.6952 52.4707 93.3219 52.368 92.7806 52.368C92.6219 52.368 92.4492 52.382 92.2626 52.41C92.0852 52.4287 91.8986 52.4613 91.7026 52.508C91.5159 52.5453 91.3339 52.5967 91.1566 52.662C90.9886 52.718 90.8392 52.7833 90.7086 52.858L90.3586 52.018ZM92.3466 57.632C92.6079 57.632 92.8412 57.5993 93.0466 57.534C93.2519 57.4593 93.4292 57.3707 93.5786 57.268C93.7279 57.156 93.8492 57.0347 93.9426 56.904C94.0452 56.7733 94.1199 56.6473 94.1666 56.526V55.364C94.0359 55.3547 93.9006 55.35 93.7606 55.35C93.6299 55.3407 93.4992 55.336 93.3686 55.336C93.0792 55.336 92.7946 55.3547 92.5146 55.392C92.2439 55.42 92.0012 55.4807 91.7866 55.574C91.5812 55.658 91.4132 55.7793 91.2826 55.938C91.1612 56.0873 91.1006 56.2787 91.1006 56.512C91.1006 56.8387 91.2172 57.1093 91.4506 57.324C91.6839 57.5293 91.9826 57.632 92.3466 57.632ZM101.518 58.5V54.538C101.518 54.1647 101.499 53.8427 101.462 53.572C101.434 53.292 101.373 53.0587 101.28 52.872C101.187 52.6853 101.051 52.5453 100.874 52.452C100.706 52.3587 100.482 52.312 100.202 52.312C99.7726 52.312 99.4132 52.4427 99.1239 52.704C98.8439 52.9653 98.6479 53.292 98.5359 53.684V58.5H97.4159V51.5H98.1999L98.4099 52.354H98.4659C98.7179 52.0553 99.0072 51.8127 99.3339 51.626C99.6699 51.43 100.104 51.332 100.636 51.332C101.084 51.332 101.448 51.4207 101.728 51.598C102.017 51.766 102.241 52.0647 102.4 52.494C102.615 52.13 102.909 51.8453 103.282 51.64C103.665 51.4347 104.094 51.332 104.57 51.332C104.962 51.332 105.293 51.3787 105.564 51.472C105.835 51.556 106.059 51.71 106.236 51.934C106.413 52.158 106.539 52.4613 106.614 52.844C106.698 53.2267 106.74 53.712 106.74 54.3V58.5H105.62V54.286C105.62 53.95 105.601 53.6607 105.564 53.418C105.536 53.166 105.471 52.9607 105.368 52.802C105.275 52.634 105.139 52.5127 104.962 52.438C104.794 52.354 104.57 52.312 104.29 52.312C103.823 52.312 103.459 52.4427 103.198 52.704C102.937 52.9653 102.75 53.3387 102.638 53.824V58.5H101.518ZM109.015 51.5H110.135V58.5H109.015V51.5ZM108.777 49.372C108.777 49.1573 108.847 48.9753 108.987 48.826C109.137 48.6673 109.323 48.588 109.547 48.588C109.771 48.588 109.963 48.6673 110.121 48.826C110.28 48.9753 110.359 49.1573 110.359 49.372C110.359 49.5867 110.28 49.764 110.121 49.904C109.963 50.044 109.771 50.114 109.547 50.114C109.323 50.114 109.137 50.044 108.987 49.904C108.847 49.764 108.777 49.5867 108.777 49.372ZM113.769 56.778C113.769 57.1047 113.825 57.338 113.937 57.478C114.049 57.618 114.208 57.688 114.413 57.688C114.535 57.688 114.665 57.6787 114.805 57.66C114.945 57.6413 115.104 57.5993 115.281 57.534L115.407 58.416C115.258 58.4907 115.048 58.5513 114.777 58.598C114.516 58.6447 114.287 58.668 114.091 58.668C113.671 58.668 113.326 58.5513 113.055 58.318C112.785 58.0753 112.649 57.6693 112.649 57.1V48.7H113.769V56.778ZM118.669 56.036L119.061 57.38H119.131L119.439 56.022L120.797 51.5H121.931L119.859 57.786C119.701 58.2433 119.542 58.6867 119.383 59.116C119.234 59.5453 119.066 59.928 118.879 60.264C118.693 60.6 118.483 60.866 118.249 61.062C118.016 61.2673 117.745 61.37 117.437 61.37C117.101 61.37 116.826 61.3233 116.611 61.23L116.807 60.264C116.929 60.3107 117.045 60.334 117.157 60.334C117.419 60.334 117.671 60.194 117.913 59.914C118.156 59.6433 118.357 59.172 118.515 58.5L115.701 51.5H116.989L118.669 56.036Z" fill="black"/></svg>',
            'five'  => '<svg width="155" height="82" viewBox="0 0 155 82" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="155" height="82" fill="white"/><rect x="0.5" y="0.5" width="154" height="81" stroke="black" stroke-opacity="0.1"/><path d="M23.98 36.5V36.1L26.04 35.42L25.82 35.74V23.26L26.04 23.58L23.98 22.9V22.5H30.3V22.88L28.2 23.6L28.42 23.28V29.2L28.2 28.96H35.7L35.48 29.2V23.26L35.7 23.58L33.64 22.9V22.5H39.96V22.88L37.86 23.6L38.08 23.28V35.74L37.86 35.42L39.96 36.12V36.5H33.64V36.1L35.7 35.42L35.48 35.74V29.6L35.7 29.84H28.2L28.42 29.6V35.74L28.2 35.42L30.3 36.12V36.5H23.98ZM45.2831 36.8C44.3765 36.8 43.5631 36.58 42.8431 36.14C42.1231 35.7 41.5498 35.0933 41.1231 34.32C40.7098 33.5467 40.5031 32.6667 40.5031 31.68C40.5031 30.6 40.7098 29.6467 41.1231 28.82C41.5365 27.9933 42.1098 27.3467 42.8431 26.88C43.5898 26.4133 44.4565 26.18 45.4431 26.18C46.2431 26.18 46.9498 26.3533 47.5631 26.7C48.1898 27.0333 48.6831 27.52 49.0431 28.16C49.4165 28.8 49.6031 29.58 49.6031 30.5C49.6031 30.5933 49.6031 30.7 49.6031 30.82C49.6031 30.9267 49.5965 31.0333 49.5831 31.14H42.7831L43.1031 30.88C43.0898 31.8133 43.1965 32.64 43.4231 33.36C43.6631 34.08 43.9965 34.6467 44.4231 35.06C44.8498 35.4733 45.3365 35.68 45.8831 35.68C46.3631 35.68 46.8898 35.5533 47.4631 35.3C48.0365 35.0467 48.5298 34.72 48.9431 34.32L49.4431 34.92C49.1631 35.28 48.7965 35.6067 48.3431 35.9C47.8898 36.18 47.3965 36.4 46.8631 36.56C46.3431 36.72 45.8165 36.8 45.2831 36.8ZM43.0631 30.64L42.7631 30.34L47.2031 30.24L46.9831 30.56C46.9698 29.7733 46.8565 29.1267 46.6431 28.62C46.4298 28.1 46.1631 27.7133 45.8431 27.46C45.5231 27.1933 45.1765 27.06 44.8031 27.06C44.4831 27.06 44.1898 27.1933 43.9231 27.46C43.6565 27.7133 43.4431 28.1067 43.2831 28.64C43.1365 29.1733 43.0631 29.84 43.0631 30.64ZM54.2463 36.82C53.5263 36.82 52.9396 36.6667 52.4863 36.36C52.0463 36.04 51.7196 35.6333 51.5063 35.14C51.3063 34.6333 51.2063 34.1067 51.2063 33.56C51.2063 33.12 51.3596 32.7333 51.6663 32.4C51.9729 32.0667 52.3929 31.78 52.9263 31.54C53.4729 31.3 54.0929 31.1133 54.7863 30.98C55.4929 30.8467 56.2329 30.7667 57.0063 30.74L56.8063 30.98V29.08C56.8063 28.4533 56.6729 27.9467 56.4063 27.56C56.1396 27.1733 55.8263 26.98 55.4663 26.98C55.1329 26.98 54.8263 27.06 54.5463 27.22C54.2796 27.3667 54.0596 27.58 53.8863 27.86C53.7263 28.1267 53.6329 28.4267 53.6063 28.76C53.6196 28.9067 53.6196 29.0333 53.6063 29.14C53.6063 29.2467 53.6063 29.34 53.6063 29.42L51.4863 29.92C51.4729 29.8 51.4663 29.6667 51.4663 29.52C51.4663 29.3733 51.4663 29.2267 51.4663 29.08C51.4663 28.5067 51.6463 28.0067 52.0063 27.58C52.3663 27.14 52.8729 26.8 53.5263 26.56C54.1796 26.3067 54.9463 26.18 55.8263 26.18C56.4929 26.18 57.0796 26.2867 57.5863 26.5C58.0929 26.7133 58.4863 27.0067 58.7663 27.38C59.0463 27.7533 59.1863 28.1867 59.1863 28.68V35.62L58.9663 35.36L60.9063 35.64V36.12L57.0063 36.82L56.7863 36.64V35.26L56.9263 35.38C56.5396 35.7667 56.1129 36.1067 55.6463 36.4C55.1929 36.68 54.7263 36.82 54.2463 36.82ZM55.1663 35.54C55.4463 35.54 55.7329 35.4333 56.0263 35.22C56.3196 34.9933 56.6263 34.7 56.9463 34.34L56.8063 34.72V31.32L57.0663 31.62C55.9729 31.6333 55.1263 31.7467 54.5263 31.96C53.9396 32.16 53.6463 32.52 53.6463 33.04C53.6463 33.4667 53.7129 33.8733 53.8463 34.26C53.9796 34.6333 54.1596 34.94 54.3863 35.18C54.6263 35.42 54.8863 35.54 55.1663 35.54ZM69.1541 36.7L68.9541 36.44L68.8541 35.32L69.0141 35.42C68.5607 35.82 68.0741 36.1533 67.5541 36.42C67.0474 36.6867 66.5541 36.82 66.0741 36.82C65.2474 36.82 64.5007 36.6067 63.8341 36.18C63.1807 35.7533 62.6607 35.1467 62.2741 34.36C61.9007 33.56 61.7141 32.62 61.7141 31.54C61.7141 30.5133 61.9341 29.5933 62.3741 28.78C62.8274 27.9667 63.4474 27.3267 64.2341 26.86C65.0207 26.3933 65.9274 26.16 66.9541 26.16C67.6474 26.16 68.3274 26.3067 68.9941 26.6L68.8141 26.76V21.78L69.0741 22.06L67.0141 21.72V21.28L71.1541 20.22L71.3341 20.48L71.2741 21.82V35.48L71.0341 35.22L72.6741 35.5V35.92L69.1541 36.7ZM67.0341 35.74C67.2874 35.74 67.5874 35.6267 67.9341 35.4C68.2807 35.16 68.6274 34.8467 68.9741 34.46L68.8141 34.84V27.3L69.0341 27.64C68.6074 27.4 68.1741 27.2333 67.7341 27.14C67.3074 27.0333 66.9141 26.98 66.5541 26.98C66.1541 26.98 65.7874 27.1533 65.4541 27.5C65.1207 27.8467 64.8541 28.3267 64.6541 28.94C64.4541 29.5533 64.3541 30.2667 64.3541 31.08C64.3541 32.0533 64.4674 32.8933 64.6941 33.6C64.9341 34.2933 65.2541 34.8267 65.6541 35.2C66.0674 35.56 66.5274 35.74 67.0341 35.74ZM72.9519 36.5V36.1L74.8919 35.44L74.6719 35.9V27.6L74.8919 28.02L72.8319 27.68V27.24L77.0119 26.18L77.1919 26.44L77.1519 27.88V35.88L76.9319 35.4L78.8719 36.1V36.5H72.9519ZM75.7319 24.72C75.3052 24.72 74.9385 24.5667 74.6319 24.26C74.3385 23.9533 74.1919 23.5867 74.1919 23.16C74.1919 22.7333 74.3385 22.3733 74.6319 22.08C74.9385 21.7733 75.3052 21.62 75.7319 21.62C76.1452 21.62 76.4985 21.7733 76.7919 22.08C77.0852 22.3733 77.2319 22.7333 77.2319 23.16C77.2319 23.5867 77.0852 23.9533 76.7919 24.26C76.4985 24.5667 76.1452 24.72 75.7319 24.72ZM79.1433 36.5V36.1L81.1433 35.4L80.8633 35.78V27.7L81.2233 28.04L79.0233 27.68V27.24L83.2033 26.18L83.3633 26.38L83.3433 27.8L83.1233 27.68C83.4166 27.4267 83.7366 27.1867 84.0833 26.96C84.4433 26.72 84.8099 26.5333 85.1833 26.4C85.5566 26.2533 85.9033 26.18 86.2233 26.18C86.9433 26.18 87.5766 26.3067 88.1233 26.56C88.6699 26.8133 89.0966 27.1667 89.4033 27.62C89.7099 28.0733 89.8633 28.5933 89.8633 29.18V35.8L89.6233 35.42L91.5433 36.1V36.5H85.9833V36.1L87.6833 35.36L87.3833 35.82V29.74C87.3833 28.9933 87.2166 28.3933 86.8833 27.94C86.5499 27.4733 86.1233 27.24 85.6033 27.24C85.3633 27.24 85.0966 27.3133 84.8033 27.46C84.5099 27.6067 84.2166 27.7933 83.9233 28.02C83.6433 28.2467 83.3833 28.4867 83.1433 28.74L83.3433 28.2V35.82L83.0633 35.38L84.7633 36.1V36.5H79.1433ZM96.8791 40.84C95.9991 40.84 95.1924 40.7267 94.4591 40.5C93.7257 40.2867 93.1391 39.98 92.6991 39.58C92.2724 39.18 92.0591 38.7267 92.0591 38.22C92.0591 37.86 92.1857 37.4533 92.4391 37C92.6924 36.5467 93.0191 36.1133 93.4191 35.7V35.98C93.0991 35.7533 92.8391 35.46 92.6391 35.1C92.4524 34.7267 92.3591 34.32 92.3591 33.88C92.3591 33.6533 92.4191 33.4067 92.5391 33.14C92.6724 32.8733 92.8391 32.6267 93.0391 32.4C93.2391 32.16 93.4391 31.98 93.6391 31.86L93.6991 32.04C93.4191 31.7333 93.1924 31.3667 93.0191 30.94C92.8591 30.5133 92.7791 30.0867 92.7791 29.66C92.7791 28.9667 92.9657 28.36 93.3391 27.84C93.7257 27.32 94.2524 26.9133 94.9191 26.62C95.5991 26.3267 96.3791 26.18 97.2591 26.18C97.7524 26.18 98.2191 26.2333 98.6591 26.34C99.1124 26.4467 99.5124 26.6 99.8591 26.8L99.4991 26.74L102.839 26.5V27.36L102.679 27.54L100.319 27.38L100.519 27.28C100.759 27.5333 100.946 27.84 101.079 28.2C101.226 28.5467 101.299 28.9067 101.299 29.28C101.299 30.0267 101.119 30.6933 100.759 31.28C100.412 31.8667 99.9057 32.3267 99.2391 32.66C98.5857 32.9933 97.7924 33.16 96.8591 33.16C96.4057 33.16 95.9524 33.1 95.4991 32.98C95.0457 32.86 94.6724 32.6867 94.3791 32.46H94.4791C94.4257 32.5267 94.3591 32.6333 94.2791 32.78C94.2124 32.9133 94.1524 33.0533 94.0991 33.2C94.0591 33.3333 94.0391 33.44 94.0391 33.52C94.0391 33.8267 94.1591 34.06 94.3991 34.22C94.6391 34.3667 94.9591 34.44 95.3591 34.44H99.7191C100.439 34.44 101.019 34.6533 101.459 35.08C101.899 35.4933 102.119 35.9867 102.119 36.56C102.119 37.4 101.906 38.14 101.479 38.78C101.066 39.42 100.466 39.92 99.6791 40.28C98.8924 40.6533 97.9591 40.84 96.8791 40.84ZM97.1791 39.9C97.8857 39.9 98.4991 39.8133 99.0191 39.64C99.5524 39.4667 99.9657 39.22 100.259 38.9C100.552 38.58 100.699 38.2133 100.699 37.8C100.699 37.5067 100.599 37.2733 100.399 37.1C100.199 36.9267 99.9257 36.8 99.5791 36.72C99.2457 36.64 98.8457 36.6 98.3791 36.6H95.3391C95.0991 36.6 94.8524 36.5667 94.5991 36.5C94.3591 36.4467 94.1457 36.3667 93.9591 36.26L94.3791 36.2C94.0991 36.48 93.8791 36.7467 93.7191 37C93.5724 37.2667 93.4991 37.5667 93.4991 37.9C93.4991 38.34 93.6791 38.7067 94.0391 39C94.4124 39.2933 94.8791 39.5133 95.4391 39.66C95.9991 39.82 96.5791 39.9 97.1791 39.9ZM97.0991 32.34C97.6191 32.34 98.0191 32.1333 98.2991 31.72C98.5924 31.3067 98.7391 30.7133 98.7391 29.94C98.7391 28.98 98.5857 28.2533 98.2791 27.76C97.9724 27.2533 97.5057 27 96.8791 27C96.4257 27 96.0657 27.2 95.7991 27.6C95.5457 27.9867 95.4191 28.5667 95.4191 29.34C95.4191 30.3133 95.5591 31.06 95.8391 31.58C96.1191 32.0867 96.5391 32.34 97.0991 32.34Z" fill="black"/><path d="M25.246 61.5V51.7H29.208C29.8053 51.7 30.3233 51.8027 30.762 52.008C31.21 52.2133 31.5553 52.5027 31.798 52.876C32.0407 53.2493 32.162 53.688 32.162 54.192C32.162 54.7333 32.0033 55.2 31.686 55.592C31.378 55.9747 30.958 56.2453 30.426 56.404C31.0793 56.5533 31.5927 56.838 31.966 57.258C32.3487 57.6687 32.54 58.1773 32.54 58.784C32.54 59.3253 32.4093 59.8013 32.148 60.212C31.8867 60.6227 31.518 60.94 31.042 61.164C30.566 61.388 30.006 61.5 29.362 61.5H25.246ZM26.324 55.984H29.124C29.7213 55.984 30.1973 55.8347 30.552 55.536C30.9067 55.228 31.084 54.8173 31.084 54.304C31.084 53.7907 30.9067 53.3847 30.552 53.086C30.1973 52.778 29.7213 52.624 29.124 52.624H26.324V55.984ZM26.324 60.576H29.25C29.9127 60.576 30.4447 60.408 30.846 60.072C31.2473 59.7267 31.448 59.274 31.448 58.714C31.448 58.154 31.2473 57.706 30.846 57.37C30.454 57.034 29.922 56.866 29.25 56.866H26.324V60.576ZM37.3025 61.612C36.6678 61.612 36.0985 61.458 35.5945 61.15C35.0905 60.842 34.6938 60.422 34.4045 59.89C34.1152 59.358 33.9705 58.756 33.9705 58.084C33.9705 57.412 34.1152 56.81 34.4045 56.278C34.6938 55.746 35.0905 55.326 35.5945 55.018C36.0985 54.71 36.6678 54.556 37.3025 54.556C37.9278 54.556 38.4878 54.71 38.9825 55.018C39.4865 55.326 39.8832 55.746 40.1725 56.278C40.4618 56.81 40.6065 57.412 40.6065 58.084C40.6065 58.756 40.4618 59.358 40.1725 59.89C39.8832 60.422 39.4865 60.842 38.9825 61.15C38.4878 61.458 37.9278 61.612 37.3025 61.612ZM37.2885 60.716C37.7365 60.716 38.1332 60.604 38.4785 60.38C38.8238 60.1467 39.0945 59.8293 39.2905 59.428C39.4958 59.0267 39.5985 58.5787 39.5985 58.084C39.5985 57.58 39.4958 57.132 39.2905 56.74C39.0945 56.3387 38.8238 56.026 38.4785 55.802C38.1332 55.5687 37.7365 55.452 37.2885 55.452C36.8405 55.452 36.4438 55.5687 36.0985 55.802C35.7532 56.026 35.4778 56.3387 35.2725 56.74C35.0765 57.132 34.9785 57.58 34.9785 58.084C34.9785 58.5787 35.0765 59.0267 35.2725 59.428C35.4778 59.8293 35.7532 60.1467 36.0985 60.38C36.4438 60.604 36.8405 60.716 37.2885 60.716ZM45.2416 61.598C44.6536 61.598 44.1216 61.444 43.6456 61.136C43.1696 60.8187 42.7916 60.3987 42.5116 59.876C42.2316 59.344 42.0916 58.7513 42.0916 58.098C42.0916 57.4353 42.2316 56.8427 42.5116 56.32C42.8009 55.788 43.1883 55.368 43.6736 55.06C44.1589 54.7427 44.7003 54.584 45.2976 54.584C45.7176 54.584 46.1096 54.668 46.4736 54.836C46.8376 54.9947 47.1549 55.228 47.4256 55.536V51.392L48.4476 51.182V61.5H47.4256V60.59C47.1643 60.9167 46.8469 61.1687 46.4736 61.346C46.1003 61.514 45.6896 61.598 45.2416 61.598ZM45.4936 60.702C45.8949 60.702 46.2636 60.6227 46.5996 60.464C46.9356 60.3053 47.2109 60.0813 47.4256 59.792V56.404C47.2016 56.1147 46.9169 55.8907 46.5716 55.732C46.2356 55.564 45.8763 55.48 45.4936 55.48C45.0363 55.48 44.6256 55.592 44.2616 55.816C43.9069 56.04 43.6223 56.348 43.4076 56.74C43.2023 57.132 43.0996 57.58 43.0996 58.084C43.0996 58.5787 43.2023 59.0267 43.4076 59.428C43.6223 59.82 43.9069 60.1327 44.2616 60.366C44.6256 60.59 45.0363 60.702 45.4936 60.702ZM50.842 64.566C50.6274 64.566 50.408 64.5333 50.184 64.468V63.558C50.2774 63.5767 50.3754 63.5907 50.478 63.6C50.5807 63.6093 50.6694 63.614 50.744 63.614C51.0054 63.614 51.22 63.544 51.388 63.404C51.5654 63.264 51.7147 63.0447 51.836 62.746L52.34 61.5L49.708 54.668H50.842L52.914 60.282L55.112 54.668H56.246L52.802 63.054C52.6527 63.418 52.4894 63.712 52.312 63.936C52.1347 64.16 51.9294 64.3187 51.696 64.412C51.4627 64.5147 51.178 64.566 50.842 64.566ZM61.6563 61.5V55.508H60.1303V54.668H61.6563V53.24C61.6563 52.568 61.8336 52.05 62.1883 51.686C62.5429 51.322 63.0469 51.14 63.7003 51.14C63.8869 51.14 64.0549 51.1493 64.2043 51.168C64.3629 51.1867 64.5029 51.2193 64.6243 51.266V52.19C64.4749 52.1433 64.3396 52.1107 64.2183 52.092C64.0969 52.0733 63.9569 52.064 63.7983 52.064C63.4063 52.064 63.1216 52.162 62.9443 52.358C62.7669 52.5447 62.6783 52.8433 62.6783 53.254V54.668H64.6243V55.508H62.6783V61.5H61.6563ZM68.7068 61.612C68.0721 61.612 67.5028 61.458 66.9988 61.15C66.4948 60.842 66.0981 60.422 65.8088 59.89C65.5195 59.358 65.3748 58.756 65.3748 58.084C65.3748 57.412 65.5195 56.81 65.8088 56.278C66.0981 55.746 66.4948 55.326 66.9988 55.018C67.5028 54.71 68.0721 54.556 68.7068 54.556C69.3321 54.556 69.8921 54.71 70.3868 55.018C70.8908 55.326 71.2875 55.746 71.5768 56.278C71.8661 56.81 72.0108 57.412 72.0108 58.084C72.0108 58.756 71.8661 59.358 71.5768 59.89C71.2875 60.422 70.8908 60.842 70.3868 61.15C69.8921 61.458 69.3321 61.612 68.7068 61.612ZM68.6928 60.716C69.1408 60.716 69.5375 60.604 69.8828 60.38C70.2281 60.1467 70.4988 59.8293 70.6948 59.428C70.9001 59.0267 71.0028 58.5787 71.0028 58.084C71.0028 57.58 70.9001 57.132 70.6948 56.74C70.4988 56.3387 70.2281 56.026 69.8828 55.802C69.5375 55.5687 69.1408 55.452 68.6928 55.452C68.2448 55.452 67.8481 55.5687 67.5028 55.802C67.1575 56.026 66.8821 56.3387 66.6768 56.74C66.4808 57.132 66.3828 57.58 66.3828 58.084C66.3828 58.5787 66.4808 59.0267 66.6768 59.428C66.8821 59.8293 67.1575 60.1467 67.5028 60.38C67.8481 60.604 68.2448 60.716 68.6928 60.716ZM73.8039 61.5V54.668H74.8259V55.774C75.0872 55.3633 75.3999 55.06 75.7639 54.864C76.1279 54.6587 76.5386 54.556 76.9959 54.556C77.4906 54.556 77.9199 54.6633 78.2839 54.878C78.6572 55.0833 78.9466 55.3773 79.1519 55.76C79.3666 56.1333 79.4739 56.572 79.4739 57.076V61.5H78.4519V57.37C78.4519 56.7633 78.2839 56.2873 77.9479 55.942C77.6212 55.5873 77.1779 55.41 76.6179 55.41C76.2446 55.41 75.9039 55.4987 75.5959 55.676C75.2879 55.8533 75.0312 56.1147 74.8259 56.46V61.5H73.8039ZM83.9274 61.64C83.3394 61.64 82.8914 61.5 82.5834 61.22C82.2848 60.9307 82.1354 60.5153 82.1354 59.974V55.508H80.7214V54.668H82.1354V52.792L83.1574 52.554V54.668H85.1174V55.508H83.1574V59.708C83.1574 60.072 83.2321 60.3333 83.3814 60.492C83.5401 60.6507 83.7968 60.73 84.1514 60.73C84.3288 60.73 84.4874 60.716 84.6274 60.688C84.7674 60.66 84.9308 60.6133 85.1174 60.548V61.458C84.9308 61.5233 84.7348 61.57 84.5294 61.598C84.3241 61.626 84.1234 61.64 83.9274 61.64ZM90.75 61.5V55.508H89.224V54.668H90.75V53.24C90.75 52.568 90.9274 52.05 91.282 51.686C91.6367 51.322 92.1407 51.14 92.794 51.14C92.9807 51.14 93.1487 51.1493 93.298 51.168C93.4567 51.1867 93.5967 51.2193 93.718 51.266V52.19C93.5687 52.1433 93.4334 52.1107 93.312 52.092C93.1907 52.0733 93.0507 52.064 92.892 52.064C92.5 52.064 92.2154 52.162 92.038 52.358C91.8607 52.5447 91.772 52.8433 91.772 53.254V54.668H93.718V55.508H91.772V61.5H90.75ZM96.9726 61.626C96.4873 61.626 96.0579 61.5373 95.6846 61.36C95.3113 61.1827 95.0173 60.94 94.8026 60.632C94.5973 60.3147 94.4946 59.9507 94.4946 59.54C94.4946 59.1293 94.6019 58.7747 94.8166 58.476C95.0313 58.168 95.3299 57.93 95.7126 57.762C96.0953 57.594 96.5433 57.51 97.0566 57.51C97.4486 57.51 97.8173 57.552 98.1626 57.636C98.5173 57.72 98.8439 57.8553 99.1426 58.042V57.104C99.1426 56.544 98.9933 56.124 98.6946 55.844C98.3959 55.5547 97.9573 55.41 97.3786 55.41C97.0613 55.41 96.7346 55.4567 96.3986 55.55C96.0719 55.6433 95.7079 55.7927 95.3066 55.998L94.9286 55.214C95.8433 54.7753 96.7019 54.556 97.5046 54.556C98.3539 54.556 99.0073 54.766 99.4646 55.186C99.9219 55.5967 100.151 56.1893 100.151 56.964V61.5H99.1426V60.702C98.8439 61.01 98.5126 61.2433 98.1486 61.402C97.7846 61.5513 97.3926 61.626 96.9726 61.626ZM95.4746 59.512C95.4746 59.9133 95.6286 60.2353 95.9366 60.478C96.2539 60.7207 96.6693 60.842 97.1826 60.842C97.5653 60.842 97.9153 60.7767 98.2326 60.646C98.5593 60.5153 98.8626 60.3193 99.1426 60.058V58.742C98.8533 58.574 98.5546 58.4527 98.2466 58.378C97.9386 58.294 97.5933 58.252 97.2106 58.252C96.6879 58.252 96.2679 58.3687 95.9506 58.602C95.6333 58.826 95.4746 59.1293 95.4746 59.512ZM102.228 61.5V54.668H103.25V55.732C103.511 55.34 103.81 55.046 104.146 54.85C104.482 54.654 104.86 54.556 105.28 54.556C105.765 54.556 106.19 54.6773 106.554 54.92C106.918 55.1533 107.193 55.4753 107.38 55.886C107.65 55.4473 107.972 55.116 108.346 54.892C108.728 54.668 109.167 54.556 109.662 54.556C110.119 54.556 110.52 54.6633 110.866 54.878C111.22 55.0927 111.496 55.3913 111.692 55.774C111.888 56.1473 111.986 56.586 111.986 57.09V61.5H110.964V57.342C110.964 56.7447 110.814 56.2733 110.516 55.928C110.217 55.5827 109.806 55.41 109.284 55.41C108.929 55.41 108.607 55.4987 108.318 55.676C108.038 55.8533 107.79 56.124 107.576 56.488C107.594 56.5813 107.608 56.6793 107.618 56.782C107.627 56.8847 107.632 56.9873 107.632 57.09V61.5H106.61V57.342C106.61 56.7447 106.456 56.2733 106.148 55.928C105.849 55.5827 105.438 55.41 104.916 55.41C104.216 55.41 103.66 55.746 103.25 56.418V61.5H102.228ZM114.04 61.5V54.668H115.062V61.5H114.04ZM114.558 52.974C114.353 52.974 114.175 52.904 114.026 52.764C113.886 52.6147 113.816 52.442 113.816 52.246C113.816 52.05 113.886 51.882 114.026 51.742C114.175 51.5927 114.353 51.518 114.558 51.518C114.763 51.518 114.936 51.5927 115.076 51.742C115.225 51.882 115.3 52.05 115.3 52.246C115.3 52.442 115.225 52.6147 115.076 52.764C114.936 52.904 114.763 52.974 114.558 52.974ZM117.157 61.5V51.392L118.179 51.182V61.5H117.157ZM120.569 64.566C120.354 64.566 120.135 64.5333 119.911 64.468V63.558C120.004 63.5767 120.102 63.5907 120.205 63.6C120.307 63.6093 120.396 63.614 120.471 63.614C120.732 63.614 120.947 63.544 121.115 63.404C121.292 63.264 121.441 63.0447 121.563 62.746L122.067 61.5L119.435 54.668H120.569L122.641 60.282L124.839 54.668H125.973L122.529 63.054C122.379 63.418 122.216 63.712 122.039 63.936C121.861 64.16 121.656 64.3187 121.423 64.412C121.189 64.5147 120.905 64.566 120.569 64.566Z" fill="black"/></svg>',
            'six'   => '<svg width="155" height="82" viewBox="0 0 155 82" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="155" height="82" fill="white"/><rect x="0.5" y="0.5" width="154" height="81" stroke="black" stroke-opacity="0.1"/><path d="M33.54 39.5V39.08L34.9 37.8V27.4L33.54 26.12V25.7H39.44V26.12L37.98 27.4V37.8L39.44 39.08V39.5H33.54ZM24.56 39.5V39.08L26.02 37.8V27.4L24.56 26.12V25.7H30.46V26.12L29.1 27.4V37.8L30.46 39.08V39.5H24.56ZM27.9 33V31.78H36.18V33H27.9ZM45.445 39.78C44.4583 39.78 43.585 39.58 42.825 39.18C42.065 38.7667 41.465 38.1933 41.025 37.46C40.5983 36.7267 40.385 35.8933 40.385 34.96C40.385 33.8533 40.6117 32.8867 41.065 32.06C41.5317 31.22 42.1717 30.5667 42.985 30.1C43.7983 29.62 44.7383 29.38 45.805 29.38C46.6583 29.38 47.3983 29.5867 48.025 30C48.665 30.4133 49.1583 31.0067 49.505 31.78C49.865 32.54 50.045 33.44 50.045 34.48H42.405V33.74L47.065 33.08C47.065 32.2933 46.9117 31.7 46.605 31.3C46.2983 30.8867 45.8917 30.68 45.385 30.68C44.985 30.68 44.625 30.8267 44.305 31.12C43.9983 31.4133 43.7583 31.8333 43.585 32.38C43.425 32.9267 43.345 33.56 43.345 34.28C43.345 35.4133 43.6183 36.3067 44.165 36.96C44.725 37.6133 45.4917 37.94 46.465 37.94C47.585 37.94 48.4983 37.5933 49.205 36.9L49.785 37.38C49.3983 38.1267 48.8183 38.7133 48.045 39.14C47.2717 39.5667 46.405 39.78 45.445 39.78ZM58.783 39.76L58.083 38.22H57.843V33.18C57.843 32.3667 57.6563 31.7467 57.283 31.32C56.9096 30.88 56.3696 30.66 55.663 30.66C55.2763 30.66 54.9096 30.7467 54.563 30.92C54.2163 31.0933 53.9363 31.34 53.723 31.66L53.763 29.82H55.623L53.203 33H52.723L51.603 30.34C51.9363 30.14 52.343 29.9667 52.823 29.82C53.3163 29.6733 53.843 29.56 54.403 29.48C54.963 29.4 55.5163 29.36 56.063 29.36C57.583 29.36 58.7296 29.6667 59.503 30.28C60.2896 30.88 60.683 31.7733 60.683 32.96V37.6L59.843 36.22L61.923 38.08V38.48L59.243 39.76H58.783ZM54.383 39.78C53.5163 39.78 52.803 39.5333 52.243 39.04C51.683 38.5333 51.403 37.8867 51.403 37.1C51.403 35.34 52.843 34.2 55.723 33.68L58.383 33.22V34.22L56.663 34.64C55.8363 34.84 55.243 35.0867 54.883 35.38C54.5363 35.6733 54.363 36.06 54.363 36.54C54.363 36.9933 54.4963 37.3467 54.763 37.6C55.0296 37.84 55.3896 37.96 55.843 37.96C56.763 37.96 57.5296 37.6733 58.143 37.1V38.22H57.903C57.463 38.74 56.9496 39.1333 56.363 39.4C55.7763 39.6533 55.1163 39.78 54.383 39.78ZM71.5003 39.76L70.7803 38.06H70.5603V26.54L71.4203 28.02L69.1403 25.94V25.54L72.8403 24.2H73.4003V37.6L72.5603 36.22L74.6403 38.08V38.48L71.9403 39.76H71.5003ZM67.2603 39.78C66.4336 39.78 65.707 39.5867 65.0803 39.2C64.4536 38.8 63.9603 38.2467 63.6003 37.54C63.2536 36.82 63.0803 35.9867 63.0803 35.04C63.0803 33.9333 63.3203 32.9533 63.8003 32.1C64.2803 31.2467 64.9403 30.58 65.7803 30.1C66.6203 29.62 67.5936 29.38 68.7003 29.38C69.9136 29.38 70.8936 29.6667 71.6403 30.24V32.1C71.267 31.58 70.8536 31.2 70.4003 30.96C69.947 30.7067 69.4336 30.58 68.8603 30.58C68.2736 30.58 67.767 30.7333 67.3403 31.04C66.927 31.3333 66.607 31.7733 66.3803 32.36C66.167 32.9333 66.0603 33.6333 66.0603 34.46C66.0603 35.5267 66.2803 36.3667 66.7203 36.98C67.1603 37.58 67.7736 37.88 68.5603 37.88C69.0136 37.88 69.427 37.8 69.8003 37.64C70.187 37.4667 70.5403 37.2 70.8603 36.84V38.06H70.6203C70.2336 38.5933 69.7336 39.0133 69.1203 39.32C68.5203 39.6267 67.9003 39.78 67.2603 39.78ZM75.578 39.5V39.18L77.198 37.6L76.878 38.16V31.86L77.738 33.28L75.458 31.18V30.78L79.158 29.52H79.718V38.18L79.418 37.62L81.038 39.18V39.5H75.578ZM78.358 28.24C77.798 28.24 77.3446 28.08 76.998 27.76C76.6513 27.44 76.478 27.0267 76.478 26.52C76.478 26.0267 76.6513 25.62 76.998 25.3C77.3446 24.98 77.798 24.82 78.358 24.82C78.9046 24.82 79.3513 24.98 79.698 25.3C80.0446 25.62 80.218 26.0267 80.218 26.52C80.218 27.0267 80.0446 27.44 79.698 27.76C79.3513 28.08 78.9046 28.24 78.358 28.24ZM89.0442 39.5V39.18L90.5642 37.6L90.2642 38.16V33.58C90.2642 32.7933 90.1109 32.2267 89.8042 31.88C89.5109 31.5333 89.0309 31.36 88.3642 31.36C87.8709 31.36 87.4176 31.4533 87.0042 31.64C86.5909 31.8133 86.1976 32.0867 85.8242 32.46V31.26H86.0642C87.2776 29.9933 88.5442 29.36 89.8642 29.36C90.9042 29.36 91.7042 29.6667 92.2642 30.28C92.8242 30.8933 93.1042 31.76 93.1042 32.88V38.18L92.7842 37.62L94.4042 39.18V39.5H89.0442ZM81.9842 39.5V39.18L83.6042 37.6L83.2842 38.18V31.52L84.1442 33.34L81.8642 31.18V30.78L85.5242 29.52H86.1042L85.9642 31.26H86.1242V38.18L85.8242 37.6L87.3442 39.18V39.5H81.9842ZM100.743 44.52C99.6098 44.52 98.6365 44.4133 97.8231 44.2C97.0231 44 96.4031 43.7067 95.9631 43.32C95.5231 42.9467 95.3031 42.5 95.3031 41.98C95.3031 41.5267 95.4765 41.1333 95.8231 40.8C96.1698 40.4667 96.6098 40.26 97.1431 40.18V39.5H98.5831V40.28C98.1565 40.5467 97.9431 40.9867 97.9431 41.6C97.9431 42.1467 98.2498 42.5867 98.8631 42.92C99.4898 43.2533 100.303 43.42 101.303 43.42C102.196 43.42 102.93 43.26 103.503 42.94C104.076 42.62 104.363 42.2067 104.363 41.7C104.363 41.2733 104.19 40.9267 103.843 40.66C103.51 40.4067 103.056 40.28 102.483 40.28H98.1631C97.4031 40.28 96.7831 40.06 96.3031 39.62C95.8365 39.1933 95.6031 38.6267 95.6031 37.92C95.6031 37.5067 95.6898 37.1333 95.8631 36.8C96.0498 36.4667 96.2965 36.1933 96.6031 35.98C96.9231 35.7533 97.2831 35.62 97.6831 35.58L98.5031 36.12C98.2231 36.12 98.0031 36.1867 97.8431 36.32C97.6831 36.4533 97.6031 36.6467 97.6031 36.9C97.6031 37.1933 97.7298 37.4133 97.9831 37.56C98.2365 37.6933 98.6165 37.76 99.1231 37.76H102.803C104.003 37.76 104.943 38.02 105.623 38.54C106.316 39.06 106.663 39.7667 106.663 40.66C106.663 41.42 106.41 42.0867 105.903 42.66C105.396 43.2467 104.696 43.7 103.803 44.02C102.923 44.3533 101.903 44.52 100.743 44.52ZM100.423 36.48C99.5165 36.48 98.7165 36.3333 98.0231 36.04C97.3298 35.7467 96.7831 35.3467 96.3831 34.84C95.9965 34.32 95.8031 33.7267 95.8031 33.06C95.8031 32.2867 96.0031 31.6267 96.4031 31.08C96.8031 30.5333 97.3765 30.1133 98.1231 29.82C98.8698 29.5267 99.7565 29.38 100.783 29.38C101.69 29.38 102.49 29.5267 103.183 29.82C103.876 30.1133 104.416 30.52 104.803 31.04C105.203 31.5467 105.403 32.1333 105.403 32.8C105.403 33.56 105.203 34.22 104.803 34.78C104.403 35.3267 103.83 35.7467 103.083 36.04C102.336 36.3333 101.45 36.48 100.423 36.48ZM100.723 35.36C101.296 35.36 101.736 35.1867 102.043 34.84C102.363 34.48 102.523 33.9667 102.523 33.3C102.523 32.46 102.336 31.7867 101.963 31.28C101.59 30.76 101.096 30.5 100.483 30.5C99.9098 30.5 99.4631 30.68 99.1431 31.04C98.8365 31.3867 98.6831 31.8933 98.6831 32.56C98.6831 33.3867 98.8698 34.06 99.2431 34.58C99.6165 35.1 100.11 35.36 100.723 35.36ZM101.523 30.24L106.263 27.42H106.663V30.08L106.503 30.24L103.683 30V30.24H101.523Z" fill="black"/><path d="M27.976 51.504C28.76 51.504 29.418 51.5833 29.95 51.742C30.482 51.9007 30.8833 52.162 31.154 52.526C31.4247 52.89 31.56 53.3753 31.56 53.982C31.56 54.374 31.49 54.724 31.35 55.032C31.2193 55.3307 31.0233 55.5827 30.762 55.788C30.5007 55.984 30.1787 56.1193 29.796 56.194V56.264C30.188 56.3293 30.538 56.4507 30.846 56.628C31.1633 56.8053 31.4107 57.0573 31.588 57.384C31.7747 57.7107 31.868 58.1353 31.868 58.658C31.868 59.2647 31.7327 59.7827 31.462 60.212C31.2007 60.632 30.8273 60.954 30.342 61.178C29.8567 61.3927 29.2733 61.5 28.592 61.5H25.274V51.504H27.976ZM28.214 55.76C28.998 55.76 29.5347 55.6247 29.824 55.354C30.1227 55.074 30.272 54.6633 30.272 54.122C30.272 53.5713 30.09 53.1793 29.726 52.946C29.3713 52.7033 28.8067 52.582 28.032 52.582H26.52V55.76H28.214ZM26.52 56.81V60.436H28.368C29.18 60.436 29.7447 60.2633 30.062 59.918C30.3887 59.5727 30.552 59.12 30.552 58.56C30.552 58.2053 30.4773 57.8973 30.328 57.636C30.188 57.3747 29.9547 57.174 29.628 57.034C29.3013 56.8847 28.8533 56.81 28.284 56.81H26.52ZM39.8659 57.734C39.8659 58.3593 39.7866 58.9147 39.6279 59.4C39.4786 59.876 39.2593 60.282 38.9699 60.618C38.6806 60.954 38.3306 61.2107 37.9199 61.388C37.5093 61.556 37.0519 61.64 36.5479 61.64C36.0813 61.64 35.6473 61.556 35.2459 61.388C34.8539 61.2107 34.5086 60.954 34.2099 60.618C33.9206 60.282 33.6966 59.876 33.5379 59.4C33.3793 58.9147 33.2999 58.3593 33.2999 57.734C33.2999 56.9033 33.4306 56.2033 33.6919 55.634C33.9626 55.0553 34.3453 54.6167 34.8399 54.318C35.3346 54.01 35.9179 53.856 36.5899 53.856C37.2339 53.856 37.7986 54.01 38.2839 54.318C38.7786 54.6167 39.1659 55.0553 39.4459 55.634C39.7259 56.2033 39.8659 56.9033 39.8659 57.734ZM34.5599 57.734C34.5599 58.322 34.6299 58.8353 34.7699 59.274C34.9099 59.7033 35.1293 60.0347 35.4279 60.268C35.7266 60.5013 36.1093 60.618 36.5759 60.618C37.0426 60.618 37.4253 60.5013 37.7239 60.268C38.0226 60.0347 38.2419 59.7033 38.3819 59.274C38.5313 58.8353 38.6059 58.322 38.6059 57.734C38.6059 57.1367 38.5313 56.628 38.3819 56.208C38.2419 55.788 38.0226 55.466 37.7239 55.242C37.4253 55.0087 37.0379 54.892 36.5619 54.892C35.8619 54.892 35.3533 55.144 35.0359 55.648C34.7186 56.152 34.5599 56.8473 34.5599 57.734ZM44.1683 61.64C43.3003 61.64 42.6003 61.318 42.0683 60.674C41.5456 60.0207 41.2843 59.05 41.2843 57.762C41.2843 56.474 41.5503 55.5033 42.0823 54.85C42.6143 54.1873 43.3143 53.856 44.1823 53.856C44.5463 53.856 44.8636 53.9073 45.1343 54.01C45.405 54.1033 45.6383 54.234 45.8343 54.402C46.0396 54.57 46.2123 54.7567 46.3523 54.962H46.4363C46.427 54.8407 46.4083 54.6633 46.3803 54.43C46.3616 54.1873 46.3523 53.996 46.3523 53.856V50.86H47.5703V61.5H46.5903L46.4083 60.492H46.3523C46.2123 60.7067 46.0396 60.9027 45.8343 61.08C45.6383 61.248 45.4003 61.3833 45.1203 61.486C44.8496 61.5887 44.5323 61.64 44.1683 61.64ZM44.3923 60.618C45.1203 60.618 45.629 60.4033 45.9183 59.974C46.217 59.5353 46.3663 58.8773 46.3663 58V57.776C46.3663 56.8427 46.2263 56.1287 45.9463 55.634C45.6663 55.13 45.1436 54.878 44.3783 54.878C43.7623 54.878 43.3003 55.144 42.9923 55.676C42.6936 56.1987 42.5443 56.9033 42.5443 57.79C42.5443 58.686 42.6936 59.3813 42.9923 59.876C43.3003 60.3707 43.767 60.618 44.3923 60.618ZM48.6917 53.996H50.0077L51.5057 58.266C51.5991 58.518 51.6831 58.7607 51.7577 58.994C51.8324 59.2273 51.8977 59.456 51.9537 59.68C52.0097 59.8947 52.0517 60.1047 52.0797 60.31H52.1217C52.1777 60.0767 52.2571 59.7733 52.3597 59.4C52.4717 59.0173 52.5884 58.6347 52.7097 58.252L54.1237 53.996H55.4537L52.4157 62.536C52.2477 63.0027 52.0471 63.4087 51.8137 63.754C51.5897 64.1087 51.3144 64.3793 50.9877 64.566C50.6611 64.762 50.2691 64.86 49.8117 64.86C49.6064 64.86 49.4197 64.846 49.2517 64.818C49.0931 64.7993 48.9577 64.776 48.8457 64.748V63.768C48.9391 63.7867 49.0557 63.8053 49.1957 63.824C49.3357 63.8427 49.4804 63.852 49.6297 63.852C49.9004 63.852 50.1337 63.796 50.3297 63.684C50.5257 63.5813 50.6937 63.4273 50.8337 63.222C50.9737 63.026 51.0904 62.7927 51.1837 62.522L51.5337 61.528L48.6917 53.996ZM63.287 54.948H61.523V61.5H60.291V54.948H59.073V54.374L60.291 53.954V53.52C60.291 52.876 60.3796 52.3533 60.557 51.952C60.7436 51.5507 61.0096 51.2567 61.355 51.07C61.7003 50.8833 62.1156 50.79 62.601 50.79C62.8903 50.79 63.1516 50.818 63.385 50.874C63.6276 50.9207 63.8376 50.9767 64.015 51.042L63.693 52.008C63.5436 51.9613 63.3756 51.9147 63.189 51.868C63.0116 51.8213 62.825 51.798 62.629 51.798C62.2556 51.798 61.9756 51.938 61.789 52.218C61.6116 52.4887 61.523 52.918 61.523 53.506V53.996H63.287V54.948ZM70.7234 57.734C70.7234 58.3593 70.644 58.9147 70.4854 59.4C70.336 59.876 70.1167 60.282 69.8274 60.618C69.538 60.954 69.188 61.2107 68.7774 61.388C68.3667 61.556 67.9094 61.64 67.4054 61.64C66.9387 61.64 66.5047 61.556 66.1034 61.388C65.7114 61.2107 65.366 60.954 65.0674 60.618C64.778 60.282 64.554 59.876 64.3954 59.4C64.2367 58.9147 64.1574 58.3593 64.1574 57.734C64.1574 56.9033 64.288 56.2033 64.5494 55.634C64.82 55.0553 65.2027 54.6167 65.6974 54.318C66.192 54.01 66.7754 53.856 67.4474 53.856C68.0914 53.856 68.656 54.01 69.1414 54.318C69.636 54.6167 70.0234 55.0553 70.3034 55.634C70.5834 56.2033 70.7234 56.9033 70.7234 57.734ZM65.4174 57.734C65.4174 58.322 65.4874 58.8353 65.6274 59.274C65.7674 59.7033 65.9867 60.0347 66.2854 60.268C66.584 60.5013 66.9667 60.618 67.4334 60.618C67.9 60.618 68.2827 60.5013 68.5814 60.268C68.88 60.0347 69.0994 59.7033 69.2394 59.274C69.3887 58.8353 69.4634 58.322 69.4634 57.734C69.4634 57.1367 69.3887 56.628 69.2394 56.208C69.0994 55.788 68.88 55.466 68.5814 55.242C68.2827 55.0087 67.8954 54.892 67.4194 54.892C66.7194 54.892 66.2107 55.144 65.8934 55.648C65.576 56.152 65.4174 56.8473 65.4174 57.734ZM75.9777 53.856C76.8177 53.856 77.4524 54.0753 77.8817 54.514C78.3204 54.9433 78.5397 55.6433 78.5397 56.614V61.5H77.3217V56.698C77.3217 56.0913 77.1957 55.6387 76.9437 55.34C76.6917 55.0413 76.3044 54.892 75.7817 54.892C75.0164 54.892 74.4844 55.1253 74.1857 55.592C73.8964 56.0587 73.7517 56.7307 73.7517 57.608V61.5H72.5337V53.996H73.5137L73.6957 55.018H73.7657C73.9151 54.7567 74.1064 54.542 74.3397 54.374C74.5731 54.1967 74.8297 54.066 75.1097 53.982C75.3897 53.898 75.6791 53.856 75.9777 53.856ZM83.1315 60.632C83.3088 60.632 83.4908 60.618 83.6775 60.59C83.8642 60.5527 84.0182 60.5153 84.1395 60.478V61.416C84.0088 61.4813 83.8222 61.5327 83.5795 61.57C83.3462 61.6167 83.1222 61.64 82.9075 61.64C82.5342 61.64 82.1888 61.5747 81.8715 61.444C81.5542 61.304 81.2975 61.066 81.1015 60.73C80.9148 60.394 80.8215 59.9227 80.8215 59.316V54.948H79.8275V54.36L80.8495 53.87L81.3115 52.274H82.0395V53.996H84.0835V54.948H82.0395V59.288C82.0395 59.7453 82.1422 60.086 82.3475 60.31C82.5528 60.5247 82.8142 60.632 83.1315 60.632ZM92.2577 54.948H90.4937V61.5H89.2617V54.948H88.0437V54.374L89.2617 53.954V53.52C89.2617 52.876 89.3503 52.3533 89.5277 51.952C89.7143 51.5507 89.9803 51.2567 90.3257 51.07C90.671 50.8833 91.0863 50.79 91.5717 50.79C91.861 50.79 92.1223 50.818 92.3557 50.874C92.5983 50.9207 92.8083 50.9767 92.9857 51.042L92.6637 52.008C92.5143 51.9613 92.3463 51.9147 92.1597 51.868C91.9823 51.8213 91.7957 51.798 91.5997 51.798C91.2263 51.798 90.9463 51.938 90.7597 52.218C90.5823 52.4887 90.4937 52.918 90.4937 53.506V53.996H92.2577V54.948ZM96.2221 53.87C97.0807 53.87 97.7201 54.0707 98.1401 54.472C98.5694 54.8733 98.7841 55.5127 98.7841 56.39V61.5H97.9021L97.6641 60.436H97.6081C97.4027 60.7067 97.1927 60.9353 96.9781 61.122C96.7727 61.2993 96.5301 61.43 96.2501 61.514C95.9794 61.598 95.6434 61.64 95.2421 61.64C94.8221 61.64 94.4441 61.5607 94.1081 61.402C93.7721 61.2433 93.5061 61.0007 93.3101 60.674C93.1141 60.338 93.0161 59.918 93.0161 59.414C93.0161 58.6673 93.2914 58.0933 93.8421 57.692C94.3927 57.2813 95.2421 57.0573 96.3901 57.02L97.5801 56.978V56.53C97.5801 55.9047 97.4541 55.4707 97.2021 55.228C96.9594 54.9853 96.6094 54.864 96.1521 54.864C95.7881 54.864 95.4381 54.9247 95.1021 55.046C94.7754 55.158 94.4627 55.2887 94.1641 55.438L93.7861 54.514C94.1034 54.3367 94.4721 54.1873 94.8921 54.066C95.3121 53.9353 95.7554 53.87 96.2221 53.87ZM96.5581 57.874C95.6994 57.9113 95.1021 58.0607 94.7661 58.322C94.4394 58.5833 94.2761 58.952 94.2761 59.428C94.2761 59.848 94.3927 60.156 94.6261 60.352C94.8594 60.548 95.1627 60.646 95.5361 60.646C96.1147 60.646 96.6001 60.4733 96.9921 60.128C97.3841 59.7733 97.5801 59.232 97.5801 58.504V57.832L96.5581 57.874ZM108.756 53.856C109.558 53.856 110.156 54.0753 110.548 54.514C110.94 54.9433 111.136 55.6433 111.136 56.614V61.5H109.932V56.67C109.932 56.082 109.815 55.6387 109.582 55.34C109.358 55.0413 109.003 54.892 108.518 54.892C107.846 54.892 107.365 55.102 107.076 55.522C106.796 55.942 106.656 56.5533 106.656 57.356V61.5H105.438V56.67C105.438 56.278 105.386 55.9513 105.284 55.69C105.181 55.4193 105.027 55.2187 104.822 55.088C104.616 54.9573 104.35 54.892 104.024 54.892C103.557 54.892 103.188 54.9993 102.918 55.214C102.647 55.4193 102.456 55.7227 102.344 56.124C102.232 56.5253 102.176 57.02 102.176 57.608V61.5H100.958V53.996H101.938L102.12 55.018H102.19C102.339 54.7567 102.521 54.542 102.736 54.374C102.95 54.1967 103.188 54.066 103.45 53.982C103.711 53.898 103.982 53.856 104.262 53.856C104.803 53.856 105.256 53.9587 105.62 54.164C105.984 54.3693 106.25 54.6867 106.418 55.116H106.502C106.735 54.6867 107.052 54.3693 107.454 54.164C107.864 53.9587 108.298 53.856 108.756 53.856ZM114.535 53.996V61.5H113.317V53.996H114.535ZM113.933 51.182C114.12 51.182 114.283 51.2473 114.423 51.378C114.563 51.4993 114.633 51.6953 114.633 51.966C114.633 52.2273 114.563 52.4233 114.423 52.554C114.283 52.6847 114.12 52.75 113.933 52.75C113.737 52.75 113.569 52.6847 113.429 52.554C113.289 52.4233 113.219 52.2273 113.219 51.966C113.219 51.6953 113.289 51.4993 113.429 51.378C113.569 51.2473 113.737 51.182 113.933 51.182ZM117.967 61.5H116.749V50.86H117.967V61.5ZM119.088 53.996H120.404L121.902 58.266C121.996 58.518 122.08 58.7607 122.154 58.994C122.229 59.2273 122.294 59.456 122.35 59.68C122.406 59.8947 122.448 60.1047 122.476 60.31H122.518C122.574 60.0767 122.654 59.7733 122.756 59.4C122.868 59.0173 122.985 58.6347 123.106 58.252L124.52 53.996H125.85L122.812 62.536C122.644 63.0027 122.444 63.4087 122.21 63.754C121.986 64.1087 121.711 64.3793 121.384 64.566C121.058 64.762 120.666 64.86 120.208 64.86C120.003 64.86 119.816 64.846 119.648 64.818C119.49 64.7993 119.354 64.776 119.242 64.748V63.768C119.336 63.7867 119.452 63.8053 119.592 63.824C119.732 63.8427 119.877 63.852 120.026 63.852C120.297 63.852 120.53 63.796 120.726 63.684C120.922 63.5813 121.09 63.4273 121.23 63.222C121.37 63.026 121.487 62.7927 121.58 62.522L121.93 61.528L119.088 53.996Z" fill="black"/></svg>',
            'seven' => '<svg width="155" height="82" viewBox="0 0 155 82" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="155" height="82" fill="white"/><rect x="0.5" y="0.5" width="154" height="81" stroke="black" stroke-opacity="0.1"/><path d="M34.42 38.5V37.74L34.9 37.7C35.4067 37.6733 35.7733 37.6067 36 37.5C36.24 37.3933 36.3933 37.2467 36.46 37.06C36.54 36.8733 36.58 36.64 36.58 36.36V26.64C36.58 26.36 36.54 26.1267 36.46 25.94C36.3933 25.7533 36.24 25.6067 36 25.5C35.7733 25.3933 35.4067 25.3267 34.9 25.3L34.42 25.26V24.5H40.62V25.26L40.14 25.3C39.66 25.3267 39.3 25.3933 39.06 25.5C38.82 25.6067 38.66 25.7533 38.58 25.94C38.5 26.1267 38.46 26.36 38.46 26.64V36.36C38.46 36.64 38.5 36.8733 38.58 37.06C38.66 37.2467 38.82 37.3933 39.06 37.5C39.3 37.6067 39.66 37.6733 40.14 37.7L40.62 37.74V38.5H34.42ZM24.82 38.5V37.74L25.3 37.7C25.8067 37.6733 26.1733 37.6067 26.4 37.5C26.64 37.3933 26.7933 37.2467 26.86 37.06C26.94 36.8733 26.98 36.64 26.98 36.36V26.64C26.98 26.36 26.94 26.1267 26.86 25.94C26.7933 25.7533 26.64 25.6067 26.4 25.5C26.1733 25.3933 25.8067 25.3267 25.3 25.3L24.82 25.26V24.5H31.02V25.26L30.54 25.3C30.06 25.3267 29.7 25.3933 29.46 25.5C29.22 25.6067 29.06 25.7533 28.98 25.94C28.9 26.1267 28.86 26.36 28.86 26.64V36.36C28.86 36.64 28.9 36.8733 28.98 37.06C29.06 37.2467 29.22 37.3933 29.46 37.5C29.7 37.6067 30.06 37.6733 30.54 37.7L31.02 37.74V38.5H24.82ZM27.98 31.58V30.66H37.26V31.58H27.98ZM46.7945 38.7C45.8212 38.7 44.9545 38.4667 44.1945 38C43.4479 37.5333 42.8612 36.9 42.4345 36.1C42.0212 35.2867 41.8145 34.36 41.8145 33.32C41.8145 32.2933 42.0479 31.3733 42.5145 30.56C42.9945 29.7467 43.6345 29.1 44.4345 28.62C45.2479 28.14 46.1479 27.9 47.1345 27.9C48.1612 27.9 48.9879 28.2 49.6145 28.8C50.2545 29.4 50.5745 30.2733 50.5745 31.42C50.5745 31.5 50.5745 31.5867 50.5745 31.68C50.5745 31.76 50.5612 31.8733 50.5345 32.02L50.4945 32.3H43.3545V31.44H48.5945C48.6345 31.2267 48.6545 31.0267 48.6545 30.84C48.6545 30.2667 48.4879 29.8 48.1545 29.44C47.8212 29.08 47.3612 28.9 46.7745 28.9C45.8145 28.9 45.0479 29.26 44.4745 29.98C43.9145 30.6867 43.6345 31.62 43.6345 32.78C43.6345 33.6067 43.8012 34.3533 44.1345 35.02C44.4812 35.6733 44.9679 36.1867 45.5945 36.56C46.2345 36.9333 46.9745 37.12 47.8145 37.12C48.2679 37.12 48.7145 37.0467 49.1545 36.9C49.5945 36.7533 50.0212 36.5333 50.4345 36.24L50.8345 36.62C50.2612 37.3533 49.6612 37.8867 49.0345 38.22C48.4079 38.54 47.6612 38.7 46.7945 38.7ZM55.0767 38.7C54.4634 38.7 53.9767 38.6 53.6167 38.4C53.2567 38.1867 53.0034 37.9267 52.8567 37.62C52.7101 37.3 52.6367 36.9733 52.6367 36.64C52.6367 36.1733 52.7967 35.7067 53.1167 35.24C53.4367 34.76 53.9701 34.2933 54.7167 33.84C55.4767 33.3733 56.4901 32.92 57.7567 32.48L58.2967 32.3L58.3367 30.62C58.3501 30.1267 58.1967 29.72 57.8767 29.4C57.5567 29.0667 57.1301 28.9 56.5967 28.9C56.1167 28.9 55.7234 29.0467 55.4167 29.34C55.1101 29.6333 54.8834 30.0667 54.7367 30.64C54.7101 30.7867 54.5567 30.92 54.2767 31.04C53.9967 31.16 53.6501 31.22 53.2367 31.22C52.9967 31.22 52.8167 31.1933 52.6967 31.14C52.5767 31.0733 52.5501 30.94 52.6167 30.74C52.8301 30.22 53.1834 29.7467 53.6767 29.32C54.1701 28.8933 54.7301 28.5533 55.3567 28.3C55.9834 28.0333 56.6034 27.9 57.2167 27.9C58.0834 27.9 58.7901 28.1067 59.3367 28.52C59.8967 28.9333 60.1634 29.5133 60.1367 30.26L59.9367 36.24C59.9234 36.76 60.0501 37.0933 60.3167 37.24C60.5967 37.3867 61.1234 37.4867 61.8967 37.54V38.12L61.1967 38.3C60.7567 38.4067 60.4167 38.4867 60.1767 38.54C59.9367 38.6067 59.7501 38.64 59.6167 38.64C59.2567 38.64 58.9834 38.56 58.7967 38.4C58.6234 38.24 58.4967 38.0533 58.4167 37.84C58.3501 37.6267 58.3034 37.4533 58.2767 37.32H58.1167C57.5434 37.88 57.0101 38.2533 56.5167 38.44C56.0234 38.6133 55.5434 38.7 55.0767 38.7ZM56.1167 37.26C56.5967 37.26 56.9901 37.1867 57.2967 37.04C57.6167 36.88 57.9034 36.7133 58.1567 36.54L58.2767 33.16L58.0767 33.22C57.1034 33.5267 56.3701 33.86 55.8767 34.22C55.3834 34.5667 55.0501 34.9133 54.8767 35.26C54.7034 35.5933 54.6167 35.88 54.6167 36.12C54.6167 36.88 55.1167 37.26 56.1167 37.26ZM67.6845 38.7C66.7912 38.7 65.9912 38.48 65.2845 38.04C64.5912 37.5867 64.0445 36.9733 63.6445 36.2C63.2579 35.4133 63.0645 34.5133 63.0645 33.5C63.0645 32.4333 63.2979 31.48 63.7645 30.64C64.2445 29.8 64.8912 29.1333 65.7045 28.64C66.5179 28.1467 67.4312 27.9 68.4445 27.9C68.9779 27.9 69.4645 27.96 69.9045 28.08C70.3579 28.1867 70.7845 28.3733 71.1845 28.64V25.24C71.1845 24.7467 71.0512 24.4333 70.7845 24.3C70.5179 24.1533 70.1312 24.0667 69.6245 24.04V23.38L72.7045 22.5H72.9845V35.84C72.9845 36.2533 73.0645 36.56 73.2245 36.76C73.3979 36.9467 73.7645 37.0733 74.3245 37.14L74.5845 37.18V37.82L71.5245 38.54H71.2445V37.16H71.0645C70.6645 37.56 70.2979 37.8733 69.9645 38.1C69.6312 38.3267 69.2845 38.48 68.9245 38.56C68.5779 38.6533 68.1645 38.7 67.6845 38.7ZM68.6045 37.16C69.2045 37.16 69.7045 37.0933 70.1045 36.96C70.5045 36.8267 70.8645 36.6067 71.1845 36.3V31.66C71.1845 31.0333 71.0445 30.52 70.7645 30.12C70.4845 29.7067 70.1245 29.4 69.6845 29.2C69.2579 29 68.7979 28.9 68.3045 28.9C67.2112 28.9 66.3779 29.2467 65.8045 29.94C65.2312 30.6333 64.9445 31.6133 64.9445 32.88C64.9445 33.68 65.1045 34.4067 65.4245 35.06C65.7445 35.7 66.1779 36.2133 66.7245 36.6C67.2845 36.9733 67.9112 37.16 68.6045 37.16ZM75.7542 38.5V37.74L76.2142 37.68C76.6942 37.6267 77.0009 37.5 77.1342 37.3C77.2809 37.1 77.3542 36.7933 77.3542 36.38V30.72C77.3542 30.2267 77.2209 29.9133 76.9542 29.78C76.6876 29.6333 76.3009 29.5467 75.7942 29.52V28.86L78.8742 27.98H79.1542V36.38C79.1542 36.7933 79.2276 37.1 79.3742 37.3C79.5209 37.5 79.8342 37.6267 80.3142 37.68L80.7542 37.74V38.5H75.7542ZM78.0542 26.44C77.7209 26.44 77.4409 26.3333 77.2142 26.12C76.9876 25.8933 76.8742 25.6067 76.8742 25.26C76.8742 24.9133 76.9876 24.6333 77.2142 24.42C77.4409 24.2067 77.7209 24.1 78.0542 24.1C78.3742 24.1 78.6476 24.2067 78.8742 24.42C79.1009 24.6333 79.2142 24.9133 79.2142 25.26C79.2142 25.6067 79.1009 25.8933 78.8742 26.12C78.6476 26.3333 78.3742 26.44 78.0542 26.44ZM81.9652 38.5V37.74L82.4252 37.68C82.9052 37.6267 83.2118 37.5 83.3452 37.3C83.4918 37.1 83.5652 36.7933 83.5652 36.38V30.72C83.5652 30.2267 83.4318 29.9133 83.1652 29.78C82.8985 29.6333 82.5118 29.5467 82.0052 29.52V28.86L85.0252 27.98H85.3052V29.44H85.4252C86.0652 28.8933 86.6585 28.5 87.2052 28.26C87.7518 28.02 88.3918 27.9 89.1252 27.9C90.0718 27.9 90.8118 28.14 91.3452 28.62C91.8918 29.0867 92.1652 29.7467 92.1652 30.6V36.38C92.1652 36.7933 92.2385 37.1 92.3852 37.3C92.5318 37.5 92.8452 37.6267 93.3252 37.68L93.7652 37.74V38.5H88.7652V37.74L89.2252 37.68C89.7052 37.6267 90.0118 37.5 90.1452 37.3C90.2918 37.1 90.3652 36.7933 90.3652 36.38V31.36C90.3652 30.8267 90.2652 30.42 90.0652 30.14C89.8652 29.8467 89.5918 29.64 89.2452 29.52C88.8985 29.4 88.4918 29.34 88.0252 29.34C87.4918 29.34 87.0185 29.42 86.6052 29.58C86.2052 29.74 85.7918 29.98 85.3652 30.3V36.38C85.3652 36.7933 85.4385 37.1 85.5852 37.3C85.7318 37.5 86.0452 37.6267 86.5252 37.68L86.9652 37.74V38.5H81.9652ZM98.7339 43.64C97.6006 43.64 96.6939 43.4133 96.0139 42.96C95.3339 42.5067 94.9939 41.92 94.9939 41.2C94.9939 40.92 95.0672 40.6 95.2139 40.24C95.3739 39.8933 95.6806 39.4933 96.1339 39.04L97.2339 37.94L98.1339 38.06C97.6406 38.6067 97.2739 39.0467 97.0339 39.38C96.7939 39.7133 96.6739 40.0733 96.6739 40.46C96.6739 41.06 96.9339 41.5067 97.4539 41.8C97.9872 42.1067 98.6939 42.26 99.5739 42.26C100.761 42.26 101.674 42.0467 102.314 41.62C102.967 41.1933 103.294 40.6333 103.294 39.94C103.294 39.4867 103.154 39.16 102.874 38.96C102.594 38.7733 102.094 38.6533 101.374 38.6L97.8139 38.34C97.0672 38.2733 96.4872 38.1133 96.0739 37.86C95.6606 37.5933 95.4539 37.2533 95.4539 36.84C95.4539 36.4933 95.5739 36.2067 95.8139 35.98C96.0539 35.7533 96.3606 35.4667 96.7339 35.12L97.3539 34.52H98.2939L97.6939 35.2C97.4672 35.4533 97.3206 35.6333 97.2539 35.74C97.1872 35.8333 97.1539 35.9267 97.1539 36.02C97.1539 36.1933 97.2339 36.3333 97.3939 36.44C97.5539 36.5333 97.8272 36.5933 98.2139 36.62L101.874 36.92C103.581 37.0533 104.434 37.82 104.434 39.22C104.434 40.0467 104.174 40.7933 103.654 41.46C103.147 42.14 102.461 42.6733 101.594 43.06C100.727 43.4467 99.7739 43.64 98.7339 43.64ZM99.1739 34.98C98.4006 34.98 97.7206 34.8267 97.1339 34.52C96.5472 34.2133 96.0872 33.7933 95.7539 33.26C95.4206 32.7267 95.2539 32.1133 95.2539 31.42C95.2539 30.7533 95.4206 30.16 95.7539 29.64C96.0872 29.1067 96.5472 28.6867 97.1339 28.38C97.7206 28.06 98.4006 27.9 99.1739 27.9L100.174 28.2C101.014 28.3467 101.707 28.7 102.254 29.26C102.814 29.82 103.094 30.54 103.094 31.42C103.094 32.0733 102.927 32.6733 102.594 33.22C102.261 33.7533 101.794 34.18 101.194 34.5C100.607 34.82 99.9339 34.98 99.1739 34.98ZM99.3739 34.04C100.001 34.04 100.481 33.84 100.814 33.44C101.161 33.04 101.334 32.48 101.334 31.76C101.334 31.2533 101.241 30.78 101.054 30.34C100.881 29.8867 100.621 29.5267 100.274 29.26C99.9272 28.98 99.4939 28.84 98.9739 28.84C98.3472 28.84 97.8606 29.04 97.5139 29.44C97.1806 29.84 97.0139 30.4067 97.0139 31.14C97.0139 31.62 97.1006 32.0867 97.2739 32.54C97.4472 32.98 97.7072 33.34 98.0539 33.62C98.4139 33.9 98.8539 34.04 99.3739 34.04ZM99.1739 28.36V27.9L103.994 26.98H104.514V28.36H99.1739Z" fill="black"/><path d="M26.2695 60.5V59.3789H28.4844C29.0996 59.3789 29.5872 59.2262 29.9473 58.9209C30.3118 58.6156 30.4941 58.1895 30.4941 57.6426C30.4941 57.0957 30.2982 56.6719 29.9062 56.3711C29.5189 56.0703 28.9857 55.9199 28.3066 55.9199H26.1055V54.8262H27.9238C28.2975 54.8262 28.6211 54.7533 28.8945 54.6074C29.1725 54.4616 29.3867 54.2611 29.5371 54.0059C29.6921 53.7507 29.7695 53.459 29.7695 53.1309C29.7695 52.6113 29.5941 52.2171 29.2432 51.9482C28.8968 51.6794 28.4297 51.5449 27.8418 51.5449H26.1055V50.4238H27.7871C28.4388 50.4238 29.0039 50.5332 29.4824 50.752C29.9655 50.9661 30.3392 51.2646 30.6035 51.6475C30.8678 52.0303 31 52.4701 31 52.9668C31 53.3314 30.9294 53.6777 30.7881 54.0059C30.6468 54.3294 30.4577 54.612 30.2207 54.8535C29.9837 55.0951 29.7194 55.2682 29.4277 55.373V55.0723C29.9062 55.1816 30.3164 55.3571 30.6582 55.5986C31.0046 55.8356 31.2689 56.1318 31.4512 56.4873C31.6335 56.8382 31.7246 57.2415 31.7246 57.6973C31.7246 58.2533 31.5879 58.7432 31.3145 59.167C31.041 59.5863 30.6559 59.9144 30.1592 60.1514C29.6624 60.3838 29.0768 60.5 28.4023 60.5H26.2695ZM25.1758 60.5V50.4238H26.3789V60.5H25.1758ZM36.5371 60.6094C35.8581 60.6094 35.252 60.4499 34.7188 60.1309C34.1901 59.8118 33.7731 59.3698 33.4678 58.8047C33.1624 58.235 33.0098 57.5788 33.0098 56.8359C33.0098 56.1068 33.1624 55.4665 33.4678 54.915C33.7731 54.359 34.1901 53.9261 34.7188 53.6162C35.252 53.3018 35.8581 53.1445 36.5371 53.1445C37.2207 53.1445 37.8268 53.3018 38.3555 53.6162C38.8887 53.9261 39.3057 54.359 39.6064 54.915C39.9118 55.4665 40.0645 56.1068 40.0645 56.8359C40.0645 57.5788 39.9095 58.235 39.5996 58.8047C39.2943 59.3698 38.875 59.8118 38.3418 60.1309C37.8132 60.4499 37.2116 60.6094 36.5371 60.6094ZM36.5371 59.5156C36.9883 59.5156 37.3893 59.404 37.7402 59.1807C38.0911 58.9574 38.3646 58.6452 38.5605 58.2441C38.7611 57.8431 38.8613 57.3737 38.8613 56.8359C38.8613 56.3118 38.7611 55.8561 38.5605 55.4688C38.3646 55.0768 38.0911 54.7738 37.7402 54.5596C37.3893 54.3454 36.9883 54.2383 36.5371 54.2383C36.0905 54.2383 35.6917 54.3454 35.3408 54.5596C34.9899 54.7738 34.7142 55.0768 34.5137 55.4688C34.3132 55.8561 34.2129 56.3118 34.2129 56.8359C34.2129 57.3737 34.3109 57.8431 34.5068 58.2441C34.7074 58.6452 34.9808 58.9574 35.3271 59.1807C35.6781 59.404 36.0814 59.5156 36.5371 59.5156ZM48.0488 60.6094C47.7708 60.4772 47.5475 60.3405 47.3789 60.1992C47.2103 60.0579 47.0872 59.903 47.0098 59.7344C46.9368 59.5658 46.9004 59.3743 46.9004 59.1602L47.2285 59.3242H46.5586L46.9277 58.5176V54.8672L46.5859 54.1426H46.7363V49.9727H47.9121V58.4902C47.9121 58.791 47.9508 59.0143 48.0283 59.1602C48.1058 59.306 48.263 59.4336 48.5 59.543L48.0488 60.6094ZM44.4258 60.6094C43.9837 60.6094 43.5645 60.5228 43.168 60.3496C42.776 60.1719 42.4274 59.9189 42.1221 59.5908C41.8213 59.2627 41.5843 58.8685 41.4111 58.4082C41.238 57.9479 41.1536 57.4329 41.1582 56.8633C41.1536 56.0977 41.3018 55.4368 41.6025 54.8809C41.9033 54.3203 42.3021 53.8896 42.7988 53.5889C43.2956 53.2835 43.8379 53.1309 44.4258 53.1309C45.0319 53.1309 45.5697 53.2881 46.0391 53.6025C46.513 53.917 46.8844 54.3545 47.1533 54.915C47.4268 55.4756 47.5658 56.125 47.5703 56.8633C47.5658 57.5879 47.4268 58.2327 47.1533 58.7979C46.8844 59.363 46.513 59.8073 46.0391 60.1309C45.5697 60.4499 45.0319 60.6094 44.4258 60.6094ZM44.6309 59.543C45.0592 59.543 45.4398 59.4268 45.7725 59.1943C46.1097 58.9574 46.374 58.6383 46.5654 58.2373C46.7614 57.8317 46.8594 57.3737 46.8594 56.8633C46.8594 56.3118 46.7568 55.8379 46.5518 55.4414C46.3512 55.0404 46.0824 54.7327 45.7451 54.5186C45.4079 54.3044 45.0365 54.1973 44.6309 54.1973C44.1888 54.1973 43.7946 54.3112 43.4482 54.5391C43.1064 54.7624 42.8376 55.0745 42.6416 55.4756C42.4502 55.8766 42.3568 56.3392 42.3613 56.8633C42.3568 57.3737 42.4502 57.8317 42.6416 58.2373C42.8376 58.6383 43.1064 58.9574 43.4482 59.1943C43.7946 59.4268 44.1888 59.543 44.6309 59.543ZM50.6328 63.4805C50.3548 63.4805 50.0951 63.4486 49.8535 63.3848C49.612 63.321 49.4434 63.2617 49.3477 63.207L49.7988 62.1406C49.9447 62.2135 50.0951 62.2728 50.25 62.3184C50.4049 62.3639 50.5462 62.3867 50.6738 62.3867C50.9518 62.3913 51.1797 62.3229 51.3574 62.1816C51.5397 62.0449 51.681 61.8831 51.7812 61.6963C51.8815 61.514 51.9544 61.3568 52 61.2246L52.3691 60.1309L52.3965 60.8418L49.2383 53.2539H50.5234L52.2324 57.6699L52.793 59.1602H52.8477L53.3535 57.6699L54.9121 53.2539H56.1562L53.0391 61.5117C52.9798 61.6758 52.8932 61.8672 52.7793 62.0859C52.6699 62.3092 52.5241 62.5257 52.3418 62.7354C52.1595 62.9495 51.9294 63.1273 51.6514 63.2686C51.3734 63.4098 51.0339 63.4805 50.6328 63.4805ZM60.2988 54.3203V53.2539H64.5371V54.3203H60.2988ZM61.5703 60.5V51.9551C61.5703 51.3398 61.7526 50.8385 62.1172 50.4512C62.4863 50.0592 63.0059 49.8633 63.6758 49.8633C63.9036 49.8633 64.0973 49.8838 64.2568 49.9248C64.4209 49.9613 64.5781 50.0137 64.7285 50.082L64.291 51.1211C64.209 51.0573 64.1133 51.014 64.0039 50.9912C63.8945 50.9684 63.7852 50.957 63.6758 50.957C63.3841 50.957 63.1562 51.055 62.9922 51.251C62.8281 51.4469 62.7461 51.7227 62.7461 52.0781V60.5H61.5703ZM68.4473 60.6094C67.7682 60.6094 67.1621 60.4499 66.6289 60.1309C66.1003 59.8118 65.6833 59.3698 65.3779 58.8047C65.0726 58.235 64.9199 57.5788 64.9199 56.8359C64.9199 56.1068 65.0726 55.4665 65.3779 54.915C65.6833 54.359 66.1003 53.9261 66.6289 53.6162C67.1621 53.3018 67.7682 53.1445 68.4473 53.1445C69.1309 53.1445 69.737 53.3018 70.2656 53.6162C70.7988 53.9261 71.2158 54.359 71.5166 54.915C71.8219 55.4665 71.9746 56.1068 71.9746 56.8359C71.9746 57.5788 71.8197 58.235 71.5098 58.8047C71.2044 59.3698 70.7852 59.8118 70.252 60.1309C69.7233 60.4499 69.1217 60.6094 68.4473 60.6094ZM68.4473 59.5156C68.8984 59.5156 69.2995 59.404 69.6504 59.1807C70.0013 58.9574 70.2747 58.6452 70.4707 58.2441C70.6712 57.8431 70.7715 57.3737 70.7715 56.8359C70.7715 56.3118 70.6712 55.8561 70.4707 55.4688C70.2747 55.0768 70.0013 54.7738 69.6504 54.5596C69.2995 54.3454 68.8984 54.2383 68.4473 54.2383C68.0007 54.2383 67.6019 54.3454 67.251 54.5596C66.9001 54.7738 66.6243 55.0768 66.4238 55.4688C66.2233 55.8561 66.123 56.3118 66.123 56.8359C66.123 57.3737 66.221 57.8431 66.417 58.2441C66.6175 58.6452 66.891 58.9574 67.2373 59.1807C67.5882 59.404 67.9915 59.5156 68.4473 59.5156ZM73.4648 60.5V53.2539H74.6406V54.1426H74.9141L74.4082 54.6484C74.5312 54.3203 74.7135 54.0446 74.9551 53.8213C75.1966 53.598 75.4814 53.4294 75.8096 53.3154C76.1377 53.2015 76.4909 53.1445 76.8691 53.1445C77.4798 53.1445 77.972 53.279 78.3457 53.5479C78.724 53.8167 78.9974 54.1585 79.166 54.5732C79.3392 54.988 79.4258 55.4141 79.4258 55.8516V60.5H78.25V56.0977C78.25 55.4824 78.0973 55.0199 77.792 54.71C77.4912 54.3955 77.0742 54.2383 76.541 54.2383C76.1855 54.2383 75.8643 54.3112 75.5771 54.457C75.29 54.5983 75.0622 54.8079 74.8936 55.0859C74.7249 55.3594 74.6406 55.6966 74.6406 56.0977V60.5H73.4648ZM83.8691 60.6094C83.1855 60.6094 82.6706 60.4111 82.3242 60.0146C81.9779 59.6182 81.8047 59.11 81.8047 58.4902V50.9297H82.9805V58.3672C82.9805 58.7409 83.0648 59.0257 83.2334 59.2217C83.402 59.4176 83.623 59.5156 83.8965 59.5156C84.015 59.5156 84.1221 59.4997 84.2178 59.4678C84.3135 59.4313 84.4023 59.3926 84.4844 59.3516L84.9355 60.3906C84.7988 60.4453 84.6439 60.4954 84.4707 60.541C84.2975 60.5866 84.097 60.6094 83.8691 60.6094ZM80.6016 54.3203V53.2539H84.7715V54.3203H80.6016ZM89.1875 54.3203V53.2539H93.4258V54.3203H89.1875ZM90.459 60.5V51.9551C90.459 51.3398 90.6413 50.8385 91.0059 50.4512C91.375 50.0592 91.8945 49.8633 92.5645 49.8633C92.7923 49.8633 92.986 49.8838 93.1455 49.9248C93.3096 49.9613 93.4668 50.0137 93.6172 50.082L93.1797 51.1211C93.0977 51.0573 93.002 51.014 92.8926 50.9912C92.7832 50.9684 92.6738 50.957 92.5645 50.957C92.2728 50.957 92.0449 51.055 91.8809 51.251C91.7168 51.4469 91.6348 51.7227 91.6348 52.0781V60.5H90.459ZM96.3789 60.6094C95.9323 60.6094 95.529 60.5228 95.1689 60.3496C94.8089 60.1764 94.5241 59.9303 94.3145 59.6113C94.1048 59.2878 94 58.9004 94 58.4492C94 57.9707 94.1299 57.5628 94.3896 57.2256C94.6494 56.8883 95.0254 56.6331 95.5176 56.46C96.0098 56.2822 96.6068 56.1934 97.3086 56.1934H98.8125V57.1367H97.3906C96.6751 57.1367 96.1214 57.2507 95.7295 57.4785C95.3421 57.7064 95.1484 58.0299 95.1484 58.4492C95.1484 58.6908 95.21 58.8981 95.333 59.0713C95.4561 59.2399 95.6201 59.3698 95.8252 59.4609C96.0348 59.5521 96.265 59.5977 96.5156 59.5977C96.8164 59.5977 97.1263 59.5316 97.4453 59.3994C97.7689 59.2627 98.04 59.0667 98.2588 58.8115C98.4821 58.5518 98.5938 58.235 98.5938 57.8613V57.1094L98.5664 56.6855V55.8789C98.5664 55.7604 98.5573 55.61 98.5391 55.4277C98.5208 55.2409 98.4661 55.0563 98.375 54.874C98.2884 54.6917 98.1403 54.5391 97.9307 54.416C97.721 54.2884 97.4271 54.2246 97.0488 54.2246C96.8255 54.2246 96.584 54.2542 96.3242 54.3135C96.069 54.3682 95.8184 54.4456 95.5723 54.5459C95.3307 54.6462 95.1165 54.7624 94.9297 54.8945L94.4785 53.8418C94.7201 53.7005 94.9889 53.5775 95.2852 53.4727C95.5859 53.3633 95.8958 53.279 96.2148 53.2197C96.5384 53.1605 96.8529 53.1309 97.1582 53.1309C97.6504 53.1309 98.0583 53.2038 98.3818 53.3496C98.71 53.4954 98.9697 53.696 99.1611 53.9512C99.3525 54.2064 99.487 54.498 99.5645 54.8262C99.6465 55.1497 99.6875 55.4915 99.6875 55.8516V58.3945C99.6875 58.6999 99.7194 58.9414 99.7832 59.1191C99.8516 59.2969 99.9701 59.4199 100.139 59.4883L100.275 59.543L99.8242 60.6094L99.6328 60.5273C99.3776 60.418 99.1589 60.2562 98.9766 60.042C98.7943 59.8278 98.7031 59.6159 98.7031 59.4062L98.9355 59.4883H98.4844L98.7852 59.2969C98.6074 59.6569 98.3044 59.9668 97.876 60.2266C97.4521 60.4818 96.9531 60.6094 96.3789 60.6094ZM101.738 60.5V53.2539H102.914V54.1152H103.133L102.627 54.7578C102.8 54.252 103.087 53.8577 103.488 53.5752C103.894 53.2881 104.363 53.1445 104.896 53.1445C105.443 53.1445 105.904 53.2858 106.277 53.5684C106.656 53.8509 106.906 54.2109 107.029 54.6484L106.496 54.1699H107.248L106.605 54.6484C106.806 54.1426 107.13 53.7666 107.576 53.5205C108.027 53.2699 108.515 53.1445 109.039 53.1445C109.445 53.1445 109.802 53.2129 110.112 53.3496C110.422 53.4818 110.682 53.6686 110.892 53.9102C111.101 54.1471 111.258 54.4251 111.363 54.7441C111.473 55.0632 111.527 55.4049 111.527 55.7695V60.5H110.352V56.0156C110.352 55.4277 110.213 54.9857 109.935 54.6895C109.661 54.3887 109.299 54.2383 108.848 54.2383C108.561 54.2383 108.294 54.3044 108.048 54.4365C107.802 54.5641 107.601 54.7601 107.446 55.0244C107.296 55.2842 107.221 55.6146 107.221 56.0156V60.5H106.045V56.0156C106.045 55.4277 105.904 54.9857 105.621 54.6895C105.343 54.3887 104.979 54.2383 104.527 54.2383C104.099 54.2383 103.723 54.391 103.399 54.6963C103.076 54.9971 102.914 55.4551 102.914 56.0703V60.5H101.738ZM113.428 60.5V53.2539H114.604V60.5H113.428ZM114.016 52.0918C113.765 52.0918 113.553 52.0052 113.38 51.832C113.211 51.6589 113.127 51.4492 113.127 51.2031C113.127 50.957 113.211 50.7474 113.38 50.5742C113.553 50.401 113.765 50.3145 114.016 50.3145C114.262 50.3145 114.471 50.401 114.645 50.5742C114.818 50.7474 114.904 50.957 114.904 51.2031C114.904 51.4492 114.818 51.6589 114.645 51.832C114.471 52.0052 114.262 52.0918 114.016 52.0918ZM118.09 60.6094C117.748 60.6094 117.468 60.5387 117.249 60.3975C117.035 60.2516 116.875 60.042 116.771 59.7686C116.666 59.4906 116.613 59.1556 116.613 58.7637V49.9727H117.789V58.791C117.789 58.8822 117.796 58.9847 117.81 59.0986C117.828 59.2126 117.873 59.3105 117.946 59.3926C118.019 59.4746 118.145 59.5156 118.322 59.5156C118.377 59.5156 118.432 59.5111 118.486 59.502C118.541 59.4883 118.596 59.4746 118.65 59.4609V60.5273C118.582 60.5547 118.498 60.5752 118.397 60.5889C118.297 60.6025 118.195 60.6094 118.09 60.6094ZM120.701 63.4805C120.423 63.4805 120.163 63.4486 119.922 63.3848C119.68 63.321 119.512 63.2617 119.416 63.207L119.867 62.1406C120.013 62.2135 120.163 62.2728 120.318 62.3184C120.473 62.3639 120.615 62.3867 120.742 62.3867C121.02 62.3913 121.248 62.3229 121.426 62.1816C121.608 62.0449 121.749 61.8831 121.85 61.6963C121.95 61.514 122.023 61.3568 122.068 61.2246L122.438 60.1309L122.465 60.8418L119.307 53.2539H120.592L122.301 57.6699L122.861 59.1602H122.916L123.422 57.6699L124.98 53.2539H126.225L123.107 61.5117C123.048 61.6758 122.962 61.8672 122.848 62.0859C122.738 62.3092 122.592 62.5257 122.41 62.7354C122.228 62.9495 121.998 63.1273 121.72 63.2686C121.442 63.4098 121.102 63.4805 120.701 63.4805Z" fill="black"/></svg>',
        ];
        return $array_list[$icon];
    }
endif;