<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */

function optionsframework_option_name() {

	// This gets the theme name from the stylesheet
	$themename = wp_get_theme();
	$themename = preg_replace("/\W/", "_", strtolower($themename) );

	$optionsframework_settings = get_option( 'optionsframework' );
	$optionsframework_settings['id'] = $themename;
	update_option( 'optionsframework', $optionsframework_settings );
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'options_framework_theme'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {

	// Background Defaults
	$background_defaults = array(
		'color' => '',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top center',
		'attachment'=>'scroll' );

	// Pull all the categories into an array
	$options_categories = array();
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
		$options_categories[$category->cat_ID] = $category->cat_name;
	}
	// Pull all tags into an array
	$options_tags = array();
	$options_tags_obj = get_tags();
	foreach ( $options_tags_obj as $tag ) {
		$options_tags[$tag->term_id] = $tag->name;
	}

	// If using image radio buttons, define a directory path
	$imagepath =  get_template_directory_uri() . '/inc/images/';
	$set_year = date('Y');
	$options = array();

	/* General Settings */	
	
	$options[] = array(
		'name' => __('General Settings', 'yume-tan'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Header Logo Text', 'yume-tan'),
		'desc' => '',
		'id' => 'header_logo_text1',
		'std' => '',
		'class' => 'mini', 
		'type' => 'text');	

	$options[] = array(
		'name' => __('Header Logo Text 2', 'yume-tan'),
		'desc' => '',
		'id' => 'header_logo_text2',
		'std' => '',
		'class' => 'mini', 
		'type' => 'text');			
		
	$options[] = array(
		'name' => __('Header Logo Image', 'yume-tan'),
		'desc' => '',
		'id' => 'logo_image',
		'type' => 'upload');
		
	$options[] = array(
		'name' => __('Fav Icon URL', 'yume-tan'),
		'desc' => '',
		'id' => 'fav_icon',
		'type' => 'upload');

	$options[] = array(
		'name' => __('Web Clip Icon URL', 'yume-tan'),
		'desc' => '',
		'id' => 'web_clip',
		'type' => 'upload');
		
	$options[] = array(
		'name' => "Default Layout",
		'desc' => "",
		'id' => "default_layout",
		'std' => "right",
		'type' => "images",
		'options' => array(
			'none' => $imagepath . '1col.png',
			'left' => $imagepath . '2cl.png',
			'right' => $imagepath . '2cr.png')
	);	
	
	$options[] = array(
		'name' => __('Footer copyright text left', 'yume-tan'),
		'desc' => '',
		'id' => 'footer_text_left',
		'std' => __('Copyright &copy; '.$set_year.' '.get_bloginfo('name'), 'yume-tan'),
		'type' => 'text');	
		
	return $options;
}