<?php
/**
 * Theme functions.
 */

function yogafitness_enqueue() {
	wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'yogafitness_enqueue' );

function yogafitness_customizer ( $wp_customize ) {

	//Services
	$wp_customize->add_section('yogafitness_service_section',array(
		'title'	=> __('Services Section','yogafitness'),
		'description'=> __('This section will appear below the Services','yogafitness'),
		'panel' => 'the_wp_fitness_panel_id',
	));

	$wp_customize->add_setting('yogafitness_service_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	
	$wp_customize->add_control('yogafitness_service_title',array(
		'label'	=> __('Section Title','yogafitness'),
		'section'=> 'yogafitness_service_section',
		'setting'=> 'yogafitness_service_title',
		'type'=> 'text'
	));	

	$categories = get_categories();
	$cats = array();
	$i = 0;
	foreach($categories as $category){
	if($i==0){
	$default = $category->slug;
	$i++;
	}
	$cats[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('yogafitness_left_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'sanitize_text_field',
	));

	$wp_customize->add_control('yogafitness_left_category',array(
		'type'    => 'select',
		'choices' => $cats,
		'label' => __('Select Category For LeftSide','yogafitness'),
		'section' => 'yogafitness_service_section',
	));

	$post_list = get_posts();
		$i = 0;
		foreach($post_list as $post){
			$posts[$post->post_title] = $post->post_title;
	}

	$wp_customize->add_setting('yogafitness_image_post',array(
		'sanitize_callback' => 'sanitize_text_field',
	));

	$wp_customize->add_control('yogafitness_image_post',array(
		'type'    => 'select',
		'choices' => $posts,
		'label' => __('Select post','yogafitness'),
		'section' => 'yogafitness_service_section',
	));

	$categories = get_categories();
	$cats = array();
	$i = 0;
	foreach($categories as $category){
	if($i==0){
	$default = $category->slug;
	$i++;
	}
	$cats[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('yogafitness_right_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'sanitize_text_field',
	));

	$wp_customize->add_control('yogafitness_right_category',array(
		'type'    => 'select',
		'choices' => $cats,
		'label' => __('Select Category For RightSide','yogafitness'),
		'section' => 'yogafitness_service_section',
	));

	//Footer
	$wp_customize->add_section('yogafitness_footer_section',array(
		'title'	=> __('Footer Text','yogafitness'),
		'description'=> __('Add the Copyright Text Here','yogafitness'),
		'panel' => 'the_wp_fitness_panel_id',
	));

	$wp_customize->add_setting('yogafitness_footer_copy',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	
	$wp_customize->add_control('yogafitness_footer_copy',array(
		'label'	=> __('Copyright Text','yogafitness'),
		'section'=> 'yogafitness_footer_section',
		'setting'=> 'yogafitness_footer_copy',
		'type'=> 'text'
	));	

}

add_action( 'customize_register', 'yogafitness_customizer' );

define('yogafitness_TOURS_CREDIT','https://wordpress.org','yogafitness');

if ( ! function_exists( 'yogafitness_tours_credit' ) ) {
	function yogafitness_tours_credit(){
			echo "<a href=".esc_url(yogafitness_TOURS_CREDIT)." target='_blank' rel='nofollow'>wordpress.org</a>";
	}
}

?>