<?php 
// Typography section for theme
function yala_blog_customize_fonts( $wp_customize ) {

 $wp_customize->add_panel(
        'yala_blog_child_settings_panel',
        array(
            'priority'       => 40,
            'capability'     => 'edit_theme_options',
            'theme_supports' => '',
            'title'          => __( 'Google Font Selection', 'yala-blog' ),
        )
    );

  $wp_customize->add_section('typography' , array(
    'priority' => 1,
    'panel' => 'yala_blog_child_settings_panel',
    'title' => __('Typography','yala-blog'),
  ));

  // Setting Typography for theme.
  $wp_customize->add_setting( 'google_fontfamily_setting', array(
    'capability'        => 'edit_theme_options',
    'default'           => __('Open Sans','yala-blog'),
    'sanitize_callback' => 'yala_blog_sanitize_select'
  ) );

  $wp_customize->add_control( 'google_fontfamily_setting', array(
    'settings'              => 'google_fontfamily_setting',
    'label'                 =>  __( 'Select font for theme', 'yala-blog' ),
    'section'               => 'typography',
    'type'                  => 'select',
    'choices'               => yala_blog_get_fonts(),
  ) );


  // Setting Typography for theme.
  $wp_customize->add_setting( 'title_google_fontfamily_setting', array(
    'capability'        => 'edit_theme_options',
    'default'           => __('Open Sans','yala-blog'),
    'sanitize_callback' => 'yala_blog_sanitize_select'
  ) );

  $wp_customize->add_control( 'title_google_fontfamily_setting', array(
    'settings'              => 'title_google_fontfamily_setting',
    'label'                 =>  __( 'Select font for heading and title', 'yala-blog' ),
    'section'               => 'typography',
    'type'                  => 'select',
    'choices'               => yala_blog_get_fonts(),
  ) );

  // Setting Typography for theme.
  $wp_customize->add_setting( 'description_google_fontfamily_setting', array(
    'capability'        => 'edit_theme_options',
    'default'           => __('Open Sans','yala-blog'),
    'sanitize_callback' => 'yala_blog_sanitize_select'
  ) );

  $wp_customize->add_control( 'description_google_fontfamily_setting', array(
    'settings'              => 'description_google_fontfamily_setting',
    'label'                 =>  __( 'Select font for Paragrah and Description', 'yala-blog' ),
    'section'               => 'typography',
    'type'                  => 'select',
    'choices'               => yala_blog_get_fonts(),
  ) );

}

add_action( 'customize_register', 'yala_blog_customize_fonts' );
/**
 * This contains regular fonts
 *
 * @package  Yala_Mag
 */
function yala_blog_get_fonts() { 
	return apply_filters (
		'fonts_array',  array(
			'ABeeZee' => __('ABeeZee, Google', 'yala-blog'),
			'Abel' => __('Abel, Google ', 'yala-blog'),
			'Abril Fatface' => __('Abril Fatface, Google ', 'yala-blog'),
			'Aclonica' => __('Aclonica, Google ', 'yala-blog'),
			'Acme' => __('Acme, Google ', 'yala-blog'),
			'Actor' => __('Actor, Google ', 'yala-blog'),
			'Adamina' => __('Adamina, Google ', 'yala-blog'),
			'Advent Pro' => __('Advent Pro, Google ', 'yala-blog'),
			'Aguafina Script' => __('Aguafina Script, Google ', 'yala-blog'),
			'Akronim' => __('Akronim, Google ', 'yala-blog'),
			'Aladin' => __('Aladin, Google ', 'yala-blog'),
			'Aldrich' => __('Aldrich, Google ', 'yala-blog'),
			'Alef' => __('Alef, Google ', 'yala-blog'),
			'Alegreya' => __('Alegreya, Google ', 'yala-blog'),
			'Alegreya SC' => __('Alegreya SC, Google ', 'yala-blog'),
			'Alegreya Sans' => __('Alegreya Sans, Google ', 'yala-blog'),
			'Alegreya Sans SC' => __('Alegreya Sans SC, Google ', 'yala-blog'),
			'Alex Brush' => __('Alex Brush, Google ', 'yala-blog'),
			'Alfa Slab One' => __('Alfa Slab One, Google ', 'yala-blog'),
			'Alice' => __('Alice, Google ', 'yala-blog'),
			'Alike' => __('Alike, Google ', 'yala-blog'),
			'Alike Angular' => __('Alike Angular, Google ', 'yala-blog'),
			'Allan' => __('Allan, Google ', 'yala-blog'),
			'Allerta' => __('Allerta, Google ', 'yala-blog'),
			'Allerta Stencil' => __('Allerta Stencil, Google ', 'yala-blog'),
			'Allura' => __('Allura, Google ', 'yala-blog'),
			'Almendra' => __('Almendra, Google ', 'yala-blog'),
			'Almendra Display' => __('Almendra Display, Google ', 'yala-blog'),
			'Almendra SC' => __('Almendra SC, Google ', 'yala-blog'),
			'Amarante' => __('Amarante, Google ', 'yala-blog'),
			'Amaranth' => __('Amaranth, Google ', 'yala-blog'),
			'Amatic SC' => __('Amatic SC, Google ', 'yala-blog'),
			'Amethysta' => __('Amethysta, Google ', 'yala-blog'),
			'Anaheim' => __('Anaheim, Google ', 'yala-blog'),
			'Andada' => __('Andada, Google ', 'yala-blog'),
			'Andika' => __('Andika, Google ', 'yala-blog'),
			'Angkor' => __('Angkor, Google ', 'yala-blog'),
			'Annie Use Your Telescope' => __('Annie Use Your Telescope, Google ', 'yala-blog'),
			'Anonymous Pro' => __('Anonymous Pro, Google ', 'yala-blog'),
			'Antic' => __('Antic, Google ', 'yala-blog'),
			'Antic Didone' => __('Antic Didone, Google ', 'yala-blog'),
			'Antic Slab' => __('Antic Slab, Google ', 'yala-blog'),
			'Anton' => __('Anton, Google ', 'yala-blog'),
			'Arapey' => __('Arapey, Google ', 'yala-blog'),
			'Arbutus' => __('Arbutus, Google ', 'yala-blog'),
			'Arbutus Slab' => __('Arbutus Slab, Google ', 'yala-blog'),
			'Architects Daughter' => __('Architects Daughter, Google ', 'yala-blog'),
			'Archivo Black' => __('Archivo Black, Google ', 'yala-blog'),
			'Archivo Narrow' => __('Archivo Narrow, Google ', 'yala-blog'),
			'Arimo' => __('Arimo, Google ', 'yala-blog'),
			'Arizonia' => __('Arizonia, Google ', 'yala-blog'),
			'Armata' => __('Armata, Google ', 'yala-blog'),
			'Artifika' => __('Artifika, Google ', 'yala-blog'),
			'Arvo' => __('Arvo, Google ', 'yala-blog'),
			'Asap' => __('Asap, Google ', 'yala-blog'),
			'Asset' => __('Asset, Google ', 'yala-blog'),
			'Astloch' => __('Astloch, Google ', 'yala-blog'),
			'Asul' => __('Asul, Google ', 'yala-blog'),
			'Atomic Age' => __('Atomic Age, Google ', 'yala-blog'),
			'Aubrey' => __('Aubrey, Google ', 'yala-blog'),
			'Audiowide' => __('Audiowide, Google ', 'yala-blog'),
			'Autour One' => __('Autour One, Google ', 'yala-blog'),
			'Average' => __('Average, Google ', 'yala-blog'),
			'Average Sans' => __('Average Sans, Google ', 'yala-blog'),
			'Averia Gruesa Libre' => __('Averia Gruesa Libre, Google ', 'yala-blog'),
			'Averia Libre' => __('Averia Libre, Google ', 'yala-blog'),
			'Averia Sans Libre' => __('Averia Sans Libre, Google ', 'yala-blog'),
			'Averia Serif Libre' => __('Averia Serif Libre, Google ', 'yala-blog'),
			'Bad Script' => __('Bad Script, Google ', 'yala-blog'),
			'Balthazar' => __('Balthazar, Google ', 'yala-blog'),
			'Bangers' => __('Bangers, Google ', 'yala-blog'),
			'Basic' => __('Basic, Google ', 'yala-blog'),
			'Battambang' => __('Battambang, Google ', 'yala-blog'),
			'Baumans' => __('Baumans, Google ', 'yala-blog'),
			'Bayon' => __('Bayon, Google ', 'yala-blog'),
			'Belgrano' => __('Belgrano, Google ', 'yala-blog'),
			'Belleza' => __('Belleza, Google ', 'yala-blog'),
			'BenchNine' => __('BenchNine, Google ', 'yala-blog'),
			'Bentham' => __('Bentham, Google ', 'yala-blog'),
			'Berkshire Swash' => __('Berkshire Swash, Google ', 'yala-blog'),
			'Bevan' => __('Bevan, Google ', 'yala-blog'),
			'Bigelow Rules' => __('Bigelow Rules, Google ', 'yala-blog'),
			'Bigshot One' => __('Bigshot One, Google ', 'yala-blog'),
			'Bilbo' => __('Bilbo, Google ', 'yala-blog'),
			'Bilbo Swash Caps' => __('Bilbo Swash Caps, Google ', 'yala-blog'),
			'Bitter' => __('Bitter, Google ', 'yala-blog'),
			'Black Ops One' => __('Black Ops One, Google ', 'yala-blog'),
			'Bokor' => __('Bokor, Google ', 'yala-blog'),
			'Bonbon' => __('Bonbon, Google ', 'yala-blog'),
			'Boogaloo' => __('Boogaloo, Google ', 'yala-blog'),
			'Bowlby One' => __('Bowlby One, Google ', 'yala-blog'),
			'Bowlby One SC' => __('Bowlby One SC, Google ', 'yala-blog'),
			'Brawler' => __('Brawler, Google ', 'yala-blog'),
			'Bree Serif' => __('Bree Serif, Google ', 'yala-blog'),
			'Bubblegum Sans' => __('Bubblegum Sans, Google ', 'yala-blog'),
			'Bubbler One' => __('Bubbler One, Google ', 'yala-blog'),
			'Buda' => __('Buda, Google ', 'yala-blog'),
			'Buenard' => __('Buenard, Google ', 'yala-blog'),
			'Butcherman' => __('Butcherman, Google ', 'yala-blog'),
			'Butterfly Kids' => __('Butterfly Kids, Google ', 'yala-blog'),
			'Cabin' => __('Cabin, Google ', 'yala-blog'),
			'Cabin Condensed' => __('Cabin Condensed, Google ', 'yala-blog'),
			'Cabin Sketch' => __('Cabin Sketch, Google ', 'yala-blog'),
			'Caesar Dressing' => __('Caesar Dressing, Google ', 'yala-blog'),
			'Cagliostro' => __('Cagliostro, Google ', 'yala-blog'),
			'Calligraffitti' => __('Calligraffitti, Google ', 'yala-blog'),
			'Cambo' => __('Cambo, Google ', 'yala-blog'),
			'Candal' => __('Candal, Google ', 'yala-blog'),
			'Cantarell' => __('Cantarell, Google ', 'yala-blog'),
			'Cantata One' => __('Cantata One, Google ', 'yala-blog'),
			'Cantora One' => __('Cantora One, Google ', 'yala-blog'),
			'Capriola' => __('Capriola, Google ', 'yala-blog'),
			'Cardo' => __('Cardo, Google ', 'yala-blog'),
			'Carme' => __('Carme, Google ', 'yala-blog'),
			'Carrois Gothic' => __('Carrois Gothic, Google ', 'yala-blog'),
			'Carrois Gothic SC' => __('Carrois Gothic SC, Google ', 'yala-blog'),
			'Carter One' => __('Carter One, Google ', 'yala-blog'),
			'Caudex' => __('Caudex, Google ', 'yala-blog'),
			'Cedarville Cursive' => __('Cedarville Cursive, Google ', 'yala-blog'),
			'Ceviche One' => __('Ceviche One, Google ', 'yala-blog'),
			'Changa One' => __('Changa One, Google ', 'yala-blog'),
			'Chango' => __('Chango, Google ', 'yala-blog'),
			'Chau Philomene One' => __('Chau Philomene One, Google ', 'yala-blog'),
			'Chela One' => __('Chela One, Google ', 'yala-blog'),
			'Chelsea Market' => __('Chelsea Market, Google ', 'yala-blog'),
			'Chenla' => __('Chenla, Google ', 'yala-blog'),
			'Cherry Cream Soda' => __('Cherry Cream Soda, Google ', 'yala-blog'),
			'Cherry Swash' => __('Cherry Swash, Google ', 'yala-blog'),
			'Chewy' => __('Chewy, Google ', 'yala-blog'),
			'Chicle' => __('Chicle, Google ', 'yala-blog'),
			'Chivo' => __('Chivo, Google ', 'yala-blog'),
			'Cinzel' => __('Cinzel, Google ', 'yala-blog'),
			'Cinzel Decorative' => __('Cinzel Decorative, Google ', 'yala-blog'),
			'Clicker Script' => __('Clicker Script, Google ', 'yala-blog'),
			'Coda' => __('Coda, Google ', 'yala-blog'),
			'Coda Caption' => __('Coda Caption, Google ', 'yala-blog'),
			'Codystar' => __('Codystar, Google ', 'yala-blog'),
			'Combo' => __('Combo, Google ', 'yala-blog'),
			'Comfortaa' => __('Comfortaa, Google ', 'yala-blog'),
			'Coming Soon' => __('Coming Soon, Google ', 'yala-blog'),
			'Concert One' => __('Concert One, Google ', 'yala-blog'),
			'Condiment' => __('Condiment, Google ', 'yala-blog'),
			'Content' => __('Content, Google ', 'yala-blog'),
			'Contrail One' => __('Contrail One, Google ', 'yala-blog'),
			'Convergence' => __('Convergence, Google ', 'yala-blog'),
			'Cookie' => __('Cookie, Google ', 'yala-blog'),
			'Copse' => __('Copse, Google ', 'yala-blog'),
			'Corben' => __('Corben, Google ', 'yala-blog'),
			'Courgette' => __('Courgette, Google ', 'yala-blog'),
			'Cousine' => __('Cousine, Google ', 'yala-blog'),
			'Coustard' => __('Coustard, Google ', 'yala-blog'),
			'Covered By Your Grace' => __('Covered By Your Grace, Google ', 'yala-blog'),
			'Crafty Girls' => __('Crafty Girls, Google ', 'yala-blog'),
			'Creepster' => __('Creepster, Google ', 'yala-blog'),
			'Crete Round' => __('Crete Round, Google ', 'yala-blog'),
			'Crimson Text' => __('Crimson Text, Google ', 'yala-blog'),
			'Croissant One' => __('Croissant One, Google ', 'yala-blog'),
			'Crushed' => __('Crushed, Google ', 'yala-blog'),
			'Cuprum' => __('Cuprum, Google ', 'yala-blog'),
			'Cutive' => __('Cutive, Google ', 'yala-blog'),
			'Cutive Mono' => __('Cutive Mono, Google ', 'yala-blog'),
			'Damion' => __('Damion, Google ', 'yala-blog'),
			'Dancing Script' => __('Dancing Script, Google ', 'yala-blog'),
			'Dangrek' => __('Dangrek, Google ', 'yala-blog'),
			'Dawning of a New Day' => __('Dawning of a New Day, Google ', 'yala-blog'),
			'Days One' => __('Days One, Google ', 'yala-blog'),
			'Delius' => __('Delius, Google ', 'yala-blog'),
			'Delius Swash Caps' => __('Delius Swash Caps, Google ', 'yala-blog'),
			'Delius Unicase' => __('Delius Unicase, Google ', 'yala-blog'),
			'Della Respira' => __('Della Respira, Google ', 'yala-blog'),
			'Denk One' => __('Denk One, Google ', 'yala-blog'),
			'Devonshire' => __('Devonshire, Google ', 'yala-blog'),
			'Didact Gothic' => __('Didact Gothic, Google ', 'yala-blog'),
			'Diplomata' => __('Diplomata, Google ', 'yala-blog'),
			'Diplomata SC' => __('Diplomata SC, Google ', 'yala-blog'),
			'Domine' => __('Domine, Google ', 'yala-blog'),
			'Donegal One' => __('Donegal One, Google ', 'yala-blog'),
			'Doppio One' => __('Doppio One, Google ', 'yala-blog'),
			'Dorsa' => __('Dorsa, Google ', 'yala-blog'),
			'Dosis' => __('Dosis, Google ', 'yala-blog'),
			'Dr Sugiyama' => __('Dr Sugiyama, Google ', 'yala-blog'),
			'Droid Sans' => __('Droid Sans, Google ', 'yala-blog'),
			'Droid Sans Mono' => __('Droid Sans Mono, Google ', 'yala-blog'),
			'Droid Serif' => __('Droid Serif, Google ', 'yala-blog'),
			'Duru Sans' => __('Duru Sans, Google ', 'yala-blog'),
			'Dynalight' => __('Dynalight, Google ', 'yala-blog'),
			'EB Garamond' => __('EB Garamond, Google ', 'yala-blog'),
			'Eagle Lake' => __('Eagle Lake, Google ', 'yala-blog'),
			'Eater' => __('Eater, Google ', 'yala-blog'),
			'Economica' => __('Economica, Google ', 'yala-blog'),
			'Ek Mukta' => __('Ek Mukta, Google ', 'yala-blog'),
			'Electrolize' => __('Electrolize, Google ', 'yala-blog'),
			'Elsie' => __('Elsie, Google ', 'yala-blog'),
			'Elsie Swash Caps' => __('Elsie Swash Caps, Google ', 'yala-blog'),
			'Emblema One' => __('Emblema One, Google ', 'yala-blog'),
			'Emilys Candy' => __('Emilys Candy, Google ', 'yala-blog'),
			'Engagement' => __('Engagement, Google ', 'yala-blog'),
			'Englebert' => __('Englebert, Google ', 'yala-blog'),
			'Enriqueta' => __('Enriqueta, Google ', 'yala-blog'),
			'Erica One' => __('Erica One, Google ', 'yala-blog'),
			'Esteban' => __('Esteban, Google ', 'yala-blog'),
			'Euphoria Script' => __('Euphoria Script, Google ', 'yala-blog'),
			'Ewert' => __('Ewert, Google ', 'yala-blog'),
			'Exo' => __('Exo, Google ', 'yala-blog'),
			'Exo 2' => __('Exo 2, Google ', 'yala-blog'),
			'Expletus Sans' => __('Expletus Sans, Google ', 'yala-blog'),
			'Fanwood Text' => __('Fanwood Text, Google ', 'yala-blog'),
			'Fascinate' => __('Fascinate, Google ', 'yala-blog'),
			'Fascinate Inline' => __('Fascinate Inline, Google ', 'yala-blog'),
			'Faster One' => __('Faster One, Google ', 'yala-blog'),
			'Fasthand' => __('Fasthand, Google ', 'yala-blog'),
			'Fauna One' => __('Fauna One, Google ', 'yala-blog'),
			'Federant' => __('Federant, Google ', 'yala-blog'),
			'Federo' => __('Federo, Google ', 'yala-blog'),
			'Felipa' => __('Felipa, Google ', 'yala-blog'),
			'Fenix' => __('Fenix, Google ', 'yala-blog'),
			'Finger Paint' => __('Finger Paint, Google ', 'yala-blog'),
			'Fira Mono' => __('Fira Mono, Google ', 'yala-blog'),
			'Fira Sans' => __('Fira Sans, Google ', 'yala-blog'),
			'Fjalla One' => __('Fjalla One, Google ', 'yala-blog'),
			'Fjord One' => __('Fjord One, Google ', 'yala-blog'),
			'Flamenco' => __('Flamenco, Google ', 'yala-blog'),
			'Flavors' => __('Flavors, Google ', 'yala-blog'),
			'Fondamento' => __('Fondamento, Google ', 'yala-blog'),
			'Fontdiner Swanky' => __('Fontdiner Swanky, Google ', 'yala-blog'),
			'Forum' => __('Forum, Google ', 'yala-blog'),
			'Francois One' => __('Francois One, Google ', 'yala-blog'),
			'Freckle Face' => __('Freckle Face, Google ', 'yala-blog'),
			'Fredericka the Great' => __('Fredericka the Great, Google ', 'yala-blog'),
			'Fredoka One' => __('Fredoka One, Google ', 'yala-blog'),
			'Freehand' => __('Freehand, Google ', 'yala-blog'),
			'Fresca' => __('Fresca, Google ', 'yala-blog'),
			'Frijole' => __('Frijole, Google ', 'yala-blog'),
			'Fruktur' => __('Fruktur, Google ', 'yala-blog'),
			'Fugaz One' => __('Fugaz One, Google ', 'yala-blog'),
			'GFS Didot' => __('GFS Didot, Google ', 'yala-blog'),
			'GFS Neohellenic' => __('GFS Neohellenic, Google ', 'yala-blog'),
			'Gabriela' => __('Gabriela, Google ', 'yala-blog'),
			'Gafata' => __('Gafata, Google ', 'yala-blog'),
			'Galdeano' => __('Galdeano, Google ', 'yala-blog'),
			'Galindo' => __('Galindo, Google ', 'yala-blog'),
			'Gentium Basic' => __('Gentium Basic, Google ', 'yala-blog'),
			'Gentium Book Basic' => __('Gentium Book Basic, Google ', 'yala-blog'),
			'Geo' => __('Geo, Google ', 'yala-blog'),
			'Geostar' => __('Geostar, Google ', 'yala-blog'),
			'Geostar Fill' => __('Geostar Fill, Google ', 'yala-blog'),
			'Germania One' => __('Germania One, Google ', 'yala-blog'),
			'Gilda Display' => __('Gilda Display, Google ', 'yala-blog'),
			'Give You Glory' => __('Give You Glory, Google ', 'yala-blog'),
			'Glass Antiqua' => __('Glass Antiqua, Google ', 'yala-blog'),
			'Glegoo' => __('Glegoo, Google ', 'yala-blog'),
			'Gloria Hallelujah' => __('Gloria Hallelujah, Google ', 'yala-blog'),
			'Goblin One' => __('Goblin One, Google ', 'yala-blog'),
			'Gochi Hand' => __('Gochi Hand, Google ', 'yala-blog'),
			'Gorditas' => __('Gorditas, Google ', 'yala-blog'),
			'Goudy Bookletter 1911' => __('Goudy Bookletter 1911, Google ', 'yala-blog'),
			'Graduate' => __('Graduate, Google ', 'yala-blog'),
			'Grand Hotel' => __('Grand Hotel, Google ', 'yala-blog'),
			'Gravitas One' => __('Gravitas One, Google ', 'yala-blog'),
			'Great Vibes' => __('Great Vibes, Google ', 'yala-blog'),
			'Griffy' => __('Griffy, Google ', 'yala-blog'),
			'Gruppo' => __('Gruppo, Google ', 'yala-blog'),
			'Gudea' => __('Gudea, Google ', 'yala-blog'),
			'Habibi' => __('Habibi, Google ', 'yala-blog'),
			'Hammersmith One' => __('Hammersmith One, Google ', 'yala-blog'),
			'Hanalei' => __('Hanalei, Google ', 'yala-blog'),
			'Hanalei Fill' => __('Hanalei Fill, Google ', 'yala-blog'),
			'Handlee' => __('Handlee, Google ', 'yala-blog'),
			'Hanuman' => __('Hanuman, Google ', 'yala-blog'),
			'Happy Monkey' => __('Happy Monkey, Google ', 'yala-blog'),
			'Headland One' => __('Headland One, Google ', 'yala-blog'),
			'Henny Penny' => __('Henny Penny, Google ', 'yala-blog'),
			'Herr Von Muellerhoff' => __('Herr Von Muellerhoff, Google ', 'yala-blog'),
			'Holtwood One SC' => __('Holtwood One SC, Google ', 'yala-blog'),
			'Homemade Apple' => __('Homemade Apple, Google ', 'yala-blog'),
			'Homenaje' => __('Homenaje, Google ', 'yala-blog'),
			'IM Fell DW Pica' => __('IM Fell DW Pica, Google ', 'yala-blog'),
			'IM Fell DW Pica SC' => __('IM Fell DW Pica SC, Google ', 'yala-blog'),
			'IM Fell Double Pica' => __('IM Fell Double Pica, Google ', 'yala-blog'),
			'IM Fell Double Pica SC' => __('IM Fell Double Pica SC, Google ', 'yala-blog'),
			'IM Fell English' => __('IM Fell English, Google ', 'yala-blog'),
			'IM Fell English SC' => __('IM Fell English SC, Google ', 'yala-blog'),
			'IM Fell French Canon' => __('IM Fell French Canon, Google ', 'yala-blog'),
			'IM Fell French Canon SC' => __('IM Fell French Canon SC, Google ', 'yala-blog'),
			'IM Fell Great Primer' => __('IM Fell Great Primer, Google ', 'yala-blog'),
			'IM Fell Great Primer SC' => __('IM Fell Great Primer SC, Google ', 'yala-blog'),
			'Iceberg' => __('Iceberg, Google ', 'yala-blog'),
			'Iceland' => __('Iceland, Google ', 'yala-blog'),
			'Imprima' => __('Imprima, Google ', 'yala-blog'),
			'Inconsolata' => __('Inconsolata, Google ', 'yala-blog'),
			'Inder' => __('Inder, Google ', 'yala-blog'),
			'Indie Flower' => __('Indie Flower, Google ', 'yala-blog'),
			'Inika' => __('Inika, Google ', 'yala-blog'),
			'Irish Grover' => __('Irish Grover, Google ', 'yala-blog'),
			'Istok Web' => __('Istok Web, Google ', 'yala-blog'),
			'Italiana' => __('Italiana, Google ', 'yala-blog'),
			'Italianno' => __('Italianno, Google ', 'yala-blog'),
			'Jacques Francois' => __('Jacques Francois, Google ', 'yala-blog'),
			'Jacques Francois Shadow' => __('Jacques Francois Shadow, Google ', 'yala-blog'),
			'Jim Nightshade' => __('Jim Nightshade, Google ', 'yala-blog'),
			'Jockey One' => __('Jockey One, Google ', 'yala-blog'),
			'Jolly Lodger' => __('Jolly Lodger, Google ', 'yala-blog'),
			'Josefin Sans' => __('Josefin Sans, Google ', 'yala-blog'),
			'Josefin Slab' => __('Josefin Slab, Google ', 'yala-blog'),
			'Joti One' => __('Joti One, Google ', 'yala-blog'),
			'Judson' => __('Judson, Google ', 'yala-blog'),
			'Julee' => __('Julee, Google ', 'yala-blog'),
			'Julius Sans One' => __('Julius Sans One, Google ', 'yala-blog'),
			'Junge' => __('Junge, Google ', 'yala-blog'),
			'Jura' => __('Jura, Google ', 'yala-blog'),
			'Just Another Hand' => __('Just Another Hand, Google ', 'yala-blog'),
			'Just Me Again Down Here' => __('Just Me Again Down Here, Google ', 'yala-blog'),
			'Kameron' => __('Kameron, Google ', 'yala-blog'),
			'Kantumruy' => __('Kantumruy, Google ', 'yala-blog'),
			'Karla' => __('Karla, Google ', 'yala-blog'),
			'Kavoon' => __('Kavoon, Google ', 'yala-blog'),
			'Kdam Thmor' => __('Kdam Thmor, Google ', 'yala-blog'),
			'Keania One' => __('Keania One, Google ', 'yala-blog'),
			'Kelly Slab' => __('Kelly Slab, Google ', 'yala-blog'),
			'Kenia' => __('Kenia, Google ', 'yala-blog'),
			'Khmer' => __('Khmer, Google ', 'yala-blog'),
			'Kite One' => __('Kite One, Google ', 'yala-blog'),
			'Knewave' => __('Knewave, Google ', 'yala-blog'),
			'Kotta One' => __('Kotta One, Google ', 'yala-blog'),
			'Koulen' => __('Koulen, Google ', 'yala-blog'),
			'Kranky' => __('Kranky, Google ', 'yala-blog'),
			'Kreon' => __('Kreon, Google ', 'yala-blog'),
            'Kristi' => __('Kristi, Google ', 'yala-blog'),
            'Kaushan Script' => __('Kaushan Script, Google ', 'yala-blog'),
			'Krona One' => __('Krona One, Google ', 'yala-blog'),
			'La Belle Aurore' => __('La Belle Aurore, Google ', 'yala-blog'),
			'Lancelot' => __('Lancelot, Google ', 'yala-blog'),
			'Lato' => __('Lato, Google ', 'yala-blog'),
			'League Script' => __('League Script, Google ', 'yala-blog'),
			'Leckerli One' => __('Leckerli One, Google ', 'yala-blog'),
			'Ledger' => __('Ledger, Google ', 'yala-blog'),
			'Lekton' => __('Lekton, Google ', 'yala-blog'),
			'Lemon' => __('Lemon, Google ', 'yala-blog'),
			'Libre Baskerville' => __('Libre Baskerville, Google ', 'yala-blog'),
			'Life Savers' => __('Life Savers, Google ', 'yala-blog'),
			'Lilita One' => __('Lilita One, Google ', 'yala-blog'),
			'Lily Script One' => __('Lily Script One, Google ', 'yala-blog'),
			'Limelight' => __('Limelight, Google ', 'yala-blog'),
			'Linden Hill' => __('Linden Hill, Google ', 'yala-blog'),
			'Lobster' => __('Lobster, Google ', 'yala-blog'),
			'Lobster Two' => __('Lobster Two, Google ', 'yala-blog'),
			'Londrina Outline' => __('Londrina Outline, Google ', 'yala-blog'),
			'Londrina Shadow' => __('Londrina Shadow, Google ', 'yala-blog'),
			'Londrina Sketch' => __('Londrina Sketch, Google ', 'yala-blog'),
			'Londrina Solid' => __('Londrina Solid, Google ', 'yala-blog'),
			'Lora' => __('Lora, Google ', 'yala-blog'),
			'Love Ya Like A Sister' => __('Love Ya Like A Sister, Google ', 'yala-blog'),
			'Loved by the King' => __('Loved by the King, Google ', 'yala-blog'),
			'Lovers Quarrel' => __('Lovers Quarrel, Google ', 'yala-blog'),
			'Luckiest Guy' => __('Luckiest Guy, Google ', 'yala-blog'),
			'Lusitana' => __('Lusitana, Google ', 'yala-blog'),
			'Lustria' => __('Lustria, Google ', 'yala-blog'),
			'Macondo' => __('Macondo, Google ', 'yala-blog'),
			'Macondo Swash Caps' => __('Macondo Swash Caps, Google ', 'yala-blog'),
			'Magra' => __('Magra, Google ', 'yala-blog'),
			'Maiden Orange' => __('Maiden Orange, Google ', 'yala-blog'),
			'Mako' => __('Mako, Google ', 'yala-blog'),
			'Marcellus' => __('Marcellus, Google ', 'yala-blog'),
			'Marcellus SC' => __('Marcellus SC, Google ', 'yala-blog'),
			'Marck Script' => __('Marck Script, Google ', 'yala-blog'),
			'Margarine' => __('Margarine, Google ', 'yala-blog'),
			'Marko One' => __('Marko One, Google ', 'yala-blog'),
			'Marmelad' => __('Marmelad, Google ', 'yala-blog'),
			'Marvel' => __('Marvel, Google ', 'yala-blog'),
			'Mate' => __('Mate, Google ', 'yala-blog'),
			'Mate SC' => __('Mate SC, Google ', 'yala-blog'),
			'Maven Pro' => __('Maven Pro, Google ', 'yala-blog'),
			'McLaren' => __('McLaren, Google ', 'yala-blog'),
			'Meddon' => __('Meddon, Google ', 'yala-blog'),
			'MedievalSharp' => __('MedievalSharp, Google ', 'yala-blog'),
			'Medula One' => __('Medula One, Google ', 'yala-blog'),
			'Megrim' => __('Megrim, Google ', 'yala-blog'),
			'Meie Script' => __('Meie Script, Google ', 'yala-blog'),
			'Merienda' => __('Merienda, Google ', 'yala-blog'),
			'Merienda One' => __('Merienda One, Google ', 'yala-blog'),
			'Merriweather' => __('Merriweather, Google ', 'yala-blog'),
			'Merriweather Sans' => __('Merriweather Sans, Google ', 'yala-blog'),
			'Metal' => __('Metal, Google ', 'yala-blog'),
			'Metal Mania' => __('Metal Mania, Google ', 'yala-blog'),
			'Metamorphous' => __('Metamorphous, Google ', 'yala-blog'),
			'Metrophobic' => __('Metrophobic, Google ', 'yala-blog'),
			'Michroma' => __('Michroma, Google ', 'yala-blog'),
			'Milonga' => __('Milonga, Google ', 'yala-blog'),
			'Miltonian' => __('Miltonian, Google ', 'yala-blog'),
			'Miltonian Tattoo' => __('Miltonian Tattoo, Google ', 'yala-blog'),
			'Miniver' => __('Miniver, Google ', 'yala-blog'),
			'Miss Fajardose' => __('Miss Fajardose, Google ', 'yala-blog'),
			'Modern Antiqua' => __('Modern Antiqua, Google ', 'yala-blog'),
			'Molengo' => __('Molengo, Google ', 'yala-blog'),
			'Molle' => __('Molle, Google ', 'yala-blog'),
			'Monda' => __('Monda, Google ', 'yala-blog'),
			'Monofett' => __('Monofett, Google ', 'yala-blog'),
			'Monoton' => __('Monoton, Google ', 'yala-blog'),
			'Monsieur La Doulaise' => __('Monsieur La Doulaise, Google ', 'yala-blog'),
			'Montaga' => __('Montaga, Google ', 'yala-blog'),
			'Montez' => __('Montez, Google ', 'yala-blog'),
			'Montserrat' => __('Montserrat, Google ', 'yala-blog'),
			'Montserrat Alternates' => __('Montserrat Alternates, Google ', 'yala-blog'),
			'Montserrat Subrayada' => __('Montserrat Subrayada, Google ', 'yala-blog'),
			'Moul' => __('Moul, Google ', 'yala-blog'),
			'Moulpali' => __('Moulpali, Google ', 'yala-blog'),
			'Mountains of Christmas' => __('Mountains of Christmas, Google ', 'yala-blog'),
			'Mouse Memoirs' => __('Mouse Memoirs, Google ', 'yala-blog'),
			'Mr Bedfort' => __('Mr Bedfort, Google ', 'yala-blog'),
			'Mr Dafoe' => __('Mr Dafoe, Google ', 'yala-blog'),
			'Mr De Haviland' => __('Mr De Haviland, Google ', 'yala-blog'),
			'Mrs Saint Delafield' => __('Mrs Saint Delafield, Google ', 'yala-blog'),
			'Mrs Sheppards' => __('Mrs Sheppards, Google ', 'yala-blog'),
			'Muli' => __('Muli, Google ', 'yala-blog'),
			'Mystery Quest' => __('Mystery Quest, Google ', 'yala-blog'),
			'Neucha' => __('Neucha, Google ', 'yala-blog'),
			'Neuton' => __('Neuton, Google ', 'yala-blog'),
			'New Rocker' => __('New Rocker, Google ', 'yala-blog'),
			'News Cycle' => __('News Cycle, Google ', 'yala-blog'),
			'Niconne' => __('Niconne, Google ', 'yala-blog'),
			'Nixie One' => __('Nixie One, Google ', 'yala-blog'),
			'Nobile' => __('Nobile, Google ', 'yala-blog'),
			'Nokora' => __('Nokora, Google ', 'yala-blog'),
			'Norican' => __('Norican, Google ', 'yala-blog'),
			'Nosifer' => __('Nosifer, Google ', 'yala-blog'),
			'Nothing You Could Do' => __('Nothing You Could Do, Google ', 'yala-blog'),
			'Noticia Text' => __('Noticia Text, Google ', 'yala-blog'),
			'Noto Sans' => __('Noto Sans, Google ', 'yala-blog'),
			'Noto Serif' => __('Noto Serif, Google ', 'yala-blog'),
			'Nova Cut' => __('Nova Cut, Google ', 'yala-blog'),
			'Nova Flat' => __('Nova Flat, Google ', 'yala-blog'),
			'Nova Mono' => __('Nova Mono, Google ', 'yala-blog'),
			'Nova Oval' => __('Nova Oval, Google ', 'yala-blog'),
			'Nova Round' => __('Nova Round, Google ', 'yala-blog'),
			'Nova Script' => __('Nova Script, Google ', 'yala-blog'),
			'Nova Slim' => __('Nova Slim, Google ', 'yala-blog'),
			'Nova Square' => __('Nova Square, Google ', 'yala-blog'),
			'Numans' => __('Numans, Google ', 'yala-blog'),
			'Nunito' => __('Nunito, Google ', 'yala-blog'),
			'Odor Mean Chey' => __('Odor Mean Chey, Google ', 'yala-blog'),
			'Offside' => __('Offside, Google ', 'yala-blog'),
			'Old Standard TT' => __('Old Standard TT, Google ', 'yala-blog'),
			'Oldenburg' => __('Oldenburg, Google ', 'yala-blog'),
			'Oleo Script' => __('Oleo Script, Google ', 'yala-blog'),
			'Oleo Script Swash Caps' => __('Oleo Script Swash Caps, Google ', 'yala-blog'),
			'Open Sans' => __('Open Sans, Google ', 'yala-blog'),
			'Open Sans Condensed' => __('Open Sans Condensed, Google ', 'yala-blog'),
			'Oranienbaum' => __('Oranienbaum, Google ', 'yala-blog'),
			'Orbitron' => __('Orbitron, Google ', 'yala-blog'),
			'Oregano' => __('Oregano, Google ', 'yala-blog'),
			'Orienta' => __('Orienta, Google ', 'yala-blog'),
			'Original Surfer' => __('Original Surfer, Google ', 'yala-blog'),
			'Oswald' => __('Oswald, Google ', 'yala-blog'),
			'Over the Rainbow' => __('Over the Rainbow, Google ', 'yala-blog'),
			'Overlock' => __('Overlock, Google ', 'yala-blog'),
			'Overlock SC' => __('Overlock SC, Google ', 'yala-blog'),
			'Ovo' => __('Ovo, Google ', 'yala-blog'),
			'Oxygen' => __('Oxygen, Google ', 'yala-blog'),
			'Oxygen Mono' => __('Oxygen Mono, Google ', 'yala-blog'),
			'PT Mono' => __('PT Mono, Google ', 'yala-blog'),
			'PT Sans' => __('PT Sans, Google ', 'yala-blog'),
			'PT Sans Caption' => __('PT Sans Caption, Google ', 'yala-blog'),
			'PT Sans Narrow' => __('PT Sans Narrow, Google ', 'yala-blog'),
			'PT Serif' => __('PT Serif, Google ', 'yala-blog'),
			'PT Serif Caption' => __('PT Serif Caption, Google ', 'yala-blog'),
			'Pacifico' => __('Pacifico, Google ', 'yala-blog'),
			'Paprika' => __('Paprika, Google ', 'yala-blog'),
			'Parisienne' => __('Parisienne, Google ', 'yala-blog'),
			'Passero One' => __('Passero One, Google ', 'yala-blog'),
			'Passion One' => __('Passion One, Google ', 'yala-blog'),
			'Pathway Gothic One' => __('Pathway Gothic One, Google ', 'yala-blog'),
			'Patrick Hand' => __('Patrick Hand, Google ', 'yala-blog'),
			'Patrick Hand SC' => __('Patrick Hand SC, Google ', 'yala-blog'),
			'Patua One' => __('Patua One, Google ', 'yala-blog'),
			'Paytone One' => __('Paytone One, Google ', 'yala-blog'),
			'Peralta' => __('Peralta, Google ', 'yala-blog'),
			'Permanent Marker' => __('Permanent Marker, Google ', 'yala-blog'),
			'Petit Formal Script' => __('Petit Formal Script, Google ', 'yala-blog'),
			'Petrona' => __('Petrona, Google ', 'yala-blog'),
			'Philosopher' => __('Philosopher, Google ', 'yala-blog'),
			'Piedra' => __('Piedra, Google ', 'yala-blog'),
			'Pinyon Script' => __('Pinyon Script, Google ', 'yala-blog'),
			'Pirata One' => __('Pirata One, Google ', 'yala-blog'),
			'Plaster' => __('Plaster, Google ', 'yala-blog'),
			'Play' => __('Play, Google ', 'yala-blog'),
			'Playball' => __('Playball, Google ', 'yala-blog'),
			'Playfair Display' => __('Playfair Display, Google ', 'yala-blog'),
			'Playfair Display SC' => __('Playfair Display SC, Google ', 'yala-blog'),
			'Podkova' => __('Podkova, Google ', 'yala-blog'),
			'Poiret One' => __('Poiret One, Google ', 'yala-blog'),
			'Poller One' => __('Poller One, Google ', 'yala-blog'),
			'Poly' => __('Poly, Google ', 'yala-blog'),
			'Pompiere' => __('Pompiere, Google ', 'yala-blog'),
			'Pontano Sans' => __('Pontano Sans, Google ', 'yala-blog'),
			'Poppins'=> __('Poppins, Google ', 'yala-blog'),
			'Port Lligat Sans' => __('Port Lligat Sans, Google ', 'yala-blog'),
			'Port Lligat Slab' => __('Port Lligat Slab, Google ', 'yala-blog'),
			'Prata' => __('Prata, Google ', 'yala-blog'),
			'Preahvihear' => __('Preahvihear, Google ', 'yala-blog'),
			'Press Start 2P' => __('Press Start 2P, Google ', 'yala-blog'),
			'Princess Sofia' => __('Princess Sofia, Google ', 'yala-blog'),
			'Prociono' => __('Prociono, Google ', 'yala-blog'),
			'Prosto One' => __('Prosto One, Google ', 'yala-blog'),
			'Puritan' => __('Puritan, Google ', 'yala-blog'),
			'Purple Purse' => __('Purple Purse, Google ', 'yala-blog'),
			'Quando' => __('Quando, Google ', 'yala-blog'),
			'Quantico' => __('Quantico, Google ', 'yala-blog'),
			'Quattrocento' => __('Quattrocento, Google ', 'yala-blog'),
			'Quattrocento Sans' => __('Quattrocento Sans, Google ', 'yala-blog'),
			'Questrial' => __('Questrial, Google ', 'yala-blog'),
			'Quicksand' => __('Quicksand, Google ', 'yala-blog'),
			'Quintessential' => __('Quintessential, Google ', 'yala-blog'),
			'Qwigley' => __('Qwigley, Google ', 'yala-blog'),
			'Racing Sans One' => __('Racing Sans One, Google ', 'yala-blog'),
			'Radley' => __('Radley, Google ', 'yala-blog'),
			'Raleway' => __('Raleway, Google ', 'yala-blog'),
			'Raleway Dots' => __('Raleway Dots, Google ', 'yala-blog'),
			'Rambla' => __('Rambla, Google ', 'yala-blog'),
			'Rammetto One' => __('Rammetto One, Google ', 'yala-blog'),
			'Ranchers' => __('Ranchers, Google ', 'yala-blog'),
			'Rancho' => __('Rancho, Google ', 'yala-blog'),
			'Rationale' => __('Rationale, Google ', 'yala-blog'),
			'Redressed' => __('Redressed, Google ', 'yala-blog'),
			'Reenie Beanie' => __('Reenie Beanie, Google ', 'yala-blog'),
			'Revalia' => __('Revalia, Google ', 'yala-blog'),
			'Ribeye' => __('Ribeye, Google ', 'yala-blog'),
			'Ribeye Marrow' => __('Ribeye Marrow, Google ', 'yala-blog'),
			'Righteous' => __('Righteous, Google ', 'yala-blog'),
			'Risque' => __('Risque, Google ', 'yala-blog'),
			'Roboto' => __('Roboto, Google ', 'yala-blog'),
			'Roboto Condensed' => __('Roboto Condensed, Google ', 'yala-blog'),
			'Roboto Slab' => __('Roboto Slab, Google ', 'yala-blog'),
			'Rochester' => __('Rochester, Google ', 'yala-blog'),
			'Rock Salt' => __('Rock Salt, Google ', 'yala-blog'),
			'Rokkitt' => __('Rokkitt, Google ', 'yala-blog'),
			'Romanesco' => __('Romanesco, Google ', 'yala-blog'),
			'Ropa Sans' => __('Ropa Sans, Google ', 'yala-blog'),
			'Rosario' => __('Rosario, Google ', 'yala-blog'),
			'Rosarivo' => __('Rosarivo, Google ', 'yala-blog'),
			'Rouge Script' => __('Rouge Script, Google ', 'yala-blog'),
			'Rubik Mono One' => __('Rubik Mono One, Google ', 'yala-blog'),
			'Rubik One' => __('Rubik One, Google ', 'yala-blog'),
			'Ruda' => __('Ruda, Google ', 'yala-blog'),
			'Rufina' => __('Rufina, Google ', 'yala-blog'),
			'Ruge Boogie' => __('Ruge Boogie, Google ', 'yala-blog'),
			'Ruluko' => __('Ruluko, Google ', 'yala-blog'),
			'Rum Raisin' => __('Rum Raisin, Google ', 'yala-blog'),
			'Ruslan Display' => __('Ruslan Display, Google ', 'yala-blog'),
			'Russo One' => __('Russo One, Google ', 'yala-blog'),
			'Ruthie' => __('Ruthie, Google ', 'yala-blog'),
			'Rye' => __('Rye, Google ', 'yala-blog'),
			'Sacramento' => __('Sacramento, Google ', 'yala-blog'),
			'Sail' => __('Sail, Google ', 'yala-blog'),
			'Salsa' => __('Salsa, Google ', 'yala-blog'),
			'Sanchez' => __('Sanchez, Google ', 'yala-blog'),
			'Sancreek' => __('Sancreek, Google ', 'yala-blog'),
			'Sansita One' => __('Sansita One, Google ', 'yala-blog'),
			'Sarina' => __('Sarina, Google ', 'yala-blog'),
			'Satisfy' => __('Satisfy, Google ', 'yala-blog'),
			'Scada' => __('Scada, Google ', 'yala-blog'),
			'Schoolbell' => __('Schoolbell, Google ', 'yala-blog'),
			'Seaweed Script' => __('Seaweed Script, Google ', 'yala-blog'),
			'Sevillana' => __('Sevillana, Google ', 'yala-blog'),
			'Seymour One' => __('Seymour One, Google ', 'yala-blog'),
			'Shadows Into Light' => __('Shadows Into Light, Google ', 'yala-blog'),
			'Shadows Into Light Two' => __('Shadows Into Light Two, Google ', 'yala-blog'),
			'Shanti' => __('Shanti, Google ', 'yala-blog'),
			'Share' => __('Share, Google ', 'yala-blog'),
			'Share Tech' => __('Share Tech, Google ', 'yala-blog'),
			'Share Tech Mono' => __('Share Tech Mono, Google ', 'yala-blog'),
			'Shojumaru' => __('Shojumaru, Google ', 'yala-blog'),
			'Short Stack' => __('Short Stack, Google ', 'yala-blog'),
			'Siemreap' => __('Siemreap, Google ', 'yala-blog'),
			'Sigmar One' => __('Sigmar One, Google ', 'yala-blog'),
			'Signika' => __('Signika, Google ', 'yala-blog'),
			'Signika Negative' => __('Signika Negative, Google ', 'yala-blog'),
			'Simonetta' => __('Simonetta, Google ', 'yala-blog'),
			'Sintony' => __('Sintony, Google ', 'yala-blog'),
			'Sirin Stencil' => __('Sirin Stencil, Google ', 'yala-blog'),
			'Six Caps' => __('Six Caps, Google ', 'yala-blog'),
			'Skranji' => __('Skranji, Google ', 'yala-blog'),
			'Slackey' => __('Slackey, Google ', 'yala-blog'),
			'Smokum' => __('Smokum, Google ', 'yala-blog'),
			'Smythe' => __('Smythe, Google ', 'yala-blog'),
			'Sniglet' => __('Sniglet, Google ', 'yala-blog'),
			'Snippet' => __('Snippet, Google ', 'yala-blog'),
			'Snowburst One' => __('Snowburst One, Google ', 'yala-blog'),
			'Sofadi One' => __('Sofadi One, Google ', 'yala-blog'),
			'Sofia' => __('Sofia, Google ', 'yala-blog'),
			'Sonsie One' => __('Sonsie One, Google ', 'yala-blog'),
			'Sorts Mill Goudy' => __('Sorts Mill Goudy, Google ', 'yala-blog'),
			'Source Code Pro' => __('Source Code Pro, Google ', 'yala-blog'),
			'Source Sans Pro' => __('Source Sans Pro, Google ', 'yala-blog'),
			'Source Serif Pro' => __('Source Serif Pro, Google ', 'yala-blog'),
			'Special Elite' => __('Special Elite, Google ', 'yala-blog'),
			'Spicy Rice' => __('Spicy Rice, Google ', 'yala-blog'),
			'Spinnaker' => __('Spinnaker, Google ', 'yala-blog'),
			'Spirax' => __('Spirax, Google ', 'yala-blog'),
			'Squada One' => __('Squada One, Google ', 'yala-blog'),
			'Stalemate' => __('Stalemate, Google ', 'yala-blog'),
			'Stalinist One' => __('Stalinist One, Google ', 'yala-blog'),
			'Stardos Stencil' => __('Stardos Stencil, Google ', 'yala-blog'),
			'Stint Ultra Condensed' => __('Stint Ultra Condensed, Google ', 'yala-blog'),
			'Stint Ultra Expanded' => __('Stint Ultra Expanded, Google ', 'yala-blog'),
			'Stoke' => __('Stoke, Google ', 'yala-blog'),
			'Strait' => __('Strait, Google ', 'yala-blog'),
			'Sue Ellen Francisco' => __('Sue Ellen Francisco, Google ', 'yala-blog'),
			'Sunshiney' => __('Sunshiney, Google ', 'yala-blog'),
			'Supermercado One' => __('Supermercado One, Google ', 'yala-blog'),
			'Suwannaphum' => __('Suwannaphum, Google ', 'yala-blog'),
			'Swanky and Moo Moo' => __('Swanky and Moo Moo, Google ', 'yala-blog'),
			'Syncopate' => __('Syncopate, Google ', 'yala-blog'),
			'Tangerine' => __('Tangerine, Google ', 'yala-blog'),
			'Taprom' => __('Taprom, Google ', 'yala-blog'),
			'Tauri' => __('Tauri, Google ', 'yala-blog'),
			'Telex' => __('Telex, Google ', 'yala-blog'),
			'Tenor Sans' => __('Tenor Sans, Google ', 'yala-blog'),
			'Text Me One' => __('Text Me One, Google ', 'yala-blog'),
			'The Girl Next Door' => __('The Girl Next Door, Google ', 'yala-blog'),
			'Tienne' => __('Tienne, Google ', 'yala-blog'),
			'Tinos' => __('Tinos, Google ', 'yala-blog'),
			'Titan One' => __('Titan One, Google ', 'yala-blog'),
			'Titillium Web' => __('Titillium Web, Google ', 'yala-blog'),
			'Trade Winds' => __('Trade Winds, Google ', 'yala-blog'),
			'Trocchi' => __('Trocchi, Google ', 'yala-blog'),
			'Trochut' => __('Trochut, Google ', 'yala-blog'),
			'Trykker' => __('Trykker, Google ', 'yala-blog'),
			'Tulpen One' => __('Tulpen One, Google ', 'yala-blog'),
			'Ubuntu' => __('Ubuntu, Google ', 'yala-blog'),
			'Ubuntu Condensed' => __('Ubuntu Condensed, Google ', 'yala-blog'),
			'Ubuntu Mono' => __('Ubuntu Mono, Google ', 'yala-blog'),
			'Ultra' => __('Ultra, Google ', 'yala-blog'),
			'Uncial Antiqua' => __('Uncial Antiqua, Google ', 'yala-blog'),
			'Underdog' => __('Underdog, Google ', 'yala-blog'),
			'Unica One' => __('Unica One, Google ', 'yala-blog'),
			'UnifrakturCook' => __('UnifrakturCook, Google ', 'yala-blog'),
			'UnifrakturMaguntia' => __('UnifrakturMaguntia, Google ', 'yala-blog'),
			'Unkempt' => __('Unkempt, Google ', 'yala-blog'),
			'Unlock' => __('Unlock, Google ', 'yala-blog'),
			'Unna' => __('Unna, Google ', 'yala-blog'),
			'VT323' => __('VT323, Google ', 'yala-blog'),
			'Vampiro One' => __('Vampiro One, Google ', 'yala-blog'),
			'Varela' => __('Varela, Google ', 'yala-blog'),
			'Varela Round' => __('Varela Round, Google ', 'yala-blog'),
			'Vast Shadow' => __('Vast Shadow, Google ', 'yala-blog'),
			'Vibur' => __('Vibur, Google ', 'yala-blog'),
			'Vidaloka' => __('Vidaloka, Google ', 'yala-blog'),
			'Viga' => __('Viga, Google ', 'yala-blog'),
			'Voces' => __('Voces, Google ', 'yala-blog'),
			'Volkhov' => __('Volkhov, Google ', 'yala-blog'),
			'Vollkorn' => __('Vollkorn, Google ', 'yala-blog'),
			'Voltaire' => __('Voltaire, Google ', 'yala-blog'),
			'Waiting for the Sunrise' => __('Waiting for the Sunrise, Google ', 'yala-blog'),
			'Wallpoet' => __('Wallpoet, Google ', 'yala-blog'),
			'Walter Turncoat' => __('Walter Turncoat, Google ', 'yala-blog'),
			'Warnes' => __('Warnes, Google ', 'yala-blog'),
			'Wellfleet' => __('Wellfleet, Google ', 'yala-blog'),
			'Wendy One' => __('Wendy One, Google ', 'yala-blog'),
			'Wire One' => __('Wire One, Google ', 'yala-blog'),
			'Yanone Kaffeesatz' => __('Yanone Kaffeesatz, Google ', 'yala-blog'),
			'Yellowtail' => __('Yellowtail, Google ', 'yala-blog'),
			'Yeseva One' => __('Yeseva One, Google ', 'yala-blog'),       
			'Yesteryear' => __('Yesteryear, Google ', 'yala-blog'),
			'Zeyada' => __('Zeyada, Google ', 'yala-blog'),
		)
	);
}