<?php

/**
 * Template Name: Front Page
 */
get_header();


$xshop_plus_woo_container = get_theme_mod('xshop_plus_woo_container', 'container');
$xshop_plus_blog_layout = get_theme_mod('xshop_plus_blog_layout', 'rightside');
$xshop_plus_blog_style = get_theme_mod('xshop_plus_blog_style', 'grid');

if (is_active_sidebar('sidebar-1') && $xshop_plus_blog_layout != 'fullwidth') {
    $xshop_plus_blog_column = 'col-lg-9';
} else {
    $xshop_plus_blog_column = 'col-lg-12';
}

?>

<div class="<?php echo esc_attr($xshop_plus_woo_container); ?> xshop-front-page mt-3 mb-5 pt-5 pb-3">
    <?php
    if (xshop_plus_is_woocommerce_activated() && xshop_plus_has_woocommerce_products()) :
    ?>
        <main id="primary" class="site-main">
            <?php get_template_part('template-parts/content', 'fshop'); ?>
        </main>

    <?php else : ?>
        <div class="row">
            <?php if (is_active_sidebar('sidebar-1') && $xshop_plus_blog_layout == 'leftside') : ?>
                <div class="col-lg-3">
                    <?php get_sidebar(); ?>
                </div>
            <?php endif; ?>
            <div class="<?php echo esc_attr($xshop_plus_blog_column); ?>">
                <main id="primary" class="site-main">
                    <?php if ($xshop_plus_blog_style == 'grid'): ?>
                        <div class="bplus-gridh mb-5">
                            <div class="grid row" data-masonry='{"percentPosition": true }'>
                            <?php endif; ?>

                            <?php
                            if (have_posts()) :
                                /* Start the Loop */
                                while (have_posts()) :
                                    the_post();
                                    get_template_part('template-parts/content', get_post_type());

                                endwhile;
                                the_posts_navigation();

                            else :
                                get_template_part('template-parts/content', 'none');

                            endif;
                            ?>
                            <?php if ($xshop_plus_blog_style == 'grid'): ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </main><!-- #main -->
            </div>
            <?php if (is_active_sidebar('sidebar-1') && $xshop_plus_blog_layout == 'rightside') : ?>
                <div class="col-lg-3">
                    <?php get_sidebar(); ?>
                </div>
            <?php endif; ?>
        </div> <!-- end row -->
    <?php endif; ?>

</div> <!-- end container -->

<?php
get_footer();
