<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$banner_type      = xpro_get_option( 'xpro_banner_type', 'xpro-wrapper-layout-1' );
$banner_type_meta = xpro_get_meta( 'xpro-post-banner' );
$container        = xpro_get_option( 'xpro_banner_container', 'container' );
$breadcrumb       = xpro_get_option( 'xpro_banner_breadcurmb_enable', '1' );

if ( 'none' !== $banner_type && 'disabled' !== $banner_type_meta ) : ?>

<div class="xpro-title-wrapper xpro-inner-area-space <?php echo esc_attr( $banner_type ); ?>">
	<div class="<?php echo esc_attr( $container ); ?> xpro-title-wrapper-inner">
		<div class="xpro-title-wrapper-content">
			<h1 class="xpro-title-wrapper-text"><?php xpro_wrapper_get_tittle(); ?></h1>
			<?php if ( $breadcrumb ) : ?>
				<ul class="xpro-breadcrumb-list">
					<?php echo wp_kses_post_deep( xpro_breadcrumb_display() ); ?>
				</ul>
			<?php endif; ?>
		</div>
	</div>
</div>

<?php endif; ?>
