<?php

$header_layout    = xpro_get_option( 'xpro_header_type', 'standard' );
$header_meta      = xpro_get_meta( 'xpro-main-header-display' );
$container_header = xpro_get_option( 'xpro_header_container', 'container' );
$header_sticky    = xpro_get_option( 'xpro_sticky_header_enable', '0' );

$logo_enable = xpro_get_option( 'xpro_header_logo_enable', '0' );
$site_logo   = xpro_get_option( 'xpro_site_logo', '' );
$sticky_logo = xpro_get_option( 'xpro_site_logo_sticky', '' );

$header_class = ( $header_sticky ) ? 'xpro-header-sticky' : '';

$search_enable = xpro_get_option( 'xpro_header_search_enable', '1' );
$search_source = xpro_get_option( 'xpro_header_search_type', 'post' );
$search_logo   = xpro_get_option( 'xpro_header_search_logo', '' );

?>

<?php if ( 'none' !== $header_layout && 'disabled' !== $header_meta ) : ?>

	<header class="xpro-header <?php echo esc_attr( $header_class ); ?>">

		<nav id="xpro-main-nav" class="xpro-navbar-primary xpro-nav-layout-<?php echo esc_attr( $header_layout ); ?>">
			<div class="<?php echo esc_attr( $container_header ); ?> xpro-navbar-inner">

				<!--Navbar Brand-->
				<div class="xpro-navbar-brand">
					<a class="navbar-brand" rel="home" href="<?php echo esc_url( home_url( '/' ) ); ?>" itemprop="url">
						<?php
						if ( $logo_enable ) {
							if ( ! empty( $site_logo ) ) :
								?>
								<img src="<?php echo esc_url( $site_logo ); ?>" alt="<?php echo esc_attr( get_bloginfo() ); ?>" class="xpro-logo<?php echo ( ! empty( $sticky_logo ) ) ? ' xpro-logo-default' : ''; ?>">
								<?php
							else :
								bloginfo( 'name' );
							endif;
							if ( ! empty( $sticky_logo ) ) :
								?>
								<img src="<?php echo esc_url( $sticky_logo ); ?>" alt="<?php echo esc_attr( get_bloginfo() ); ?>" class="xpro-logo xpro-logo-sticky">
								<?php
							endif;
						} else {
							bloginfo( 'name' );
						}
						?>
					</a>
				</div>

				<div class="xpro-navbar-overlay"></div>

				<?php
				wp_nav_menu(
					array(
						'theme_location'  => 'primary',
						'container_class' => 'xpro-navbar-collapse',
						'container_id'    => 'xpro-navbar-menu',
						'menu_class'      => 'xpro-navbar-nav',
						'fallback_cb'     => 'xpro_nav_menu_fallback',
						'menu_id'         => 'xpro-nav-menu',
						'walker'          => new Xpro_Navwalker(),
					)
				);
				?>

				<?php if ( $search_enable ) : ?>
					<div class="xpro-nav-actions">
						<?php if ( $search_enable ) : ?>
						<span class="xpro-nav-search-button xpro-icon">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M46.746 49.77a5.12 5.12 0 0 1-2.129-1.485 3860.777 3860.777 0 0 1-11.312-11.254l-.39-.402c-5.267 3.55-11.966 4.559-18.118 2.719-4.66-1.305-8.676-4.168-11.313-8.067C-2.277 23.008-.8 11.938 6.95 5.313s19.414-6.79 27.367-.387c2.832 2.246 4.985 5.172 6.239 8.48a18.805 18.805 0 0 1 .941 10.278c-.621 3.464-2.191 6.707-4.55 9.406l.718.719 11.379 11.355a2.55 2.55 0 0 1 .95 1.856 2.534 2.534 0 0 1-.778 1.93 7.68 7.68 0 0 1-1.41.82ZM20.918 5.469c-8.531-.004-15.453 6.61-15.453 14.77-.004 8.163 6.914 14.78 15.445 14.777 8.535 0 15.45-6.621 15.442-14.786-.016-8.144-6.914-14.742-15.434-14.761Zm0 0"/></svg>
						</span>
						<div class="xpro-nav-search-overlay"></div>
						<div class="xpro-nav-search-wrapper">
							<div class="xpro-nav-search-inner">
								<?php if ( ! empty( $search_logo ) ) : ?>
									<a class="xpro-header-search-logo" rel="home" href="<?php echo esc_url( home_url( '/' ) ); ?>" itemprop="url">
										<img src="<?php echo esc_url( $search_logo ); ?>" alt="<?php echo esc_attr( get_bloginfo() ); ?>">
									</a>
								<?php endif; ?>
								<span class="xpro-nav-search-close xpro-icon">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M1.957 50c-.145-.063-.289-.129-.434-.188a2.426 2.426 0 0 1-1-3.746c.153-.187.317-.367.493-.535 6.699-6.699 13.394-13.394 20.093-20.09.157-.132.325-.25.504-.355-.238-.25-.367-.39-.5-.523C14.371 17.823 7.625 11.082.883 4.34c-.68-.68-1.04-1.453-.817-2.418a2.423 2.423 0 0 1 1.622-1.8 2.422 2.422 0 0 1 2.37.495c.16.13.305.293.454.442a48355.09 48355.09 0 0 1 20.015 20.02c.137.136.262.296.422.491.184-.175.32-.3.453-.433 6.746-6.742 13.489-13.48 20.23-20.223.782-.785 1.661-1.121 2.74-.762.878.285 1.335.977 1.628 1.805v.977c-.234.734-.738 1.273-1.27 1.804-6.62 6.61-13.238 13.227-19.851 19.844-.133.133-.262.273-.445.465.183.156.34.273.476.414 6.594 6.59 13.188 13.184 19.785 19.773.543.543 1.059 1.09 1.305 1.84v.977a2.85 2.85 0 0 1-1.957 1.957h-.973c-.734-.238-1.273-.738-1.804-1.274-6.61-6.62-13.223-13.238-19.844-19.851a50.318 50.318 0 0 0-.485-.461 6.81 6.81 0 0 1-.39.496C17.94 35.528 11.34 42.133 4.738 48.734c-.535.536-1.07 1.047-1.804 1.274Zm0 0"/></svg>
								</span>
								<form class="header-search-form" role="search" method="get" id="header-search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>" >
									<label aria-hidden="true" for="xpro-navbar-search"></label>
									<input required class="navbar_search_input" type="text" value="<?php echo esc_html( get_search_query() ); ?>" placeholder="<?php echo esc_attr__( 'Search', 'xpro' ); ?>" name="s" id="xpro-navbar-search" autocomplete="off">
									<input type="hidden" name="post_type" value="<?php echo esc_attr( $search_source ); ?>">
									<button class="xpro-nav-search-submit xpro-icon" id="searchsubmit" type="submit">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M46.746 49.77a5.12 5.12 0 0 1-2.129-1.485 3860.777 3860.777 0 0 1-11.312-11.254l-.39-.402c-5.267 3.55-11.966 4.559-18.118 2.719-4.66-1.305-8.676-4.168-11.313-8.067C-2.277 23.008-.8 11.938 6.95 5.313s19.414-6.79 27.367-.387c2.832 2.246 4.985 5.172 6.239 8.48a18.805 18.805 0 0 1 .941 10.278c-.621 3.464-2.191 6.707-4.55 9.406l.718.719 11.379 11.355a2.55 2.55 0 0 1 .95 1.856 2.534 2.534 0 0 1-.778 1.93 7.68 7.68 0 0 1-1.41.82ZM20.918 5.469c-8.531-.004-15.453 6.61-15.453 14.77-.004 8.163 6.914 14.78 15.445 14.777 8.535 0 15.45-6.621 15.442-14.786-.016-8.144-6.914-14.742-15.434-14.761Zm0 0"/></svg>
									</button>
								</form>
							</div>
						</div>
						<?php endif; ?>
					</div>
				<?php endif; ?>

				<!--Navbar Toggle-->
				<button class="xpro-navbar-toggle" type="button" data-toggle="collapse" data-target="#xpro-navbar-list" aria-expanded="false" aria-label="<?php esc_attr_e( 'Toggle navigation', 'xpro' ); ?>">
					<span class="navbar-toggler-icon"></span>
				</button>

			</div>
		</nav>

	</header>

	<?php
endif;
