<?php

$thumb           = xpro_get_option( 'xpro_layout_archive_thumb', '1' );
$post_title      = xpro_get_option( 'xpro_layout_archive_title', '1' );
$date            = xpro_get_option( 'xpro_layout_archive_date', '1' );
$category        = xpro_get_option( 'xpro_layout_archive_category', '1' );
$comments_enable = xpro_get_option( 'xpro_layout_archive_comments', '0' );
$author          = xpro_get_option( 'xpro_layout_archive_author', '1' );
$content         = xpro_get_option( 'xpro_layout_archive_content', '1' );
$excerpt         = xpro_get_option( 'xpro_layout_archive_excerpt_enable', '1' );
$excerpt_length  = xpro_get_option( 'xpro_layout_archive_excerpt', 40 );
$social          = xpro_get_option( 'xpro_layout_archive_social_icon', '1' );
$button          = xpro_get_option( 'xpro_layout_archive_button', '1' );
$button_text     = xpro_get_option( 'xpro_layout_archive_button_text', 'Read More' );
$featured_meta   = xpro_get_meta( 'xpro-featured-image' );

?>

<article <?php post_class( 'xpro-post xpro-layout-classic' ); ?> id="xpro-post-<?php the_ID(); ?>">

	<?php do_action( 'xpro_entry_top' ); ?>

	<?php
	if ( has_post_thumbnail() && $thumb && 'disabled' !== $featured_meta ) {
		echo '<div class="xpro-post-thumbnail">';
		echo get_the_post_thumbnail( $post->ID, 'large' );
		echo '</div>';
	}
	?>

	<?php if ( $post_title ) : ?>
		<h3 class="xpro-post-title">
			<?php the_title( sprintf( '<a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a>' ); ?>
		</h3>
	<?php endif; ?>

	<ul class="xpro-post-links">

		<?php if ( $date ) : ?>
			<li class="xpro-post-date"><?php the_time( 'F j, Y' ); ?></li>
		<?php endif; ?>

		<?php if ( ! empty( get_the_category_list() ) && $category ) : ?>
			<li class="xpro-post-date">
				<span class="cat-links"><?php echo get_the_category_list( esc_html__( ', ', 'xpro' ) ); ?></span>
			</li>
		<?php endif; ?>

		<?php if ( $comments_enable ) : ?>
			<li class="xpro-post-comment">
				<a href="<?php comments_link(); ?>">
					<?php comments_number( esc_html__( 'Leave A  Comment', 'xpro' ), esc_html__( '1 Comment', 'xpro' ), esc_html__( '% Comments', 'xpro' ) ); ?>
				</a>
			</li>
		<?php endif; ?>

		<?php if ( $author ) : ?>
			<li class="xpro-post-author">
				<?php esc_html_e( 'By', 'xpro' ); ?>
				<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php echo esc_html( get_the_author() ); ?></a>
			</li>
		<?php endif; ?>

	</ul>

	<?php if ( $content ) : ?>
		<div class="xpro-post-content">
			<p>
				<?php
				if ( $excerpt ) {
					xpro_excerpt( $excerpt_length );
				} else {
					the_content();
				}
				?>
			</p>
		</div>
	<?php endif; ?>

	<?php if ( $button ) : ?>
		<a class="xpro-btn" href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>"><?php echo esc_html( $button_text ); ?></a>
	<?php endif; ?>

	<?php do_action( 'xpro_entry_bottom' ); ?>

</article>
