<?php
/**
 * The template for displaying search forms
 *
 * @package xpro
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<form method="get" id="searchform" class="xpro-serach-form" action="<?php echo esc_url( home_url( '/' ) ); ?>" role="search">
	<label class="sr-only" for="s"><?php esc_html_e( 'Search', 'xpro' ); ?></label>
	<div class="input-group">
		<input class="field form-control" id="s" name="s" type="text"
			placeholder="<?php esc_attr_e( 'Search &hellip;', 'xpro' ); ?>" value="<?php the_search_query(); ?>">
		<button class="submit xpro-btn-search" id="searchsubmit" name="submit" type="submit">
			<svg id="search-icon" class="xpro-icon xpro-icon-search" viewBox="0 0 24 24" width="24" height="24">
				<path d="M13.5 6C10.5 6 8 8.5 8 11.5c0 1.1.4 2.1.9 3l-3.4 3 1 1.1 3.4-2.9c1 .9 2.2 1.4 3.6 1.4 3 0 5.5-2.5 5.5-5.5C19 8.5 16.5 6 13.5 6zm0 9.5c-2.2 0-4-1.8-4-4s1.8-4 4-4 4 1.8 4 4-1.8 4-4 4z"></path>
			</svg>
		</button>
	</div>
</form>
