<?php

/*=================================================
	Shop Layout
=================================================*/

$xpro_fields[] = array(
	'type'        => 'radio-image',
	'settings'    => 'xpro_shop_layout',
	'label'       => __( 'Shop Layout', 'xpro' ),
	'description' => __( 'Specifies the shop/posts layout.', 'xpro' ),
	'section'     => 'xpro_layout_shop_section',
	'default'     => 'full-layout',
	'choices'     => array(
		'left-layout'  => XPRO_THEME_IMAGES_URI . '/customizer/sidebar-left.png',
		'full-layout'  => XPRO_THEME_IMAGES_URI . '/customizer/full.png',
		'right-layout' => XPRO_THEME_IMAGES_URI . '/customizer/sidebar-right.png',
	),
);

$xpro_fields[] = array(
	'type'        => 'select',
	'settings'    => 'xpro_shop_container_layout',
	'label'       => __( 'Container', 'xpro' ),
	'description' => __( 'Specifies the shop container.', 'xpro' ),
	'section'     => 'xpro_layout_shop_section',
	'default'     => 'container',
	'choices'     => array(
		'container'         => __( 'Container', 'xpro' ),
		'container-fluid'   => __( 'Container Fluid', 'xpro' ),
		'xpro-page-builder' => __( 'Full Width', 'xpro' ),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_shop_container_width',
	'label'       => __( 'Container Width', 'xpro' ),
	'description' => __( 'Specifies the width of the shop container.', 'xpro' ),
	'section'     => 'xpro_layout_shop_section',
	'transport'   => 'auto',
	'default'     => 1170,
	'choices'     => array(
		'min'  => 1000,
		'max'  => 1920,
		'step' => 5,
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_shop_container_layout',
			'operator' => '==',
			'value'    => 'container',
		),
	),
	'output'      => array(
		array(
			'element'  => '.woocommerce.shop .xpro-content-wrapper > .container,.woocommerce.archive .xpro-content-wrapper > .container',
			'property' => 'max-width',
			'units'    => 'px',
		),
	),
);


$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_layout_shop_spacing',
	'label'       => __( 'Space Top/Bottom', 'xpro' ),
	'description' => __( 'To change shop content top bottom padding.', 'xpro' ),
	'section'     => 'xpro_layout_shop_section',
	'default'     => 80,
	'transport'   => 'auto',
	'choices'     => array(
		'min'  => 0,
		'max'  => 300,
		'step' => 5,
	),
	'output'      => array(
		array(
			'element'  => '.woocommerce.shop .xpro-content-wrapper,.woocommerce.archive .xpro-content-wrapper',
			'property' => 'padding-top',
			'units'    => 'px',
		),
		array(
			'element'  => '.woocommerce.shop .xpro-content-wrapper,.woocommerce.archive .xpro-content-wrapper',
			'property' => 'padding-bottom',
			'units'    => 'px',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'image',
	'settings'    => 'xpro_layout_shop_background',
	'label'       => __( 'Banner Background', 'xpro' ),
	'description' => __( 'Banner background controls.', 'xpro' ),
	'section'     => 'xpro_layout_shop_section',
	'transport'   => 'auto',
	'output'      => array(
		array(
			'element'  => '.woocommerce.shop .xpro-title-wrapper,.woocommerce.archive .xpro-title-wrapper',
			'property' => 'background-image',
		),
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_banner_type',
			'operator' => '!=',
			'value'    => 'none',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'select',
	'settings'    => 'xpro_shop_product_column',
	'label'       => __( 'Column(s)', 'xpro' ),
	'description' => __( 'Specifies the column per row.', 'xpro' ),
	'section'     => 'xpro_layout_shop_section',
	'transport'   => 'auto',
	'default'     => 3,
	'choices'     => array(
		2 => __( '2 Column', 'xpro' ),
		3 => __( '3 Column', 'xpro' ),
		4 => __( '4 Column', 'xpro' ),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_shop_product_per_page',
	'label'       => __( 'Product Per Page', 'xpro' ),
	'description' => __( 'Specifies the no. of products to show per page.', 'xpro' ),
	'section'     => 'xpro_layout_shop_section',
	'transport'   => 'auto',
	'default'     => 12,
	'choices'     => array(
		'min'  => 1,
		'max'  => 100,
		'step' => 1,
	),
);


/*=================================================
	Single Product
=================================================*/

$xpro_fields[] = array(
	'type'        => 'select',
	'settings'    => 'xpro_product_single_container_layout',
	'label'       => __( 'Container', 'xpro' ),
	'description' => __( 'Specifies the post product_single container.', 'xpro' ),
	'section'     => 'xpro_layout_product_single_section',
	'default'     => 'container',
	'choices'     => array(
		'container'         => __( 'Container', 'xpro' ),
		'container-fluid'   => __( 'Container Fluid', 'xpro' ),
		'xpro-page-builder' => __( 'Full Width', 'xpro' ),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_product_single_container_width',
	'label'       => __( 'Container Width', 'xpro' ),
	'description' => __( 'Specifies the width of the post product_single container.', 'xpro' ),
	'section'     => 'xpro_layout_product_single_section',
	'transport'   => 'auto',
	'default'     => 1170,
	'choices'     => array(
		'min'  => 1000,
		'max'  => 1920,
		'step' => 5,
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_product_single_container_layout',
			'operator' => '==',
			'value'    => 'container',
		),
	),
	'output'      => array(
		array(
			'element'  => '.single-product .xpro-content-wrapper > .container',
			'property' => 'max-width',
			'units'    => 'px',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_layout_product_single_spacing',
	'label'       => __( 'Space Top/Bottom', 'xpro' ),
	'description' => __( 'To change product_single content top bottom padding.', 'xpro' ),
	'section'     => 'xpro_layout_product_single_section',
	'default'     => 80,
	'transport'   => 'auto',
	'choices'     => array(
		'min'  => 0,
		'max'  => 300,
		'step' => 5,
	),
	'output'      => array(
		array(
			'element'  => '.single-product .xpro-content-wrapper',
			'property' => 'padding-top',
			'units'    => 'px',
		),
		array(
			'element'  => '.single-product .xpro-content-wrapper',
			'property' => 'padding-bottom',
			'units'    => 'px',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'image',
	'settings'    => 'xpro_layout_product_single_background',
	'label'       => __( 'Banner Background', 'xpro' ),
	'description' => __( 'Banner background controls.', 'xpro' ),
	'section'     => 'xpro_layout_product_single_section',
	'transport'   => 'auto',
	'output'      => array(
		array(
			'element'  => '.single-product .xpro-title-wrapper',
			'property' => 'background-image',
		),
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_banner_type',
			'operator' => '!=',
			'value'    => 'none',
		),
	),
);

/*=================================================
	Cart
=================================================*/

$xpro_fields[] = array(
	'type'        => 'select',
	'settings'    => 'xpro_cart_container_layout',
	'label'       => __( 'Container', 'xpro' ),
	'description' => __( 'Specifies the post cart container.', 'xpro' ),
	'section'     => 'xpro_layout_cart_section',
	'default'     => 'container',
	'choices'     => array(
		'container'         => __( 'Container', 'xpro' ),
		'container-fluid'   => __( 'Container Fluid', 'xpro' ),
		'xpro-page-builder' => __( 'Full Width', 'xpro' ),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_cart_container_width',
	'label'       => __( 'Container Width', 'xpro' ),
	'description' => __( 'Specifies the width of the post cart container.', 'xpro' ),
	'section'     => 'xpro_layout_cart_section',
	'transport'   => 'auto',
	'default'     => 1170,
	'choices'     => array(
		'min'  => 1000,
		'max'  => 1920,
		'step' => 5,
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_cart_container_layout',
			'operator' => '==',
			'value'    => 'container',
		),
	),
	'output'      => array(
		array(
			'element'  => '.woocommerce-cart .xpro-content-wrapper > .container',
			'property' => 'max-width',
			'units'    => 'px',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_layout_cart_spacing',
	'label'       => __( 'Space Top/Bottom', 'xpro' ),
	'description' => __( 'To change cart content top bottom padding.', 'xpro' ),
	'section'     => 'xpro_layout_cart_section',
	'default'     => 80,
	'transport'   => 'auto',
	'choices'     => array(
		'min'  => 0,
		'max'  => 300,
		'step' => 5,
	),
	'output'      => array(
		array(
			'element'  => '.woocommerce-cart .xpro-content-wrapper',
			'property' => 'padding-top',
			'units'    => 'px',
		),
		array(
			'element'  => '.woocommerce-cart .xpro-content-wrapper',
			'property' => 'padding-bottom',
			'units'    => 'px',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'image',
	'settings'    => 'xpro_layout_cart_background',
	'label'       => __( 'Banner Background', 'xpro' ),
	'description' => __( 'Banner background controls.', 'xpro' ),
	'section'     => 'xpro_layout_cart_section',
	'transport'   => 'auto',
	'output'      => array(
		array(
			'element'  => '.woocommerce-cart .xpro-title-wrapper',
			'property' => 'background-image',
		),
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_banner_type',
			'operator' => '!=',
			'value'    => 'none',
		),
	),
);


/*=================================================
	Checkout
=================================================*/

$xpro_fields[] = array(
	'type'        => 'select',
	'settings'    => 'xpro_checkout_container_layout',
	'label'       => __( 'Container', 'xpro' ),
	'description' => __( 'Specifies the post checkout container.', 'xpro' ),
	'section'     => 'xpro_layout_checkout_section',
	'default'     => 'container',
	'choices'     => array(
		'container'         => __( 'Container', 'xpro' ),
		'container-fluid'   => __( 'Container Fluid', 'xpro' ),
		'xpro-page-builder' => __( 'Full Width', 'xpro' ),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_checkout_container_width',
	'label'       => __( 'Container Width', 'xpro' ),
	'description' => __( 'Specifies the width of the post checkout container.', 'xpro' ),
	'section'     => 'xpro_layout_checkout_section',
	'transport'   => 'auto',
	'default'     => 1170,
	'choices'     => array(
		'min'  => 1000,
		'max'  => 1920,
		'step' => 5,
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_checkout_container_layout',
			'operator' => '==',
			'value'    => 'container',
		),
	),
	'output'      => array(
		array(
			'element'  => '.woocommerce-checkout .xpro-content-wrapper > .container',
			'property' => 'max-width',
			'units'    => 'px',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_layout_checkout_spacing',
	'label'       => __( 'Space Top/Bottom', 'xpro' ),
	'description' => __( 'To change checkout content top bottom padding.', 'xpro' ),
	'section'     => 'xpro_layout_checkout_section',
	'default'     => 80,
	'transport'   => 'auto',
	'choices'     => array(
		'min'  => 0,
		'max'  => 300,
		'step' => 5,
	),
	'output'      => array(
		array(
			'element'  => '.woocommerce-checkout .xpro-content-wrapper',
			'property' => 'padding-top',
			'units'    => 'px',
		),
		array(
			'element'  => '.woocommerce-checkout .xpro-content-wrapper',
			'property' => 'padding-bottom',
			'units'    => 'px',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'image',
	'settings'    => 'xpro_layout_checkout_background',
	'label'       => __( 'Banner Background', 'xpro' ),
	'description' => __( 'Banner background controls.', 'xpro' ),
	'section'     => 'xpro_layout_checkout_section',
	'transport'   => 'auto',
	'output'      => array(
		array(
			'element'  => '.woocommerce-checkout .xpro-title-wrapper',
			'property' => 'background-image',
		),
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_banner_type',
			'operator' => '!=',
			'value'    => 'none',
		),
	),
);

/*=================================================
	Checkout
=================================================*/

$xpro_fields[] = array(
	'type'        => 'select',
	'settings'    => 'xpro_account_container_layout',
	'label'       => __( 'Container', 'xpro' ),
	'description' => __( 'Specifies the post account container.', 'xpro' ),
	'section'     => 'xpro_layout_account_section',
	'default'     => 'container',
	'choices'     => array(
		'container'         => __( 'Container', 'xpro' ),
		'container-fluid'   => __( 'Container Fluid', 'xpro' ),
		'xpro-page-builder' => __( 'Full Width', 'xpro' ),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_account_container_width',
	'label'       => __( 'Container Width', 'xpro' ),
	'description' => __( 'Specifies the width of the post account container.', 'xpro' ),
	'section'     => 'xpro_layout_account_section',
	'transport'   => 'auto',
	'default'     => 1170,
	'choices'     => array(
		'min'  => 1000,
		'max'  => 1920,
		'step' => 5,
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_account_container_layout',
			'operator' => '==',
			'value'    => 'container',
		),
	),
	'output'      => array(
		array(
			'element'  => '.woocommerce-account .xpro-content-wrapper > .container',
			'property' => 'max-width',
			'units'    => 'px',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_layout_account_spacing',
	'label'       => __( 'Space Top/Bottom', 'xpro' ),
	'description' => __( 'To change account content top bottom padding.', 'xpro' ),
	'section'     => 'xpro_layout_account_section',
	'default'     => 80,
	'transport'   => 'auto',
	'choices'     => array(
		'min'  => 0,
		'max'  => 300,
		'step' => 5,
	),
	'output'      => array(
		array(
			'element'  => '.woocommerce-account .xpro-content-wrapper',
			'property' => 'padding-top',
			'units'    => 'px',
		),
		array(
			'element'  => '.woocommerce-account .xpro-content-wrapper',
			'property' => 'padding-bottom',
			'units'    => 'px',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'image',
	'settings'    => 'xpro_layout_account_background',
	'label'       => __( 'Banner Background', 'xpro' ),
	'description' => __( 'Banner background controls.', 'xpro' ),
	'section'     => 'xpro_layout_account_section',
	'transport'   => 'auto',
	'output'      => array(
		array(
			'element'  => '.woocommerce-account .xpro-title-wrapper',
			'property' => 'background-image',
		),
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_banner_type',
			'operator' => '!=',
			'value'    => 'none',
		),
	),
);
