<?php

/*=================================================
	Logo
=================================================*/


$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_responsive_logo_width',
	'label'       => __( 'Logo Width', 'xpro' ),
	'description' => __( 'To change header logo width.', 'xpro' ),
	'section'     => 'xpro_responsive_logo_section',
	'default'     => 150,
	'transport'   => 'auto',
	'choices'     => array(
		'min'  => 0,
		'max'  => 300,
		'step' => 1,
	),
	'output'      => array(
		array(
			'element'     => '.xpro-navbar-primary .xpro-navbar-brand > a > .xpro-logo',
			'property'    => 'width',
			'units'       => 'px',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_header_logo_enable',
			'operator' => '==',
			'value'    => '1',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_responsive_sticky_logo_width',
	'label'       => __( 'Sticky Logo Width', 'xpro' ),
	'description' => __( 'To change sticky header logo width.', 'xpro' ),
	'section'     => 'xpro_responsive_logo_section',
	'default'     => 150,
	'transport'   => 'auto',
	'choices'     => array(
		'min'  => 0,
		'max'  => 300,
		'step' => 1,
	),
	'output'      => array(
		array(
			'element'     => '.xpro-appear .xpro-navbar-primary .xpro-navbar-brand > a > .xpro-logo',
			'property'    => 'width',
			'units'       => 'px',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_header_logo_enable',
			'operator' => '==',
			'value'    => '1',
		),
	),
);

/*=================================================
	Menu
=================================================*/

$xpro_fields[] = array(
	'type'        => 'typography',
	'settings'    => 'xpro_hamburger_typography',
	'label'       => __( 'Font Size', 'xpro' ),
	'description' => __( 'To change hamburger menu font size. e.g. 15px', 'xpro' ),
	'section'     => 'xpro_responsive_menu_section',
	'transport'   => 'auto',
	'default'     => array(
		'font-size'      => '',
		'line-height'    => '',
		'letter-spacing' => '',
		'text-transform' => '',
	),
	'output'      => array(
		array(
			'element'     => '.xpro-navbar-primary .xpro-navbar-nav li > a',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);

$xpro_fields[] = array(
	'type'      => 'select',
	'settings'  => 'xpro_font_weight_hamburger',
	'label'     => __( 'Font Weight', 'xpro' ),
	'section'   => 'xpro_responsive_menu_section',
	'transport' => 'auto',
	'default'   => 'normal',
	'choices'   => array(
		'normal' => __( 'Normal', 'xpro' ),
		'100'    => __( '100', 'xpro' ),
		'200'    => __( '200', 'xpro' ),
		'300'    => __( '300', 'xpro' ),
		'400'    => __( '400', 'xpro' ),
		'500'    => __( '500', 'xpro' ),
		'600'    => __( '600', 'xpro' ),
		'700'    => __( '700', 'xpro' ),
		'800'    => __( '800', 'xpro' ),
		'900'    => __( '900', 'xpro' ),
	),
	'output'    => array(
		array(
			'element'     => '.xpro-navbar-primary .xpro-navbar-nav li > a',
			'property'    => 'font-weight',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_hamburger_menu_padding',
	'label'       => __( 'Top/Bottom Space', 'xpro' ),
	'description' => __( 'Specifies the padding top/bottom between menu.', 'xpro' ),
	'section'     => 'xpro_responsive_menu_section',
	'transport'   => 'auto',
	'default'     => 10,
	'choices'     => array(
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	),
	'output'      => array(
		array(
			'element'     => '.xpro-navbar-primary .xpro-navbar-nav li > a',
			'property'    => 'padding-top',
			'units'       => 'px',
			'media_query' => '@media (max-width: 1024px)',
		),
		array(
			'element'     => '.xpro-navbar-primary .xpro-navbar-nav li > a',
			'property'    => 'padding-bottom',
			'units'       => 'px',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'color',
	'settings'    => 'xpro_hamburger_color',
	'label'       => __( 'Menu Color', 'xpro' ),
	'description' => __( 'Specifies the color of hamburger menu.', 'xpro' ),
	'section'     => 'xpro_responsive_menu_section',
	'transport'   => 'auto',
	'default'     => '#fff',
	'choices'     => array(
		'alpha' => true,
	),
	'output'      => array(
		array(
			'element'     => '.xpro-navbar-primary .xpro-navbar-nav li > a,.xpro-navbar-primary .xpro-navbar-nav li > a:hover',
			'property'    => 'color',
			'media_query' => '@media (max-width: 1024px)',
		),
		array(
			'element'     => '.xpro-appear .xpro-navbar-primary .xpro-dropdown-menu > li a,.xpro-appear .xpro-navbar-primary .xpro-dropdown-menu > li a:hover',
			'property'    => 'color',
			'media_query' => '@media (max-width: 1024px)',
		),
		array(
			'element'     => '.xpro-navbar-primary .xpro-navbar-nav li > a > i > svg,.xpro-navbar-primary .xpro-navbar-nav li > a:hover > i > svg',
			'property'    => 'fill',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'color',
	'settings'    => 'xpro_hamburger_bdrcolor',
	'label'       => __( 'Separator Color', 'xpro' ),
	'description' => __( 'Specifies the separator color of hamburger menu.', 'xpro' ),
	'section'     => 'xpro_responsive_menu_section',
	'transport'   => 'auto',
	'choices'     => array(
		'alpha' => true,
	),
	'output'      => array(
		array(
			'element'     => '.xpro-navbar-primary .xpro-navbar-nav li',
			'property'    => 'border-color',
			'media_query' => '@media (max-width: 1024px)',
		),
		array(
			'element'     => '.xpro-navbar-primary .xpro-navbar-nav ul',
			'property'    => 'border-color',
			'media_query' => '@media (max-width: 1024px)',
		),
		array(
			'element'     => '.xpro-header .xpro-navbar-primary .xpro-navbar-nav li',
			'property'    => 'border-color',
			'media_query' => '@media (max-width: 1024px)',
		),
		array(
			'element'     => '.xpro-header .xpro-navbar-primary .xpro-navbar-nav ul',
			'property'    => 'border-color',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'color',
	'settings'    => 'xpro_hamburger_bgcolor',
	'label'       => __( 'Background Color', 'xpro' ),
	'description' => __( 'Specifies the color of hamburger menu background.', 'xpro' ),
	'section'     => 'xpro_responsive_menu_section',
	'transport'   => 'auto',
	'choices'     => array(
		'alpha' => true,
	),
	'output'      => array(
		array(
			'element'     => '.xpro-navbar-primary .xpro-navbar-collapse',
			'property'    => 'background-color',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'color',
	'settings'    => 'xpro_hamburger_close_btn_color',
	'label'       => __( 'Close Button', 'xpro' ),
	'description' => __( 'Specifies the color of hamburger close button.', 'xpro' ),
	'section'     => 'xpro_responsive_menu_section',
	'transport'   => 'auto',
	'default'     => '#fff',
	'choices'     => array(
		'alpha' => true,
	),
	'output'      => array(
		array(
			'element'     => '.xpro-header .xpro-navbar-primary .xpro-navbar-toggle.active::before, .xpro-appear .xpro-navbar-primary .xpro-navbar-toggle.active::after',
			'property'    => 'background-color',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);


/*=================================================
	Banner
=================================================*/

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_responsive_banner_height',
	'label'       => __( 'Banner Height', 'xpro' ),
	'description' => __( 'To change title banner height.', 'xpro' ),
	'section'     => 'xpro_responsive_banner_section',
	'transport'   => 'auto',
	'default'     => 100,
	'choices'     => array(
		'min'  => 50,
		'max'  => 1000,
		'step' => 5,
	),
	'output'      => array(
		array(
			'element'     => '.xpro-title-wrapper > .xpro-title-wrapper-inner',
			'property'    => 'height',
			'units'       => 'px',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_banner_type',
			'operator' => '!=',
			'value'    => 'none',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'xpro_responsive_banner_dimensions',
	'label'       => __( 'Banner Spacing', 'xpro' ),
	'description' => __( 'To change banner padding/margin e.g. 50px', 'xpro' ),
	'section'     => 'xpro_responsive_banner_section',
	'transport'   => 'auto',
	'default'     => array(
		'padding-top'    => '',
		'padding-bottom' => '',
		'margin-top'     => '',
		'margin-bottom'  => '',
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_banner_type',
			'operator' => '!=',
			'value'    => 'none',
		),
	),
	'choices'     => array(
		'labels' => array(
			'padding-top'    => __( 'Padding Top', 'xpro' ),
			'padding-bottom' => __( 'Padding Bottom', 'xpro' ),
			'margin-top'     => __( 'Margin Top', 'xpro' ),
			'margin-bottom'  => __( 'Margin Bottom', 'xpro' ),
		),
	),
	'output'      => array(
		array(
			'choice'      => 'padding-top',
			'element'     => '.xpro-title-wrapper',
			'property'    => 'padding-top',
			'media_query' => '@media (max-width: 1024px)',
		),
		array(
			'choice'      => 'padding-bottom',
			'element'     => '.xpro-title-wrapper',
			'property'    => 'padding-bottom',
			'media_query' => '@media (max-width: 1024px)',
		),
		array(
			'choice'      => 'margin-top',
			'element'     => '.xpro-title-wrapper',
			'property'    => 'margin-top',
			'media_query' => '@media (max-width: 1024px)',
		),
		array(
			'choice'      => 'margin-bottom',
			'element'     => '.xpro-title-wrapper',
			'property'    => 'margin-bottom',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);


$xpro_fields[] = array(
	'type'        => 'typography',
	'settings'    => 'xpro_responsive_banner_title_typography',
	'label'       => __( 'Title Font', 'xpro' ),
	'description' => __( 'Additional fonts for banner title.', 'xpro' ),
	'section'     => 'xpro_responsive_banner_section',
	'transport'   => 'auto',
	'default'     => array(
		'font-family'    => '',
		'font-size'      => '',
		'line-height'    => '',
		'letter-spacing' => '',
		'text-transform' => '',
	),
	'output'      => array(
		array(
			'element'     => '.xpro-title-wrapper .xpro-title-wrapper-text',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);

$xpro_fields[] = array(
	'type'      => 'select',
	'settings'  => 'xpro_font_weight_responsive_banner_title',
	'label'     => __( 'Font Weight', 'xpro' ),
	'section'   => 'xpro_responsive_banner_section',
	'transport' => 'auto',
	'choices'   => array(
		'normal' => __( 'Normal', 'xpro' ),
		'100'    => __( '100', 'xpro' ),
		'200'    => __( '200', 'xpro' ),
		'300'    => __( '300', 'xpro' ),
		'400'    => __( '400', 'xpro' ),
		'500'    => __( '500', 'xpro' ),
		'600'    => __( '600', 'xpro' ),
		'700'    => __( '700', 'xpro' ),
		'800'    => __( '800', 'xpro' ),
		'900'    => __( '900', 'xpro' ),
	),
	'output'    => array(
		array(
			'element'     => '.xpro-title-wrapper .xpro-title-wrapper-text',
			'property'    => 'font-weight',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_responsive_banner_breadcrumb_font',
	'label'       => __( 'Breadcrumb Font', 'xpro' ),
	'description' => __( 'To change breadcrumb font size.', 'xpro' ),
	'section'     => 'xpro_responsive_banner_section',
	'transport'   => 'auto',
	'default'     => 14,
	'choices'     => array(
		'min'  => 10,
		'max'  => 50,
		'step' => 1,
	),
	'output'      => array(
		array(
			'element'     => '.xpro-title-wrapper ul li',
			'property'    => 'font-size',
			'units'       => 'px',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
	'required'    => array(
		array(
			'setting'  => 'xpro_banner_breadcurmb_enable',
			'operator' => '==',
			'value'    => '1',
		),
	),
);

/*=================================================
	Footer
=================================================*/

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_responsive_footer_height',
	'label'       => __( 'Footer Height', 'xpro' ),
	'description' => __( 'To change footer height.', 'xpro' ),
	'section'     => 'xpro_responsive_footer_section',
	'transport'   => 'auto',
	'default'     => 80,
	'choices'     => array(
		'min'  => 0,
		'max'  => 300,
		'step' => 5,
	),
	'output'      => array(
		array(
			'element'     => '.xpro-copyright-bar',
			'property'    => 'height',
			'units'       => 'px',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);

$xpro_fields[] = array(
	'type'        => 'slider',
	'settings'    => 'xpro_responsive_footer_bottom_space',
	'label'       => __( 'Margin Top', 'xpro' ),
	'description' => __( 'To change footer top space.', 'xpro' ),
	'section'     => 'xpro_responsive_footer_section',
	'transport'   => 'auto',
	'default'     => 0,
	'choices'     => array(
		'min'  => 0,
		'max'  => 300,
		'step' => 5,
	),
	'output'      => array(
		array(
			'element'     => '.xpro-footer-wrapper',
			'property'    => 'margin-top',
			'units'       => 'px',
			'media_query' => '@media (max-width: 1024px)',
		),
	),
);
