<?php
/**
 * The main template file
 * @package Xpro
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

get_header();

$layout_option = xpro_get_option( 'xpro_blog_layout', 'right-layout' );
$layout_meta   = xpro_get_meta( 'xpro-sidebar-layout' );
$layout        = ( ! empty( $layout_meta ) ) ? $layout_meta : $layout_option;
$main_col      = ( 'left-layout' === $layout || 'right-layout' === $layout ) ? 'col-lg-8' : ' col-lg-12';

?>

	<div class="xpro-theme-grid <?php echo esc_attr( $main_col ); ?>">
		<main class="xpro-main xpro-post-classic">
			<?php do_action( 'xpro_content_loop' ); ?>
		</main>
	</div>

<?php

if ( 'left-layout' === $layout || 'right-layout' === $layout ) {
	?>
	<div class="col-lg-4">
		<?php do_action( 'xpro_sidebar' ); ?>
	</div>
	<?php
}

get_footer();
