<?php
/**
 * Custom hooks
 *
 * @package Xpro
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Add site info hook to WP hook library.
 */

if ( ! function_exists( 'xpro_site_info' ) ) {

	function xpro_site_info() {
		do_action( 'xpro_site_info' );
	}
}

/**
 * Add site info content.
 */

add_action( 'xpro_site_info', 'xpro_add_site_info' );
if ( ! function_exists( 'xpro_add_site_info' ) ) {

	function xpro_add_site_info() {
		$the_theme = wp_get_theme();

		$site_info = sprintf(
			'<a href="%1$s">%2$s</a><span class="sep"> | </span>%3$s(%4$s)',
			esc_url( __( 'http://wordpress.org/', 'xpro' ) ),
			sprintf(
			/* translators: WordPress */
				esc_html__( 'Proudly powered by %s', 'xpro' ),
				'WordPress'
			),
			sprintf( // WPCS: XSS ok.
			/* translators: 1: Theme name, 2: Theme author */
				esc_html__( 'Theme: %1$s by %2$s.', 'xpro' ),
				$the_theme->get( 'Name' ),
				'<a href="' . esc_url( __( 'http://xprotheme.com', 'xpro' ) ) . '">xprotheme.com</a>'
			),
			sprintf( // WPCS: XSS ok.
			/* translators: Theme version */
				esc_html__( 'Version: %1$s', 'xpro' ),
				$the_theme->get( 'Version' )
			)
		);

		echo apply_filters( 'xpro_site_info_content', $site_info ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}

add_action( 'xpro_header_before', 'xpro_do_skip_to_content_link', 2 );
/**
 * Add skip to content link before the header.
 *
 * @since 2.0
 */
function xpro_do_skip_to_content_link() {
	printf(
		'<a class="screen-reader-text skip-link" href="#content" title="%1$s">%2$s</a>',
		esc_attr__( 'Skip to content', 'xpro' ),
		esc_html__( 'Skip to content', 'xpro' )
	);
}

/**
 * Build the header.
 *
 * @since 1.0.0
 */
add_action( 'xpro_header', 'xpro_construct_header' );
if ( ! function_exists( 'xpro_construct_header' ) ) {

	function xpro_construct_header() {
		get_template_part( 'template-parts/header' );
	}
}

/**
 * Build the loader.
 *
 * @since 1.0.0
 */
add_action( 'xpro_loader', 'xpro_construct_loader' );
if ( ! function_exists( 'xpro_construct_loader' ) ) {

	function xpro_construct_loader() {
		get_template_part( 'template-parts/pre-loader' );
	}
}

/**
 * Build the title wrapper.
 *
 * @since 1.0.0
 */
add_action( 'xpro_title_wrapper', 'xpro_construct_title_wrapper' );
if ( ! function_exists( 'xpro_construct_title_wrapper' ) ) {

	function xpro_construct_title_wrapper() {
		get_template_part( 'template-parts/title-banner' );
	}
}

/**
 * Build the footer.
 *
 * @since 1.0.0
 */
add_action( 'xpro_footer', 'xpro_construct_footer' );
if ( ! function_exists( 'xpro_construct_footer' ) ) {

	function xpro_construct_footer() {
		get_template_part( 'template-parts/footer' );
	}
}

add_action( 'xpro_not_found', 'xpro_construct_not_found' );
if ( ! function_exists( 'xpro_construct_not_found' ) ) {

	function xpro_construct_not_found() {
		get_template_part( 'template-parts/not-found' );
	}
}

/**
 * Build the footer.
 *
 * @since 1.0.0
 */
add_action( 'xpro_scroll_top', 'xpro_construct_scroll_top' );
if ( ! function_exists( 'xpro_construct_scroll_top' ) ) {

	function xpro_construct_scroll_top() {

		$scroll_top = xpro_get_option( 'xpro_scrolltop_enable', '1' );

		if ( $scroll_top ) : ?>
			<span class="xpro-scroll-top-btn">
				<i class="xpro-icon xpro-icon-arrow-up">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 125">
					<path d="M43.781 21.504c-.68.648-1.074 1.008-1.445 1.379a78069.083 78069.083 0 0 0-31.188 31.125c-1.691 1.691-3.613 2.613-6.05 2.156a6.215 6.215 0 0 1-4.657-3.82 6.177 6.177 0 0 1 .782-5.957c.39-.496.816-.965 1.273-1.403C16.621 30.883 30.75 16.785 44.875 2.687c3.465-3.457 6.816-3.453 10.293 0 14.133 14.11 28.262 28.208 42.387 42.301 1.77 1.758 2.816 3.703 2.32 6.266a6.174 6.174 0 0 1-3.719 4.559c-1.933.8-4.136.57-5.867-.602a13.028 13.028 0 0 1-1.75-1.563 57360.005 57360.005 0 0 1-30.875-30.804c-.371-.39-.762-.727-1.43-1.36v96.039a11.07 11.07 0 0 1-.254 2.891c-.82 3.023-3.652 4.805-6.851 4.438a6.152 6.152 0 0 1-5.32-5.887c-.032-.633 0-1.266 0-1.899V21.504Zm0 0"/>
				</svg>
				</i>
			</span>
			<?php
		endif;
	}
}

/**
 * Build Sidebar.
 *
 * @since 1.0.0
 */
add_action( 'xpro_sidebar', 'xpro_construct_sidebar' );
if ( ! function_exists( 'xpro_construct_sidebar' ) ) {

	function xpro_construct_sidebar() {

		if ( is_active_sidebar( 'xpro-main-sidebar' ) ) {
			?>
			<aside class="xpro-aside-widget">
				<?php
				do_action( 'xpro_sidebars_before' );
				dynamic_sidebar( 'xpro-main-sidebar' );
				do_action( 'xpro_sidebars_after' );
				?>
			</aside>

			<?php
		}

	}
}

/**
 * Build Woo Sidebar.
 *
 * @since 1.0.0
 */
add_action( 'xpro_woo_sidebar', 'xpro_construct_woo_sidebar' );
if ( ! function_exists( 'xpro_construct_woo_sidebar' ) ) {

	function xpro_construct_woo_sidebar() {

		if ( is_active_sidebar( 'xpro-woocommerce-sidebar' ) ) {
			?>
			<aside class="xpro-aside-widget">
				<?php
				do_action( 'xpro_sidebars_before' );
				dynamic_sidebar( 'xpro-woocommerce-sidebar' );
				do_action( 'xpro_sidebars_after' );
				?>
			</aside>
			<?php
		}

	}
}

/**
 * Build Sidebar.
 *
 * @since 1.0.0
 */
add_action( 'xpro_content_before', 'xpro_construct_content_before' );
if ( ! function_exists( 'xpro_construct_content_before' ) ) {

	function xpro_construct_content_before() {

		$container_option = 'container';

		if ( is_page() ) {
			$container_option = xpro_get_option( 'xpro_page_container_layout', 'container' );
		} elseif ( is_home() ) {
			$container_option = xpro_get_option( 'xpro_blog_container_layout', 'container' );
		} elseif ( is_singular( 'post' ) ) {
			$container_option = xpro_get_option( 'xpro_single_container_layout', 'container' );
		} elseif ( is_404() ) {
			$container_option = xpro_get_option( 'xpro_not_found_container_layout', 'container' );
		} elseif ( class_exists( 'WooCommerce' ) && is_shop() ) {
			$container_option = xpro_get_option( 'xpro_shop_container_layout', 'container' );
		} elseif ( is_archive() ) {
			$container_option = xpro_get_option( 'xpro_archive_container_layout', 'container' );
		} elseif ( class_exists( 'woocommerce' ) && ( is_shop() || is_product_category() || is_product_tag() ) ) {
			$container_option = xpro_get_option( 'xpro_shop_container_layout', 'container' );
		} elseif ( class_exists( 'woocommerce' ) && is_product() ) {
			$container_option = xpro_get_option( 'xpro_product_single_container_layout', 'container' );
		} elseif ( class_exists( 'woocommerce' ) && is_cart() ) {
			$container_option = xpro_get_option( 'xpro_cart_container_layout', 'container' );
		} elseif ( class_exists( 'woocommerce' ) && is_checkout() ) {
			$container_option = xpro_get_option( 'xpro_checkout_container_layout', 'container' );
		} elseif ( class_exists( 'woocommerce' ) && is_account_page() ) {
			$container_option = xpro_get_option( 'xpro_account_container_layout', 'container' );
		}

		$container_meta = xpro_get_meta( 'xpro-content-layout' );
		$container      = ( ! empty( $container_meta ) ) ? $container_meta : $container_option;

		?>
		<div id="content" class="xpro-content-wrapper">
		<div class="<?php echo esc_attr( $container ); ?>">
		<div class="row">
		<?php
	}
}

/**
 * Build Sidebar.
 *
 * @since 1.0.0
 */
add_action( 'xpro_content_after', 'xpro_construct_content_after' );
if ( ! function_exists( 'xpro_construct_content_after' ) ) {

	function xpro_construct_content_after() {
		?>
		</div>
		</div>
		</div>
		<?php
	}
}

/**
 * Build Post nav.
 *
 * @since 1.0.0
 */
add_action( 'xpro_post_nav', 'xpro_construct_post_nav' );

if ( ! function_exists( 'xpro_construct_post_nav' ) ) {
	/**
	 * Display navigation to next/previous post when applicable.
	 */
	function xpro_construct_post_nav() {
		// Don't print empty markup if there's nowhere to navigate.
		$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
		$next     = get_adjacent_post( false, '', false );

		$svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 100 54"><g id="xpro-chevron">
                    <path d="M 50 43.402344 C 50.289062 42.976562 50.601562 42.570312 50.9375 42.179688 C 64.570312 28.667969 78.207031 15.152344 91.847656 1.636719 C 93.1875 0.308594 94.710938 -0.328125 96.558594 0.15625 C 98.066406 0.546875 99.265625 1.675781 99.730469 3.144531 C 100.199219 4.613281 99.867188 6.21875 98.855469 7.390625 C 98.675781 7.605469 98.472656 7.804688 98.269531 8.003906 L 53.507812 52.335938 C 52.121094 53.710938 50.527344 54.410156 48.609375 53.738281 C 47.8125 53.449219 47.09375 52.988281 46.496094 52.394531 C 31.503906 37.597656 16.527344 22.777344 1.566406 7.9375 C -0.375 6.019531 -0.421875 3.246094 1.375 1.445312 C 3.238281 -0.414062 6.003906 -0.355469 8.007812 1.625 C 21.65625 15.132812 35.300781 28.640625 48.941406 42.15625 C 49.242188 42.453125 49.488281 42.800781 50 43.402344 Z M 50 43.402344 "/>
                    </g></svg>';

		if ( ! $next && ! $previous ) {
			return;
		}
		?>
		<nav class="xpro-post-single-navigation">
			<h2 class="sr-only"><?php esc_html_e( 'Post navigation', 'xpro' ); ?></h2>
			<div class="xpro-post-navigation-list">
				<div class="row">
					<?php
					if ( get_previous_post_link() ) {
						// phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText
						previous_post_link( '<div class="col-6 mr-auto"><div class="xpro-nav-previous">%link</div>', _x( '<i class="xpro-icon xpro-icon-chevron-left">' . $svg_icon . '</i><div class="xpro-nav-content"><span>' . __( 'Previous Post', 'xpro' ) . '</span><h6>%title</h6></div></div>', 'Previous post link', 'xpro' ) );
					}
					if ( get_next_post_link() ) {
						// phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText
						next_post_link( '<div class="col-6 ml-auto"><div class="xpro-nav-next">%link</div>', _x( '<div class="xpro-nav-content"><span>' . __( 'Next Post', 'xpro' ) . '</span><h6>%title</h6></div><i class="xpro-icon xpro-icon-chevron-right">' . $svg_icon . '</i></div>', 'Next post link', 'xpro' ) );
					}
					?>
				</div>
			</div><!-- .nav-links -->
		</nav><!-- .navigation -->
		<?php
	}
}

/**
 * Build Pagination.
 *
 * @since 1.0.0
 */
add_action( 'xpro_pagination', 'xpro_construct_pagination' );

if ( ! function_exists( 'xpro_construct_pagination' ) ) {

	function xpro_construct_pagination() {
		xpro_pagination();
	}
}

/**
 * Build Content Loop.
 *
 * @since 1.0.0
 */

add_action( 'xpro_content_loop', 'xpro_construct_content_loop' );

if ( ! function_exists( 'xpro_construct_content_loop' ) ) {

	function xpro_construct_content_loop() {

		if ( have_posts() ) {

			while ( have_posts() ) {

				the_post();

				if ( is_home() ) {
					get_template_part( 'template-parts/index/content', 'post-classic' );

				} elseif ( is_archive() || is_author() || is_category() || is_search() || is_tag() ) {
					get_template_part( 'template-parts/archive/content', 'post-classic' );
				} elseif ( is_page() ) {
					get_template_part( 'template-parts/page/content', 'page' );
				} elseif ( is_single() ) {
					get_template_part( 'template-parts/single/content', 'single' );
				}
			}

			do_action( 'xpro_pagination' );

		} else {
			get_template_part( 'template-parts/content', 'none' );
		}
	}
}

if ( class_exists( 'woocommerce' ) ) {
	/* To Remove woocommerce_breadcrumb Action And Add New Action For WooCommerce Breadcrumb */
	remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart' );

	add_action( 'xpro_woocommerce_breadcrumb', 'xpro_woocommerce_breadcrumb', 20, 0 );
	if ( ! function_exists( 'xpro_woocommerce_breadcrumb' ) ) {
		function xpro_woocommerce_breadcrumb( $args = array() ) {
			// phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound
			$args = wp_parse_args(
				$args,
				apply_filters(
					'woocommerce_breadcrumb_defaults',
					array(
						'delimiter'   => '',
						'wrap_before' => '',
						'wrap_after'  => '',
						'before'      => '<li>',
						'after'       => '</li>',
						'home'        => _x( 'Home', 'breadcrumb', 'xpro' ),
					)
				)
			);

			$breadcrumbs = new WC_Breadcrumb();

			if ( ! empty( $args['home'] ) ) {
				// phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound
				$breadcrumbs->add_crumb( $args['home'], apply_filters( 'woocommerce_breadcrumb_home_url', home_url() ) );
			}

			$args['breadcrumb'] = $breadcrumbs->generate();

			/**
			 * WooCommerce Breadcrumb hook
			 *
			 * @hooked WC_Structured_Data::generate_breadcrumblist_data() - 10
			 */
			// phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound
			do_action( 'woocommerce_breadcrumb', $breadcrumbs, $args );

			wc_get_template( 'global/breadcrumb.php', $args );
		}
	}

	add_filter(
		'woocommerce_show_page_title',
		function () {
			return false;
		}
	);

	// Fix html on item product
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
	add_action( 'woocommerce_before_shop_loop_item', 'xpro_before_shop_loop_item' );
	add_action( 'xpro_before_shop_loop_item', 'woocommerce_show_product_loop_sale_flash', 10 );
	add_action( 'xpro_before_shop_loop_item', 'woocommerce_template_loop_product_thumbnail', 10 );

	function xpro_before_shop_loop_item() {
		echo '<div class="product-thumbnail">';
		do_action( 'xpro_before_shop_loop_item' );
		echo '</div><div class="product-info">';
	}
	add_action(
		'woocommerce_after_shop_loop_item',
		function() {
			echo '</div>';
		},
		99
	);


	add_filter( 'loop_shop_columns', 'xpro_loop_columns', 999 );

	function xpro_loop_columns() {
		$column = xpro_get_option( 'xpro_shop_product_column', 3 );
		return $column;
	}

	add_filter( 'loop_shop_per_page', 'xpro_loop_shop_per_page', 20 );

	function xpro_loop_shop_per_page( $cols ) {
		$product_per_page = xpro_get_option( 'xpro_shop_product_per_page', 12 );
		return $product_per_page;
	}

	add_filter( 'woocommerce_output_related_products_args', 'xpro_related_products_args', 20 );
	function xpro_related_products_args( $args ) {
		$args['posts_per_page'] = 3;
		$args['columns']        = 3;
		return $args;
	}
}
