<?php
/**
 * Xpro functions and definitions
 *
 * @package Xpro
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

// Xpro's includes directory.
$xpro_inc_dir = get_template_directory();

// Array of files to include.
$xpro_includes = array(

	'/inc/setup.php',                           // Theme setup and custom theme supports.
	'/inc/widgets.php',                         // Register widget area.
	'/inc/enqueue.php',                         // Enqueue scripts and styles.
	'/inc/template-tags.php',                   // Custom template tags for this theme.
	'/inc/pagination.php',                      // Custom pagination for this theme.
	'/inc/hooks.php',                           // Custom hooks.
	'/inc/extras.php',                          // Custom functions that act independently of the theme templates.
	'/inc/editor.php',                          // Load Editor functions.

	//Classes
	'/classes/class-xpro-loop.php',             // Load class navwalker.
	'/classes/class-xpro-navwalker.php',        // Load class navwalker.
	'/classes/class-xpro-script-loader.php',    // Load class script loader.
	'/classes/class-xpro-breadcrumb.php',       // Load breadcrumb.
	'/classes/class-xpro-meta-boxes.php',       // Load meta boxes.

	//Compatibility
	'/classes/compatibility/class-elementor-compatibility.php',      // Elementor Compatibility.
	'/classes/compatibility/class-elementor-pro-compatibility.php',  // Elementor Pro Compatibility.
	'/classes/compatibility/class-beaver-builder-compatibility.php',  // Beaver Builder Compatibility.
	'/classes/compatibility/class-beaver-themer-compatibility.php',  // Beaver Themer Compatibility.

	//Libraries
	'/lib/customizer/customizer-config.php',          // Load class navwalker.

);

//Plugins
if ( ! class_exists( 'Kirki' ) ) {
	$xpro_includes[] = '/lib/plugins/kirki/kirki.php'; // Load Kirki Customizer.
}

// Include files.
foreach ( $xpro_includes as $xpro_file ) {
	require_once $xpro_inc_dir . $xpro_file;
}
