<?php
/**
 * Beaver Builder Compatibility File.
 *
 * @package Xpro
 */

// If plugin - 'Builder Builder' not exist then return.
if ( ! class_exists( 'FLBuilderModel' ) ) {
	return;
}

/**
 * Xpro Beaver Builder Compatibility
 */
if ( ! class_exists( 'Xpro_Beaver_Builder_Compatibility' ) ) :

	/**
	 * Xpro Beaver Builder Compatibility
	 *
	 * @since 1.0.0
	 */
	class Xpro_Beaver_Builder_Compatibility {

		/**
		 * Member Variable
		 *
		 * @var object instance
		 */
		private static $instance;

		/**
		 * Initiator
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * Constructor
		 */
		public function __construct() {
			add_action( 'wp', array( $this, 'beaver_builder_default_setting' ) );
		}

		/**
		 * Builder Template Content layout set as Full Width / Stretched
		 *
		 * @since  1.0.13
		 * @return void
		 */
		public function beaver_builder_default_setting() {

			if ( false === xpro_enable_page_builder_compatibility() || get_post_type() === 'post' ) {
				return;
			}

			if ( 'fl-builder-template' === get_post_type() ) {
				remove_action( 'xpro_header', 'xpro_construct_header' );
				remove_action( 'xpro_title_wrapper', 'xpro_construct_title_wrapper' );
				remove_action( 'xpro_content_before', 'xpro_construct_content_before' );
				remove_action( 'xpro_content_after', 'xpro_construct_content_after' );
				remove_action( 'xpro_footer', 'xpro_construct_footer' );
				remove_action( 'xpro_post_nav', 'xpro_construct_post_nav' );
				remove_action( 'xpro_sidebar', 'xpro_construct_sidebar' );
				remove_action( 'xpro_content_loop', 'xpro_construct_content_loop' );
				add_action( 'xpro_content_loop', array( $this, 'construct_content_loop' ) );
			}

		}

		public function construct_content_loop() {
			while ( have_posts() ) {
				the_post();
				the_content();
			}
			wp_reset_postdata();
		}

	}

endif;

/**
 * Kicking this off by calling 'get_instance()' method
 */
Xpro_Beaver_Builder_Compatibility::get_instance();