<?php
/**
 * The main template file
 * @package Xpro
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

get_header();

$layout   = xpro_get_option( 'xpro_archive_layout', 'right-layout' );
$main_col = ( 'left-layout' === $layout || 'right-layout' === $layout ) ? 'col-lg-8' : ' col-lg-12';
?>

	<div class="xpro-theme-grid <?php echo esc_attr( $main_col ); ?>">
		<main class="xpro-main xpro-post-classic">
			<?php do_action( 'xpro_content_loop' ); ?>
		</main>
	</div>

<?php

if ( 'left-layout' === $layout || 'right-layout' === $layout ) {
	?>
	<div class="col-lg-4">
		<?php do_action( 'xpro_sidebar' ); ?>
	</div>
	<?php
}

get_footer();
