<?php get_header( ); ?>

<article id="post-<?php the_ID( ); ?>" <?php post_class( ); ?>>
    <header class="entry-header">
        
            <h1 class="entry-title"><?php the_title( ); ?></h1>
        
        <div class="entry-meta">      
            <div class="col-md-12 col-xs-12 mobile-content margin-top-bottom-15">
                
                <div class="col-md-3 col-xs-3">
                    <span class="glyphicon glyphicon-comment"></span> <?php
                    echo xodogo_comment_with_link( );
                    ?>
                </div>
                <div class="col-md-3 col-xs-4">
                    <span class="glyphicon glyphicon-time"></span><span class="published"><span class="value">
                            <a href="<?php echo get_permalink( ); ?>" rel="bookmark" title="<?php echo the_time( 'F j Y' ); ?>" ><?php echo the_time( 'Y-m-d' ); ?></a></span>
                    </span>
                </div>
                <div class="col-md-3 col-xs-3">
                    <span class="glyphicon glyphicon-refresh"></span><span class="updated"><span class="value">
                            <a href="<?php echo get_permalink( ); ?>" rel="bookmark" title="<?php echo the_modified_date( 'F j Y' ); ?>" ><?php echo the_modified_date( 'Y-m-d' ); ?></a></span>
                    </span>
                </div>
            </div>
        </div><!-- .entry-meta -->
    </header><!-- .entry-header -->

   <div class="entry-meta">
                    <?php
                    $metadata = wp_get_attachment_metadata( );
                    printf( '<span class="attachment-meta full-size-link"><a href="%1$s" title="%2$s">%3$s ( %4$s &times; %5$s )</a></span>', esc_url( wp_get_attachment_url( ) ), esc_attr__( 'Link to full-size image', 'xodogo' ), __( 'Full resolution', 'xodogo' ), $metadata['width'], $metadata['height']
                     );
                    edit_post_link( __( 'Edit', 'xodogo' ), '<span class="edit-link">', '</span>' );
                    ?>
                </div><!-- .entry-meta -->
        <div class="entry-content">
           <nav id="image-navigation" class="navigation image-navigation" role="navigation">
                    <span class="nav-previous round-full-color">
                        <?php previous_image_link( false, __( '<span class="glyphicon glyphicon-backward"></span>  Previous ', 'xodogo' ) ); ?>
                    </span>
                    <span class="nav-next round-full-color pull-right">
                        <?php next_image_link( false, __( 'Next  <span class="glyphicon glyphicon-forward"></span>', 'xodogo' ) ); ?>
                    </span>
                </nav><!-- #image-navigation -->
        </div>
        <footer class="entry-meta">
            <div class="entry-attachment">
                    <div class="attachment center">
                        <?php xodogo_the_attached_image( ); ?>
                    </div><!-- .attachment -->
                </div><!-- .entry-attachment -->
        </footer><!-- .entry-content -->
</article><!-- #post -->

<?php comments_template( ); ?>
<?php get_footer( ); ?>