<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package Buffercode
 */
?><!DOCTYPE html>
<html <?php language_attributes( ); ?>>
    <head>
        <title><?php wp_title( '|', true, 'right' ); ?></title>
        <?php wp_head( ); ?>
    </head>
    <body <?php body_class( ); ?>>
        <div id="page" class="container hfeed site">
            <?php 
             $xodogo_custom_options_values = get_option('xodogo_custom_options');
             $xodogo_TC_logo = esc_url( $xodogo_custom_options_values[ 'xodogo_TC_logo' ] ); ?>

            <header id="masthead" class="site-header" role="banner">
                <div class="row">
                    <div class="col-md-8 mobile-head">
                        <?php if ( !empty( $xodogo_TC_logo ) ) { ?>
                            <span class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo $xodogo_TC_logo; ?>" alt="<?php bloginfo( 'name' ); ?>" width="290" height="94"/></a></span>
                        <?php } else { ?>
                            <a class="home-link" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                                <h1 class="site-title"><?php bloginfo( 'name' ); ?></h1>
                                <h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
                            </a>
                        <?php } ?>
                    </div>
                    <div class="col-md-4" >
                        <div class="row">
                            <?php get_search_form( ); ?>
                        </div>
                    </div>
                </div>
            </header><!-- #masthead -->
            <nav class="navbar navbar-default" role="navigation">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="row">
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-ex1-collapse">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                    </div>
                    <?php
                    wp_nav_menu( array( 
                        'theme_location' => __( 'primary','xodogo' ),
                        'depth' => 2,
                        'container' => 'div',
                        'container_class' => 'collapse navbar-collapse navbar-ex1-collapse',
                        'menu_class' => 'nav navbar-nav dropdown',
                        'fallback_cb' => 'wp_bootstrap_navwalker::fallback',
                        'walker' => new wp_bootstrap_navwalker( ) )
                     );
                    ?>
                </div>
            </nav>
            <div  class="row">
                <?php
               
                $xodogo_banner_option_value = esc_attr( $xodogo_custom_options_values['xodogo_banner_option_value']);
                $xodogo_TC_banner_script = esc_attr( $xodogo_custom_options_values[ 'xodogo_TC_banner_script' ] );
                switch ( $xodogo_banner_option_value ) {
                    case 1:
                        echo '<div class="col-md-8 xodogo_top_ads_728x90"><a href="' . esc_url( $xodogo_custom_options_values[ 'xodogo_TC_banner_728x80_url' ] ) . '"><img src="' . esc_url( $xodogo_custom_options_values[ 'xodogo_TC_banner_728x80' ] ) . '" /></a></div>';
                        break;
                    case 2:
                        echo '<div class="col-md-8 xodogo_top_ads_728x90">' . html_entity_decode( $xodogo_TC_banner_script, ENT_COMPAT ) . '</div>';
                        break;
                    case 0:
                        echo '<div class="col-md-8 xodogo_top_ads_728x90"></div>';
                        break;
                    default:
                        echo '<div class="col-md-8 xodogo_top_ads_728x90"></div>';
                }
                ?>
                <div class="col-md-4 social-hide"><?php if ( !dynamic_sidebar( 'xodogo_social_netw' ) ) { ?>
                        <div class="row social">
                            <?php
                            
                            if ( 1 == esc_attr( $xodogo_custom_options_values[ 'xodogo_social_enable' ] ) ) {
                                $xodogo_TC_FB = esc_url( $xodogo_custom_options_values[ 'xodogo_TC_FB' ] );
                                $xodogo_TC_linked = esc_url( $xodogo_custom_options_values[ 'xodogo_TC_linked' ] );
                                $xodogo_TC_Twitter = esc_url( $xodogo_custom_options_values[ 'xodogo_TC_Twitter' ] );
                                $xodogo_TC_GP = esc_url( $xodogo_custom_options_values[ 'xodogo_TC_GP' ] );

                                if ( !empty( $xodogo_TC_FB ) ) {
                                    ?>
                                    <div class="col-md-2 thumbnail">
                                        <a href="<?php echo $xodogo_TC_FB; ?>">
                                            <img src="<?php echo get_template_directory_uri( ) . '/images/facebook.png'; ?>" alt="Facebook" width="50" height="50" />
                                        </a>
                                    </div>
                                <?php }
                                if ( !empty( $xodogo_TC_linked ) ) {
                                    ?>
                                    <div class="col-md-2 thumbnail">
                                        <a href="<?php echo $xodogo_TC_linked; ?>">
                                            <img src="<?php echo get_template_directory_uri( ) . '/images/linkedin.png'; ?>" alt="LinkedIn" width="50" height="50" />
                                        </a>
                                    </div>
        <?php }
        if ( !empty( $xodogo_TC_Twitter ) ) {
            ?>
                                    <div class="col-md-2 thumbnail">
                                        <a href="<?php echo $xodogo_TC_Twitter; ?>">
                                            <img src="<?php echo get_template_directory_uri( ) . '/images/twitter.png'; ?>" alt="Twitter" width="50" height="50" />
                                        </a>
                                    </div>
        <?php }
        if ( !empty( $xodogo_TC_GP ) ) {
            ?>
                                    <div class="col-md-2 thumbnail">
                                        <a href="<?php echo $xodogo_TC_GP; ?>">
                                            <img src="<?php echo get_template_directory_uri( ) . '/images/google-plus.png'; ?>" alt="Google Plus" width="50" height="50" />
                                        </a>
                                    </div>
        <?php
        }
    }
}
?>
                    </div>
                </div>
            </div>
            <div id="content" class="row">