<?php
    /**
     *  Menu
     */
    require_once( 'inc/wp_bootstrap_navwalker.php' );
    
    /**
     *  Custom header
     */
    require get_template_directory() . '/inc/cust-header.php';
    
    /** 
     * Comment - Archieve - Tag - Comments
     */
    include 'catc-widget.php';
    
function xodogo_setup(){
    /**
     *  Feedlinks
     */
    add_theme_support( 'automatic-feed-links' );
    
    /**
     *  Comment form
     */
    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
    
    /**
     * Menus
     */
    register_nav_menus( array( 'primary' => __( 'Primary Menu', 'xodogo' ), ) );
    
    /**
     * Post Thumbnails
     */
    add_theme_support( 'post-thumbnails' );
    set_post_thumbnail_size( 150, 150, true );
    
}
add_action( 'after_setup_theme', 'xodogo_setup' );

// For Content and attachment format
function xodogo_content_width() {
    global $content_width;
    // For content width
    if ( !isset( $content_width ) )
        $content_width = 1200;
    if ( is_attachment() )
        $content_width = 724;
}

add_action( 'template_redirect', 'xodogo_content_width' );

// Post Thumbnail
add_filter( 'post_thumbnail_html', 'xodogo_post_thumbnail', 10, 3 );

function xodogo_post_thumbnail( $html, $post_id, $post_image_id ) {
    $html = '<a href="' . esc_url( get_permalink( $post_id ) ) . '" title="' . esc_attr( get_the_title( $post_id ) ) . '">' . $html . '</a>';
    return $html;
}

//Adding featured image end
#Buffercode Script Location

function xodogo_style() {
    echo '<meta name="viewport" content="width=device-width, initial-scale=1.0">';
    echo '<meta charset="';
    bloginfo( "charset" );
    echo '" />';
    echo '<link rel="profile" href="http://gmpg.org/xfn/11" />';
    echo '<link rel="pingback" href="';
    bloginfo( "pingback_url" );
    echo '" />';
    $xodogo_custom_options_values = get_option('xodogo_custom_options');
    $xodogo_TC_favicon_set = esc_url( $xodogo_custom_options_values['xodogo_TC_favicon']  );
    if( !empty( $xodogo_TC_favicon_set ) ) {
        echo '<link rel="shortcut icon" href="' . esc_url( $xodogo_TC_favicon_set ) . '" />';
    }
    
}

add_action( 'wp_head', 'xodogo_style' );

function xodogo_styles_scripts() {
    if ( !is_admin() ) {
        wp_enqueue_script( 'jquery-bootstrap', get_template_directory_uri() . '/js/bootstrap.js', array( 'jquery' ), '3.0.3', true );
        wp_enqueue_script( 'xodogo-popup', get_template_directory_uri() . '/js/pop.js', array( 'jquery' ), '3.0.3', true );
        wp_enqueue_style( 'xodogo-style', get_stylesheet_uri() );
        wp_enqueue_style( 'xodogo-style-boot', get_template_directory_uri() . '/css/bootstrap.css' );
    }
    if ( is_singular() && comments_open() && esc_attr( get_option( 'thread_comments' ) ) ) {
    wp_enqueue_script( 'comment-reply' );
    }

    wp_enqueue_style( 'xodogo-google-fonts', '//fonts.googleapis.com/css?family=Copse' );
}

add_action( 'wp_enqueue_scripts', 'xodogo_styles_scripts' );


#Comment Number with Link
if ( ! function_exists( 'xodogo_comment_with_link' ) ) {
function xodogo_comment_with_link() {
    $xodogo_number_comments = get_comments_number();
    if ( comments_open() ) {
        if ( $xodogo_number_comments == 0 ) {
            $xodogo_comments = __( 'No Comments', 'xodogo' );
        } elseif ( $xodogo_number_comments > 1 ) {
            $xodogo_comments = $xodogo_number_comments . __( ' Comments', 'xodogo' );
        } else {
            $xodogo_comments = __( '1 Comment', 'xodogo' );
        }
        $xodogo_output_comments = '<a href="' . get_comments_link() . '">' . $xodogo_comments . '</a>';
    } else {
        $xodogo_output_comments = __( 'Comment Disabled', 'xodogo' );
    }
    return $xodogo_output_comments;
}
}

# Five Sidebars

function xodogo_widgets() {

    register_sidebar( array(
        'name' => __( 'Right Sidebar','xodogo' ),
        'id' => 'xodogo_right_sidebar',
        'before_widget' => '<div class="sidebar-bg">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="rounded">',
        'after_title' => '</h2>',
    ) );

    register_sidebar( array(
        'name' => __( 'Left Footer','xodogo' ),
        'id' => 'xodogo_left_footer',
        'before_widget' => '<div class="sidebar-bg">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="rounded">',
        'after_title' => '</h2>',
    ) );
    register_sidebar( array(
        'name' => __( 'Center Footer','xodogo' ),
        'id' => 'xodogo_center_footer',
        'before_widget' => '<div class="sidebar-bg">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="rounded">',
        'after_title' => '</h2>',
    ) );
    register_sidebar( array(
        'name' => __( 'Right Footer','xodogo' ),
        'id' => 'xodogo_right_footer',
        'before_widget' => '<div class="sidebar-bg">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="rounded">',
        'after_title' => '</h2>',
    ) );

    register_sidebar( array(
        'name' => __( 'Social Network','xodogo' ),
        'id' => 'xodogo_social_netw',
        'before_widget' => '<div class="xodogo_social_network">',
        'after_widget' => '</div>',
        'before_title' => '',
        'after_title' => '',
    ) );
}

add_action( 'widgets_init', 'xodogo_widgets' );


//Customizing front page comment view like username, email id, url, textarea.

add_filter( 'comment_form_default_fields', 'xodogo_comment_form_fields' );

function xodogo_comment_form_fields( $fields ) {
    $commenter = wp_get_current_commenter();
    $req = esc_attr( get_option( 'require_name_email' ) );
    $aria_req = ( $req ? " aria-required='true'" : '' );
    $html5 = current_theme_supports( 'html5', 'comment-form' ) ? 1 : 0;
    $fields = array( 
        'author' => '<div class="form-group comment-form-author">' . '<label for="author">' . __( 'Name', 'xodogo' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
        '<input placeholder="Enter Your Name" class="form-control" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></div>',
        'email' => '<div class="form-group comment-form-email"><label for="email">' . __( 'Email', 'xodogo' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
        '<input placeholder="Enter You Email-ID" class="form-control" id="email" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' /></div>',
        'url' => '<div  class="form-group comment-form-url"><label for="url">' . __( 'Website', 'xodogo' ) . '</label> ' .
        '<input placeholder="Enter Your Web Address" class="form-control" id="url" name="url" ' . ( $html5 ? 'type="url"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></div>',
    );
    return $fields;
}

add_filter( 'comment_form_defaults', 'xodogo_comment_form_textarea' );

function xodogo_comment_form_textarea( $args ) {
    $args['comment_field'] = '<div class="form-group comment-form-comment">
    <label for="comment">' . __( 'Comment', 'xodogo' ) . '</label>
    <textarea placeholder="Enter Your Comments" class="form-control" id="comment" name="comment" cols="45" rows="8" aria-required="true"></textarea>
    </div>';
    return $args;
}

add_action( 'comment_form', 'xodogo_comment_button' );

function xodogo_comment_button() {
    echo '<button class="btn btn-default" type="submit">' . __( 'Submit', 'xodogo' ) . '</button>';
}

// for <title> tag in header
add_filter( 'wp_title', 'xodogo_header_title', 10, 3 );

function xodogo_header_title( $title, $sep, $seplocation ) {
    global $page, $paged;
    // Don't affect in feeds.
    if ( is_feed() )
        return $title;
    // Add the blog name
    if ( 'right' == $seplocation )
        $title .= get_bloginfo( 'name' );
    else
        $title = get_bloginfo( 'name' ) . $title;
    // Add the blog description for the home/front page.
    $site_description = get_bloginfo( 'description', 'display' );
    if ( $site_description && ( is_home() || is_front_page() ) )
        $title .= " {$sep} {$site_description}";
    // Add a page number if necessary:
    if ( $paged >= 2 || $page >= 2 )
        $title .= " {$sep} " . sprintf( __( 'Page %s', 'xodogo' ), max( $paged, $page ) );
    return $title;
}

//Custom Comment Customization to display in front page
if ( ! function_exists( 'xodogo_comments' ) ){
function xodogo_comments( $comment, $args, $depth ) {
    $GLOBALS['comment'] = $comment;
    ?>
    <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
        <div id="comment-<?php comment_ID(); ?>">
            	
                <?php echo get_avatar( $comment->comment_author_email, 30 ); ?>			
                <?php echo get_comment_author_link() ?>
                <a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf( __( '%1$s at %2$s', 'xodogo' ), get_comment_date(), get_comment_time() ) ?></a> //
        <?php if ( comments_open() && $args['max_depth'] != $depth ) { ?>		
            <?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ) ?>
        <?php } ?> //
        <?php edit_comment_link( '<span class="glyphicon glyphicon-pencil"></span>', '  ', '' ) ?>
            
        <?php if ( $comment->comment_approved == '0' ) : ?>
                <div class="comment-info"><?php _e( 'Your comment is awaiting moderation.', 'xodogo' ) ?></div>
        <?php endif; ?>
            <div class="comment-text">	
        <?php comment_text() ?>	
            </div>
        </div><?php
    }
}
// Attached image for image.php

    if ( !function_exists( 'xodogo_the_attached_image' ) ) {

        function xodogo_the_attached_image() {

            $attachment_size = apply_filters( 'xodogo_attachment_size', array( 724, 724 ) );
            $next_attachment_url = wp_get_attachment_url();
            $post = get_post();

            $attachment_ids = get_posts( array( 
                'post_parent' => $post->post_parent,
                'fields' => 'ids',
                'numberposts' => -1,
                'post_status' => 'inherit',
                'post_type' => 'attachment',
                'post_mime_type' => 'image',
                'order' => 'ASC',
                'orderby' => 'menu_order ID'
                    ) );

            // If there is more than 1 attachment in a gallery...
            if ( count( $attachment_ids ) > 1 ) {
                foreach ( $attachment_ids as $attachment_id ) {
                    if ( $attachment_id == $post->ID ) {
                        $next_id = current( $attachment_ids );
                        break;
                    }
                }

                // get the URL of the next image attachment...
                if ( $next_id )
                    $next_attachment_url = get_attachment_link( $next_id );

                // or get the URL of the first image attachment.
                else
                    $next_attachment_url = get_attachment_link( array_shift( $attachment_ids ) );
            }

            printf( '<a href="%1$s" title="%2$s" rel="attachment">%3$s</a>', esc_url( $next_attachment_url ), the_title_attribute( array( 'echo' => false ) ), wp_get_attachment_image( $post->ID, $attachment_size )
            );
        }

    }

    // Attached image for image.php - Ends

    /**
     *  Custom Theme settings
     * 1. Custom Settings
     * 2. Top Banner Ads
     * 3. Author Social information
     * 
     */

    /**
     *  1. Custom Settings
     * Custom - Social Information, Footer Link, Header Logo
     * 
     */
    
  function xodogo_default_values(){
            $xodogo_custom = array(
                        'xodogo_social_enable',
                        'xodogo_TC_FB',
                        'xodogo_TC_linked',
                        'xodogo_TC_Twitter',
                        'xodogo_TC_GP',
                        'xodogo_TC_copy_text',
                        'xodogo_TC_copy_url',
                        'xodogo_TC_logo',
                        'xodogo_TC_favicon',
                        'xodogo_banner_option_value',
                        'xodogo_TC_banner_728x80',
                        'xodogo_TC_banner_728x80_url',
                        'xodogo_TC_banner_script'
                    );
       
            
add_option('xodogo_custom_options',$xodogo_custom);            
  }

 register_activation_hook(__FILE__, 'xodogo_default_values');
    
    
if ( ! function_exists( 'xodogo_theme_social_function' ) ){
     function xodogo_theme_social_function() {
            
        if ( !current_user_can( 'manage_options' ) ) {
            wp_die( __( 'You do not have sufficient permissions to access this page.', 'xodogo' ) );
        }
        
           /*
            * Checking for Nonce
            */
            if(isset($_REQUEST['xodogo_custom_nonce'])) {
                $xodogo_custom_nonce = esc_attr($_REQUEST['xodogo_custom_nonce']);
                    if (! wp_verify_nonce($xodogo_custom_nonce, 'xodogo-setting-nonce') ) {
                        die("Security check");
                        }
             }   

        if ( isset( $_POST['hidden_social_name'] ) && esc_attr( $_POST['hidden_social_name'] ) == 'Y' ) {
            
            $xodogo_custom_options_values = get_option('xodogo_custom_options');
            
            $xodogo_custom_options_values['xodogo_social_enable'] = isset( $_POST['xodogo_social_enable'] );
            $xodogo_custom_options_values['xodogo_TC_FB'] = esc_url_raw( $_POST['xodogo_TC_FB'] );
            $xodogo_custom_options_values['xodogo_TC_linked'] = esc_url_raw( $_POST['xodogo_TC_linked'] );
            $xodogo_custom_options_values['xodogo_TC_Twitter'] = esc_url_raw( $_POST['xodogo_TC_Twitter'] );
            $xodogo_custom_options_values['xodogo_TC_GP'] = esc_url_raw( $_POST['xodogo_TC_GP'] );
            $xodogo_custom_options_values['xodogo_TC_copy_text'] = esc_attr( $_POST['xodogo_TC_copy_text'] );
            $xodogo_custom_options_values['xodogo_TC_copy_url'] = esc_url_raw( $_POST['xodogo_TC_copy_url'] );
            $xodogo_custom_options_values['xodogo_TC_logo'] = esc_url_raw( $_POST['xodogo_TC_logo'] );
            $xodogo_custom_options_values['xodogo_TC_favicon'] = esc_url_raw( $_POST['xodogo_TC_favicon'] );
            
            update_option('xodogo_custom_options', $xodogo_custom_options_values);
        
            echo'<div class="updated"><p><strong>'. __( 'Updated Successfully...','xodogo' ) .'</strong></p></div>';
        }
       
        ?>
        <?php $xodogo_custom_options_values = get_option('xodogo_custom_options'); ?>
        <form method="post" action="" name="xodogo_theme_social">
            <h2><?php _e( 'Xodogo Setting','xodogo' ) ?></h2>
            <table class="form-table">

                <tr valign="top">
                    <td>
                        <input type="checkbox" name="xodogo_social_enable" value="1" <?php checked($xodogo_custom_options_values['xodogo_social_enable'], 1 ); ?> /><?php  _e( 'Enable the below Social ? If not you can use any plugin to add in social widget in widget location.','xodogo' ); ?>
                    </td>
                </tr>

                <tr valign="top">
                    <td>
                        <input placeholder="Facebook URL"  type="text" size="35" name="xodogo_TC_FB" value="<?php echo esc_url( $xodogo_custom_options_values['xodogo_TC_FB'] ); ?>" />
                    </td>
                </tr>

                <tr valign="top">
                    <td>
                        <input placeholder="Linkedin URL"  type="text" size="35" name="xodogo_TC_linked" value="<?php echo esc_url( $xodogo_custom_options_values['xodogo_TC_linked']  ); ?>" />
                    </td>
                </tr>

                <tr valign="top">
                    <td>
                        <input placeholder="Twitter URL"  type="text" size="35" name="xodogo_TC_Twitter" value="<?php echo esc_url( $xodogo_custom_options_values[ 'xodogo_TC_Twitter']  ); ?>" />
                    </td>
                </tr>

                <tr valign="top">
                    <td>
                        <input placeholder="Google Plus URL"  type="text" size="35" name="xodogo_TC_GP" value="<?php echo esc_url( $xodogo_custom_options_values[ 'xodogo_TC_GP'] ); ?>" />
                    </td>
                </tr>
            </table>
            <hr>
            <table class="form-table">
                <tr valign="top">
                    <th><?php _e( 'CopyRight Information [Footer Location]','xodogo' ); ?></th>
                    <td>
                        <input placeholder="Text to place"  type="text" size="35" name="xodogo_TC_copy_text" value="<?php echo esc_attr( $xodogo_custom_options_values[ 'xodogo_TC_copy_text']  ); ?>" />
                        <input placeholder="Link for that Text"  type="text" size="35" name="xodogo_TC_copy_url" value="<?php echo esc_url( $xodogo_custom_options_values['xodogo_TC_copy_url'] ); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th><?php _e( 'Upload Logo','xodogo' ); ?></th>
                    <td>
                        <label for="xodogo_theme_upload_image">
                            <input placeholder="Logo"  id="xodogo_theme_upload_image2" type="text" size="25" name="xodogo_TC_logo" value="<?php echo esc_url( $xodogo_custom_options_values[ 'xodogo_TC_logo'] ); ?>" />
                            <input class="upload_image_button" class="button" type="button" value="Upload Image" />
                            <br /><?php _e( 'Enter a URL ( with http:// ) or upload an image <br /> Upload size - max of 350px width/height <br />','xodogo' ); ?>
                        </label>
                    </td>
                </tr>

                <tr valign="top">
                    <th><?php _e( 'Upload Favicon','xodogo' ); ?></th>
                    <td>
                        <label for="xodogo_theme_upload_favicon">
                            <input placeholder="Favicon"  id="xodogo_theme_upload_image3" type="text" size="25" name="xodogo_TC_favicon" value="<?php echo esc_url(  $xodogo_custom_options_values['xodogo_TC_favicon']  ); ?>" />
                            <input class="upload_image_button" class="button" type="button" value="Upload Image" />
                            <br /><?php _e( 'Enter a URL ( with http:// ) or upload an image <br /> Upload size - [16px x 16px - .png file format ] <br />','xodogo' ); ?>
                        </label>
                    </td>
                </tr>
                
                <tr valign="top">
                    <td>
                        <input type="hidden" name="xodogo_custom_nonce" value="<?php echo wp_create_nonce('xodogo-setting-nonce'); ?>">
                    </td>
                </tr>
                
                <tr valign="top">
                    <td>
                        <input type="hidden" name="hidden_social_name" value="Y">
                    </td>
                </tr>

                <tr valign="top">
                    <td><?php submit_button(); ?></td>
                </tr>
            </table>
        </form>

    <?php
    }
}
// 1. Ends
// 2. Banner ads starts
    add_action( 'admin_menu', 'xodogo_theme_custom_options' );
if ( ! function_exists( 'xodogo_theme_custom_options' ) ){
    function xodogo_theme_custom_options() {
        global $xodogo_custom_hook, $top_banner_hook;

        $top_banner_hook = add_theme_page( 'Top Banner Ads', 'Top Banner Ads', 'edit_theme_options', 'xodogo-top-banner', 'xodogo_theme_custom_options_function' );
        $xodogo_custom_hook = add_theme_page( 'Xodogo Custom Settings', 'Xodogo Custom Settings', 'edit_theme_options', 'xodogo-custom-settings', 'xodogo_theme_social_function' );
        add_action( "admin_print_scripts-{$xodogo_custom_hook}", 'xodogo_TC_uploader_scripts' );
        add_action( "admin_print_scripts-{$top_banner_hook}", 'xodogo_TC_uploader_scripts' );
        add_action( 'admin_print_scripts', 'xodogo_TC_uploader_styles' );
    }
}
if ( ! function_exists( 'xodogo_theme_custom_options_function' ) ){
    function xodogo_theme_custom_options_function() {
        if ( !current_user_can( 'manage_options' ) ) {
            wp_die( __( 'You do not have sufficient permissions to access this page.', 'xodogo' ) );
        }
        
         /*
         * Checking for Nonce
         */
        if(isset($_REQUEST['banner_ads_nonce'])) {
            $banner_ads_nonce = esc_attr($_REQUEST['banner_ads_nonce']);
                if (! wp_verify_nonce($banner_ads_nonce, 'banner-ads-nonce') ) {
                    die("Security check");
                    }
         }   
             
        if ( isset( $_POST['hidden_field_name'] ) && $_POST['hidden_field_name'] == 'Y' ) {
            if ( !empty( $_POST['xodogo_TC_banner_728x80'] ) && !empty( $_POST['xodogo_TC_banner_script'] ) ) {
                echo'<div class="error"><p><strong> Please add any one ads type, either upload banner or script </strong></p></div>';
            } else {
                $banner_ads_values = get_option('xodogo_custom_options');
                if ( !empty( $_POST['xodogo_TC_banner_728x80'] ) ) {
                    $xodogo_TC_banner_728x80 = htmlentities( stripslashes( $_POST['xodogo_TC_banner_728x80'] ), ENT_COMPAT );
                    $xodogo_TC_banner_728x80_url = htmlentities( stripslashes( $_POST['xodogo_TC_banner_728x80_url'] ), ENT_COMPAT );
                    $banner_ads_values['xodogo_banner_option_value'] = 1;
                    $banner_ads_values['xodogo_TC_banner_728x80'] = $xodogo_TC_banner_728x80;
                    $banner_ads_values['xodogo_TC_banner_728x80_url'] = $xodogo_TC_banner_728x80_url;
                    $banner_ads_values['xodogo_TC_banner_script'] = '';
                    
                    echo'<div class="updated"><p><strong> Banner Image Added Successfully...</strong></p></div>';
                } elseif ( !empty( $_POST['xodogo_TC_banner_script'] ) ) {
                    $banner_ads_values['xodogo_banner_option_value'] = 2 ;
                    $xodogo_TC_banner_script = htmlentities( stripslashes( $_POST['xodogo_TC_banner_script'] ), ENT_COMPAT );
                    $banner_ads_values['xodogo_TC_banner_script'] = $xodogo_TC_banner_script;
                    $banner_ads_values['xodogo_TC_banner_728x80'] =  '';
                    $banner_ads_values['xodogo_TC_banner_728x80_url'] = '';
                    
                    echo'<div class="updated"><p><strong> Banner Script Added Successfully...</strong></p></div>';
                } else {
                    $banner_ads_values['xodogo_banner_option_value'] = 0;
                    $banner_ads_values['xodogo_TC_banner_728x80'] = '';
                    $banner_ads_values['xodogo_TC_banner_728x80_url'] = '';
                    $banner_ads_values['xodogo_TC_banner_script'] = '';
                    echo'<div class="updated"><p><strong> Settings Saved... But neither Image nor script added</strong></p></div>';
                }
            update_option('xodogo_custom_options', $banner_ads_values);
                
           }
        }
        ?>
           <?php $banner_ads_values = get_option('xodogo_custom_options'); ?> 
        <form method="post" action="" name="xodogo_theme_upload">
            <h2><?php _e( 'Top Banner Setting Page','xodogo' ); ?></h2>
            <table class="form-table">

                <tr valign="top">
                    <td>
                        <h4><?php _e( 'Upload banner','xodogo' ); ?></h4>
                        <label for="xodogo_theme_upload_image">
                            <input placeholder="image banner"  id="xodogo_theme_upload_image1" type="text" size="25" name="xodogo_TC_banner_728x80" value="<?php echo esc_url( $banner_ads_values['xodogo_TC_banner_728x80'] ); ?>" />
                            <input class="upload_image_button" class="button" type="button" value="Upload Image" />
                            <br /><?php _e( 'Enter a URL ( with http:// ) or upload an image size [728x80 px]<br /><br />','xodogo' ); ?>
                            <input placeholder="Link for that image"  type="text" size="25" name="xodogo_TC_banner_728x80_url" value="<?php echo esc_url( $banner_ads_values['xodogo_TC_banner_728x80_url'] ); ?>" />
                            <br /><?php _e( 'Enter a URL ( with http:// )','xodogo' ); ?>
                        </label>
                        <input type="hidden" name="hidden_field_name" value="Y">
                        <input type="hidden" name="banner_ads_nonce" value="<?php echo wp_create_nonce('banner-ads-nonce'); ?>">
                    </td>
                </tr>
                <tr valign="top">
                    <td><?php _e( '[OR]','xodogo' ); ?></td>
                </tr>
                <tr valign="top">

                    <td><textarea placeholder="Past Script Here"  cols="40" rows="7" name="xodogo_TC_banner_script" value="" ><?php echo esc_attr( $banner_ads_values['xodogo_TC_banner_script'] ); ?></textarea></td>
                </tr>

                <tr valign="top">
                    <td><?php submit_button(); ?></td>
                </tr>
            </table>
        </form>
        <?php
    }
}
    function xodogo_TC_uploader_scripts() {
        wp_enqueue_script( 'media-upload' );
        wp_enqueue_script( 'thickbox' );
        wp_enqueue_script( 'xodogo-banner-upload-script', get_template_directory_uri() . '/js/upload-js.js', array(), '1.0', true );
    }

    function xodogo_TC_uploader_styles() {
        wp_enqueue_style( 'thickbox' );
    }

// 2. Banner ads - End
//3. Author Social - Starts

    add_action( 'show_user_profile', 'xodogo_show_profile' );
    add_action( 'edit_user_profile', 'xodogo_show_profile' );

    function xodogo_show_profile( $user ) {
        ?>
        <!--  Simple Author Widget -->
        <h3><?php _e( 'Author Social Information','xodogo' ); ?></h3>
        <table class="form-table">
            <tr>
                <th><label for="xodogo_fb_label"><?php _e( 'Facebook ID','xodogo' ); ?></label></th>
                <td>
                    <input name="xodogo_fb_textbox" class="regular-text" value="<?php echo esc_attr( get_the_author_meta( 'xodogo_fb_textbox', $user->ID ) ); ?>" /><br>
                    <span class="description"><?php _e( 'Please enter your FB acount URL.','xodogo' ); ?><br />
                        <?php _e( '( eg ) http://facebook.com/buffercode','xodogo' ); ?>
                    </span>
                </td>
            </tr>
            
            <tr>
                <th><label for="xodogo_twitter_label"><?php _e( 'Twitter','xodogo' ); ?></label></th>
                <td>
                    <input name="xodogo_twitter_textbox" class="regular-text" value="<?php echo esc_url( get_the_author_meta( 'xodogo_twitter_textbox', $user->ID ) ); ?>" /><br>
                    <span class="description"><?php _e( 'Please enter your Twitter account. <br />( eg ) http://twitter.com/buffercode','xodogo' ); ?></span>
                </td>
            </tr>
            
            <tr>
                <th><label for="xodogo_GP_label"><?php _e( 'Google Plus','xodogo' ); ?></label></th>
                <td>
                    <input name="xodogo_GP_textbox" class="regular-text" value="<?php echo esc_url( get_the_author_meta( 'xodogo_GP_textbox', $user->ID ) ); ?>" /><br>
                    <span class="description"><?php _e( 'Please enter your Google Plus account <br />( eg ) https://plus.google.com/+buffercode','xodogo' ); ?></span>
                </td>
            </tr>
            
            <tr>
                <th><label for="xodogo_LI_label"><?php _e( 'Linked In','xodogo' ); ?></label></th>
                <td>
                    <input name="xodogo_LI_textbox" class="regular-text" value="<?php echo esc_url( get_the_author_meta( 'xodogo_LI_textbox', $user->ID ) ); ?>" /><br>
                    <span class="description"><?php _e( 'Please enter your Linked In account <br /> ( eg ) http://in.linkedin.com/in/mavinothkumar/','xodogo' ); ?></span>
                </td>
            </tr>
        </table>
        
        <?php
    }

    add_action( 'personal_options_update', 'xodogo_edit_save_profile' );
    add_action( 'edit_user_profile_update', 'xodogo_edit_save_profile' );

    function xodogo_edit_save_profile( $user_id ) {
        if ( !current_user_can( 'edit_user', $user_id ) )
            return false;
        update_user_meta( $user_id, 'xodogo_fb_textbox', esc_attr( $_POST['xodogo_fb_textbox'] ) );
        update_user_meta( $user_id, 'xodogo_twitter_textbox', esc_attr( $_POST['xodogo_twitter_textbox'] ) );
        update_user_meta( $user_id, 'xodogo_GP_textbox', esc_attr( $_POST['xodogo_GP_textbox'] ) );
        update_user_meta( $user_id, 'xodogo_LI_textbox', esc_attr( $_POST['xodogo_LI_textbox'] ) );
    }
// 3. Author Social Ends