<?php
// Additing Action hook widgets_init
add_action('widgets_init', 'xodogo_catc_widget');
function xodogo_catc_widget() {
    register_widget('xodogo_catc_widget_info');
}
class xodogo_catc_widget_info extends WP_Widget {
    function __construct() {
        parent::__construct(
                'xodogo_catc_widget_info', // Base ID
                __('Category Archieve Tag Comment Widget', 'xodogo'), // Name
                array('description' => __('Shows Comment, Archives, Tags, Category', 'xodogo'),)
        );
    }
    public function form($instance) {
        echo '<p>' . __('You have added the Category, Archieve, Tag and Comment widget','xodogo') . '</p>';
    }
    
    function widget($args, $instance) {
        extract($args);
        echo $before_widget;
        ?>
        <!-- sidebar Nav tabs - Comments - Archives - Tags Starts -->
        <div class="tab-design">
            <ul class="nav nav-tabs tab-header">
                <li class="active">
                    <a href="#tabcomment" data-toggle="tab">Comments</a>
                </li>
                <li>
                    <a href="#tabarchives" data-toggle="tab">Archives</a>
                </li>
                <li>
                    <a href="#tabtags" data-toggle="tab" >Tags</a>
                </li>
                <li>
                    <a href="#tabcategory" data-toggle="tab" >Category</a>
                </li>
            </ul>
            <!-- Tab panes Starts -->
            <div class="tab-content">
                <!-- Tab panes for comments Starts -->
                <div class="tab-pane fade in active pad-20" id="tabcomment">
                    <?php
                    $args = array(
                        'status' => 'approve',
                        'number' => '5',
                    );
                    $comments = get_comments($args);
                    foreach ($comments as $comment) {
                        echo '<div class="row tab-comment-layout"><div class="tab_comment_author">';
                        echo '<span class="glyphicon glyphicon-comment"></span>  <a href="' . get_permalink($comment->comment_post_ID) . '">' . $comment->comment_content . '</a> <i>by</i> <span class="url fn" rel="author"><span class="glyphicon glyphicon-user"></span> ' . $comment->comment_author . '</span></div></div>';
                    }
                    ?>
                </div>
                <!-- Tab panes for comments Ends -->
                <!-- Tab panes for Archives starts -->
                <div class="tab-pane fade in " id="tabarchives">
                    <?php
                    $tabargs = array(
                        'type' => 'yearly',
                        'limit' => '10',
                        'format' => 'custom',
                        'before' => '<p class="pad-20"><span class="glyphicon glyphicon-folder-open"></span>&nbsp;&nbsp;&nbsp;',
                        'after' => '</p>',
                        'show_post_count' => true,
                        'echo' => 1,
                        'order' => 'DESC'
                    );
                    ?>
                    <?php wp_get_archives($tabargs); ?>
                </div>
                <!-- Tab panes for Archives ends -->
                <!-- Tab panes for Tag starts -->
                <div class="tab-pane fade in margin-top-15" id="tabtags">
                    <?php wp_tag_cloud(); ?>
                </div>
                <!-- Tab panes for Tag ends -->
                <!-- Tab panes for category starts -->
                <div class="tab-pane fade in margin-top-15" id="tabcategory">
                    <?php wp_tag_cloud(array('taxonomy' => 'category')); ?>
                </div>
                <!-- Tab panes for category ends -->
            </div>
        </div>
        <?php
        echo $after_widget;
    }
}
?>