<?php

if (is_single()) {
    $limit  = '5';
    $taxs = array();

    global $post;    
    $tags = get_the_tags($post->ID);

    if ($tags) {
        $ids = array();
        foreach ($tags as $tag) {
            $ids[] = $tag->term_id;
        }
        $taxs [] = array(
            'taxonomy' => 'post_tag',
            'field' => 'id',
            'terms' => $ids
        );
    }


    if ($taxs) {
        $related_args = array(
            'tax_query' => $taxs,
            'post__not_in' => array($post->ID),
            'posts_per_page' => $limit
        );

        $related_posts = new WP_Query($related_args);
        if ($related_posts->have_posts()):
            ?>            
            <div class="kopa-recent-post">
                <h3 class="recent-title"><?php _e('Related articles', 'xmax'); ?></h3>
                <ul class="clearfix">
                    <?php
                    while ($related_posts->have_posts()):
                        $related_posts->the_post();                            
                        ?>
                        <li>
                            <article class="entry-item">
                                <div class="entry-content">
                                    <header>
                                        <h4 class="entry-title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h4>
                                        
                                        <p class="entry-date"><?php _e('Posted:', 'xmax'); ?>
                                            <span><?php echo esc_attr(get_the_date()); ?></span>
                                        </p>
                                    </header>
                                    <?php the_excerpt(); ?>
                                </div>
                            </article>
                        </li>                           
                        <?php
                    endwhile;
                    ?>
                </ul>
            </div>                    
            <?php
        endif;
        wp_reset_postdata();
    }
}