<?php

global $post;
$user_id     = $post->post_author;
$description = get_the_author_meta('description', $user_id);
$email       = get_the_author_meta('user_email', $user_id);
$name        = get_the_author_meta('display_name', $user_id);
$url         = trim(get_the_author_meta('user_url', $user_id));
$link        = ($url) ? $url : get_author_posts_url($user_id);

if (!empty($description)):
?>
    <div class="kopa-author clearfix">
        <span></span>
        <a class="avatar-thumb" href="<?php echo esc_url($link); ?>" title="<?php echo esc_attr($name); ?>"><?php echo get_avatar($email, 91); ?></a>
        <div class="author-content media-body">
            <header class="">                
                <h5 class="author-name">
                    <a href="<?php echo esc_url($link); ?>" title="<?php echo esc_attr($name); ?>">
                        <?php echo esc_attr($name); ?>
                    </a>
                </h5>                
            </header>
            <?php echo esc_textarea($description); ?>
        </div>
    </div>
<?php 
endif;