<?php
$prev_post = get_previous_post();
$next_post = get_next_post();

if ($prev_post || $next_post):
    ?>
    <div class="kopa-related-post clearfix">
        <?php if ($prev_post): ?>
            <div class="prev-post">
                <div class="entry-item clearfix">
                    <h4 class="entry-title">
                        <a href="<?php echo esc_url(get_the_permalink($prev_post)); ?>"><?php echo esc_attr(get_the_title($prev_post)); ?></a>
                    </h4>
                    <p class="entry-date"><?php _e('Posted:', 'xmax'); ?> <span><?php echo get_the_date('', $prev_post); ?></span></p>
                </div>
                <a href="<?php echo esc_url(get_the_permalink($prev_post)); ?>" class="btn-prev fa fa-angle-left"></a>
            </div>        
        <?php endif; ?>

        <?php if ($next_post): ?>
        <div class="next-post">
            <div class="entry-item clearfix">
                <h4 class="entry-title"><a href="<?php echo esc_url(get_the_permalink($next_post)); ?>"><?php echo esc_attr(get_the_title($next_post)); ?></a></h4>
                <p class="entry-date"><?php _e('Posted:', 'xmax'); ?> <span><?php echo get_the_date('', $next_post); ?></span></p>
            </div>
            <a href="<?php echo esc_url(get_the_permalink($prev_post)); ?>" class="btn-next fa fa-angle-right"></a>
        </div>
        <?php endif; ?>            
    </div>
    <?php
endif;