<?php
$headlines_limit_posts = (int) get_theme_mod('headline_limit', 10);

if ($headlines_limit_posts) {

    $headlines = new WP_Query(array(
        'post_type'           => array('post'),
        'posts_per_page'      => $headlines_limit_posts,
        'post_status'         => array('publish'),
        'ignore_sticky_posts' => true));

    if ($headlines->have_posts()) {
        $label_line_1 = __('News', 'xmax');
        $label_line_2 = __('Stories', 'xmax');
        ?>

        <div class="widget kopa-list-post-no-thumb clearfix">
            <span></span>

            <h3 class="widget-title">
                <?php echo esc_html($label_line_1); ?>
                <span><?php echo esc_html($label_line_2); ?></span>
            </h3>

            <div class="list-post-main">
                <div class="owl-carousel owl-carousel1"> 
                    <?php
                    while ($headlines->have_posts()):
                        $headlines->the_post();
                        $post_url   = get_permalink();
                        $post_title = get_the_title();
                        ?>
                        <div class="item">
                            <article class="entry-item clearfix">
                                <?php if ( ! empty($post_title) ) : ?>
                                    <h4 class="entry-title"><a href="<?php echo esc_url($post_url); ?>"><?php echo esc_html($post_title); ?></a></h4>
                                <?php endif; ?>

                                <span class="entry-date"><?php echo get_the_date(); ?></span>
                            </article>  
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </div>
        <?php
    }

    wp_reset_postdata();
}