<div class="featured-entry-list">    
    <ul class="clearfix">
    <?php
    if (have_posts()):            
        while (have_posts()) : 
            the_post();
            $post_id      = get_the_ID();
            $post_url     = get_permalink();
            $post_title   = get_the_title();
            ?>
            <li>
                <div class="item">
                    <article class="entry-item clearfix">
                        <div class="entry-thumb">
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail('xmax-blog-small', array('class' => 'img-responsive')); ?>
                            </a>
                        </div>
                        <div class="entry-content">
                            <header>
                                <h4 class="entry-title">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h4>

                                <div class="entry-meta clearfix">
                                    <?php printf('<p class="entry-date">%s<span>%s</span></p>', __('Posted:',  'xmax'),get_the_date()); ?>
                                    <p class="entry-comment"><?php comments_popup_link(__('No Comment', 'xmax'), __('1 Comment', 'xmax'), __('% Comments', 'xmax'), '', __('0 Comment', 'xmax')); ?></p>
                                    <?php if(has_category()): ?>
                                        <p class="entry-categories"><?php _e('In:', 'xmax'); ?> <?php the_category(', '); ?></p>                            
                                    <?php endif;?>
                                </div>
                            </header>

                            <?php the_excerpt(); ?>
                            
                            <a href="<?php the_permalink(); ?>" class="more-link"><?php _e('Read more', 'xmax'); ?><span class="fa fa-angle-double-right "></span></a>
                        </div>
                    </article>
                </div>
            </li>           
            <?php
        endwhile;
    else:
        printf('<blockquote>%1$s</blockquote>', __('Nothing Found...', 'xmax'));
    endif;
    ?>
    </ul>

    <?php get_template_part('pagination'); ?>
</div>