<ul class="clearfix">
    <?php
    if (have_posts()):            
        while (have_posts()) : 
            the_post();
            $post_id      = get_the_ID();
            $post_url     = get_permalink();
            $post_title   = get_the_title();
            ?>
            <li <?php post_class(); ?>>
                <div class="item">
                    <article class="entry-item clearfix">

                        <?php if(has_post_thumbnail()): ?>                    
                            <div class="entry-thumb">
                                <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                    <?php the_post_thumbnail('xmax-blog', array('class' => 'img-responsive')); ?>
                                </a>
                            </div>
                        <?php endif; ?>

                        <div class="entry-content">
                            <header>
                                <h4 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h4>
                            
                                <div class="entry-meta clearfix">
                                    <?php printf('<p class="entry-date">%s<span>%s</span></p>', __('Posted:',  'xmax'),get_the_date()); ?>
                                    <p class="entry-comment"><?php comments_popup_link(__('No Comment', 'xmax'), __('1 Comment', 'xmax'), __('% Comments', 'xmax'), '', __('0 Comment', 'xmax')); ?></p>
                                    <?php if(has_category()): ?>
                                        <p class="entry-categories"><?php _e('In:', 'xmax'); ?> <?php the_category(', '); ?></p>                            
                                    <?php endif;?>
                                </div>
                            </header>

                            <?php the_excerpt(); ?>
                        </div>
                    </article>
                </div>
            </li>            
            <?php
        endwhile;
    else:
        printf('<blockquote>%1$s</blockquote>', __('Nothing Found...', 'xmax'));
    endif;
    ?>
</ul>

<?php get_template_part('pagination'); ?>