<?php
add_action( 'widgets_init', array('Xmax_Widget_Posts_Two_Cols', 'register'));

class Xmax_Widget_Posts_Two_Cols extends Xmax_Widget_Master{
    
    function __construct() {
        $widget_ops = array('classname' => 'xmax-widget-posts-two-cols recent-cat-post', 'description' => __('Display list of posts with layout two cols.', 'xmax'));
        $control_ops = array('width' => 'auto', 'height' => 'auto');
        parent::__construct('xmax-widget-posts-two-cols', __('Xmax Posts - Two Cols', 'xmax'), $widget_ops, $control_ops);
    }

    public static function register(){
    	register_widget('Xmax_Widget_Posts_Two_Cols');
    }    

    function widget($args, $instance) {
        extract($args);

        $instance = wp_parse_args((array) $instance, $this->get_default());
        $title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);

        echo  htmlspecialchars_decode(esc_html($before_widget));
        if (!empty($title))
            echo  htmlspecialchars_decode(esc_html($before_title . $title . $after_title));

				$query      = $this->get_query($instance);
				$resuls_set = new WP_Query($query);

        if ($resuls_set->have_posts()):
            ?>

            <?php
            $is_first = true;
            while ($resuls_set->have_posts()):
                $resuls_set->the_post();
                $post_title = get_the_title();
                $post_url   = get_permalink();
                
                if($is_first):
                	$is_first = false;
                ?>
									<article class="entry-item last-item clearfix">
										<?php if(has_post_thumbnail()): ?>
											<div class="entry-thumb">
												<a href="<?php echo esc_url($post_url); ?>">
													<?php the_post_thumbnail('xmax-medium-thumb', array('class' => 'img-responsive')); ?>
												</a>
											</div>
										<?php endif; ?>

										<div class="entry-content">
											
											<header>
												<h4 class="entry-title">
													<a href="<?php echo esc_url($post_url); ?>"><?php echo esc_attr($post_title); ?></a>
												</h4>
												
												<div class="entry-meta clearfix">
													<?php printf('<p class="entry-date">%s<span>%s</span></p>', __('Posted:',  'xmax'),get_the_date()); ?>
													
													<p class="entry-comment">
														<?php comments_popup_link(__('No Comment', 'xmax'), __('1 Comment', 'xmax'), __('% Comments', 'xmax'), '', __('0 Comment', 'xmax')); ?>
													</p>

													<?php if(has_category()): ?>
													<p class="entry-categories">
														<?php _e('In:', 'xmax'); ?> <?php the_category(', '); ?>
													</p>
													<?php endif;?>

												</div>

											</header>
											
											<?php the_excerpt(); ?>

										</div>

									</article>

									<div class="recent-entry-list">
									<h3 class="entry-list-title"><?php _e('Other Articles', 'xmax'); ?></h3>
									<ul class="clearfix">
                <?php
                else:
                ?>
								<li>
									<article class="entry-item">
											<h4 class="entry-title">
												<a href="<?php echo esc_url($post_url); ?>"><?php echo esc_attr($post_title); ?></a>
											</h4>

										<p class="entry-date"><?php _e('Posted:', 'xmax'); ?><span><?php echo esc_attr(get_the_date()); ?></span></p>

									</article>
								</li>
              	<?php
                endif;                 
            endwhile;
            ?>                
            </ul>
          </div>
            <?php
        endif;

        wp_reset_postdata();

        echo htmlspecialchars_decode(esc_html($after_widget));
    }

}