<?php
add_action( 'widgets_init', array('Xmax_Widget_Posts_Only_Title', 'register'));

class Xmax_Widget_Posts_Only_Title extends Xmax_Widget_Master{
    
    function __construct() {
        $widget_ops = array('classname' => 'xmax-widget-posts-only-title widget_recent_entries', 'description' => __('Display list of posts with only title.', 'xmax'));
        $control_ops = array('width' => 'auto', 'height' => 'auto');
        parent::__construct('xmax-widget-posts-only-title', __('Xmax Posts - Only Title', 'xmax'), $widget_ops, $control_ops);
    }

    public static function register(){
    	register_widget('Xmax_Widget_Posts_Only_Title');
    }    

    function widget($args, $instance) {
        extract($args);

        $instance = wp_parse_args((array) $instance, $this->get_default());
        $title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);

        echo  htmlspecialchars_decode(esc_html($before_widget));
        if (!empty($title))
            echo  htmlspecialchars_decode(esc_html($before_title . $title . $after_title));

				$query      = $this->get_query($instance);
				$resuls_set = new WP_Query($query);

        if ($resuls_set->have_posts()):
            ?>
          	<ul class="clearfix">
	            <?php
	            while ($resuls_set->have_posts()):
								$resuls_set->the_post();
	              ?>
							  <li>
										<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
										<p class="entry-date">
											<?php _e('posted:', 'xmax'); ?> 
											<span class="post-date"><?php echo esc_attr(get_the_date()); ?></span>
										</p>
								</li>
	              <?php
	            endwhile;
	            ?>                
          	</ul>
            <?php
        endif;

        wp_reset_postdata();

        echo htmlspecialchars_decode(esc_html($after_widget));
    }

}