<?php
add_action( 'widgets_init', array('Xmax_Widget_Posts_Icons', 'register'));

class Xmax_Widget_Posts_Icons extends Xmax_Widget_Master{
    
    function __construct() {
        $widget_ops = array('classname' => 'xmax-widget-posts-icons kopa-article-list-widget', 'description' => __('Display list of posts with post-format icon.', 'xmax'));
        $control_ops = array('width' => 'auto', 'height' => 'auto');
        parent::__construct('xmax-widget-posts-icons', __('Xmax Posts - Icons', 'xmax'), $widget_ops, $control_ops);
    }

    public static function register(){
    	register_widget('Xmax_Widget_Posts_Icons');
    }    

    function widget($args, $instance) {
        extract($args);

        $instance = wp_parse_args((array) $instance, $this->get_default());
        $title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);

        echo  htmlspecialchars_decode(esc_html($before_widget));
        if (!empty($title))
            echo  htmlspecialchars_decode(esc_html($before_title . $title . $after_title));

				$query      = $this->get_query($instance);
				$resuls_set = new WP_Query($query);

        if ($resuls_set->have_posts()):
            ?>
          	<ul class="clearfix">
	            <?php
	            while ($resuls_set->have_posts()):
	                $resuls_set->the_post();

	              	$icon = 'fa fa-edit';

	              	switch (get_post_format()) {
	              		case 'audio':
	              			$icon = 'fa fa-volume-up';
	              			break;
	              		case 'video':
	              			$icon = 'fa fa-play-circle-o';
	              			break;
	              		case 'gallery':
	              			$icon = 'fa fa-camera';
	              			break;	              		
	              	}
	              ?>
								<li class="clearfix">
									<article class="entry-item">
										<span class="entry-icon <?php echo esc_attr($icon); ?>"></span>
										<div class="entry-content">
											<p class="entry-date"><?php _e('Posted:', 'xmax');?><span><?php echo esc_attr(get_the_date()); ?></span></p>
											<h2 class="entry-title">
												<a href="<?php the_permalink();?>"><?php the_title(); ?></a>
											</h2>
										</div>
									</article>
								</li>	              
	              <?php
	            endwhile;
	            ?>                
          	</ul>
            <?php
        endif;

        wp_reset_postdata();

        echo htmlspecialchars_decode(esc_html($after_widget));
    }

}