<!DOCTYPE html>
<html <?php language_attributes(); ?>>              
<head>
    <meta charset="<?php bloginfo('charset'); ?>" />                   
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />    
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />                       
    <?php wp_head(); ?>
</head>    

<body <?php body_class(); ?>>  
    <header id="kopa-header">
        <div class="header-top">
            <div class="wrapper clearfix">
                <?php
                #TOP MENU
                if (has_nav_menu('top-nav')) {
                    wp_nav_menu(
                        array(
                            'theme_location' => 'top-nav',
                            'container' => 'nav',
                            'container_id' => 'top-nav',
                            'container_class' => 'top-nav pull-left',
                            'menu_id' => 'top-menu',
                            'menu_class' => 'top-menu clearfix'
                            )
                        );

                    echo '<nav class="top-nav-mobile clearfix">';
                    echo '<a class="pull" href="#">' . __('Menu', 'xmax') . '<span class="fa fa-caret-down"></span></a>';
                    wp_nav_menu(
                        array(
                            'theme_location' => 'top-nav',
                            'container' => false,
                            'menu_id' => 'top-menu-mobile',
                            'menu_class' => 'top-menu-mobile'
                            )
                        );
                    echo '</nav>';
                }
                ?>           

                <?php if (1 == (int)get_theme_mod('is_display_search_form', 1)): ?>
                <div class="search-box pull-right">
                    <?php get_search_form(); ?>
                </div>
            <?php endif; ?>

        </div><!--/end .search-box-->
    </div><!--/end .header-top-->

    <?php
    $logo = get_theme_mod('logo');            
    ?>
    <div class="header-middle">
        <div class="wrapper clearfix">
            <?php if (!empty($logo)) {?>
            <div class="kopa-logo pull-left">
                <a href="<?php echo esc_url(home_url()); ?>"><img src="<?php echo esc_url($logo); ?>" alt="<?php bloginfo('name'); ?>"/></a>
            </div>
            <?php } else { ?>
            <div class="kopa-logo pull-left">
                <h1 class="site-title"><a href="<?php echo esc_url(home_url()); ?>"><?php bloginfo('name'); ?></a></h1>
                <p><?php bloginfo('description'); ?></p>
            </div>
            <?php } ?>

            <?php 
            $top_banner_image = get_header_image();
            if($top_banner_image):
            ?>
                <div class="kopa-top-banner pull-right">                                
                    <a  href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($top_banner_image); ?>" alt=""/></a>
                </div>
            <?php endif;?>


            <?php
            #MAIN MENU
            if (has_nav_menu('main-nav')) {                        
                echo '<nav class="main-nav-mobile clearfix">';
                echo '<a class="pull"><span class="fa fa-bars"></span></a>';

                wp_nav_menu(
                    array(
                        'theme_location' => 'main-nav',
                        'container'      => false,
                        'menu_id'        => 'main-menu-mobile',
                        'menu_class'     => 'main-menu-mobile')
                    );
                echo '</nav>';
            }
            ?>      
        </div><!--/end .header-middle-->
    </div>

    <div class="header-bottom">
        <div class="wrapper clearfix">
            <?php
            #MAIN MENU
            if (has_nav_menu('main-nav')) {
                wp_nav_menu(array(
                    'theme_location'  => 'main-nav',
                    'container'       => 'nav',
                    'container_id'    => 'main-nav',
                    'container_class' => 'kopa-main-nav kopa-relative clearfix',
                    'menu_id'         => 'main-menu',
                    'menu_class'      => 'main-menu sf-menu clearfix'));
            }
            ?>                     
        </div>
    </div><!--/end .header-bottom-->
</header>
<!--/end HEADER-->
<div class="wrapper clearfix">
    <div id="kopa-main-content">
        <section class="widget-area-1 clearfix">
            <?php get_template_part('module/headlines'); ?>
        </section>
        <!--/end widget-area-1-->

        <div class="clear"></div>
        <div class="main-wrapper clearfix">

            <?php get_template_part('module/breadcrumb'); ?>               

            <div class="kopa-main-col">