<?php
define('XMAX_MODE', 'product'); //product or dev

/*
LIBRARY
----------
Load the required library for theme.
----------*/
require_once 'lib/customizer.php';
require_once 'lib/widget-master.php';

/*
WIDGET
----------
Load custom widgets for theme.
----------*/
get_template_part('lib/widgets/posts', 'two-cols');
get_template_part('lib/widgets/posts', 'tabs');
get_template_part('lib/widgets/posts', 'icons');
get_template_part('lib/widgets/posts', 'only-title');

add_action('after_setup_theme', 'xmax_after_setup_theme');

function xmax_after_setup_theme() {

    load_theme_textdomain('xmax', get_template_directory() . '/languages');

    add_theme_support( 'custom-background', array(
        'default-color'      => '',
        'default-attachment' => 'fixed',
    ));

    add_theme_support( 'custom-header', apply_filters( 'xmax_custom_header_args', array(
        'header-text' => false,
        'width'       => 468,
        'height'      => 60 
    )));

    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
    add_theme_support('html5');
    add_theme_support('loop-pagination');
    add_theme_support('automatic-feed-links');
    add_theme_support('post-formats', array('gallery', 'video', 'audio'));

    xmax_register_new_image_sizes();
    
    global $content_width;
    if (!isset($content_width))
        $content_width = 817;

    register_nav_menus(array(
        'top-nav'    => __('Top Menu', 'xmax'),
        'main-nav'   => __('Main Menu', 'xmax'),
        'footer-nav' => __('Footer Menu', 'xmax'),
    ));

    add_filter('xmax_customization_init_options', 'xmax_init_options');
    add_action('widgets_init', 'xmax_register_sidebar');

    if (!is_admin()){
        add_action('wp_enqueue_scripts', 'xmax_enqueue_scripts');        
        add_filter('body_class', 'xmax_body_class');
        add_filter('excerpt_more', '__return_false');        
    }
}

function xmax_register_new_image_sizes(){
    add_image_size('xmax-blog', 720, 400, true);
    add_image_size('xmax-blog-small', 155, 155, true);
    add_image_size('xmax-single-post', 720, 400, true);
    add_image_size('xmax-medium-thumb', 341, 191, true);
    add_image_size('xmax-small-thumb', 63, 63, true);    
}

function xmax_enqueue_scripts(){
    global $post, $wp_styles, $is_IE;
    $dir    = get_template_directory_uri();
    $suffix = ('product' === XMAX_MODE) ? '.min' : '';

    /*
     * --------------------------------------------------
     * STYLESHEET
     * --------------------------------------------------
     */
    wp_enqueue_style('xmax-assets', "{$dir}/assets/xmax{$suffix}.css", array(), NULL);
    wp_enqueue_style('xmax-style', get_stylesheet_uri(), array(), NULL);

    wp_enqueue_style('xmax-font-roboto', '//fonts.googleapis.com/css?family=Roboto:400,500,700', array(), NULL);
    wp_enqueue_style('xmax-font-open-sans', '//fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800', array(), NULL);

    /*
     * --------------------------------------------------
     * JAVASCRIPT
     * --------------------------------------------------
     */
    wp_enqueue_script('jquery');    
    wp_enqueue_script('hoverIntent');        

    if (is_singular())
        wp_enqueue_script('comment-reply');

    wp_enqueue_script('xmax-script', "{$dir}/assets/xmax{$suffix}.js", array('jquery'), NULL, TRUE);

    if($is_IE){
        wp_enqueue_script('xmax-ie', "{$dir}/js/pie_ie678.js", array('jquery'), NULL, TRUE);
    }
    /*
     * --------------------------------------------------
     * IE FIX
     * --------------------------------------------------
     */
    if ($is_IE) {
        wp_register_style('xmax-ie', $dir . '/css/ie.css', array(), NULL);
        wp_enqueue_style('xmax-ie');
        $wp_styles->add_data('xmax-ie', 'conditional', 'lt IE 9');        
    }
}

function xmax_body_class($classes){

    if(is_archive() || is_home()){
        $classes[] = 'cat-2';
    }else if(is_single()){
        $classes[] = 'kopa-single-page';
    }else if(is_page()){
        $classes[] = 'kopa-element-page';
    }
	return $classes;
}

function xmax_init_options($options){
    $options['sections'][] = array(
        'id'    => 'xmax_opt_general',
        'title' => __('General Settings', 'xmax'));

    $options['settings'][] = array(
        'settings'    => 'logo',
        'label'       => __('Logo', 'xmax'),
        'description' => __('Upload your logo image.', 'xmax'),
        'default'     => '',
        'type'        => 'image',
        'section'     => 'xmax_opt_general',
        'transport'   => 'refresh');

    $options['settings'][] = array(
        'settings'    => 'copyright',
        'label'       => __('Copyright', 'xmax'),
        'description' => __('Your copyright information on footer.', 'xmax'),
        'default'     => '',
        'type'        => 'textarea',
        'section'     => 'xmax_opt_general',
        'transport'   => 'refresh');

    $options['settings'][] = array(
        'settings' => 'blog-layout',
        'label'    => __('Blog layout', 'xmax'),        
        'default'  => 'small-thumb',
        'type'     => 'select',
        'choices'  => array(
            'small-thumb' => __('Small thumbnail', 'xmax'),
            'large-thumb' => __('Large thumbnail', 'xmax')
        ),
        'section'     => 'xmax_opt_general',
        'transport'   => 'refresh');  


    return $options;
}

function xmax_register_sidebar(){

    $args = array(
        'before_widget' => '<div id="%1$s" class="widget clearfix %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>');

    $sidebars = array(
        array(
            'name'          => __( 'Main Top Sidebar', 'xmax' ),
            'id'            => 'main-top-sidebar',
            'description'   => __( 'The main-top sidebar for only archives page: blog, category, tag, ..', 'xmax' )),
        array(
            'name'          => __( 'Right Sidebar', 'xmax' ),
            'id'            => 'right-sidebar',
            'description'   => __( 'The right sidebar for blog or single.', 'xmax' )),
        array(
            'name' => __('Footer 1st', 'xmax'),
            'id' => 'footer-1-sidebar'),     
        array(
            'name' => __('Footer 2nd', 'xmax'),
            'id' => 'footer-2-sidebar'),     
        array(
            'name' => __('Footer 3rd', 'xmax'),
            'id' => 'footer-3-sidebar'),     
        array(
            'name' => __('Footer 4th', 'xmax'),
            'id' => 'footer-4-sidebar')        
    );

    foreach($sidebars as $sidebar){
        $sidebar = array_merge($sidebar, $args);
        register_sidebar($sidebar);
    }       
}