<?php if (post_password_required()) {return;} ?>

<div id="comments">
    <?php
    if (have_comments()) :
        global $post;
        ?>     
        <h4 class="comments-title">
            <?php
            printf(_n('%1$s Comment', '%1$s Comments', get_comments_number(), 'xmax'), get_comments_number());
            ?>
        </h4>

        <ol class="comments-list clearfix">
            <?php
            wp_list_comments(array(
                'walker'     => null,
                'style'      => 'ul',
                'short_ping' => true,
                'callback'   => 'xmax_list_comments',
                'type'       => 'all'
            ));
            ?>
        </ol>
        <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>           
            <div class="pagination kopa-comment-pagination">  
                <?php
                paginate_comments_links(array(
                    'prev_text' => __('<span>&laquo;</span> Previous', 'xmax'),
                    'next_text' => __('Next <span>&raquo;</span>', 'xmax')
                ));
                ?>
            </div>
        <?php endif; ?>
        <?php if (!comments_open() && get_comments_number()) : ?>
            <blockquote><?php _e('Comments are closed.', 'xmax'); ?></blockquote>
        <?php endif; ?>    
        <?php
    endif;
    xmax_comment_form();    
    ?>
</div>
<?php

function xmax_comment_form($args = array(), $post_id = null) {
    if (null === $post_id)
        $post_id = get_the_ID();

    $commenter      = wp_get_current_commenter();
    $user           = wp_get_current_user();
    $user_identity  = $user->exists() ? $user->display_name : '';
    $args           = wp_parse_args($args);
    if (!isset($args['format']))
    $args['format'] = current_theme_supports('html5', 'comment-form') ? 'html5' : 'xhtml';
    $req            = get_option('require_name_email');
    $aria_req       = ( $req ? " aria-required='true'" : '' );
    $html5          = 'html5' === $args['format'];
    $fields         = array();

    $fields['author'] = '<div class="comment-left pull-left">';    
    $fields['author'] .= '<p class="input-block">';    
    $fields['author'] .= sprintf('<input type="text" 
        value="%s" 
        id="comment_name" 
        name="author" 
        size="30" 
        placeholder="%s" 
        %s>', 
        esc_attr($commenter['comment_author']), 
        __('Your name (*)', 'xmax'), 
        $aria_req);
    $fields['author'] .= '</p>';
    
    $fields['email']  = '<p class="input-block">';    
    $fields['email']  .= sprintf('<input type="%s" 
        value="%s" 
        id="comment_email" 
        name="email" 
        size="30" 
        placeholder="%s" 
        %s>', 
        ( $html5 ? 'email' : 'text'), 
        esc_attr($commenter['comment_author_email']), 
        __('Your email (*)', 'xmax'), 
        $aria_req);
    $fields['email']  .= '</p>';
    
    $fields['url']    = '<p class="input-block">';    
    $fields['url']    .= sprintf('<input type="%s" 
        value="%s" 
        id="comment_url" 
        name="url" 
        size="30" 
        placeholder="%s" %s>', 
        ( $html5 ? 'url' : 'text'), 
        esc_attr($commenter['comment_author_url']), 
        __('Your website', 'xmax'), $aria_req);    
    $fields['email']  .= '</p>';
    $fields['url']    .= '</div>';
    
    
    $comment_field    = '<div class="comment-right pull-left">';    
    $comment_field    .= '<p class="textarea-block">';    
    $comment_field    .= sprintf('<textarea name="comment" 
        id="comment_message" 
        style="overflow: auto; resize: vertical;" 
        rows="6" 
        placeholder="%s" %s></textarea>', 
        __('Your comment (*)', 'xmax'), 
        $aria_req);    
    $comment_field    .= '</p>';
    $comment_field    .= '</div>';
    
    $fields           = apply_filters('comment_form_default_fields', $fields);

    $defaults = array(
        'fields'               => $fields,
        'comment_field'        => $comment_field,
        'must_log_in'          => '<p class="must-log-in">' . sprintf(__('You must be <a href="%s">logged in</a> to post a comment.', 'xmax'), wp_login_url(apply_filters('the_permalink', get_permalink($post_id)))) . '</p>',
        'logged_in_as'         => '<p class="logged-in-as">' . sprintf(__('Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'xmax'), get_edit_user_link(), $user_identity, wp_logout_url(apply_filters('the_permalink', get_permalink($post_id)))) . '</p>',
        'comment_notes_before' => '',
        'comment_notes_after'  => '',
        'id_form'              => 'comments-form',
        'id_submit'            => 'submit-comment',
        'title_reply'          => __('Leave a Reply', 'xmax'),
        'title_reply_to'       => __('Leave a Reply to %s', 'xmax'),
        'cancel_reply_link'    => __('X', 'xmax'),
        'label_submit'         => __('Post Comment', 'xmax'),
        'format'               => 'xhtml',
    );
    $args = wp_parse_args($args, apply_filters('comment_form_defaults', $defaults));
    ?>
    <?php if (comments_open($post_id)) : ?>
        <?php
        do_action('comment_form_before');
        ?>
        <div id="respond">            
            <h4 id="reply-title" class="comment-reply-title clearfix"><?php comment_form_title($args['title_reply'], $args['title_reply_to']); ?></h4>            

            <?php if (get_option('comment_registration') && !is_user_logged_in()) : ?>
                <?php echo $args['must_log_in']; ?>
                <?php
                do_action('comment_form_must_log_in_after');
                ?>
            <?php else : ?>            
                <form action="<?php echo esc_url(site_url('/wp-comments-post.php')); ?>" method="post" id="<?php echo esc_attr($args['id_form']); ?>" class="comment-form clearfix" <?php echo $html5 ? ' novalidate' : ''; ?>>
                    <p class="comment-notes"><?php echo $args['comment_notes_before']; ?></p>
                    <?php
                    do_action('comment_form_top');
                    ?>
                    <?php if (is_user_logged_in()) : ?>
                        <?php
                        echo apply_filters('comment_form_logged_in', $args['logged_in_as'], $commenter, $user_identity);
                        ?>
                        <?php
                        do_action('comment_form_logged_in_after', $commenter, $user_identity);
                        ?>
                    <?php else : ?>                        
                        <?php
                        do_action('comment_form_before_fields');
                        foreach ((array) $args['fields'] as $name => $field) {
                            echo apply_filters("comment_form_field_{$name}", $field) . "\n";
                        }
                        do_action('comment_form_after_fields');
                        ?>
                    <?php endif; ?>
                    <?php
                    echo apply_filters('comment_form_field_comment', $args['comment_field']);
                    ?>
                    <?php echo $args['comment_notes_after']; ?>
                    
                    <div class="clear"></div>
                    
                    <p class="comment-button clearfix">              
                            <input name="submit" type="submit" id="<?php echo esc_attr($args['id_submit']); ?>" value="<?php echo esc_attr($args['label_submit']); ?>" />
                            <?php cancel_comment_reply_link($args['cancel_reply_link']); ?>                        
                            <?php comment_id_fields($post_id); ?>                                                    
                    </p>
                    <?php
                    do_action('comment_form', $post_id);
                    ?>
                </form>
            <?php endif; ?>
        </div><!-- #respond -->
        <?php
        do_action('comment_form_after');
    else :
        do_action('comment_form_comments_closed');
    endif;
}

function xmax_list_comments($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    ?>
    <li <?php comment_class('clearfix'); ?> id="comment-<?php comment_ID(); ?>">
        <article class="comment-wrap clearfix">
            <div class="comment-avatar">
                <?php echo get_avatar($comment->comment_author_email, 91); ?>
            </div>

            <div class="media-body clearfix">
                <header class="clearfix">
                    <h6><?php comment_author_link(); ?></h6>

                    <div class="comment-button pull-right">
                        <span class="entry-date pull-left">
                            <?php comment_time(get_option('date_format') . ' - ' . get_option('time_format')); ?>
                        </span>
                        <?php edit_comment_link(__('Edit', 'xmax'), '<span class="btn-separate">/</span>', ''); ?>
                        <span class="btn-separate">/</span>
                        <?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
                    </div>

                    <div class="clear"></div>
                </header>
                
                <div class="content-text">
                    <?php comment_text(true); ?>
                </div>
            </div>
            <!--media-body -->
        </article>
    </li>
<?php
}