/**
 * XBlog Pro Notice Dismissal Script
 */
(function($) {
    'use strict';
    
    // When document is ready
    $(document).ready(function() {
        // Handle the dismiss button click
        $('.xblog-dismiss-notice').on('click', function(e) {
            e.preventDefault();
            
            // Get the parent notice element
            var $notice = $(this).closest('.xblog-pro-notice');
            
            // Send AJAX request to dismiss the notice
            $.ajax({
                url: xblog_notice_params.ajax_url,
                type: 'POST',
                data: {
                    action: 'xblog_dismiss_pro_notice',
                    nonce: xblog_notice_params.nonce
                },
                success: function(response) {
                    if (response.success) {
                        // Fade out and remove the notice
                        $notice.fadeOut(300, function() {
                            $(this).remove();
                        });
                    }
                }
            });
        });
    });
})(jQuery);