<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package x-blog
 */
$xblog_plus_footer_copywright = get_theme_mod('footer_copywright');
?>

</div><!-- #content row -->
</div><!-- #content -->
<?php if (is_dynamic_sidebar('footer-widget')) : ?>
	<div class="footer-widget-area">
		<div class="baby-container widget-footer">
			<div class="widget-items">
				<?php dynamic_sidebar('footer-widget'); ?>
			</div>
		</div>
	</div>
<?php endif; ?>
<footer id="colophon" class="site-footer footer-display">
	<div class="baby-container site-info">&copy;
		<?php if ($xblog_plus_footer_copywright) : ?>
			<?php echo esc_html($xblog_plus_footer_copywright); ?>
		<?php else : ?>
			<?php
			echo date_i18n(
				/* translators: Copyright date format, see https://www.php.net/date */
				_x('Y', 'copyright date format', 'x-blog-plus')
			);
			?>
			<a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a>

		<?php endif; ?>
		<span class="sep"> | </span>
		<?php
		/* translators: 1: Theme name, 2: Theme author. */
		printf(esc_html__('Built with %1$s free WordPress theme by %2$s', 'x-blog-plus'), 'Xblog Plus', '<a href="' . esc_url('https://wpthemespace.com/product/x-blog-plus') . '">wpthemespace.com</a>');
		?>
	</div><!-- .site-info -->
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>